;	Project Title			BATTERY OPERATED TRACK CLEANER
;
;	Author				Jeff MONEGAL
;
;	Start Date				29 December 2005
;
;	Processor				PICAXE 08M
;
;*******************************************************************************************************

		symbol	temp = b10	
		symbol	speed = w6	
		symbol	temp2 = b9
		symbol	counter = b8

;-------------------------------------------------------------------- 

		pwmout 2,0,0			rem make sure motor is off
		low pin1			rem de-energize relay to select fwd direction		
		temp2 = 0
		temp = 0
		speed = 0

;-------------------------------------------------------------------- 
begin:
		
		pause 100
		if pin3 = 0 then begin		rem loop until a UHF command received
		temp = 20
		speed = 80
		counter = 0

decide_lp:

		pause 20
		if pin3 = 0 then fwd
		counter = counter + 1		rem if button held pressed for more than
		if counter > 50 then rev	rem one second then goto reverse
		goto decide_lp

fwd:

		low 1				rem select forward direction

spd_inc:
		pwmout 2,255,speed
		temp = temp + 1
		if temp > 140 then at_max
		speed = temp * 4
		pause 20
		goto spd_inc

at_max:
		if pin3 = 1 then stop_train	rem wait for button to be pressed again then
		goto at_max			rem stop the train

rev:

		high 1				rem select reverse direction
		goto spd_inc

stop_train:

		pwmout 2,255,speed
		temp = temp - 1
		if temp < 2 then train_is_stopped
		speed = temp * 4
		pause 5
		goto stop_train

train_is_stopped:

		pwmout 2,0,0			rem ensure output to motor is off
		pause 1000
		goto begin