
; UHF rolling code receiver

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_ON & _LVP_OFF & _BODEN_OFF & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations
; Transmitter 1
EEPROM0		equ	H'00'	; storage of seed 32-bit ms
EEPROM1		equ	H'01'	; storage of seed 32-bit
EEPROM2		equ	H'02'	; storage of seed 32-bit
EEPROM3		equ	H'03'	; storage of seed 32-bit ls

EEPROM4		equ	H'04'	; storage of multiplier 24-bit ms
EEPROM5		equ	H'05'	; storage of multiplier 24-bit
EEPROM6		equ	H'06'	; storage of multiplier 24-bit ls

EEPROM7		equ	H'07'	; storage of incrementer 
EEPROM8		equ	H'08'	; byte 5 of random code
EEPROM9		equ	H'09'	; byte 6 of random code
EEPROM10	equ	H'0A'	; scramble data code

; Transmitter 2
EEPROM11	equ	H'0B'	; storage of seed 32-bit ms
EEPROM12	equ	H'0C'	; storage of seed 32-bit
EEPROM13	equ	H'0D'	; storage of seed 32-bit
EEPROM14	equ	H'0E'	; storage of seed 32-bit ls

EEPROM15	equ	H'0F'	; storage of multiplier 24-bit ms
EEPROM16	equ	H'10'	; storage of multiplier 24-bit
EEPROM17	equ	H'11'	; storage of multiplier 24-bit ls

EEPROM18	equ	H'12'	; storage of incrementer 
EEPROM19	equ	H'13'	; byte 5 of random code
EEPROM20	equ	H'14'	; byte 6 of random code
EEPROM21	equ	H'15'	; scramble data code

; Transmitter 3
EEPROM22	equ	H'16'	; storage of seed 32-bit ms
EEPROM23	equ	H'17'	; storage of seed 32-bit
EEPROM24	equ	H'18'	; storage of seed 32-bit
EEPROM25	equ	H'19'	; storage of seed 32-bit ls

EEPROM26	equ	H'1A'	; storage of multiplier 24-bit ms
EEPROM27	equ	H'1B'	; storage of multiplier 24-bit
EEPROM28	equ	H'1C'	; storage of multiplier 24-bit ls

EEPROM29	equ	H'1D'	; storage of incrementer 
EEPROM30	equ	H'1E'	; byte 5 of random code
EEPROM31	equ	H'1F'	; byte 6 of random code
EEPROM32	equ	H'20'	; scramble data code

; Transmitter 4
;EEPROM 33 (H'21' to H'2B') 
; Transmitter 5
;EEPROM 44 (H'2C' to H'36')
; Transmitter 6
;EEPROM 55 (H'37' to H'41') 
; Transmitter 7
;EEPROM 66 (H'42' to H'4C')
; Transmitter 8
;EEPROM 77 (H'4D' to H'57') 
; Transmitter 9
;EEPROM 88 (H'58' to H'62')
; Transmitter 10
;EEPROM 99 (H'63' to H'6D') 
; Transmitter 11
;EEPROM 110 (H'6E' to H'78')
; Transmitter 12
;EEPROM 121 (H'79' to H'83')
; Transmitter 13
;EEPROM 132 (H'84' to H'8E')
; Transmitter 14
;EEPROM 143 (H'8F' to H'99') 
; Transmitter 15
;EEPROM 154 (H'9A' to H'A4')
; Transmitter 16
;EEPROM 165 (H'A5' to H'AF')

EEPROM176 	equ	H'B0'	; synchronisation flag storage 9-16
EEPROM177   equ	H'B1'	; synchronisation flag storage 0-8
EEPROM178	equ	H'B2'	; momentary / toggle for outputs 1,2,3
EEPROM179	equ	H'B3'	; compensation

; Bank 0 RAM

; Math
BARGB0		equ	H'20'	; random number generator
BARGB1		equ	H'21'	; random number gen
BARGB2		equ	H'22'	; random number gen
AARGB0		equ	H'23'	; random number gen
AARGB1		equ	H'24'	; random number gen
AARGB2		equ	H'25'	; random number gen
AARGB3		equ	H'26'	; random number gen
AARGB4		equ	H'27'	; random number gen
AARGB5		equ	H'28'	; random number gen
AARGB6		equ	H'29'	; random number gen

TEMPB0		equ	H'2A'	; random gen temp files
TEMPB1		equ	H'2B'	; random gen temp files
TEMPB2		equ	H'2C'	; random gen temp files
TEMPB3		equ	H'2D'	; random gen temp files
LOOPCOUNT	equ	H'2E'	; loop counter in random gen

; Seed
RANDB0		equ	H'2F'	; random number seed ms
RANDB1		equ	H'30'	; random number seed
RANDB2		equ	H'31'	; random number seed
RANDB3		equ	H'32'	; random number seed ls
RANDB4		equ	H'33'	; random number last byte
RANDB5		equ	H'34'	; random number last byte

; Multiplier
MULT0		equ	H'35'	; multiplier ms
MULT1		equ	H'36'	; multiplier ms
MULT2		equ	H'37'	; multiplier ms

; Increment
INCREMENT	equ	H'38'	; increment value

; Counters
VALUE		equ	H'39'	; Value of bit for sending data
CYCLE_COUNT	equ	H'3A'	; cycles per data
IDENTIFIER	equ H'3B'	; transmit identity
VALUE_1		equ	H'3C'	; delay counter
VALUE_2		equ	H'3D'	; delay counter	
PRIME_CONT	equ	H'3E'	; prime number counter
MULT_CYC	equ	H'3F'	; multiplier cycle counter
SCRAMBLE	equ	H'40'	; data code scramble

; Other
TEMPX		equ	H'41'	; temporary register
MOM_PERIOD1	equ	H'42'	; momentary period output 1
MOM_PERIOD2	equ	H'43'	; momentary period output 2
MOM_PERIOD3	equ	H'44'	; momentary period output 3
COUNTER_DIV	equ	H'45'	; counter divider reducing interrupt at 1024us to 262ms
FLAG		equ	H'46'	; interrupt flag

; receive bytes
RECEIVE0	equ	H'47'	; receive byte
RECEIVE1	equ	H'48'	; receive byte
RECEIVE2	equ	H'49'	; receive byte
RECEIVE3	equ	H'4A'	; receive byte
RECEIVE4	equ	H'4B'	; receive byte
RECEIVE5	equ	H'4C'	; receive byte
RECEIVE6	equ	H'4D'	; receive byte
RECEIVE7	equ	H'4E'	; receive byte
RECEIVE8	equ	H'4F'	; receive byte
RECEIVE9	equ	H'50'	; receive byte
RECEIVE10	equ	H'51'	; receive byte

REC_EIVE0	equ	H'52'	; receive byte unscrambled
REC_EIVE1	equ	H'53'	; receive byte 		"
REC_EIVE2	equ	H'54'	; receive byte      "
REC_EIVE3	equ	H'55'	; receive byte		"
REC_EIVE4	equ	H'56'	; receive byte		"
REC_EIVE5	equ	H'57'	; receive byte unscrambled

COUNT_BITS	equ	H'58'	; bit counter for receive bytes
CNT_BIT_STO	equ	H'59'	; bit counter for receive bytes
STORE1		equ	H'5A'	; delay counter
STORE2		equ	H'5B'	; delay counter
IDENTITY	equ	H'5C'	; identity address
TIMER1H_VAL equ	H'5D'	; timer 1 preset ms byte
TIMER1L_VAL equ	H'5E'	; timer 1 preset ls byte
TIMER1H_WK	equ	H'5F'	; timer 1 working value
TIMER1L_WK	equ	H'60'	; timer 1 working value	
TIMER1H_4	equ	H'61'	; timer 1 1/4 value ms byte
TIMER1L_4	equ	H'62'	; timer 1 1/4 value ls byte
SCRAMBLE1	equ	H'63'	; data code scramble working register
STORE3		equ	H'64'	; timer counter
REPEAT		equ	H'65'	; repeat recalculation
STO_RANDB3	equ	H'66'	; stored value from previous random calculation	
TEMP		equ	H'67'	; temporary
SYNC_SET	equ	H'68'	; flag for synchronisation 0 = first data block, 1 = second data block
TRANS_COUNT	equ H'69'	; transient count
DIV4_1		equ	H'6A'	; momentary period divider
DIV4_2		equ	H'6B'	; momentary period divider
DIV4_3		equ	H'6C'	; momentary period divider

FLAG_MOM	equ	H'6D'	; momentary divide by flags
TEMP_AD		equ	H'6E'	; temp value


; All Banks RAM

W_TMP	  	equ H'70'; storage of w before interrupt
STATUS_TMP	equ H'71'; status storage before interrupt
PCLATH_STO	equ H'72'; PCLATH store in interrupt

COUNTER_DIV1	equ	H'73'	; counter divider1
COUNTER_DIV2	equ	H'74'	; counter divider2
COUNTER_DIV3	equ	H'75'	; counter divider3
COMPENSATE		equ	H'76'	; compensation value			
; working registers				

SYNCHRON_FLAG  equ H'7D'; synchronise flag
ALL_COUNT	   equ H'7E'; ID counter to lockout all 16 IDs					

						 				
; preprogram EEPROM DATA 
	
	ORG     H'2100'		; start at 0 for EEPROM
	
	DE	H'04', H'10', H'CF', H'03', H'00', H'A1', H'8E', H'1D', H'0E', H'48', H'01'; ID1
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID2
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID3
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID4
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID5
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID6
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID7
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID8
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID9
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID10
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID11
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID12
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID13
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID14
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID15
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID16

	DE	H'00', H'01' ; EEPROM176,177 for synchronisation flags all clear (all transmitters are locked out
					 ; except 0)
					 ; bit 0 set in 177 is ID0, bit 7 is ID7, bit 0 in 176 is ID8, bit 7 is ID15
	DE  D'00'		 ; EEPROM178 momentary outputs bits 0,1,2 low for output 1,output 2,output 3 
	DE	D'10'		 ; EEPROM179 compensation value
	
; start at memory 0

	org	0				; main program
	goto	SETUP
	org	4				; interrupt vector
; Interrupt starts here
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	movf	PCLATH,w	; keep PCLATH
	movwf	PCLATH_STO	; store PC lath
	bsf		PCLATH,3	; page 1
	goto	INTERRUPT	; interrupt continues at page 1 address
	
; lookup table to find transmitter identity EEADR address for EEPROM
IDENTITY_FIND
	addwf	PCL,f		; add value to program counter
	retlw	H'00'		; transmitter 1 EEPROM start address
	retlw	H'0B'		; transmitter 2 EEPROM start address  
	retlw	H'16'
	retlw	H'21'
	retlw	H'2C'
	retlw	H'37'
	retlw	H'42'
	retlw	H'4D'
	retlw	H'58'		; transmitter 8
	retlw	H'63'
	retlw	H'6E'
	retlw	H'79'
	retlw	H'84'
	retlw	H'8F'
	retlw	H'9A'
	retlw	H'A5'		; transmitter 16 EEPROM start address 

MOM_TIME ; momentary period lookup table

	addwf	PCL,f		; add value to program counter
; Value = (A/D value -5)/4 for the ~62 values
; 0.26s increments
	retlw	D'1'		; value 1; 0.26s
	retlw	D'2'		; value 2; 0.52s
	retlw	D'3'		; value 3; 0.78s
	retlw	D'4'		; value 4; 1.04s
	retlw	D'5'		; value 5; 1.3s
	retlw	D'6'		; value 6; 1.56s
	retlw	D'7'		; value 7; 1.82s
	retlw	D'8'		; value 8; 2.0s
; above value 8, the period is increased by 4 using divider DIV4
; 1-second increments
	retlw	D'3'		; value 9; 3.12s
	retlw	D'4'		; value 10; 4.16s
	retlw	D'5'		; value 11; 5.2s
	retlw	D'6'		; value 12; 6.24s
	retlw	D'7'		; value 13; 7.2s
	retlw	D'8'		; value 14; 8.3s
	retlw	D'9'		; value 15; 9.3s
	retlw	D'10'		; value 16; 10.48s
; 5-second increments
	retlw	D'15'		; value 17; 15.6s
	retlw	D'20'		; value 18; 
	retlw	D'25'		; value 19; 
	retlw	D'30'		; value 20; 
	retlw	D'35'		; value 21; 
	retlw	D'40'		; value 22; 
	retlw	D'45'		; value 23; 46s
	retlw	D'50'		; value 24; 
	retlw	D'55'		; value 25; 
	retlw	D'60'		; value 26; 
	retlw	D'65'		; value 27; 
	retlw	D'70'		; value 28; 
	retlw	D'75'		; value 29; 
	retlw	D'80'		; value 30; 
	retlw	D'85'		; value 31; 88.4s (1.47m)
	retlw	D'90'		; value 32; 
	retlw	D'95'		; value 33; 
	retlw	D'100'		; value 34; 
	retlw	D'105'		; value 35; 
	retlw	D'110'		; value 36; 
	retlw	D'115'		; value 37; 
	retlw	D'120'		; value 38; 
	retlw	D'125'		; value 39; 130s (2.2m)
	retlw	D'130'		; value 40; 
	retlw	D'135'		; value 41; 
	retlw	D'140'		; value 42; 
	retlw	D'145'		; value 43; 
	retlw	D'150'		; value 44; 
	retlw	D'155'		; value 45; 
	retlw	D'160'		; value 46; 166s (2.7m)
	retlw	D'165'		; value 47;
	retlw	D'170'		; value 48; 
	retlw	D'175'		; value 49; 
	retlw	D'180'		; value 50; 
	retlw	D'185'		; value 51; 
	retlw	D'190'		; value 52; 
	retlw	D'195'		; value 53; 202s (3.37m)
	retlw	D'200'		; value 54;
; 8-second increments
	retlw	D'208'		; value 55; 
	retlw	D'216'		; value 56; 
	retlw	D'224'		; value 57; 
	retlw	D'232'		; value 58; 
	retlw	D'240'		; value 59; 
	retlw	D'248'		; value 60; 
	retlw	D'255'		; value 61; 265s (4.42m)

	retlw	D'255'		; value 62; 
	retlw	D'255'		; value 63; 
	retlw	D'255'		; value 64; 

; **********************************************************************************************

SETUP

	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE	; enable timer 1 interrupt

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11111111'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00101101'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled TMR0/256)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'01001001'	; AN0,3 & 6 are analog inputs
	movwf	ANSEL
	movlw	B'00000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	clrf	PORTA		; port A output low
	movlw	B'01000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01101000'	; for 4MHz
	movwf	OSCCON		; osc
	bcf		STATUS,RP0	; select memory bank 0
	movlw	H'FB'		; preload timer 1
	movwf	TIMER1H_VAL
	movwf	TMR1H
	movlw	H'FF'
	movwf	TIMER1L_VAL
	movwf	TMR1L
	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on
	
; initial conditions

	clrf	SYNC_SET	; synchronisation set flag for first or second data
	clrf	MOM_PERIOD1	; momentary period 1
	clrf	MOM_PERIOD2	; momentary period 2
	clrf	MOM_PERIOD3	; momentary period 3

	movlw	EEPROM179
	call	EEREAD1
	movwf	COMPENSATE	; compensate value

; delay start
DELAY_START	
	call	DELAYms

	bcf		PIR1,TMR1IF	; clear timer 1 overflow

; allow interrupts
ALL_INTERRUPTS
	bsf		INTCON,PEIE	; peripheral interrupt enable

; check inputs

CHECK_INPUTS
	bsf		INTCON,GIE	; set global interrupt (enable for timer 1)
	bcf		PORTA,7		; set off
	bsf		T1CON,0		; make sure timer1 is running to count and check for overrange
 
; Switches

	btfss	PORTA,5		; select
	goto 	PRGM
	btfss	PORTB,6		
	goto	SWITCH_1_OUT; output for switch 1
	btfss	PORTB,5		
	goto	SWITCH_2_OUT; output for switch 2 
	btfss	PORTB,4		
	goto	SWITCH_3_OUT; output for switch 3
	goto	INPUT_SIG

PRGM
	btfss	PORTB,6		; lockout	
	goto	LOCKOUT		; 
	btfss	PORTB,5		; momentary/toggle
	goto	MOM_TOGG	;  
	
; Signal input
INPUT_SIG
	btfss	PORTA,2		; when high begin to read data
	goto	CHECK_INPUTS
	clrf	FLAG		; 1024us flag
	movlw	D'10'		; transmission counter
	movwf	TRANS_COUNT
TRANS_LOOP
	btfss	PORTA,2		; check if still high
	goto	CHECK_INPUTS; not high so out
	btfss	FLAG,0		; count flags (set in interrupt) for a 10ms high transmission from transmitter 
	goto	TRANS_LOOP
	decfsz	TRANS_COUNT,f; count
	goto	QUIETING_LOOP
	goto	SIG_IN
QUIETING_LOOP
	clrf	FLAG
	goto	TRANS_LOOP

SIG_IN
	movlw	D'56'		; 56 plus 8-bits stop/start (total 64 bits for normal transmission inc start/stop)
	btfsc	PORTA,5		; if select link in continue
	goto	IN2			; switches have operate function so bypass sync

	btfss	PORTB,4		; sync switch
	movlw	D'40'		; total of 48 bits synchronise transmission inc start stop received in two lots 
IN2
	btfss	PORTA,2		; if high then check to start reception
	goto	CHECK_INPUTS
	movwf	COUNT_BITS
	movwf	CNT_BIT_STO	; store for reference later

; use start bits to lock the transmission frequency
	bcf		INTCON,GIE	; stop interrupt
	bcf		T1CON,0		; stop timer 1
	clrf	TMR1L		; clear timer 1
	clrf	TMR1H
	clrf	FLAG		; interrupt occurred flag
	bcf		PIR1,TMR1IF	; clear interrupt flag
	clrf	TMR0		; timer 0 cleared plus prescaler
	nop
	nop
	nop					; wait for timer0 to clear	
	bcf		INTCON,TMR0IF; clear timer 0 flag
		
; count with timer 1 for RB4 to go low and then high, low and high corresponding to a 1,1,1 start bits

WAIT_LOW
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE when timer overflow
	btfsc	PORTA,2		; wait for a low 
	goto	WAIT_LOW

WAIT_HIGH
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait till high 
	goto	WAIT_HIGH
	bsf		T1CON,0		; timer1 on to count and check for overrange

WAIT_LOW1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait for a low 
	goto	WAIT_LOW1

WAIT_HIGH1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait till high (start of third start bit after 15 interrupts)
	goto	WAIT_HIGH1

WAIT_LOW2
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait for a low 
	goto	WAIT_LOW2

WAIT_HIGH2
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait till high 
	goto	WAIT_HIGH2

; 7 interrupts
WAIT_LOW3
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait for a low 
	goto	WAIT_LOW3

WAIT_HIGH3
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait till high
	goto	WAIT_HIGH3

WAIT_LOW4
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait for a low
	goto	WAIT_LOW4

WAIT_HIGH4
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait till high
	goto	WAIT_HIGH4

WAIT_LOW5
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait till low 
	goto	WAIT_LOW5

WAIT_HIGH5
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait for a high 
	goto	WAIT_HIGH5

WAIT_LOW6
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait till low 
	goto	WAIT_LOW6

WAIT_HIGH6
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait for a high 
	goto	WAIT_HIGH6

WAIT_LOW7
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait till low 
	goto	WAIT_LOW7

WAIT_HIGH7
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait for a high 
	goto	WAIT_HIGH7

WAIT_LOW8
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait till low 
	goto	WAIT_LOW8

WAIT_HIGH8
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait for a high 
	goto	WAIT_HIGH8

WAIT_LOW9
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTA,2		; wait till low 
	goto	WAIT_LOW9

WAIT_HIGH9
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTA,2		; wait for a high 
	goto	WAIT_HIGH9

; read timer 1 and divide by 16 to get the required timer 1 offset (take from FFFF to get preload value)
; if outside range then ignore. Typically should be 1024 but 2048 to 512 allowable

	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	bcf		T1CON,0		; stop timer 1
	movf	TMR1L,w		; read timer 1
	movwf	TIMER1L_WK	; working registers
	movf	TMR1H,w
	movwf	TIMER1H_WK

; divide by 16 to get average count between each edge
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /2
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /4
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /8
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /16

; compare with over range/under range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111110'		; 512 and greater
	btfsc	STATUS,Z		; if zero then value too small 
	goto	CHECK_INPUTS	; IGNORE
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111000'		; 2048 and greater
	btfss	STATUS,Z		; if not zero then value too large 
	goto	CHECK_INPUTS	; IGNORE

; take from FFFF to get preset for interrupt rate	
	movf	TIMER1H_WK,w	; ms byte
	sublw	H'FF'			; maximum
	movwf	TIMER1H_VAL
	movf	TIMER1L_WK,w	; ls byte
	sublw	H'FF'			; maximum
	movwf	TIMER1L_VAL
	btfss	STATUS,C		; if carry reduce ms byte
	decf	TIMER1H_VAL,f

; add compensation for preload losses
	movf	COMPENSATE,w	; 			 
	addwf	TIMER1L_VAL,f	; add compensation
	btfsc	STATUS,C
	incf	TIMER1H_VAL,f	; if overrange increase ms byte

; preload counter 1 to sync with transmission rate 
	movf	TIMER1H_VAL,w
	movwf	TMR1H
	movf	TIMER1L_VAL,w
	movwf	TMR1L
	clrf	FLAG		; clear flag
	bsf		T1CON,0		; timer1 on start count	
	bsf		INTCON,GIE	; allow interrupts

; wait for one interrupt interval
WAIT_FLG_R
	btfss	FLAG,0
	goto	WAIT_FLG_R
	clrf	FLAG

; wait for 1/4 interrupt interval to centre measurement of level on high or low transmission

; calculate 1/4 interval
	bcf		STATUS,C	; carry cleared
	rrf		TIMER1H_WK,w	; divide by 2
	movwf	TIMER1H_4	; place in secondary register
	rrf		TIMER1L_WK,w
	movwf	TIMER1L_4
	bcf		STATUS,C
	rrf		TIMER1H_4,f	; divide by 2 for total of 4
	rrf		TIMER1L_4,f

; take from FFFF to get shift in time to read data centred on a 1 or 0 value
	bcf		INTCON,GIE	; stop interrupts
	bcf		T1CON,0		; stop timer 1

	movf	TIMER1H_4,w	; ms byte
	sublw	H'FF'		; maximum
	movwf	TMR1H
	movf	TIMER1L_4,w	; ls byte
	sublw	H'FF'		; maximum
	movwf	TMR1L
	btfss	STATUS,C	; if carry reduce ms byte
	decf	TMR1H,f

	bcf		PIR1,TMR1IF	; clear interrupt flag
	bsf		T1CON,0		; run timer 1
	clrf	FLAG
	bsf		INTCON,GIE	; allow interrupts

; start of data
; shift into RECEIVE3,4,5 etc
START_DATA
	clrf	RECEIVE3
	clrf	RECEIVE4
	clrf	RECEIVE5
	clrf	RECEIVE6
	clrf	RECEIVE7
	clrf	RECEIVE8
	clrf	RECEIVE9

WAIT_FLG3
	btfss	FLAG,0		; wait for interrupt flag change
	goto	WAIT_FLG3
	clrf	FLAG		; clear flag 
	btfsc	PORTA,2		; check level
	goto	SET_CARRY
	bcf		STATUS,C	; clear carry
	bcf		PORTA,7		; ack LED
	goto	STORE_RECEIVE
SET_CARRY
	bsf		STATUS,C	; set when port is set
	bsf		PORTA,7
STORE_RECEIVE

	rlf		RECEIVE9,f
	rlf		RECEIVE8,f
	rlf		RECEIVE7,f
	rlf		RECEIVE6,f
	rlf		RECEIVE5,f
	rlf		RECEIVE4,f
	rlf		RECEIVE3,f
	decfsz	COUNT_BITS,f
	goto	WAIT_FLG3	; continue loading bits

; check stop bits
WAIT_FLG4
	btfss	FLAG,0
	goto	WAIT_FLG4
	clrf	FLAG		; clear flag
	btfss	PORTA,2		; check level must be a high (for the 1 in the stop bits)
	goto	IGNORE 
WAIT_FLG5
	bsf		PORTA,7
	btfss	FLAG,0
	goto	WAIT_FLG5
	clrf	FLAG		; clear flag 
	btfsc	PORTA,2		; check level must be a low (for the 0 in the stop bits)
	goto	IGNORE
WAIT_FLG6
	bcf		PORTA,7
	btfss	FLAG,0
	goto	WAIT_FLG6
	clrf	FLAG		; clear flag
	btfss	PORTA,2		; check level must be a high (for the 1 in the stop bits)
	goto	IGNORE 
WAIT_FLG7
	bsf		PORTA,7
	btfss	FLAG,0
	goto	WAIT_FLG7
	clrf	FLAG		; clear flag 
	btfss	PORTA,2		; check level must be a high (for the 1 in the stop bits)
	goto	IGNORE 

; when loaded check CNT_BIT_STO to see if it was for synchronisation or Data.
	movf	CNT_BIT_STO,w
	xorlw	D'56'		; data
	btfss	STATUS,Z
	goto	SYNCH_VALUES
	clrf	SYNC_SET	; reset to data block 1

; collate data for scramble recovery
	movf	RECEIVE3,w
	movwf	RECEIVE10	; identifier
; shift RECEIVE4 to 9 to RECEIVE0 to 5
	movf	RECEIVE4,w
	movwf	RECEIVE0
	movf	RECEIVE5,w
	movwf	RECEIVE1
	movf	RECEIVE6,w
	movwf	RECEIVE2
	movf	RECEIVE7,w
	movwf	RECEIVE3
	movf	RECEIVE8,w
	movwf	RECEIVE4
	movf	RECEIVE9,w
	movwf	RECEIVE5

; Identifier in RECEIVE10. Data placed in REC_EIVE,0 to 5
	
	movf	RECEIVE10,w
	andlw	B'00001111'	; select ls bytes only
	movwf	IDENTITY	; 1 of 16 transmitters
	
; check if this identity has been synchronised yet. If not then exit (IGNORE).
; Identity value 0 is transmitter ID0, 1 is transmitter ID1 etc 15 or F is transmitter ID15
; set EEPROM address first

	movlw	EEPROM177	; 0-8 ID flags	
	call	EEREAD		; sets EEADR

	movf	IDENTITY,w	; identity value (0-15)= 1-16
	xorlw	D'00'		; if 0 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT0
	movf	IDENTITY,w
	xorlw	D'01'		; if 1 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT1
	movf	IDENTITY,w
	xorlw	D'02'		; if 2 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT2
	movf	IDENTITY,w
	xorlw	D'03'		; if 3 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT3
	movf	IDENTITY,w
	xorlw	D'04'		; if 4 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT4
	movf	IDENTITY,w
	xorlw	D'05'		; if 5 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT5
	movf	IDENTITY,w
	xorlw	D'06'		; if 6 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT6
	movf	IDENTITY,w
	xorlw	D'07'		; if 7 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT7

; set up EEPROM address	
	movlw	EEPROM176	; 9-16 ID flags	
	call	EEREAD		; sets EEADR

	movf	IDENTITY,w	; 0-15
	xorlw	D'08'		; if 8 check if bit 0 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT8
	movf	IDENTITY,w
	xorlw	D'09'		; if 9 check if bit 1 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT9
	movf	IDENTITY,w
	xorlw	D'10'		; if 10 check if bit 2 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT10
	movf	IDENTITY,w
	xorlw	D'11'		; if 11 check if bit 3 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT11
	movf	IDENTITY,w
	xorlw	D'12'		; if 12 check if bit 4 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT12
	movf	IDENTITY,w
	xorlw	D'13'		; if 13 check if bit 5 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT13
	movf	IDENTITY,w
	xorlw	D'14'		; if 14 check if bit 6 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT14
	movf	IDENTITY,w
	xorlw	D'15'		; if 15 check if bit 7 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT15
	goto	IGNORE		; none set so ignore 

CK_IDENT0
;	check if bit 0 set in EEPROM177
	call	EEREAD2			; EEADR set previously for EEPROM177
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,0	; 
	goto	CON_CODE_CK		; if set can CONtinue_CODE_ChecK
	goto	IGNORE
CK_IDENT1
;	check if bit 1 set in EEPROM
	call	EEREAD2			; EEADR set previously 
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,1	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT2
;	check if bit 2 set in EEPROM
	call	EEREAD2			; EEADR set previously 
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,2	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT3
;	check if bit 3 set in EEPROM
	call	EEREAD2			; EEADR set previously 
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,3	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT4
;	check if bit 4 set in EEPROM
	call	EEREAD2			; EEADR set previously 
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,4	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT5
;	check if bit 5 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,5	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT6
;	check if bit 6 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,6	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT7
;	check if bit 7 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,7	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT8
;	check if bit 0 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,0	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT9
;	check if bit 1 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,1	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT10
;	check if bit 2 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,2	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT11
;	check if bit 3 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,3	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT12
;	check if bit 4 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,4	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT13
;	check if bit 5 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,5	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT14
;	check if bit 6 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,6	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT15
;	check if bit 7 set in EEPROM
	call	EEREAD2			; EEADR set previously for EEPROM
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,7	; if set can CONtinue_CODE_ChecK
	goto	IGNORE

CON_CODE_CK; continue with code check
; identity synchronised so continue with code check
	movf	IDENTITY,w
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	addlw	H'0A'			; get scramble value address @10 addresses above identity start address 
	call	EEREAD			;
	movwf	SCRAMBLE

; unscramble data bytes
	bsf		PCLATH,3		; page 1
	call	DECODE_SCRAMBLE
	bcf		PCLATH,3		; page 0

; compare for matching values
	call	MATCH
	goto	RESULT

; subroutine to compare
MATCH ; compare values received with those stored	
;0
	movf	IDENTITY,w
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE0,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;1
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE1,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;2	
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE2,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;3
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE3,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;4
	incf	EEADR,f			; increase to 8th location for last 2-bytes
	incf	EEADR,f			;
	incf	EEADR,f
	incf	EEADR,f
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE4,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;5
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE5,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; not matching
	retlw	D'01'			; matching

RESULT
	xorlw	D'01'			; if 01 then match
	btfsc	STATUS,Z
	goto	FUNCTIONS
;  codes do not match recalculate to match operation

	goto	RECALC_TO_MATCH	; 

; *******************************************************************

FUNCTIONS

; Ack LED	
	bcf		PORTA,7			; acknowledge LED off

; calculate the next random data and store in EEPROM
	call	RECALCULATE		; next values calculated and stored 
	call	STORE			; 

; Data correct then act on depending on functions required 

; output1, output2, output 3 check
		
	btfss	RECEIVE10,6		; if clear then switch 1 
	goto	SWITCH_1_OUT
	btfss	RECEIVE10,5		; if clear then switch 2
	goto	SWITCH_2_OUT
	btfss	RECEIVE10,7		; if clear then switch 3
	goto	SWITCH_3_OUT
	goto	IGNORE			; none so ignore

SWITCH_1_OUT ; switch 1 pressed
	movlw	EEPROM178		; momentary or toggle
	call	EEREAD1
	movwf	TEMP
	btfsc	TEMP,0			; when low, momentary
	goto	TOGGLE_1
; load momentary timer

; A/D conversion
; Channel 3 A/D value

CH3
	bcf		STATUS,GIE
	bsf		ADCON0,3
	bsf		ADCON0,4
	bcf		ADCON0,5

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT1
	decfsz	TEMP,f
	goto	WAIT1	

	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	movlw	D'05'			; start at A/D value 5 to allow smooth operation of trimpot setting
	subwf	ADRESH,w
	btfss	STATUS,C		; if negative set at 0
	movlw	D'0'
	movwf	TEMP_AD
; divide by 4
	bcf		STATUS,C
	rrf		TEMP_AD,f		; /2
	bcf		STATUS,C
	rrf		TEMP_AD,f		; /4
; clear x4 period flag for momentary period
	bcf		FLAG_MOM,1		; for 1
	movf	TEMP_AD,w
	sublw	D'08'			; take from 8
	btfss	STATUS,C		; if negative then >8
	bsf		FLAG_MOM,1		; set for the x 4 divider
; get lookup value for timer
	movf	TEMP_AD,w
	call	MOM_TIME

; place in timer
	
	movwf	MOM_PERIOD1
	bsf		PORTA,4			; momentary on for momentary period	
	movlw	H'FF'			; initial 0.26s	
	movwf	COUNTER_DIV1	
	clrf	DIV4_1
	bsf		INTCON,GIE
	goto	WAIT_OP1

TOGGLE_1
	btfsc	PORTA,4
	goto	CLEAR1
	bsf		PORTA,4
	goto	WAIT_OP1
CLEAR1
	bcf		PORTA,4
WAIT_OP1
	movlw	D'255'
	call	DELAY
	btfss	PORTB,6			; wait for switch to open
	goto	WAIT_OP1
	goto	CHECK_INPUTS

SWITCH_2_OUT
	movlw	EEPROM178		; momentary or toggle
	call	EEREAD1
	movwf	TEMP
	btfsc	TEMP,1			; when low momentary
	goto	TOGGLE_2

; load momentary timer
; A/D conversion
; Channel 6 A/D value

CH6
	bcf		STATUS,GIE
	bcf		ADCON0,3
	bsf		ADCON0,4
	bsf		ADCON0,5

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT2
	decfsz	TEMP,f
	goto	WAIT2	

	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV2
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV2
	movlw	D'05'			; start at A/D value 5 to allow smooth operation of trimpot setting
	subwf	ADRESH,w
	btfss	STATUS,C		; if negative set at 0
	movlw	D'0'
	movwf	TEMP_AD
; divide by 4
	bcf		STATUS,C
	rrf		TEMP_AD,f		; /2
	bcf		STATUS,C
	rrf		TEMP_AD,f		; /4
; clear x4 period flag for momentary period
	bcf		FLAG_MOM,2		; for 2
	movf	TEMP_AD,w
	sublw	D'08'			; take from 8
	btfss	STATUS,C		; if negative then >8
	bsf		FLAG_MOM,2		; set for the x 4 divider
; get lookup value for timer
	movf	TEMP_AD,w
	call	MOM_TIME		; lookup timer values

; place in timer
		
	movwf	MOM_PERIOD2

	bsf		PORTA,6			; momentary on for momentary period	
	movlw	H'FF'			; initial 0.26s	
	movwf	COUNTER_DIV2	
	clrf	DIV4_2
	bsf		INTCON,GIE
	goto	WAIT_OP2

TOGGLE_2
	btfsc	PORTA,6
	goto	CLEAR2
	bsf		PORTA,6
	goto	WAIT_OP2
CLEAR2
	bcf		PORTA,6
WAIT_OP2
	movlw	D'255'
	call	DELAY
	btfss	PORTB,5			; wait for switch to open
	goto	WAIT_OP2
	goto	CHECK_INPUTS


SWITCH_3_OUT
	movlw	EEPROM178		; momentary or toggle
	call	EEREAD1
	movwf	TEMP
	btfsc	TEMP,2			; when low momentary
	goto	TOGGLE_3
; load momentary timer

; A/D conversion
; Channel 0 A/D value

CH0
	bcf		STATUS,GIE
	bcf		ADCON0,3
	bcf		ADCON0,4
	bcf		ADCON0,5

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT3
	decfsz	TEMP,f
	goto	WAIT3	

	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV3
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV3
	movlw	D'05'			; start at A/D value 5 to allow smooth operation of trimpot setting
	subwf	ADRESH,w
	btfss	STATUS,C		; if negative set at 0
	movlw	D'0'
	movwf	TEMP_AD
; divide by 4
	bcf		STATUS,C
	rrf		TEMP_AD,f		; /2
	bcf		STATUS,C
	rrf		TEMP_AD,f		; /4
; clear x4 period flag for momentary period
	bcf		FLAG_MOM,3		; for 3
	movf	TEMP_AD,w
	sublw	D'08'			; take from 8
	btfss	STATUS,C		; if negative then >8
	bsf		FLAG_MOM,3		; set for the x 4 divider
; get lookup value for timer
	movf	TEMP_AD,w
	call	MOM_TIME

; place in timer
	
	movwf	MOM_PERIOD3
	bsf		PORTA,1			; momentary on for momentary period	
	movlw	H'FF'			; initial 0.26s	
	movwf	COUNTER_DIV3	
	clrf	DIV4_3
	bsf		INTCON,GIE
	goto	WAIT_OP3

TOGGLE_3
	btfsc	PORTA,1
	goto	CLEAR3
	bsf		PORTA,1
	goto	WAIT_OP3
CLEAR3
	bcf		PORTA,1

WAIT_OP3
	movlw	D'255'
	call	DELAY
	btfss	PORTB,4			; wait for switch to open
	goto	WAIT_OP3
	goto	CHECK_INPUTS

	
; ************************************************************************************
; Recalculation
; if incorrect recalculate next random data then store and check again for xx repeats
RECALC_TO_MATCH

	movlw	D'100'			; test at repeat of xx
	movwf	REPEAT			; look ahead count
	call	RECALCULATE		; gets stored values first for random generator and then randomises values
	goto	CK_RANDBX		; bypass call random as already in recalculate
RECALC_XXX
	bsf		PCLATH,3		; page 1
	call	RANDOM			; recalculate random number
	bsf		PCLATH,3		; page 1
	call	DECODE_SCRAMBLE	; decode data from scramble
	bcf		PCLATH,3

; check next number of repeat values if not a match then abort
CK_RANDBX
	movf	RANDB0,w 
	xorwf	REC_EIVE0,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB1,w 
	xorwf	REC_EIVE1,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB2,w 
	xorwf	REC_EIVE2,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB3,w 
	xorwf	REC_EIVE3,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB4,w 
	xorwf	REC_EIVE4,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB5,w 
	xorwf	REC_EIVE5,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match

; when a match recalculate and store
	call	STORE			; store values
	goto	FUNCTIONS		; a match so act upon
NXT1
	decfsz	REPEAT,f		; decrease till 0 
	goto	RECALC_XXX
	goto	IGNORE			; no match after xx future codes 

RECALCULATE

; get values (RANDB0,1,2,3, multiplier and increment) for calculation
	movf	IDENTITY,w
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
; RANDB0
	call	EEREAD
	movwf	RANDB0
	bsf		STATUS,RP1		; bank 2
; RANDB1
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	RANDB1
	bsf		STATUS,RP1		; bank 2
; RANDB2
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	RANDB2
	bsf		STATUS,RP1		; bank 2
; RAND3
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	RANDB3
	bsf		STATUS,RP1		; bank 2
; MULT0
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	MULT0
	bsf		STATUS,RP1		; bank 2
; MULT1
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	MULT1
	bsf		STATUS,RP1		; bank 2
; MULT2
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	MULT2
	bsf		STATUS,RP1		; bank 2
; INCREMENT
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	INCREMENT
; scramble
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; next EEPROM
	incf	EEADR,f
	incf	EEADR,w
	call	EEREAD
	movwf	SCRAMBLE

	bsf		PCLATH,3		; page 1
	call	RANDOM			; recalculate the random values
	bcf		PCLATH,3
	return

STORE
; store
	movf	IDENTITY,w	
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR
; RAND0
	movf	RANDB0,w		; Random ms byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND1
	incf	EEADR,f	 		; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB1,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB2,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND3
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB3,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; increase to 8th location for last 2-bytes
	incf	EEADR,f			;
	incf	EEADR,f
	incf	EEADR,f
; RAND4
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB4,w		; Mult byte
	call	EEWRITE
; RAND5
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB5,w		; Random byte
	call	EEWRITE
; Scramble	
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	SCRAMBLE,w		; scramble
	call	EEWRITE
	return


; ********************************************************************
; SYNCHRONISE/REGISTER

; if synchronise, load into EEPROM new values
SYNCH_VALUES

; First data block IDENTIFIER, RANDB0,1,2,3 (40 bits) 
; Second data block MULT0,1,2, INCREMENT, SCRAMBLE (40 bits)
; located in RECEIVE9 to RECEIVE5
; identifier provides EEPROM locations starting address 
; set synchronisation flag in EEPROM for the identity

; Check which block
	movf	SYNC_SET,w		; if zero data block 1
	btfss	STATUS,Z
	goto	BLOCK2_SYNC

; bits 0,1,2,3 are the identity bits set at 0 to 15 with IDENTITY bits 0,1,2,3

	movf	RECEIVE5,w
	andlw	B'00001111'		; ls bits only

	movwf	IDENTITY	
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR

; RAND0
	movf	RECEIVE6,w		; Random ms byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND1
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE7,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE8,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND3
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE9,w		; Random byte
	call	EEWRITE
	movlw	D'03'
	movwf	SYNC_SET		; set at 3 so can be reduced to 0 after 0.75secs max
	call	DELAYms
	goto	SIG_IN			; CHECK_INPUTS

; block 2
BLOCK2_SYNC
	movf	IDENTITY,w	
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; next EEPROM
	incf	EEADR,f			; next EEPROM
	incf	EEADR,f			; next EEPROM
	
; MULT0	
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE5,w		; Mult byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; MULT1
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE6,w		; Mult byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; MULT2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE7,w		; Mult byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; INCREMENT
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE8,w		; Increment byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2

	incf	EEADR,f			; increase to 8th location for last 2-bytes
	incf	EEADR,f			;
; SCRAMBLE
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE9,w		; Scramble byte
	call	EEWRITE
	
	clrf	SYNC_SET		; first block flag cleared

;  store identifier 0 to 7 in EEPROM177

	clrf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	btfsc	STATUS,Z		; when 0 set bit 0 in EEPROM
	bsf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'01'			; when 1 set bit 1 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'02'			; when 2 set bit 2 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'03'			; when 3 set bit 3 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'04'			; when 4 set bit 4 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'05'			; when 5 set bit 5 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'06'			; when 6 set bit 6 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'07'			; when 7 set bit 7 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,7	

; check if zero
	movf	SYNCHRON_FLAG,w
	btfsc	STATUS,Z		; if flag register is zero bypass storing the new flag setting
	goto	ID8_16
; get current flags
	movlw	EEPROM177		; 0-8 flags
	call	EEREAD			; value in w
	iorwf	SYNCHRON_FLAG,w	; include new flag
	call 	EEWRITE			; write values

; store identifier 8 to 16 in EEPROM176
ID8_16
	clrf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	xorlw	D'08'			; when 8 set bit 0 in EEPROM
	btfsc	STATUS,Z		; 
	bsf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'09'			; when 9 set bit 1 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'10'			; when 10 set bit 2 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'11'			; when 11 set bit 3 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'12'			; when 12 set bit 4 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'13'			; when 13 set bit 5 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'14'			; when 14 set bit 6 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'15'			; when 15 set bit 7 in EEPROM
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,7	

; check if zero
	movf	SYNCHRON_FLAG,w
	btfsc	STATUS,Z		; if flag register is zero bypass storing the new flag setting
	goto	FLAS_ACK

; get current flags
	movlw	EEPROM176		; 9-16 flags
	call	EEREAD			; value in w
	iorwf	SYNCHRON_FLAG,w	; include new flag
	call 	EEWRITE			; write values

; flash ACK LED
FLAS_ACK
	bcf		PORTA,7			; acknowledge LED off
	movlw 	D'25'
	movwf	STORE3
	
MORE_DELAY1
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY1	
; show ACK LED
	bsf		PORTA,7			; acknowledge LED on
	movlw 	D'25'
	movwf	STORE3
	
MORE_DELAY2
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY2	
; flash ACK LED
	bcf		PORTA,7			; acknowledge LED off
	movlw 	D'25'
	movwf	STORE3
	
MORE_DELAY3
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY3	
; show ACK LED
	bsf		PORTA,7			; acknowledge LED on
	btfss	PORTB,4			; keep flashing until synch switch open
	goto	FLAS_ACK
	goto	CHECK_INPUTS

; *********************************************************************

IGNORE
; start and stop bits incorrect so ignore data. Flash Ack LED to indicate ignore 
	
	bcf		PORTA,7		; ack LED off 
	goto	CHECK_INPUTS


; ********************************************************************

LOCKOUT
 ; load timeout counter for all ID lockout 
	movlw	D'04'
	movwf	ALL_COUNT
	bcf		INTCON,GIE		; interrupt off
	
; identity bits set at 0 to 15 with IDENTITY bits 0,1,2,3
	movf	PORTB,w
	andlw	B'00001111'		; select ls bits
	movwf	TEMP
; correct order for identity
	clrf	IDENTITY		; set at 0 initially 1 of 16 transmitters
	btfss	TEMP,0			; BCD1, (8) if bit 0 low then ms bit (8) so set bit 3 
	bsf		IDENTITY,3
	btfss	TEMP,1			; BCD1, (2)
	bsf		IDENTITY,1
	btfss	TEMP,2			; BCD1, (4)
	bsf		IDENTITY,2
	btfss	TEMP,3			; BCD1, (1)
	bsf		IDENTITY,0

;  clear identifier 0 to 7 in EEPROM177

	movlw	H'FF'			; all 1's
	movwf	SYNCHRON_FLAG	; set ready to clear a bit
	movf	IDENTITY,w
	btfsc	STATUS,Z		; when 0 clear bit 0 in EEPROM
	bcf		SYNCHRON_FLAG,0

	movf	IDENTITY,w
	xorlw	D'01'			; when 1 clear bit 1 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'02'			; when 2 clear bit 2 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'03'			; when 3 clear bit 3 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'04'			; when 4 clear bit 4 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'05'			; when 5 clear bit 5 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'06'			; when 6 clear bit 6 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'07'			; when 7 clear bit 7 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,7	

; get current flags
	movlw	EEPROM177		; 0-8 flags
	call	EEREAD1			; value in w
	andwf	SYNCHRON_FLAG,w	; exclude new flag
	call 	EEWRITE1		; write values

;  clear identifier 8 to 16 in EEPROM176
	movlw	H'FF'
	movwf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	xorlw	D'08'			; when 8 clear bit 0 in EEPROM
	btfsc	STATUS,Z		; 
	bcf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'09'			; when 9 clear bit 1 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'10'			; when 10 clear bit 2 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'11'			; when 11 clear bit 3 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'12'			; when 12 clear bit 4 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'13'			; when 13 clear bit 5 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'14'			; when 14 clear bit 6 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'15'			; when 15 clear bit 7 in EEPROM
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,7	

; get current flags
	movlw	EEPROM176		; 9-16 flags
	call	EEREAD1			; value in w
	andwf	SYNCHRON_FLAG,w	; exclude new flag
	call 	EEWRITE1		; write values

; Flash power LED to indicate locked out ID.
REFLASH
	movf	IDENTITY,w		; flash from 0-15 
	movwf	SYNCHRON_FLAG	; use register to work with to flash LED for ID number

; Initial flash
	bsf		PORTA,7			; Ack LED on 
	movlw 	D'40'
	movwf	STORE3
MORE_DELAYI
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYI	
	movf	SYNCHRON_FLAG,w
	btfsc	STATUS,Z 		; if zero 	
	goto	CK_LOCK_OPEN

; now flash ID value
FLASH_ID	
	bcf		PORTA,7			; Ack LED off 
	movlw 	D'20'
	movwf	STORE3
	
MORE_DELAYA
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYA	

	bsf		PORTA,7			; Ack LED on 
	movlw 	D'10'
	movwf	STORE3
MORE_DELAYB
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYB	
	
	decfsz	SYNCHRON_FLAG,f	; decrease til zero
	goto	FLASH_ID

; check for lockout open
CK_LOCK_OPEN
	btfsc	PORTB,6			; check lockout if open start normal program
	goto	LOCKOUT_OPEN

; decrease counter
	decfsz	ALL_COUNT,f		; decrease til zero
	goto	SHOW_ID

; zero so clear all IDs

	movlw	EEPROM177		; 0-8 flags
	call	EEREAD1			; sets EEADR
	clrw					; clear all flags	
	call 	EEWRITE1		; write values
	movlw	EEPROM176		; 9-16 flags
	call	EEREAD1			; SETS EEADR
	clrw					; clear all flags
	call 	EEWRITE1		; write values

; ack LED on
	bsf		PORTA,7
LOOP_TIL_OPEN
	btfss	PORTB,6			; check lockout if open start normal program
	goto	LOOP_TIL_OPEN
	goto	LOCKOUT_SEL_DELAY

SHOW_ID
	bcf		PORTA,7			; ack LED off 
	movlw 	D'200'			; extra delay
	movwf	STORE3
	
MORE_DELAYC
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYC	
	goto	REFLASH			; keep flashing

LOCKOUT_SEL_DELAY
	bcf		PORTA,7			; ack LED off 
	movlw 	D'100'			; extra delay
	movwf	STORE3

MORE_DELAYD
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYD
	
LOCKOUT_OPEN	
	bcf		PORTA,7			; Ack LED off
	bsf		INTCON,GIE		; interrupt on
	goto	CHECK_INPUTS

; ************************************************
	
MOM_TOGG ; sets momentary or toggle for output as selected with BCD switch at setting 1, 2 or 3
	bcf		INTCON,GIE		; interrupt off
	
; output number (1,2 or 3) set with BCD1
	
	clrf	TEMP			; set at 0 initially 
	btfss	PORTB,0			; BCD1, (8) if bit 0 low then ms bit (8) so set bit 3 
	bsf		TEMP,3
	btfss	PORTB,1			; BCD1, (2)
	bsf		TEMP,1
	btfss	PORTB,2			; BCD1, (4)
	bsf		TEMP,2
	btfss	PORTB,3			; BCD1, (1)
	bsf		TEMP,0

	movf	TEMP,w
	btfsc	STATUS,Z		; if zero out
	goto	OUT_TOGG
	
	sublw	D'3'			; if >3 out
	btfss	STATUS,C
	goto	COMPENSATE_VAL 

	bsf		PORTA,7			; ack LED on

; read toggle/momentary bits
	movlw	EEPROM178
	call	EEREAD1			; value in EEPROM178
	movwf	STORE3
; find output selection

	movf	TEMP,w
	xorlw	D'1'			; output 1
	btfsc	STATUS,Z		; if 1 alter output 1 operation	
	goto	ALT_1
	movf	TEMP,w
	xorlw	D'2'			; output 2
	btfsc	STATUS,Z		; if 1 alter output 1 operation	
	goto	ALT_2
	movf	TEMP,w
	xorlw	D'3'			; output 3
	btfsc	STATUS,Z		; if 1 alter output 1 operation	
	goto	ALT_3
OUT_TOGG
	movlw 	D'100'			; extra delay
	movwf	STORE3

MORE_DEL
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DEL
	
	bcf		PORTA,7			; Ack LED off
	bsf		INTCON,GIE		; interrupt on
	goto	CHECK_INPUTS

ALT_1
	btfss	STORE3,0		; if set clear, if clear set
	goto	SET_TOGG1
	bcf		STORE3,0
	goto	WRI_MOM_TOGGLE
SET_TOGG1
	bsf		STORE3,0
	goto	WRI_MOM_TOGGLE
ALT_2
	btfss	STORE3,1		; if set clear, if clear set
	goto	SET_TOGG2
	bcf		STORE3,1
	goto	WRI_MOM_TOGGLE
SET_TOGG2
	bsf		STORE3,1
	goto	WRI_MOM_TOGGLE
ALT_3
	btfss	STORE3,2		; if set clear, if clear set
	goto	SET_TOGG3
	bcf		STORE3,2
	goto	WRI_MOM_TOGGLE
SET_TOGG3
	bsf		STORE3,2

WRI_MOM_TOGGLE
	movf	STORE3,w
	call	EEWRITE1
	goto	OUT_TOGG

COMPENSATE_VAL
	movlw 	D'250'
	movwf	STORE3
	
MORE_DELAY9
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY9	

; if PORTB,5 low change setting
	btfsc	PORTB,5
	goto	OUT_TOGG
	bsf		PORTA,7			; ack LED on
; read compensate value
	movlw	EEPROM179
	call	EEREAD1			; sets EEADR
	bcf		STATUS,C
	movf	TEMP,w			; BCD switch value
	movwf	COMPENSATE
	call	EEWRITE1
	
	goto	OUT_TOGG

; **************************************************************

; subroutines

; delay
DELAYms
	movlw	D'20'		; delay 
DELAY
	movwf	STORE1		; STORE1 is number of loops value
LOOP1	
	movlw	D'255'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return

; subroutines to read EEPROM memory

EEREAD; when interrupt stopped	
	bcf		INTCON,GIE	; clear global interrupt enable 
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	bsf		INTCON,GIE	; set global interrupt enable 
	return

EEREAD1; when interrupt not stopped	
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

EEREAD2; when EEADR is set
	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf		STATUS,RP1	; bank 2
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	bsf		INTCON,GIE	; set global interrupt enable 
	return

; subroutines to write to EEPROM

EEWRITE
	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence

	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
	bsf		INTCON,GIE	; set global interrupt enable 
	return				; value written 

EEWRITE1; before interrupts enabled

	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bcf		INTCON,GIE	; disable interrupts
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence

	bcf		EECON1,WREN	; clear WREN bit
WRITE1	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
	return				; value written 

; ************************************************

	org	H'800'; page 1	
; scramble data decode
DECODE_SCRAMBLE
	movf	SCRAMBLE,w
	andlw	B'00011111'	; count of 32 maximum
	movwf	SCRAMBLE1
	btfsc	STATUS,Z	; if zero
	goto	ZERO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 1	
	goto	ONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 2	
	goto	TWO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 3	
	goto	THREE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 4	
	goto	FOUR_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 5	
	goto	FIVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 6	
	goto	SIX_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 7	
	goto	SEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 8	
	goto	EIGHT_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 9	
	goto	NINE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 10	
	goto	TEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 11	
	goto	ELEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 12	
	goto	TWELVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 13	
	goto	THIRTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 14	
	goto	FOURTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 15	
	goto	FIVETEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 16	
	goto	SIXTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 17	
	goto	SEVENTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 18
	goto	EIGHTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 19	
	goto	NINETEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 20	
	goto	TWENTY_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 21	
	goto	TWENTYONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 22	
	goto	TWENTYTWO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 23	
	goto	TWENTYTHREE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 24	
	goto	TWENTYFOUR_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 25	
	goto	TWENTYFIVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 26	
	goto	TWENTYSIX_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 27	
	goto	TWENTYSEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 28	
	goto	TWENTYEIGHT_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 29	
	goto	TWENTYNINE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 30	
	goto	THIRTY_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 31	
	goto	THIRTYONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 32	
	goto	THIRTYTWO_SCRAMBLE

ZERO_SCRAMBLE
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf		PCLATH,3		; page 0
	return
ONE_SCRAMBLE
; 0,1,3,2,4,5 transmitter scramble (swap 2&3)
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE3	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf		PCLATH,3		; page 0
	return
TWO_SCRAMBLE
; 0,2,1,3,4,5 (swap 2&1)
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
THREE_SCRAMBLE
; 0,2,3,1,4,5 scramble
; 0,1,2,3,4,5 unscramble
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
FOUR_SCRAMBLE
; 0,3,1,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
FIVE_SCRAMBLE
; 0,3,2,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
SIX_SCRAMBLE
; 1,2,3,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
SEVEN_SCRAMBLE
; 1,2,0,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
EIGHT_SCRAMBLE
; 1,3,0,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
NINE_SCRAMBLE
; 1,3,2,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
TEN_SCRAMBLE
; 1,0,2,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
ELEVEN_SCRAMBLE
; 1,0,3,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
TWELVE_SCRAMBLE
; 2,0,1,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
THIRTEEN_SCRAMBLE
; 2,0,3,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
FOURTEEN_SCRAMBLE
; 2,1,0,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
FIVETEEN_SCRAMBLE
; 2,1,3,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
SIXTEEN_SCRAMBLE
; 2,3,0,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
SEVENTEEN_SCRAMBLE
; 2,3,1,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
EIGHTEEN_SCRAMBLE
; 3,0,1,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
NINETEEN_SCRAMBLE
; 3,0,2,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE4,w
 	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
TWENTY_SCRAMBLE
; 3,1,0,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
TWENTYONE_SCRAMBLE
; 3,1,2,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
TWENTYTWO_SCRAMBLE
; 3,2,0,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
TWENTYTHREE_SCRAMBLE
; 3,2,1,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	bcf  	PCLATH,3		; page 0
	return
TWENTYFOUR_SCRAMBLE
; 4,5,0,1,2,3
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE2
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	bcf  	PCLATH,3		; page 0
	return
TWENTYFIVE_SCRAMBLE
; 4,5,0,1,3,2
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	bcf  	PCLATH,3		; page 0
	return
TWENTYSIX_SCRAMBLE
; 4,5,0,2,1,3
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE1
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	bcf  	PCLATH,3		; page 0
	return
TWENTYSEVEN_SCRAMBLE
; 4,5,0,2,3,1
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE1
	bcf  	PCLATH,3		; page 0
	return
TWENTYEIGHT_SCRAMBLE
; 4,5,0,3,1,2
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE1
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	bcf  	PCLATH,3		; page 0
	return
TWENTYNINE_SCRAMBLE
; 4,5,0,3,2,1
; 0,1,2,3,4,5	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE2
	movf	RECEIVE5,w
	movwf	REC_EIVE1
	bcf  	PCLATH,3		; page 0
	return
THIRTY_SCRAMBLE
; 4,5,1,2,3,0
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE0
	bcf  	PCLATH,3		; page 0
	return
THIRTYONE_SCRAMBLE
; 4,5,1,2,0,3	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE0
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	bcf		PCLATH,3
	return
THIRTYTWO_SCRAMBLE
; 4,5,1,3,0,2	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE0
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	bcf  	PCLATH,3		; page 0
	return


; number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	X  = (a * X(previous) + c) 

;	X is the result (2**48 bits used) and becomes the seed for next calculation 
;	with multiplier a (24 bit), increment c (8-bit) 

RANDOM

		movf		RANDB0,w		; random numbers
		movwf		AARGB0
		movf		RANDB1,w
		movwf		AARGB1
		movf		RANDB2,w
		movwf		AARGB2
		movf		RANDB3,w
		movwf		STO_RANDB3
		movwf		AARGB3
				

		movf		MULT2,w			; multiplier 
		movwf		BARGB2
		movf		MULT1,w
		movwf		BARGB1
		movf		MULT0,w
		movwf		BARGB0

		call		FXM3224U		; multiply

		movf		INCREMENT,w		; increment value
        addwf       AARGB6,F		; c = incrementer
        btfsc       STATUS,Z		; carry to more significant bytes
        incf        AARGB5,F
		btfsc		STATUS,Z
		incf		AARGB4,F
		btfsc		STATUS,Z
		incf		AARGB3,F
		btfsc       STATUS,Z
        incf        AARGB2,F
		btfsc		STATUS,Z
		incf		AARGB1,F
		btfsc		STATUS,Z
		incf		AARGB0,F

; transfer values to RAND registers
	
		movf		AARGB1,w
		movwf		RANDB5
		movf		AARGB2,w
		movwf		RANDB4

		movf		AARGB3,w
		movwf		RANDB0
		movf		AARGB4,W
		movwf		RANDB1
		movf		AARGB5,W
		movwf		RANDB2
		movf		AARGB6,W
		movwf		RANDB3

; check if value the same as last time
		movf		STO_RANDB3,w
		xorwf		RANDB3,w
		btfsc		STATUS,Z
		incf		RANDB3,f
; check if last 4-ls bits were the same
		movf		STO_RANDB3,w
		andlw		H'0F'			; least 4-bits
		movwf		TEMPX
		movf		RANDB3,w
		andlw		H'0F'	
		xorwf		TEMPX,w
		btfsc		STATUS,Z
		incf		RANDB3,f

		incf		SCRAMBLE,f		; scramble changes each time
		bcf			PCLATH,3		; page 0		
		return


;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
               	clrf   		 	AARGB4          ; clear partial product
               	clrf    		AARGB5
               	clrf    		AARGB6
                movf   			AARGB0,W
                movwf   		TEMPB0
                movf   			AARGB1,W
                movwf   		TEMPB1
                movf   			AARGB2,W
                movwf   		TEMPB2
                movf   			AARGB3,W
                movwf   		TEMPB3

               	call 			UMUL3224L

                retlw           D'00'

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L       movlw   		D'8'
                movwf   		LOOPCOUNT

LOOPUM3224A
                rrf    		 	BARGB2,F
                btfsc   		STATUS,C
               	goto   			ALUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto   			LOOPUM3224A

                movwf   		LOOPCOUNT

LOOPUM3224B
                rrf     		BARGB1,F
                btfsc   		STATUS,C
               	goto   			BLUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto   			LOOPUM3224B

                movwf  			LOOPCOUNT

LOOPUM3224C
                rrf     		BARGB0,F
                btfsc   		STATUS,C
              	goto  	 		CLUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto  	 		LOOPUM3224C

              	clrf    		AARGB0
               	clrf    		AARGB1
               	clrf    		AARGB2
               	clrf    		AARGB3
                retlw   		D'00'
                
ALUM3224NAP     bcf     		STATUS,C
               	goto  	 		ALUM3224NA
                
BLUM3224NAP     bcf     		STATUS,C
               	goto 	  		BLUM3224NA
                
CLUM3224NAP     bcf     		STATUS,C
              	goto  	 		CLUM3224NA

ALOOPUM3224
                rrf     		BARGB2,F
                btfss   		STATUS,C
                goto   			ALUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

ALUM3224NA
                rrf    			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf             AARGB3,F
                rrf             AARGB4,F
                decfsz  		LOOPCOUNT,F
                goto    		ALOOPUM3224

                movlw   		D'8'
                movwf   		LOOPCOUNT

BLOOPUM3224
                rrf     		BARGB1,F
                btfss   		STATUS,C
              	goto  	 		BLUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

BLUM3224NA
                rrf    			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf             AARGB3,F
                rrf             AARGB4,F
                rrf             AARGB5,F
                decfsz  		LOOPCOUNT,F
              	goto   			BLOOPUM3224

                movlw   		D'8'
                movwf   		LOOPCOUNT

CLOOPUM3224
                rrf     		BARGB0,F
                btfss   		STATUS,C
               	goto 	  		CLUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

CLUM3224NA
                rrf  			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf    			AARGB3,F
                rrf             AARGB4,F
                rrf             AARGB5,F
                rrf             AARGB6,F
                decfsz  		LOOPCOUNT,F
                goto   			CLOOPUM3224
				return	
 

; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 

INTERRUPT
	
	bcf		STATUS,RP0
	bcf		STATUS,RP1	; bank 0

	btfss	PIR1,TMR1IF	; check timer 1 flag
	goto	RECLAIM		; not timer 1
; preload timer
	bcf		T1CON,0		; timer 1 off	
	movf	TIMER1H_VAL,w
	addwf	TMR1H,f
	movf	TIMER1L_VAL,w
	addwf	TMR1L,f
	btfsc	STATUS,C
	incf	TMR1H,f		; increase ms byte if ls addition has carry
	bsf		T1CON,0		; timer 1 on

	bcf		PIR1,TMR1IF	; clear timer 1 overflow

	bsf		FLAG,0		; set flag bit to indicate an interrupt has occurred

	decf	COUNTER_DIV,f	; extra divider for timers/counters
	decf	COUNTER_DIV1,f	; extra divider for timers/counters
	decf	COUNTER_DIV2,f	; extra divider for timers/counters
	decf	COUNTER_DIV3,f	; extra divider for timers/counters

COUNTERS
	movf	COUNTER_DIV,w
	btfss	STATUS,Z		; when zero 0.26s so run counters
	goto	DIVIDER

; decrease SYNC_SET to 0 after 0.75s maximum (when 0 returns to block1 data for synchronise)

	movf	SYNC_SET,w			; block2 data 
	btfss	STATUS,Z			; if zero do not decrease
	decf	SYNC_SET,f

DIVIDER
; divider 1
	movf	COUNTER_DIV1,w
	btfss	STATUS,Z			; when zero 0.26s so run counters
	goto	DIVIDER2
	incf	DIV4_1,f
	movf	DIV4_1,w
	andlw	B'00000011'			; use ls bits
	movwf	DIV4_1	

; decrease counters to zero 
; Momentary period 1
MO_1	
	btfss	FLAG_MOM,1			; if flag is clear, bypass DIV2 division
	goto	BY1
	movf	DIV4_1,w
	btfss	STATUS,Z			; if zero check MOM_PERIOD1
	goto	DIVIDER2			; check momentary 2
BY1
	movf	MOM_PERIOD1,w		; momentary period for output 1
	btfss	STATUS,Z			; if zero do not decrease
	decfsz	MOM_PERIOD1,f
	goto	DIVIDER2
	bcf		PORTA,4				; output low on end of timeout if momentary mode

DIVIDER2			
; divider 2	
	movf	COUNTER_DIV2,w
	btfss	STATUS,Z			; when zero 0.26s so run counters
	goto	DIVIDER3
	incf	DIV4_2,f
	movf	DIV4_2,w
	andlw	B'00000011'			; use ls bits
	movwf	DIV4_2	

; Momentary period 2
MO_2
	btfss	FLAG_MOM,2			; if flag is clear, bypass DIV2 division
	goto	BY2
	movf	DIV4_2,w
	btfss	STATUS,Z			; if zero check MOM_PERIOD2
	goto	DIVIDER3			; check momentary 3
BY2
	movf	MOM_PERIOD2,w		; momentary period for output 2
	btfss	STATUS,Z			; if zero do not decrease
	decfsz	MOM_PERIOD2,f
	goto	DIVIDER3
	bcf		PORTA,6				; output low on end of timeout if momentary mode

DIVIDER3
; divider 3
	movf	COUNTER_DIV3,w
	btfss	STATUS,Z			; when zero 0.26s so run counters
	goto	RECLAIM
	incf	DIV4_3,f
	movf	DIV4_3,w
	andlw	B'00000011'			; use ls bits
	movwf	DIV4_3

; Momentary period 3
MO_3
	btfss	FLAG_MOM,3			; if flag is clear, bypass DIV2 division
	goto	BY3
	movf	DIV4_3,w
	btfss	STATUS,Z			; if zero check MOM_PERIOD3
	goto	RECLAIM				; out
BY3
	movf	MOM_PERIOD3,w		; momentary period for output 3
	btfss	STATUS,Z			; if zero do not decrease
	decfsz	MOM_PERIOD3,f
	goto	RECLAIM
	bcf		PORTA,1				; output low on end of timeout if momentary mode

; end of interrupt reclaim w and status 
RECLAIM
	movf	PCLATH_STO,w; restore PCLATH	
	movwf	PCLATH
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt
 
  	            

 end
