;
;Serial to IrDA adapter: 4800 Baud version
;
	processor	12f629
	__config	0x184	;_CP_OFF & _WDT_OFF & _BODEN_OFF & _PWRTE_ON
				;_INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

delay	equ	0x20		;general delay register
timer1	equ	0x21		;
timer2	equ	0x22		;sleep timer registers
timer3	equ	0x23		;
				;
start				;
	org	0x00		;
	nop			;
	goto	init		;jump over interrupt vector
	org	0x04		;
	nop			;
init				;
	movlw	0x07		;
	movwf	0x19		;comparator disabled
	bsf	0x03,0x05	;select bank 1
	call	0x3FF		;calibration value stored in 0x3FF
	movwf	0x90		;calibration value into OSCCAL
	movlw	0x3B		;GP0,1,3,4,5 inputs; GP2 output (111011)
	movwf	0x85		;move into TRISIO
	bcf	0x03,0x05	;select bank 0
timerclr			;
	clrf	timer1		;reset sleep timer
	clrf	timer2		;
	movlw	0x1A		;
	movwf	timer3		;
loop				;
	decfsz	timer1,1	;sleep timer
	goto	bittest		;
	decfsz	timer2,1	;
	goto	bittest		;~10 seconds
	decfsz	timer3,1	;
	goto	bittest		;
	goto	powerdown	;if no input, go to sleep
bittest				;
	btfsc	0x05,0x05	;check input - hi or lo?
	goto	loop		;if logic hi - keep looping; if logic lo - flash LED
	movlw	0x1E		;
	movwf	delay		;
pulse1				;
	decfsz	delay,1		;
	goto	pulse1		;
pulse2				;
	movlw	0x05		;
	movwf	delay		;
	movlw	0x04		;(000100)
	movwf	0x05		;LED ON
pulse3				;
	decfsz	delay,1		;
	goto	pulse3		;
	clrf	0x05		;LED OFF
	movlw	0x40		;
	movwf	delay		;
pulse4				;
	decfsz	delay,1		;
	goto	pulse4		;
	btfsc	0x05,0x05	;check next input bit - hi or lo?
	goto	timerclr	;if hi - return to loop & wait for next lo
	goto	pulse2		;if lo - flash again
powerdown			;
	clrf	0x05		;
	movlw	0x08		;enable GPIO change (00001000)
	movwf	0x0B		;move into INTCON
	bsf	0x03,0x05	;
	bsf	0x96,0x00	;wakeup on GP0 change
	bcf	0x03,0x05	;
	sleep			;go to sleep
	nop			;
	clrf	0x0B		;disable GPIO change, clear flag
	goto	start		;
				;
	end			;
