
// This is a rudimentary piece of software to testdrive the AruduTronic LP gas fuel injection system for single cylinder engines.

// The Volumetric Efficiency calculation is very rudimentary, but will suffice for testing and for engines that run at a constant 
// rpm such as generators or pumps. For more sophisticated use, a good sized table will need to be implemented.

// When running the injector, note that it will overheat if it is kept turned on for more than about 80 percent of the time. 
// (ie duty cycle >= 80% is bad!). So calculate the rpm as a time per revolution and compare it to your programmed injector ON time
// and don't forget to add the injector opening and closing times to the total ON time.

// The injector has a maximum switching speed, so be aware that it may not suit your 12,000 rpm engine

// Don't forget that the println statements take a finite amount of time to execute. Comment them out when the testing is finished or 
// you will find that they can interfere with the timing loops and cause the injector to miss it's cue. My engine had a regular miss 
// around once per second with some of the printlns in place.



volatile float time = 0;
volatile float time_last = 0;
volatile long rpm_array[5] = {0,0,0,0,0};
volatile int InjectorPin = 5;
volatile boolean InjectorState;
volatile int PrimeButton = 11;
int AtmosPressure;                                       // MAP with engine stationary
long MaxTimerCount = 24576;                              // Corresponds to an injector time of 12 mSeconds
float VE[] = {0.48,0.52,0.56,0.60,0.65,0.68,0.70};       // Volumetric Efficiency, generally between 0 and 1
float RunningMAP;                                        // MAP value with engine running
float AirMass;                                           // MAP corrected cylinder air mass 
float VECorrectedMass;                                   // VE corrected cylinder air mass
float CorrectedMaxCount;                                 // Set up Timer 1 compare value
long rpm = 0;                                            // Crankshaft RPM value, sensed at the flywheel
int rpmIndex = 0;
int UpdatePause = 0;                                     // Delay to stop overly fast display updates
int InjectorDelay = 2;                                   // Injector opening and closing times lumped in together


void setup()
{
 cli();                                                 //Stop interrupts 
 
 attachInterrupt(0, hall_interrupt, FALLING);           //Digital Pin 2 Set As An Interrupt
 pinMode(InjectorPin, OUTPUT);
 pinMode(PrimeButton,INPUT);                            // Set it as input
 digitalWrite(PrimeButton, HIGH);                       //   and enable pullup
 delay(400);                                            //Allow sensors to warm up
 AtmosPressure = analogRead(A0);                        //Atmospheric pressure with engine off                                                                                                                                                                                                                                                                                          
  
 Serial.begin(115200);
 
 Serial.println ("Astmospheric Pressure"); 
 Serial.println (AtmosPressure);  
 
  
TCCR1A = 0;                                              // set entire TCCR1A register to 0
TCCR1B = 0;                                              // same for TCCR1B
TCNT1 = 0;                                               //initialize counter value to 0

TCCR1B |= (1 << WGM12);                                      // turn on CTC mode
TCCR1B |= (0 << CS12) | (1 << CS11) | (0 << CS10);           // Set CS10 and CS12 bits for 8 prescaler
TIMSK1 |= (0 << OCIE1A);                                     // disable timer compare interrupt

sei();                                                       //allow interrupts
}


void loop()                     
{
  
  
  //delay(700);                  //Slow down the display updates to make it readable when testing
   
  // Serial.println ("RPM");  
  // Serial.println  (rpm);  
   
    RunningMAP = analogRead(A0);
    AirMass = RunningMAP/AtmosPressure;                          // Correct for MAP 
    VECorrectedMass = AirMass * VE[rpmIndex];                    // Correct for VE
    CorrectedMaxCount = VECorrectedMass * MaxTimerCount;         // Set up Timer 1 compare value
      
    if (digitalRead(PrimeButton) == LOW)
      {
       digitalWrite(InjectorPin, HIGH);                         // Set the injector ON  
      }
    else
     {
      digitalWrite(InjectorPin, InjectorState);                 // Return it the way it was
     }
          
     if(time > 0)                                              // Update The RPM
        {
          rpm_array[0] = rpm_array[1];                         // 5 Sample Moving Average To Smooth Out The Data
          rpm_array[1] = rpm_array[2];
          rpm_array[2] = rpm_array[3];
          rpm_array[3] = rpm_array[4];
          rpm_array[4] = 60*(1000000/time);  
          
                                              //Average the last five RPM readings
        
          rpm = (rpm_array[0] + rpm_array[1] + rpm_array[2] + rpm_array[3] + rpm_array[4]) / 5;
         }
   
   
          
       if (rpm < 500)                        // This is a rudimentary VE table which will work well for 
        {                                    //  engines that operate at constant RPM. 
          rpmIndex = 0;
        }
        else if (500 >= rpm < 1000)          // NOTE that these values need to be tuned for your engine!
        {
          rpmIndex = 1;
        }
        
        else if (1000 >= rpm < 1500)
        {
          rpmIndex = 2;
        }
        
        else if (1500 >= rpm < 2000)
        {
          rpmIndex = 3;
        }
        
        else if (2000 >= rpm < 2500)
        {
          rpmIndex = 4;
        } 
        
        else if (2500 >= rpm < 3000)
        {
          rpmIndex = 5;
        }
        
        else
        {
          rpmIndex = 6;
        }   
          
        
      
         
         
    /*  UpdatePause++;
      if( UpdatePause > 1)                    // Change the pause to suit yourself
      {
   
      Serial.println ("Running MAP");     
      Serial.println (RunningMAP);
      Serial.println ("Air Mass Ratio");
      Serial.println (AirMass);
      Serial.println ("VE corrected air mass ratio");
      Serial.println (VECorrectedMass);
      Serial.println ("Corrected timer count");
      Serial.println (CorrectedMaxCount);
      
      UpdatePause = 0;
      }
    */

 
}            // Close loop subroutine



// ************************** ISR: Capture The Hall Flywheel Sensor Period ********************************

void hall_interrupt()
{
   time = (micros() - time_last); 
   time_last = micros();
   TCNT1 = 0;                               // initialize counter value to 0 
    
   OCR1A = CorrectedMaxCount;               // set compare match register
   TIMSK1 |= (1 << OCIE1A);                 // enable timer compare interrupt
   digitalWrite(InjectorPin, HIGH);         // set the injector on
   InjectorState = HIGH;                    // Store the state of the injector
}

// ************************************* ISR: Timer has expired, so turn off injector ***********************

ISR(TIMER1_COMPA_vect)
{
  TIMSK1 |= (0 << OCIE1A);                   // disable timer compare interrupt
  delay(InjectorDelay);                      // Add injector opening/closing times here
  digitalWrite(InjectorPin, LOW);            // set the injector off
  InjectorState = LOW;                       // Store the state of the injector
}



