'this version controls an 8 digit 7 segment LED display
'using a 74HC238 decoder chip

    For i = 1 To 8:SetPin i,8:Next i
    For i = 15 To 18:SetPin i,9:Next i
    SetPin 14,8:SetPin 19,8:SetPin 20,8
    SetPin 13,3
    SetTick 25,display

main:
    GoSub blank
    Input n
    GoSub format
    Pause 5000
GoTo main

format:
    Pin(14) = 0:Pin(19) = 0:Pin(20) = 0 'turn off DPt & - signs
    n$ = Str$(n)
    If Left$(n$,1) = "-" Then   'check if a negative No
        n$ = Right$(n$,Len(n$) - 1)   'delete - sign
        Pin(14) = 1             'set -ve sign
    EndIf
    l = Len(n$)

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'1st check if number is in FPt form
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    d = Instr(1,n$,"E")
    If d > 0 Then
        If Abs(n) > 3.4e38 Or Abs(n) < 1.18e-38 Then GoTo error1
        m = Instr(1,n$,"-")        'is exponent -ve?
        If m > 0 Then Pin(20) = 1  'if so set -ve exponent sign
        n$ = Left$(n$,1) + Mid$(n$,3,d-3) + String$(8-d,"0") + Right$(n$,2)
        number$ = n$                    'pass No to display interrupt
        Pin(19) = 1                     'set DPt
        Return
    EndIf

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'now check for integer or fixed point
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    d = Instr(1,n$,".")       'is No integer or fixed point decimal?
    If d = 0 Then             'it is an integer
        n$ = String$(6-l,"0") + n$    'pad out number
        number$ = n$
    Return
    EndIf
    If Abs(n) >= 1 Then		'it is fixed point
        power = d - 2         'get exponent
        n$ = Left$(n$,d-1)+Right$(n$,l-d)+String$(7-l,"0")+"0"+Str$(power)
        Pin(19) = 1           'turn on DPt
        number$ = n$
        Return
    EndIf

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'whats left are decimal fractions like 0.00345
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    d = 2
loop1:
        d = d + 1				'count number of "0" after DPt
        If Mid$(n$,d,1) <> "0" Then GoTo cont
GoTo loop1
cont:
        power = d - 2			'calculate exponent
        Pin(20) = 1:Pin(19) = 1
        n$ = Right$(n$,l+1-d)+String$(6+d-l,"0")+Str$(power)
        number$ = n$
Return

display:

    For i = 1 To 8                      'get each digit in turn
        digit = Val(Mid$(number$,i,1))  'get current digit
        Pin(4) = 0                      'turn off display
        Port(15,4) = digit              'send digit to 4511
        Port(1,4) = i + 7               'display digit
    Next i                              'get next digit
    For i = 1 To 2: Next i              'adj brightness of last digit
    Pin(4) = 0                          'turn disp off
IReturn

blank:

    Pin(4) = 0:Pin(14) = 0:Pin(20) = 0
Return

error1:
    GoSub blank
    j = 0
    For i = 1 To 10
        j = Not j
        Pin(14) = j:Pin(20) = j
        Pause 500
    Next i
Return


                            
