'                       MUSICAL DOOR MINDER2 - PICAXE 08M2  
'                             (dminder2_08m2.bas)
'-------------------------------------------------------------------------------
'Door Minder uses the change in pressure when opening the door to sound the alarm.
'This trigger mode is similar to the Door Minder in July 95 issue of Silicon Chip.  
'Does not need to be located near the door to operate, place anywhere in the room.
'Minder will monitor rooms with several doors and is not effected by open windows.
'Includes an 8 second delay to stop extra alarms as the door is opened and closed.
'Jumpers select the alarm type using three alarm sounds and three music sequences.
'-------------------------------------------------------------------------------
 

on_delay:'------------- wait for op-amp stage to stablize after power-on -------   
pause 100
readadc C.4,b0
if b0 > 115 and b0 < 140 then: goto door_pulse: endif
goto on_delay

alarm_delay:' --------- delay to give only one alarm sound for each entry ------  
pause 8000
'goto door_pulse

door_pulse:'----------- wait for door pulse before selecting alarm "mode" ------
inc b6
readadc C.4,b1
if b1 < 100 or b1 > 155 then: goto alarm_mode: endif
pause 10
if b6 >= 8 then: b6 = 0: endif
goto door_pulse 

alarm_mode:' ---------- checks "mode" jumper to determine the alarm type -------
if pinC.3 = 0 then goto alarm_tone                    '(LKA)
if pinC.3 = 1 then goto alarm_tune                    '(LKB)

alarm_tone:'---------- checks "play" jumper to select one of three tones ------- 
readadc C.1,b2
if b2 > 200 then goto tone_1                          '(LK1)
if b2 < 200 and b2 > 50 then: goto tone_2: endif      '(LK2)
if b2 < 50  then goto tone_3                          '(LK3)

tone_1:'------ single beep
sound C.2,(90,80)
goto alarm_delay 

tone_2:'------ double beep
sound C.2,(90,50,100,70)
goto alarm_delay

tone_3:'------ triple beep
sound C.2,(90,50,100,70,90,50)
goto alarm_delay
      
alarm_tune:'--------- checks "play" jumper to select three tune sequences ------
readadc C.1,b3
if b3 > 200 then goto kids_tunes                      '(LK1)
if b3 < 200 and b3 > 50 then: goto theme_tunes: endif '(LK2)
if b3 < 50 then goto random_tunes                     '(LK3)

kids_tunes:'---------- a sequence of four kid's tunes played in rotation -------   
inc b4    
if b4 = 1 then goto tune_1
if b4 = 2 then goto tune_3
if b4 = 3 then goto tune_5
if b4 = 4 then goto tune_7
 
           
theme_tunes:'--------- a sequence of four theme tunes played in rotation -------
inc b5    
if b5 = 1 then goto tune_2
if b5 = 2 then goto tune_4
if b5 = 3 then goto tune_6
if b5 = 4 then goto tune_8

random_tunes:'--------- a sequence of eight tunes played in random order ------- 
if b6 = 1 then goto tune_1
if b6 = 2 then goto tune_2
if b6 = 3 then goto tune_3
if b6 = 4 then goto tune_4
if b6 = 5 then goto tune_5
if b6 = 6 then goto tune_6
if b6 = 7 then goto tune_7
if b6 = 8 then goto tune_8       

tune_1:'------ Peter Gunn  
tune 0,5,($66,$64,$67,$64,$69,$67,$64,$64,$66,$64,$67,$64,$69,$67,$A4,$21,$EC)
goto alarm_delay

tune_2:'------ Looney Tunes  
tune 0,5,($44,$42,$40,$42,$44,$43,$44,$40,$42,$42,$42,$C2,$42,$40,$6B,$40,$42)
goto alarm_delay

tune_3:'------ Star Wars   
tune 0,4,($65,$65,$EA,$C5,$43,$40,$8A,$C5,$43,$42,$40,$8A,$C5,$42,$43,$80)
goto alarm_delay

tune_4:'------ The Muppets  
tune 0,5,($2C,$24,$24,$27,$25,$64,$25,$40,$60,$62,$24,$64,$64,$6C,$64,$27)
goto alarm_delay 

tune_5:'------ Batman 
tune 0,5,($6A,$6A,$69,$69,$6A,$6A,$6B,$6B,$6A,$6A,$69,$69,$6A,$6A,$2B,$6C,$2B)
goto alarm_delay  

tune_6:'------ George Of The Jungle  
tune 0,3,($4C,$25,$25,$4C,$25,$29,$4C,$00,$4C,$25,$4C,$25,$4C,$27,$27,$4C,$29)
goto alarm_delay

tune_7:'------ Indiana Jones  
tune 0,4,($6C,$65,$67,$6C,$C0,$6C,$22,$6C,$64,$A5,$2C,$27,$6C,$69,$6B,$6C,$C5)
b4 = 0
goto alarm_delay

tune_8:'------ Adams Family  
tune 0,4,($05,$49,$05,$40,$2B,$07,$45,$04,$47,$04,$64,$29,$05,$40,$05,$49,$05)
b5 = 0
goto alarm_delay

'                          Available alarm tones and tunes
'                (use only two jumpers placed on the nominated links)
'--------------------------------------------------------------------------------
' ----- select tones -----                      
' LKA + LK1 = single beep                        
' LKA + LK2 = double beep                       
' LKA + LK3 = triple beep 
                      
' ----- select tunes -----
' LKB + LK1 = kid's tunes   (Looney Tunes; Muppets; George Jungle; Adams Family)
' LKB + LK2 = theme tunes   (Peter Gunn; Star Wars; Batman; Indiana Jones) 
' LKB + LK3 = random tunes  (above eight tunes played in a random order)
'--------------------------------------------------------------------------------
   

'                              Definition of variables
'--------------------------------------------------------------------------------
'b0 = readadc - on delay
'b1 = readadc - door pulse
'b2 = readadc - alarm tone
'b3 = readadc - alarm tune
'b4 = counter - kid's tunes
'b5 = counter - theme tunes
'b6 = counter - random tunes
'--------------------------------------------------------------------------------


'                             Microprocessor pin details
'                    (New standard Picaxe pin names used in program)
'--------------------------------------------------------------------------------             
'pin    name     type      use               pin    name     type      use             
' 1     +V      power     positive            5     C.2     output    alarm out
' 2     C.5     serial    ICSP input          6     C.1     analog    play links 
' 3     C.4     input     door pulse          7     C.0     serial    ICSP output
' 4     C.3     input     mode links          8     0V      power     negative
'--------------------------------------------------------------------------------   
