'                       MUSICAL DOOR MINDER1 - PICAXE 08M2  
'                             (dminder1_08m2.bas)
'-------------------------------------------------------------------------------
'Door Minder uses the change in pressure when opening the door to sound the alarm.
'This trigger mode is similar to the Door Minder in July 95 issue of Silicon Chip.  
'Does not need to be located near the door to operate, place anywhere in the room.
'Minder will monitor rooms with several doors and is not effected by open windows.
'Includes an 8 second delay to stop extra alarms as the door is opened and closed.
'Jumpers select the alarm type from three alarm sounds and three music selections.    
'------------------------------------------------------------------------------- 

on_delay:'------------- wait for op-amp stage to stablize after power-on -------   
pause 100
readadc C.4,b0
if b0 > 115 and b0 < 140 then: goto door_pulse: endif
goto on_delay

alarm_delay:' --------- delay to give only one alarm sound for each entry ------  
pause 8000
'goto door_pulse

door_pulse:'----------- wait for door pulse before selecting alarm "mode" ------
readadc C.4,b1
if b1 < 100 or b1 > 155 then: goto alarm_mode: endif
pause 10
goto door_pulse 

alarm_mode:' ---------- checks "mode" jumper to determine the alarm type -------
if pinC.3 = 0 then goto alarm_tone                '(LKA)
if pinC.3 = 1 then goto alarm_tune                '(LKB)

alarm_tone:'---------- checks "play" jumper to select one of three tones ------- 
readadc C.1,b2
if b2 > 200 then goto tone_1                      '(LK1)
if b2 < 200 and b2 > 50 then: goto tone_2: endif  '(LK2)
if b2 < 50  then goto tone_3                      '(LK3)

tone_1:'------ single beep
sound C.2,(90,80)
goto alarm_delay 

tone_2:'------ double beep
sound C.2,(90,50,100,70)
goto alarm_delay

tone_3:'------ triple beep
sound C.2,(90,50,100,70,90,50)
goto alarm_delay
      
alarm_tune:'---------- checks "play" jumper to select one of three tunes -------
readadc C.1,b3
if b3 > 200 then goto tune_1                      '(LK1)
if b3 < 200 and b3 > 50 then: goto tune_2: endif  '(LK2)
if b3 < 50 then goto tune_3                       '(LK3) 

tune_1:'------ Looney Tunes  
tune 0,5,($44,$42,$40,$42,$44,$43,$44,$40,$42,$42,$42,$C2,$42,$40,$6B,$40,$42)
goto alarm_delay

tune_2:'------ The Muppets  
tune 0,5,($2C,$24,$24,$27,$25,$64,$25,$40,$60,$62,$24,$64,$64,$6C,$64,$27)
goto alarm_delay

tune_3:'------ Adams Family  
tune 0,4,($05,$49,$05,$40,$2B,$07,$45,$04,$47,$04,$64,$29,$05,$40,$05,$49,$05)
goto alarm_delay


'                          Available alarm tones and tunes
'                (use only two jumpers placed on the nominated links)
'--------------------------------------------------------------------------------
'     ----- select tones -----                       ----- select tunes -----
'     LKA + LK1 = single beep                        LKB + LK1 = Looney Tunes
'     LKA + LK2 = double beep                        LKB + LK2 = The Muppets
'     LKA + LK3 = triple beep                        LKB + LK3 = Adams Family
'--------------------------------------------------------------------------------
   

'                              Definition of variables
'--------------------------------------------------------------------------------
'b0 = readadc - on delay
'b1 = readadc - door pulse
'b2 = readadc - alarm tone
'b3 = readadc - alarm tune
'--------------------------------------------------------------------------------


'                             Microprocessor pin details
'                    (new standard Picaxe pin names used in program)
'-------------------------------------------------------------------------------              
'pin    name     type      use               pin    name     type      use             
' 1     +V      power     positive            5     C.2     output    alarm out
' 2     C.5     serial    ICSP input          6     C.1     analog    play links 
' 3     C.4     input     door pulse          7     C.0     serial    ICSP output
' 4     C.3     input     mode links          8     0V      power     negative
'--------------------------------------------------------------------------------   
              
