//#define USE_RESISTOR
#define USE_OPTO
//#define USE_SWITCH
#define SENSE_PIN (1)
#define ACTION  Mouse.press(MOUSE_LEFT);delay(100);Mouse.release(MOUSE_LEFT);
#define DEBOUNCE_TIME 300

#include "Mouse.h"

void setup() {
  Serial.begin(115200);  
#ifdef USE_RESISTOR
  pinMode(SENSE_PIN,INPUT_PULLDOWN);
#endif
#ifdef USE_OPTO
  pinMode(SENSE_PIN,INPUT_PULLUP);
#endif
#ifdef USE_SWITCH
  pinMode(SENSE_PIN,INPUT_PULLUP);
#endif
}

void loop() {
  long t;  
  if(getState()){
    t=millis();
    while((millis()-t)<DEBOUNCE_TIME){      //let state be high for t before proceeding
      if(getState()==0){return;}
    }
    Serial.println("TRIGGER");              //output on serial for debugging
    ACTION                                  //do action
    while(getState()){}                     //wait til state goes low
    delay(DEBOUNCE_TIME);                   //and a bit more
  }
}

int getState(void){
#ifdef USE_RESISTOR
  return digitalRead(SENSE_PIN);
#endif
#ifdef USE_OPTO
  return (digitalRead(SENSE_PIN)==0);
#endif
#ifdef USE_SWITCH
  return (digitalRead(SENSE_PIN)==0);
#endif
  return 0; //default
}

