
int led = 13;
const char* pinmodes[14];

void setup()
{
  Serial.begin(115200);
  analogReference(3/*INTERNAL2V56*/);
  analogRead(0);
  for( char i = 0; i < 14; ++i )
    pinmodes[i] = "input";
  pinMode(led, OUTPUT);
}

char inbuf[64];
char lastsend[64];
char inbuflen;
char quiet;

void loop() {
  if( !Serial.available() )
    return;
  inbuf[inbuflen++] = Serial.read();
  if( inbuflen < 64 && inbuf[inbuflen-1] != '\r' && inbuf[inbuflen-1] != '\n' )
    return;
  char len = inbuflen;
  inbuflen = 0;
  digitalWrite(led, !digitalRead(led));
  if( len < 64 )
    inbuf[len] = '\0';
  while( len > 0 && (inbuf[len-1] == '\r' || inbuf[len-1] == '\n') )
    inbuf[--len] = '\0';
  if( len == 0 || !memcmp(inbuf, lastsend, len+1) )
    return;
  if( len < 64 ) {
    String cmd = inbuf;
    if( cmd.substring(0, 1) == "A" ) {
      int adcport = cmd.substring(1).toInt();
      if( (adcport < 10 && cmd.substring(2) == "?") || (adcport < 12 && cmd.substring(3) == "?") ) {
        analogRead(adcport);
        delay(1); // not necessary on Leostick but it is on Teensy
        dtostrf(analogRead(adcport) * 2.56 / 1024, 4, 3, lastsend);
        Serial.println(lastsend);
        Serial.flush();
        return;
      }
    } else if( cmd.substring(0, 1) == "D" ) {
      int pin = cmd.substring(1).toInt();
      if( (pin < 10 && cmd.substring(2) == "?") || (pin < 14 && cmd.substring(3) == "?") ) {
        lastsend[0] = '0' + digitalRead(pin);
        lastsend[1] = '\0';
        Serial.println(lastsend);
        Serial.flush();
        return;
      } else if( (pin < 10 && cmd.substring(2, 3) == "=") || (pin < 14 && cmd.substring(3, 4) == "=") ) {
        unsigned char val = pin < 10 ? cmd.substring(3).toInt() : cmd.substring(4).toInt();
        if( val <= 1 ) {
          digitalWrite(pin, val);
          pinMode(pin, OUTPUT);
          if( !quiet ) {
            sprintf(lastsend, "D%d set to %d", pin, val);
            Serial.println(lastsend);
          }
          pinmodes[pin] = "output";
          if( !quiet )
            Serial.flush();
          return;
        }
      }
    } else if( cmd.substring(0, 3) == "IPU" ) {
      int pin = cmd.substring(3).toInt();
      if( pin < 14 ) {
        digitalWrite(pin, 1);
        pinMode(pin, INPUT);
        if( !quiet ) {
          sprintf(lastsend, "D%d set as input with pull-up", pin);
          Serial.println(lastsend);
        }
        pinmodes[pin] = "input with pull-up";
        if( !quiet )
          Serial.flush();
        return;
      }
    } else if( cmd.substring(0, 1) == "I" ) {
      int pin = cmd.substring(1).toInt();
      if( pin < 14 ) {
        digitalWrite(pin, 0);
        pinMode(pin, INPUT);
        if( !quiet ) {
          sprintf(lastsend, "D%d set as input", pin);
          Serial.println(lastsend);
        }
        pinmodes[pin] = "input";
        if( !quiet )
          Serial.flush();
        return;
      }
    } else if( cmd.substring(0, 1) == "M" ) {
      int pin = cmd.substring(1).toInt();
      if( (pin < 10 && cmd.substring(2) == "?") || (pin < 14 && cmd.substring(3) == "?") ) {
//        sprintf(lastsend, "Digital pin %d is configured as %s", pin, pinmodes[pin]);
        strcpy(lastsend, pinmodes[pin]);
        Serial.println(lastsend);
        Serial.flush();
        return;
      }
    } else if( cmd == "quiet" ) {
      quiet = 1;
    } else if( cmd == "verbose" ) {
      quiet = 0;
    }
  }
  if( !quiet ) {
    Serial.print("Command error (");
    Serial.print(inbuf);
    Serial.println(")");
    Serial.println("");
    Serial.println("Usage:");
    Serial.println("Ax?   - read voltage at analog pin x (0-11)");
    Serial.println("Dx?   - read state of digital pin x (0-13)");
    Serial.println("Dx=y? - set digital pin x (0-13) to output state y (0,1)");
    Serial.println("Ix    - set digital pin x (0-13) as input without pull-up");
    Serial.println("IPUx  - set digital pin x (0-13) as input with pull-up");
    Serial.println("Mx?   - display digital pin x (0-13) mode (output, input, input with pull-up)");
  }
}

