//SSD1306/SH1106 OLED implementation for 16F1455

#ifndef OLED_H
#define OLED_H
#include <xc.h>
#include "io.h"
#include <libpic30.h>        //delay macros

#define OLED_ADDRESS 0x78   //8bit write address, read address is +1
//#define OLED_ADDRESS 0x7A   //8bit write address, read address is +1

//for flippable text display
//TEXT_LH is same as original
#define TEXT_RH 1
#define TEXT_LH 2

//special font characters
#define C_ERROR (27)
#define C_DIODER (28)
#define C_DIODEF (29)
#define C_OHM (30)
#define C_MICRO (31)

extern char col,page; //column variable
extern char textFlip;
extern unsigned char dbuf[10];

void OLEDsendCommand(unsigned char c);
void OLEDsendData(unsigned char c);
void OLEDbrightness(unsigned char b);
void OLEDclear(void);
void OLEDinit(void);
void OLEDsetpage(unsigned char p);
void OLEDsetcolumn(unsigned char c);
void OLEDflip(char c);      //to suit flip orientation according to textFlip
void OLEDchar(const char c,const char* f);//single character, col/page handled internally
void OLEDchararray(const char* c, const char* f);    //char array version of above
void OLEDscanlong(unsigned long n);

#endif  //OLED_H

