#include "config.h"
#include "util.h"
#include <xc.h>

//RevB pinout:
//RB6/15        OLEDPWR
//RB5/14        SDA
//RB7/16        SCL
//RB9/18        SW1
//RB8/17        SW2
//RA4/12        SW3
//RB15/AN9/26   AN1
//RB14/AN6/25   AN2
//RB13/AN7/24   AN3
//RB12/23       D2A
//RB11/22       D2B
//RA0/AN0/2     AN4
//RA1/AN1/3     AN5
//RB2/AN4/6     AN6
//RA2/9         D5A
//RA3/10        D5B
//RB0/RB1/4/5   PGD/PDC
//other
//MCLR/1
//(A)VSS/8/19/27
//(A)VDD/13/28
//VCAP/20
//not connected (to be set for low leakage)
//7//11/21=RB3/RB4/RB10

//see util.c/util.h for important variables and functions used in main

int main(void) {
    unsigned int iflags;    //save interrupt state, switch repeat counts
    CLKDIVbits.CPDIV=2;        //8MHz
    IOinit();
    setADC();
    I2Cinit();
    OLEDinit();
    OLEDflip(TEXT_RH);
    loadCalValues();
    INTCON2bits.GIE=1;          //start pending interrupts
    udflag=2;                   //flag display update
    tmout=cur.d.dTimeout;
    while(1){
        checkSW();
        if(sw3flag&&(inSettings==0)){SW3action();}  //normal mode SW3 response
        //SETTINGS
        if(inSettings){
            iflags=INTCON2;    //save interrupt state
            INTCON2bits.GIE=0;              //disable
            s1rpt=0;
            s2rpt=0;
            while(sw1count>120){sw1count=sw1count-40;s1rpt++;}     //gives delayed repeat
            while(sw2count>120){sw2count=sw2count-40;s2rpt++;}     //gives delayed repeat
            INTCON2=iflags;                 //restore
            if(sw1flag){SW1settings();SW1settingsRepeat();}
            if(sw2flag){SW2settings();SW2settingsRepeat();}
            while(s1rpt--){SW1settingsRepeat();}
            while(s2rpt--){SW2settingsRepeat();}
            if(sw3flag){SW3settings();}
            if(udflag){drawSettings();}
            if(saveState==2){               //perform save if flagged
                flashSave((unsigned int*)&cur,FLASHADD(&sav));
                saveState=3;
            }            
            if(inSettings==0){  //exit from settings here if flagged
                option=OLEDHAND;    //back to start
                OLEDclear();
                sw1flag=0;      //clear pending presses from other modes
                sw2flag=0;
                sw3flag=0;      //clear        
                udflag=2;       //big update needed
                tmout=cur.d.dTimeout;
                tmrLocked=0;    //unlock on mode change                                
                saveState=0;    //cancel any pending
            }
        }else{
        //NORMAL DISPLAY
            if(udflag){    //global displays
                if(udflag==2){  //update mode name
                    col=0;
                    page=6;
                    OLEDchararray(modeNames[mode],arial);                    
                }
                col=63;
                page=6;            
                vb=getVB();
                showB(vb,arial);       //battery
                col=104;
                page=6;
                c=tmout/3;             //show sleep countdown
                if(tmrLocked && flashFlag){
                    tmout=cur.d.dTimeout;
                    OLEDchar(' ',arial);        
                    OLEDchar(' ',arial);        
                }else{
                    if(c>99){
                        OLEDchar('+',arial);        
                        OLEDchar('+',arial);        
                    }else if(c>9){
                        OLEDchar((c/10)+'0',arial);                                
                        OLEDchar((c%10)+'0',arial);                                
                    }else{
                        OLEDchar(' ',arial);        
                        OLEDchar(c+'0',arial);        
                    }
                }
            }
            switch(mode){
                case AUTO:  doAuto();       doze();     break;
                case RES:   doResistor();   doze();     break;
                case CAP:   doCapacitor();  doze();     break;
                case DIODE: doDiode();      doze();     break;
                case METER: doMeter();      doze();     break;
                case SCOPE: doScope();      doze();     break;
                case SERDEC:doSERDEC();                 break;
                case IVPLOT:doIVPLOT();     doze();     break;
                case LOGIC :doLogic();                  break;                
                case TONE  :doTone();       doze();     break;
                default:
                    col=0;
                    page=6;
                    OLEDchararray("S3???",arial);   //unknown mode, S3 to change mode
                    break;
            }
            if(mode!=SCOPE){sampleFlag=0;}        //turn off if not in SCOPE mode
            doToneOutput();         //check this globally so that tone generation doesn't interfere
            if(tmout==0){           //sleep, during normal operation only (not settings)
                sleepAndWakeup();
                tmout=cur.d.dTimeout;            //reset sleep timer
            }
        }
    }
    return 0;           //shouldn't get here, resets
}
