//Tim Blythman
#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#define FCY 4000000UL
#include <libpic30.h>        //delay macros
//for initial tone setup
#include "util.h"

//RevB pinout:
//RB6/15        OLEDPWR
//RB5/14        SDA
//RB7/16        SCL
//RB9/18        SW1
//RB8/17        SW2
//RA4/12        SW3
//RB15/AN9/26   AN1
//RB14/AN6/25   AN2
//RB13/AN7/24   AN3
//RB12/23       D2A
//RB11/22       D2B
//RA0/AN0/2     AN4
//RA1/AN1/3     AN5
//RB2/AN4/6     AN6
//RA2/9         D5A
//RA3/10        D5B
//RB0/RB1/4/5   PGD/PDC
//other
//MCLR/1
//(A)VSS/8/19/27
//(A)VDD/13/28
//VCAP/20
//not connected (to be set for low leakage)
//7//11/21

#define VBG_REF (28)
#define BGVOLTAGE (1200L)

#define OLEDPWR (22)
#define SW1 (25)
#define SW2 (24)
#define SW3 (4)
#define AN_1 (31)
#define AN_2 (30)
#define AN_3 (29)
#define D_2A (28)
#define D_2B (27)
#define AN_4 (0)
#define AN_5 (1)
#define AN_6 (18)
#define D_5A (2)
#define D_5B (3)

#define T_SETTLE 100
#define R_VALID 10
#define D_VALID 200
#define PRESSED (0)

#define UART_BUFSIZE 128
extern int rxbuf[UART_BUFSIZE];
extern volatile int rx_head,rx_tail;
#define PARITY_FLAG (0x4000)
#define FRAME_FLAG (0x2000)

extern volatile unsigned int ctr;
extern volatile unsigned int udflag;
extern volatile unsigned int tmout;
extern const char anchan[];
extern long v[6];    //voltage samples with R dividers

extern long r1k,r10k,r100k,rlead;
extern char sw1flag;
extern char sw2flag;
extern char sw3flag;
extern volatile unsigned int sw1count; //to handle holds during settings
extern volatile unsigned int sw2count;
extern volatile char flashFlag;

//pinmode macros, correspond to pu,pd,ansel,tris =8,4,2,1
#define AN_INPUT_PULLUP (11)
#define AN_INPUT (3)
#define INPUT_PULLUP (9)
#define INPUT_PULLDOWN (5)
#define INPUT (1)
#define OUTPUT (0)
#define ADC_OS (16)

#define SDAHI {TRISBbits.TRISB5=1;}
#define SDALO {TRISBbits.TRISB5=0;}

#define SCLHI {TRISBbits.TRISB7=1;}
#define SCLLO {TRISBbits.TRISB7=0;}

//functions
void I2Cinit(void);
void I2Cdeinit(void);
void I2Cbit(unsigned char n);
void I2Cbyte(unsigned char n);
void I2Cstart(void);
void I2Cstop(void);
void IOinit(void);
int getADC(int c);
int getADCsamp(int c, long t);     //ADC with sample time t
void pinMode(char n, char mode);   //abstraction
void setPin(char n,char level);    //digital output
char getPin(char n);               //digital input
void setADC(void);                 //config to use ADC
void setCTMU(void);                //config to use CTMU
void setHigh(char n);              //simple wrappers for pinMode and setPin
void setLow(char n);
void setFloat(char n);             //analog input
void setInput(char n);             //digital input
void checkSW(void);                //sets flag(s) on downpress, with debounce
int uartRead(void);                //-1 on empty
int uartAvailable(void);

#endif	/* IO_H */
