//Tim Blythman
//#include <p24FJ256GA702.h>

#include "io.h"

volatile unsigned int ctr=0;
volatile unsigned int udflag=0;
volatile unsigned int tmout=0;
long v[6]={0,0,0,0,0,0};
char sw1flag=0;
char sw2flag=0;
char sw3flag=0;
volatile unsigned int sw1count=0; //to handle holds during settings
volatile unsigned int sw2count=0;
volatile char flashFlag=0;

//assume A0=0,A15=15,B0=16 etc
const char anchan[]={
//AN pins are A0,A1,B0,B1,B2,B3,B14,B13,B12,B15
    0,1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,
    2,3,4,5,-1,-1,-1,-1,
    -1,-1,-1,-1,8,7,6,9                                    
};

int rxbuf[UART_BUFSIZE];    //int in case of 9-bit data
volatile int rx_head=0;
volatile int rx_tail=0;

void IOinit(void){
    //switch IOs
    pinMode(SW1,INPUT_PULLUP);
    pinMode(SW2,INPUT_PULLUP);
    pinMode(SW3,INPUT_PULLUP);
    //sense IO pins to idle state which should discharge caps
    setLow(AN_1);
    setFloat(AN_2);
    setFloat(AN_3);
    setFloat(D_2A);
    setFloat(D_2B);
    setLow(AN_4);
    setFloat(AN_5);
    setFloat(AN_6);
    setFloat(D_5A);
    setFloat(D_5B);
    ///NC/PGD/PGC pins
    pinMode(19,INPUT_PULLDOWN);
    pinMode(20,INPUT_PULLDOWN);
    pinMode(26,INPUT_PULLDOWN);
    pinMode(16,INPUT_PULLDOWN);
    pinMode(17,INPUT_PULLDOWN);
    //ADC
    AD1CON1=0;              //reset ADC, right aligned absolute, 10bit
    AD1CON2=0;              //VDD/VSS, use CHA only
    AD1CON3=0;              //
    AD1CON4=0;              //
    AD1CON5=0;              //
    AD1CON1bits.MODE12=1;   //12bit
    AD1CON3bits.ADRC=1;     //use ADC RC clock
    //AD1CON3bits.ADCS=1;     //0.5us
    AD1CHS=0;               //negative ref=VSS
    ANCFGbits.VBGEN3=1;     //enable bandgap reference for ADC; BG is 1.2V+-5%    
    CTMUCON1Lbits.CTMUEN = 0; //make sure CTMU is disabled
    CTMUCON1Lbits.CTMUSIDL = 0; //CTMU continues to run in idle mode
    CTMUCON1Lbits.TGEN = 0; //disable edge delay generation mode of the CTMU
    CTMUCON1Lbits.EDGEN = 0; //edges are blocked
    CTMUCON1Lbits.EDGSEQEN = 0; //edge sequence not needed
    CTMUCON1Lbits.IDISSEN = 0; //Do not ground the current source
    CTMUCON1Lbits.CTTRIG = 0; //Trigger Output is disabled
    CTMUCON1H=0;              //edges disabled, edge controls ignored, IRNGH = low range
    CTMUCON2L=0;              //Source and discharge reset disabled
    CTMUCON1Lbits.IRNG=0;       //550uA
    CTMUCON1Lbits.ITRIM=0;      //nominal
    //use setADC() or setCTMU() to set correct mode
    setADC();
    //UART for serial decoding
    U1MODE=0;           //reset
    U1STA=0;
    U1MODEbits.BRGH=1;  //high speed
    U1STAbits.URXEN=1;  //enable rx
    __builtin_write_OSCCONL(OSCCON&0xbf);   //unlock for PPS write
    RPINR18bits.U1RXR=15;                   //RB15/AN9
    __builtin_write_OSCCONL(OSCCON|0x40);   //relock
    IEC0bits.U1RXIE=1;      //interrupt enable
    //everything else is set as needed
    //TIMER1
    T1CON=0;    //reset;TCS=FOSC/2, no sync, PS=1:1
    //LPRC:
    T1CONbits.TCS=1;        //not FOSC
    T1CONbits.TECS=2;       //LPRC
    PR1=62;                 //500Hz for minimum sample rate of scope
    IPC0bits.T1IP=4;        //4 is default interrupt priority
    IFS0bits.T1IF=0;
    IEC0bits.T1IE=1;
    T1CONbits.TON=1;        //running
    //CCP2 for complementary tone waveforms
    CCP2CON1L=0;        //reset, SYSCLK, PS=1:1, OC/PWM
    CCP2CON1H=0;        //reset
    CCP2CON2L=0;        //reset
    CCP2CON2H=0;        //reset
    CCP2CON3H=0;        //reset
    CCP2CON1Lbits.MOD=3;//toggle on compare
    CCP2CON2Hbits.OCAEN=1;  //A enable
    CCP2CON2Hbits.OCBEN=1;  //A enable
    CCP2CON3Hbits.POLACE=0; //active high
    CCP2CON3Hbits.POLBDF=1; //active low
    CCP2TMRH=0;
    CCP2TMRL=0;
    CCP2PRH=0;
    CCP2PRL=FCY/(2*toneF[0]);     //period for init freq setting;
    CCP2CON1Lbits.CCPON=1;  //on
}

void setADC(void){
    AD1CON1bits.ADON=0;         //off, reset ADC
    AD1CON1bits.SSRC=0;         //manual sample
    CTMUCON1Hbits.EDG1STAT=0;   //edge off
    CTMUCON1Lbits.CTMUEN = 0;   //CTMU off
    AD1CON1bits.ADON=1;         //on    
}

void setCTMU(void){
    AD1CON1bits.ADON=0;         //off, reset ADC
    AD1CON1bits.SSRC=0;         //manual sample
    CTMUCON1Lbits.CTMUEN = 1;   //CTMU on
    CTMUCON1Hbits.EDG1STAT=1;   //trigger edge
    CTMUCON1Lbits.ITRIM=cur.d.ctmuTrim;
    AD1CON1bits.ADON=1;         //on            
}

int getADC(int c){
    IFS0bits.AD1IF=0;           //reset FIFO
    AD1CHSbits.CH0SA=c;
    AD1CON1bits.SAMP = 1;       //start
    __delay32(100);              //tweaked to give 25kHz samples at 32MHz FRCPLL
    AD1CON1bits.SAMP = 0;       //start conversion
    while(!AD1CON1bits.DONE){}  // conversion done
    return ADC1BUF0;
}

int getADCsamp(int c, long t){
    IFS0bits.AD1IF=0;           //reset FIFO
    AD1CHSbits.CH0SA=c;
    AD1CON1bits.SAMP = 1;       //start
    __delay32(t);
    AD1CON1bits.SAMP = 0;       //start conversion
    while(!AD1CON1bits.DONE){}  // conversion done
    return ADC1BUF0;
}

//pinmode macros correspond to pu,pd,ansel,tris =8,4,2,1, see defines
void pinMode(char n, char mode){   //abstraction
    unsigned int mask,nmask;
    mask=1<<(n&0xF);
    nmask=~mask;
    if(n&0x10){ //RBxx
        if(mode&1){TRISB=TRISB|mask;}else{TRISB=TRISB&nmask;}
        if(mode&2){ANSELB=ANSELB|mask;}else{ANSELB=ANSELB&nmask;}
        if(mode&4){IOCPDB=IOCPDB|mask;}else{IOCPDB=IOCPDB&nmask;}
        if(mode&8){IOCPUB=IOCPUB|mask;}else{IOCPUB=IOCPUB&nmask;}
    }else{      //RAxx
        if(mode&1){TRISA=TRISA|mask;}else{TRISA=TRISA&nmask;}
        if(mode&2){ANSELA=ANSELA|mask;}else{ANSELA=ANSELA&nmask;}
        if(mode&4){IOCPDA=IOCPDA|mask;}else{IOCPDA=IOCPDA&nmask;}
        if(mode&8){IOCPUA=IOCPUA|mask;}else{IOCPUA=IOCPUA&nmask;}        
    }
}

void setPin(char n,char level){    //digital output
    unsigned int mask,nmask;
    mask=1<<(n&0xF);
    nmask=~mask;
    if(n&0x10){ //RBxx
        if(level){LATB=LATB|mask;}else{LATB=LATB&nmask;}        
    }else{      //RAxx
        if(level){LATA=LATA|mask;}else{LATA=LATA&nmask;}                
    }    
}

char getPin(char n){               //digital input
    unsigned int mask;
    unsigned int port;
    mask=1<<(n&0xF);
    if(n&0x10){ //RBxx
        port=PORTB;
    }else{      //RAxx
        port=PORTA;
    }        
    if(port&mask){return 1;}else{return 0;}
}

void setHigh(char n){
    setPin(n,1);
    pinMode(n,OUTPUT);
}

void setLow(char n){
    setPin(n,0);
    pinMode(n,OUTPUT);
}

void setFloat(char n){
    pinMode(n,AN_INPUT);    //analog input
}

void setInput(char n){
    pinMode(n,INPUT);    //digital input
}

void I2Cinit(void){
    //power on and delay
    setHigh(OLEDPWR);
    __delay_ms(10);
    //if needed for ANSEL etc
    //ANSELBbits.ANSB7=0;
    //ANSELBbits.ANSB5=0;
    TRISBbits.TRISB7=1;//input= pulled up by bus
    TRISBbits.TRISB5=1;//input= pulled up by bus
    LATBbits.LATB7=0;
    LATBbits.LATB5=0;
    I2Cstop();      //idle state
}

void I2Cdeinit(void){
    I2Cstart();      //low pin levels to avoid leakage
    setLow(OLEDPWR);
}

//write only:
void I2Cbit(unsigned char n){      //send one bit
    if(n){
        SDAHI
    }else{
        SDALO
    }
    //__delay_us(1); //as and where needed
    SCLHI
    //__delay_us(1); //as and where needed
    __delay32(1);   //seems to be enough
    SCLLO
}

void I2Cbyte(unsigned char n){  //send byte, unrolled inline version is slightly faster
    if(n&128){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&64){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&32){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&16){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&8){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&4){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&2){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    if(n&1){SDAHI}else{SDALO}
    SCLHI;Nop();SCLLO
    SDAHI;                          //ack
    SCLHI;Nop();SCLLO
}

void I2Cstart(void){                 //send start condition
    //SDAHI                            //allow repeated start
    SDALO
    SCLLO
}

void I2Cstop(void){                  //send stop condition
    SDALO
    SCLHI
    SDAHI
}

void checkSW(void){                       //sets flag on downpress, with debounce
    static char oldSW1=0;
    static char oldSW2=0;
    static char oldSW3=0;
    char s;
    s=(getPin(SW1)==PRESSED);
    if((s==1)&&(oldSW1==0)){sw1flag=1;}   //other code will clear when acted on
    oldSW1=s;
    s=(getPin(SW2)==PRESSED);
    if((s==1)&&(oldSW2==0)){sw2flag=1;}   //other code will clear when acted on
    oldSW2=s;    
    s=(getPin(SW3)==PRESSED);
    if((s==1)&&(oldSW3==0)){sw3flag=1;}   //other code will clear when acted on
    oldSW3=s;    
}

int uartRead(void){   //-1 on empty
  int c;
  if(rx_head==rx_tail){
      return -1;    //empty
  }
  c=rxbuf[rx_tail];
  rx_tail=(rx_tail+1)%UART_BUFSIZE;
  return c;    
}

int uartAvailable(void){
    return (rx_head+UART_BUFSIZE-rx_tail)%UART_BUFSIZE;    
}
