#ifndef DISPLAY_H
#define	DISPLAY_H
//display routines for Tweezers

#include <xc.h> // include processor files - each processor file is guarded.  
#include "oled.h"
#include <stdlib.h>        //abs

#define OLED_COLS (128)
#define OLED_ROWS (8)
extern unsigned char pixels[OLED_COLS][OLED_ROWS];            //bitmap for blitting to display
extern char xOffset;                            //to implement scrolling
extern const unsigned char grat[4][6];             //simple graticule bitmap

#define SIGNUM(x) (((x) > 0) - ((x) < 0))

void showOhms(long n,const char* f);            //adds suffixes etc, target for 6 char spaces
void showD(long vf, long vr, const char* f);    //show diode specs, 6 chars
void showB(long v, const char* f);              //show voltage x.xV
void narrowDot(void);                           //custom narrow . matching arial font
void showFarad(long n,const char* f);           //adds suffixes etc, target for 6 char spaces
void showV(long n,const char* f);               //adds suffixes etc, target for 6 char spaces
void showSint(int n,const char* f);             //signed int, 6 slots
void showV2(long n,const char* f);              //short version -xxV
void shown4(unsigned long n, const char*f);     //4 digit number raw
void pixel(int x,int y, int c);                  //pixel drawing
void clearPixels(unsigned char c);              //fill with c
void drawPixels(int c, int r, int x, int y);      //output c columns and r rows at x,y
unsigned char vBitmap(unsigned char v, unsigned char y);    //bitmap that would appear at page y for value v (0 at top)
unsigned char vBitmapSolid(unsigned char v,unsigned char oldv, unsigned char y);    //bitmap that would appear at page y for value v and oldv(0 at top)
void drawTrace(unsigned char v);    //at current col, top 6 pages
void drawCaret(unsigned char v);    //trig marker
void showLong(unsigned long n, const char* f);              //precision, with commas for long numbers, eg 1,000,000
void drawGraph(unsigned char v,unsigned char g);    //at current col, top 6 pages, with graticule g
void line(int x1,int y1,int x2,int y2, int c);      //Bresenham line implementation

#endif	/* DISPLAY_H */

