#ifndef MEASURE_H
#define	MEASURE_H
//measurement routines for Tweezers

#include <xc.h> // include processor files - each processor file is guarded.  
#include "io.h"
#include "defaults.h"

//IRNG settings
#define CTMU550NA 1
#define CTMU5500NA 2
#define CTMU55000NA 3
#define CTMU550000NA 4
#define CTMU2200000NA 5
#define CTMU5UA 2
#define CTMU55UA 3
#define CTMU550UA 4
#define CTMU2MA 5

#define CTMUTIME (1250L)
#define TIMECONST (1000)
#define LONGMAX (2147483647)
#define T_SAMP_OFFSET (200)
#define CTMU_SAT (2560)
#define CTMU_550_NOM (550)

extern long ctmuActual[6];

long adjustC(long c);              //adjust for stray capacitance
long getC(void);                   //scan with CTMU and return in pF (max 2000uF)
void getV(void);                   //sample V with various voltage dividers
long getR(void);                   //works out valid R
int getDF(void);                   //forward diode voltage mV
int getDR(void);                   //reverse diode voltage mV    
long getVB(void);                  //battery voltage in mV referred to BG ref
void setCTMUcurrent(char c);       //set IRNG and IRNGH
long getCsample(int irng,long t); //return c from CTMU/t sample
void compIdle(void);    //idle mode for component measure
void compScope(void);    //idle mode for scope measure
void compDiode(void); //idle mode for diode measurement, keeps +bias on
void compUART(void);    //idle for UART decode, +weak pullup
void compFloat(void);   //floating for logic probe
long CTMUactual(void);      //for trimming/calibration

#endif	/* MEASURE_H */

