#include "display.h"

unsigned char pixels[OLED_COLS][OLED_ROWS];        //bitmap for blitting to display
char xOffset=0;                      //to implement scrolling
const unsigned char grat[4][6]={    //simple graticule bitmap
    {1,16,0,1,16,128},
    {0,0,0,0,0,0},
    {0,0,0,0,0,0},
    {0,0,0,0,0,0}
};  

void showOhms(long n,const char* f){  //adds suffixes etc, target for 6 char spaces
    //preset col/page before calling
    OLEDscanlong(n);
    if(n<0){            //also handles negative
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        //OLEDchar(C_OHM,f);    
    }else if(n<10){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[9],f);
        OLEDchar(C_OHM,f);    
    }else if(n<100){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
        OLEDchar(C_OHM,f);    
    }else if(n<1000){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
        OLEDchar(C_OHM,f);    
    }else if(n<2000){
        OLEDchar(' ',f);            
        OLEDchar(dbuf[6],f);
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
        OLEDchar(C_OHM,f);    
    }else if(n<10000){
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar('k',f);            
        OLEDchar(C_OHM,f);            
    }else if(n<100000){
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar('k',f);            
        OLEDchar(C_OHM,f);            
    }else if(n<1000000){
        OLEDchar(' ',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar('k',f);            
        OLEDchar(C_OHM,f);            
    }else if(n<10000000){
        OLEDchar(dbuf[3],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar(dbuf[5],f);
        OLEDchar('M',f);            
        OLEDchar(C_OHM,f);            
    }else if(n<100000000){
        OLEDchar(dbuf[2],f);
        OLEDchar(dbuf[3],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar('M',f);            
        OLEDchar(C_OHM,f);            
    }else if(n<1000000000){
        OLEDchar(' ',f);            
        OLEDchar(dbuf[1],f);
        OLEDchar(dbuf[2],f);
        OLEDchar(dbuf[3],f);
        OLEDchar('M',f);            
        OLEDchar(C_OHM,f);            
    }else{
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar('>',f);            
        OLEDchar('G',f);            
        OLEDchar(C_OHM,f);            
    }    
}

void showD(long vf, long vr, const char* f){         //show diode specs
    if(vf>0){
        OLEDscanlong(vf);
        if(cur.d.hand==TEXT_RH){        //match diode direction to hand
            OLEDchar(C_DIODEF,f);            
        }else{
            OLEDchar(C_DIODER,f);            
        }
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar('V',f);                       
    }else if(vr>0){
        OLEDscanlong(vr);
        if(cur.d.hand==TEXT_RH){        //match diode direction to hand
            OLEDchar(C_DIODER,f);            
        }else{
            OLEDchar(C_DIODEF,f);            
        }
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar('V',f);                               
    }else{
        OLEDchararray("------",f);            
    }
}

void showB(long v, const char* f){         //show voltage x.xV
    OLEDscanlong(v);
    OLEDchar(dbuf[6],f);
    narrowDot();
    OLEDchar(dbuf[7],f);
    OLEDchar('V',f);               
}

void narrowDot(void){       //custom narrow . matching arial font
    OLEDsetpage(page);
    OLEDsetcolumn(col);
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    I2Cbyte(0);  //blank
    I2Cbyte(0);  //blank
    I2Cstop();
    OLEDsetpage(page+1);
    OLEDsetcolumn(col);
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    I2Cbyte(24);  //dot
    I2Cbyte(24);  //dot
    I2Cstop();
    col=col+2;
}

void showFarad(long n,const char* f){  //adds suffixes etc, target for 6 char spaces
    //preset col/page before calling
    OLEDscanlong(n);
    if(n<0){            //also handles negative
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        OLEDchar('-',f);            
        //OLEDchar(C_OHM,f);    
    }else if(n<10){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[9],f);
        OLEDchar('p',f);            
        OLEDchar('F',f);            
    }else if(n<100){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
        OLEDchar('p',f);            
        OLEDchar('F',f);            
    }else if(n<1000){
        OLEDchar(' ',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
        OLEDchar('p',f);            
        OLEDchar('F',f);            
    }else if(n<10000){
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar('n',f);            
        OLEDchar('F',f);            
    }else if(n<100000){
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar('n',f);            
        OLEDchar('F',f);            
    }else if(n<1000000){
        OLEDchar(' ',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar('n',f);            
        OLEDchar('F',f);            
    }else if(n<10000000){
        OLEDchar(dbuf[3],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar(dbuf[5],f);
        OLEDchar(C_MICRO,f);            
        OLEDchar('F',f);            
    }else if(n<100000000){
        OLEDchar(dbuf[2],f);
        OLEDchar(dbuf[3],f);
        OLEDchar('.',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar(C_MICRO,f);            
        OLEDchar('F',f);            
    }else if(n<1000000000){
        OLEDchar(' ',f);            
        OLEDchar(dbuf[1],f);
        OLEDchar(dbuf[2],f);
        OLEDchar(dbuf[3],f);
        OLEDchar(C_MICRO,f);            
        OLEDchar('F',f);            
    }else{
        OLEDchar(dbuf[0],f);
        OLEDchar(dbuf[1],f);
        OLEDchar(dbuf[2],f);
        OLEDchar(dbuf[3],f);
        OLEDchar(C_MICRO,f);            
        OLEDchar('F',f);            
    }        
}

void showSint(int n,const char* f){  //signed int, 6 slots
    char s=' ';
    if(n<0){s='-';}   
    long a;         //negative integer overflow
    a=abs(n);
    OLEDscanlong(a);
    if(a<10){
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(s,f);
        OLEDchar(dbuf[9],f);
    }else if(a<100){
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(s,f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);        
    }else if(a<1000){
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(s,f);
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);        
    }else if(a<10000){
        OLEDchar(' ',f);
        OLEDchar(s,f);
        OLEDchar(dbuf[6],f);
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);        
    }else{
        OLEDchar(s,f);
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);        
    }
}

void showV2(long n,const char* f){  //short version -xxV
    long a;
    a=abs(n);
    if(n>0){
        OLEDchar('+',f);        
    }else if(n<0){
        OLEDchar('-',f);                
    }else{
        OLEDchar(' ',f);                        
    }
    OLEDscanlong(a);
    if(a<10000){
        OLEDchar(' ',f);                        
        OLEDchar(dbuf[6],f);
    }else{
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
    }
    OLEDchar('V',f);        
}

void showV(long n,const char* f){  //adds suffixes etc, target for 6 char spaces
    long a;
    a=abs(n);
    if(n>0){
        OLEDchar('+',f);        
    }else if(n<0){
        OLEDchar('-',f);                
    }else{
        OLEDchar(' ',f);                        
    }
    OLEDscanlong(a);
    if(a<10000){
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);        
    }else{
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar('.',f);
        OLEDchar(dbuf[7],f);
    }
    OLEDchar('V',f);    
}

void shown4(unsigned long n, const char*f){      //4 digit number raw
    OLEDscanlong(n);
    if(n<10){
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(dbuf[9],f);        
    }else if(n<100){
        OLEDchar(' ',f);
        OLEDchar(' ',f);
        OLEDchar(dbuf[8],f);        
        OLEDchar(dbuf[9],f);        
    }else if(n<1000){
        OLEDchar(' ',f);
        OLEDchar(dbuf[7],f);        
        OLEDchar(dbuf[8],f);        
        OLEDchar(dbuf[9],f);        
    }else if(n<10000){
        OLEDchar(dbuf[6],f);        
        OLEDchar(dbuf[7],f);        
        OLEDchar(dbuf[8],f);        
        OLEDchar(dbuf[9],f);        
    }else{
        OLEDchar('?',f);
        OLEDchar('?',f);
        OLEDchar('?',f);
        OLEDchar('?',f);                
    }
    
}

void pixel(int x,int y, int c){             //pixel drawing
    if(x<0){return;}
    if(x>=OLED_COLS){return;}
    if(y<0){return;}
    if(y>=(OLED_ROWS*8)){return;}
    unsigned char mask=1<<(y&7);
    y=y>>3;
    if(c){
        pixels[x][y]=pixels[x][y]|mask;
    }else{
        pixels[x][y]=pixels[x][y]&(~mask);
    }
}

void clearPixels(unsigned char c){
    unsigned char x,y;
    for(x=0;x<OLED_COLS;x++){
        for(y=0;y<OLED_ROWS;y++){
            pixels[x][y]=c;
        }
    }
}

void drawPixels(int c, int r, int x, int y){      //output c columns and r rows at x,y
    int xx,yy;
    for(yy=y;yy<y+r;yy++){
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|(yy&7));      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 | (x & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 | ((x>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        for(xx=0;xx<c;xx++){
            I2Cbyte(pixels[(xx+xOffset)&0x7F][yy]);
        }
        I2Cstop();        
    }    
}

unsigned char vBitmap(unsigned char v, unsigned char y){    //bitmap that would appear at page y for value v (0 at top)
    if((v/8)==y){
        return 1<<(v&7);        
    }else{
        return 0;
    }    
}

unsigned char vBitmapSolid(unsigned char v,unsigned char oldv, unsigned char y){    //bitmap that would appear at page y for value v and oldv(0 at top)
    unsigned char top,bot,a,b;
    if(v==oldv){
        if(v==0){       //special edge case
            if(y==0){return 1;}
            return 0;
        }
        top=v;bot=v-1;
    }else if(v<oldv){
        top=v;bot=oldv;   //exclude old
    }else{
        top=oldv;bot=v;   //exclude old
    }
    a=0;
    b=0;
    if((top/8)==y){
        a=(2<<(top&7))-1;
    }else if((top/8)>y){
        a=255;
    }
    if((bot/8)==y){
        b=(2<<(bot&7))-1;
    }else if((bot/8)>y){
        b=255;
    }
    return a^b;
}

void drawTrace(unsigned char v){    //at current col, top 6 pages
    static unsigned char oldv=0;
    unsigned char y;
    unsigned char g=0;
    if(((col-2)%25)==0){g=34;}  //vertical graticule
    if(col==52){g=170;}         //trigger point
    if(col==27){oldv=v;}        //avoid wraparound
    for(y=0;y<6;y++){
        //optimised I2C command sequence
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|y);      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 + (col & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 + ((col>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        //I2Cbyte(vBitmap(v,y)|vBitmap((oldv+v)/2,y)|grat[col&3][y]|g);
        I2Cbyte(vBitmapSolid(v,oldv,y)|grat[col&3][y]|g);
        I2Cstop();                        
    }
    oldv=v;
}

void drawCaret(unsigned char v){    //trig marker 
    unsigned char y;
    for(y=0;y<6;y++){
        //optimised I2C command sequence
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|y);      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 + (col & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 + ((col>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        I2Cbyte(vBitmap(v-2,y)|vBitmap(v+2,y));
        I2Cstop();                        
    }    
    col=col+1;
    for(y=0;y<6;y++){
        //optimised I2C command sequence
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|y);      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 + (col & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 + ((col>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        I2Cbyte(vBitmap(v,y)|vBitmap(v-1,y)|vBitmap(v+1,y));
        I2Cstop();                        
    }    
    col=col+1;
    for(y=0;y<6;y++){
        //optimised I2C command sequence
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|y);      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 + (col & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 + ((col>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        I2Cbyte(vBitmap(v,y));
        I2Cstop();                        
    }    
}

void showLong(unsigned long n, const char* f){              //precision, with commas for long numbers, eg 9,999,999
    OLEDscanlong(n);
    if(n<10){            //also handles negative
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[9],f);
    }else if(n<100){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
    }else if(n<1000){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
    }else if(n<10000UL){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[6],f);
        OLEDchar(',',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
    }else if(n<100000UL){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar(',',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
    }else if(n<1000000UL){
        OLEDchar(' ',f);            
        OLEDchar(' ',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar(',',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);
    }else if(n<10000000UL){
        OLEDchar(dbuf[3],f);
        OLEDchar(',',f);            
        OLEDchar(dbuf[4],f);
        OLEDchar(dbuf[5],f);
        OLEDchar(dbuf[6],f);
        OLEDchar(',',f);            
        OLEDchar(dbuf[7],f);
        OLEDchar(dbuf[8],f);
        OLEDchar(dbuf[9],f);        
    }else{
        OLEDchararray("OVERFLOW!",f);
    }
}

void drawGraph(unsigned char v,unsigned char g){    //at current col, top 6 pages, with graticule g
    static unsigned char oldv=0;
    unsigned char y;    
    for(y=0;y<6;y++){
        //optimised I2C command sequence
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|y);      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 + (col & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 + ((col>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        if((v>47)||(oldv>47)){
            I2Cbyte(grat[col&3][y]|g);            
        }else{
            I2Cbyte(vBitmapSolid(v,oldv,y)|grat[col&3][y]|g);            
        }
        I2Cstop();                        
    }
    oldv=v;
}

//Bresenham line implementation
void line(int x1,int y1,int x2,int y2, int c){
  int steps,stepsx,stepsy,xinc,yinc,x,y,d,i;
  stepsx=abs(x1-x2);
  stepsy=abs(y1-y2);
  steps=((stepsx>stepsy)?stepsx:stepsy)+1;  //+1 because always at least one point
  xinc=SIGNUM(x2-x1);
  yinc=SIGNUM(y2-y1);
  x=x1;
  y=y1;  
  if(stepsx>stepsy){
    d=stepsx/2;
    for(i=0;i<steps;i++){
      pixel(x,y,c);
      x=x+xinc;
      d=d+stepsy;
      if(d>stepsx){d=d-stepsx;y=y+yinc;}
    }
  }else{
    d=stepsy/2;
    for(i=0;i<steps;i++){
      pixel(x,y,c);
      y=y+yinc;
      d=d+stepsx;
      if(d>stepsy){d=d-stepsy;x=x+xinc;}
    } 
  }  
}
