//SSD1306/SH1106 OLED implementation for 16F1455, generic enough for most PICs

#include "oled.h"
//#include "softi2c.h"

char col,page; //column variable
char textFlip;

//buffer for number display
unsigned char dbuf[10];

void OLEDsendCommand(unsigned char c){
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDsendData(unsigned char c){     //not used only does a single byte
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x40); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDinit(void){
    __delay_ms(100);
    OLEDsendCommand(0x20);  //set addressing mode
    OLEDsendCommand(0x02);  //set page addressing mode (SH1106 only supports page mode)
    OLEDsendCommand(0x8D);  //Charge pump setting
    OLEDsendCommand(0x14);  //Enable Charge pump
    //OLEDsendCommand(0xA1);  //column reverse
    OLEDsendCommand(0xA0);  //column normal
    //OLEDsendCommand(0xC8);  //row reverse
    OLEDsendCommand(0xC0);  //row normal
    OLEDsendCommand(0x40);  //display start 0
    OLEDsendCommand(0xD3);  //display offset
    OLEDsendCommand(0x00);  //is zero
    OLEDsendCommand(0xAF);  //display on
    OLEDbrightness(0xFF);   //max for now
    OLEDclear();
}

void OLEDbrightness(unsigned char b){
    OLEDsendCommand(0x81);   //set contrast
    OLEDsendCommand(b);      //to b
}

void OLEDclear(void){
    unsigned char i,j;
    for(i=0;i<8;i++){
        OLEDsetpage(i);
        OLEDsendCommand(0xB0+i); //cycle through pages
        OLEDsendCommand(0x00);   //column=0 (lower nybble)     
        OLEDsendCommand(0x10);   //column=0 (upper nybble)
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x40); //write data
        for(j=0;j<128;j++){
            I2Cbyte(0x00);
        }
        I2Cstop();
    }
}

void OLEDsetpage(unsigned char p){
    //p=7-p;      //flipped
    OLEDsendCommand(0xB0 + (p&7));      //set page address    
}

void OLEDsetcolumn(unsigned char c){
    OLEDsendCommand(0x00 + (c & 0x0F));  //set column lower address
    OLEDsendCommand(0x10 + ((c>>4)&0x0F));   //set column higher address    
}

void OLEDflip(char c){      //to suit flip orientation according
    if(c==TEXT_LH){
        OLEDsendCommand(0xA1);  //column reverse
        OLEDsendCommand(0xC8);  //row reverse
    }else{
        OLEDsendCommand(0xA0);  //column normal
        OLEDsendCommand(0xC0);  //row normal
    }          
}

void OLEDchar(const char c,const char* f){
    unsigned int w,h,c0,i,j,p;
    w=f[0];
    h=f[1]/8;
    c0=f[2];
    p=(c-c0)*w*h+4;   //4 is data offset
    for(j=0;j<h;j++){
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x80); //write command
        I2Cbyte(0xB0|(page+j));      //set page address    
        I2Cbyte(0x80); //write command
        I2Cbyte(0x00 + (col & 0x0F));  //set column lower address
        I2Cbyte(0x80); //write command
        I2Cbyte(0x10 + ((col>>4)&0x0F));   //set column higher address    
        I2Cbyte(0x40); //write data
        for(i=0;i<w;i++){
            I2Cbyte(f[p+i*h+j]);
        }
        I2Cstop();                        
    }
    col=col+w;
}

void OLEDchararray(const char* c, const char* f){
    while(*c){
        OLEDchar(*c++,f);
    }
}

void OLEDscanlong(unsigned long n){ //converts an unsigned long into decimal
    unsigned long r=1000000000;
    int p;
    for(p=0;p<10;p++){dbuf[p]='0';}   //clear
    p=0;
    while(n){
        while(n>=r){
            n=n-r;
            dbuf[p]++;            
        }
        r=r/10;
        p++;
    }
}
