#include "measure.h"

long ctmuActual[6]={550000,550,5500,55000,550000,2200000}; //in nA, 0 should match 4

long adjustC(long c){    //adjust for stray capacitance
    if(c<0){return c;}  //propagate error
    c=c-cur.d.cstray;
    if(c<0){c=0;}
    return c;
}

long getC(void){            //scan with CTMU and return in pF (max 2000uF)
    long c0,c1,c2,c3,c4,c5,c6;                      //for different ranges
    setCTMU();  //use CTMU
    c0=getCsample(CTMU550NA,CTMUTIME/8);
    c1=getCsample(CTMU550NA,CTMUTIME);
    c2=getCsample(CTMU5UA,CTMUTIME);
    c3=getCsample(CTMU55UA,CTMUTIME);
    c4=getCsample(CTMU550UA,CTMUTIME);
    c5=getCsample(CTMU550UA,CTMUTIME*10);    
    c6=-1;
    if(c5>-1){c6=getCsample(CTMU550UA,CTMUTIME*100);}  //only run if c5 is OK to avoid long sample time    
    setADC();//return to idle
    //first one that doesn't saturate is best
    if(c6>-1){return c6;}
    if(c5>-1){return c5;}
    if(c4>-1){return c4;}
    if(c3>-1){return c3;}
    if(c2>-1){return c2;}
    if(c1>-1){return c1;}
    return c0;
}

long getVB(void){
    long v;        
    v=getADC(VBG_REF);
    if(v<600){      //to cover all cur.d.vBandgap values
        return 9999;
    }else{
         return (cur.d.vBandgap*4096)/v;
    }    
}

void getV(void){                   //sample V with various voltage dividers
    int i;
    for(i=0;i<6;i++){v[i]=0;}       //clear
    setHigh(AN_1);
    setLow(AN_4);       //use this as bottom, measure bottom with AN_5
    for(i=0;i<ADC_OS;i++){v[0]=v[0]+getADCsamp(anchan[AN_2],T_SETTLE);} //high side
    for(i=0;i<ADC_OS;i++){v[0]=v[0]-getADCsamp(anchan[AN_5],T_SETTLE);} //low side
    if(v[0]<0){v[0]=0;} //could happen, but not desirable
    setFloat(AN_1);
    setHigh(AN_2);
    for(i=0;i<ADC_OS;i++){v[1]=v[1]+getADCsamp(anchan[AN_1],T_SETTLE);} //high side
    for(i=0;i<ADC_OS;i++){v[1]=v[1]-getADCsamp(anchan[AN_5],T_SETTLE);} //low side
    if(v[1]<0){v[1]=0;} //could happen, but not desirable
    setFloat(AN_2);
    setHigh(AN_3);
    getADCsamp(anchan[AN_1],T_SETTLE*8);        //allow to equalise
    for(i=0;i<ADC_OS;i++){v[2]=v[2]+getADCsamp(anchan[AN_1],T_SETTLE);} //high side
    for(i=0;i<ADC_OS;i++){v[2]=v[2]-getADCsamp(anchan[AN_5],T_SETTLE);} //low side
    if(v[2]<0){v[2]=0;} //could happen, but not desirable
    setFloat(AN_3);
    setLow(AN_1);       //use this as bottom, measure bottom with AN_2
    setHigh(AN_4);
    for(i=0;i<ADC_OS;i++){v[3]=v[3]+getADCsamp(anchan[AN_5],T_SETTLE);} //high side
    for(i=0;i<ADC_OS;i++){v[3]=v[3]-getADCsamp(anchan[AN_2],T_SETTLE);} //low side
    if(v[3]<0){v[3]=0;} //could happen, but not desirable    
    setFloat(AN_4);
    setHigh(AN_5);
    for(i=0;i<ADC_OS;i++){v[4]=v[4]+getADCsamp(anchan[AN_4],T_SETTLE);} //high side
    for(i=0;i<ADC_OS;i++){v[4]=v[4]-getADCsamp(anchan[AN_2],T_SETTLE);} //low side
    if(v[4]<0){v[4]=0;} //could happen, but not desirable
    setFloat(AN_5);
    setHigh(AN_6);
    getADCsamp(anchan[AN_4],T_SETTLE*8);        //allow to equalise
    for(i=0;i<ADC_OS;i++){v[5]=v[5]+getADCsamp(anchan[AN_4],T_SETTLE);} //high side
    for(i=0;i<ADC_OS;i++){v[5]=v[5]-getADCsamp(anchan[AN_2],T_SETTLE);} //low side
    if(v[5]<0){v[5]=0;} //could happen, but not desirable    
    setFloat(AN_6);
    setLow(AN_4);   //idle state
}

int getDF(void){                   //forward diode voltage mV    
    long vb;
    if(v[3]<((4095L*ADC_OS)-D_VALID)){return -1;}   //reverse current flowing
    if(v[0]>((4095L*ADC_OS)-D_VALID)){return -1;}   //negligible forward current flowing
    vb=getVB();
    return (vb*v[0])/(4095L*ADC_OS);
}

int getDR(void){                   //reverse diode voltage mV    
    long vb;
    if(v[0]<((4095L*ADC_OS)-D_VALID)){return -1;}   //reverse current flowing
    if(v[3]>((4095L*ADC_OS)-D_VALID)){return -1;}   //negligible forward current flowing
    vb=getVB();
    return (vb*v[3])/(4095L*ADC_OS);
}

long getR(void){
    long top=4095L*ADC_OS;
    long e[6]={-1,-1,-1,-1,-1,-1};  //estimates corresponding to v[] tests
    if((v[0]>R_VALID)&&(v[0]<top-R_VALID)){ //avoid overflow etc
        e[0]=(((long long)v[0])*(cur.d.r2_1k+cur.d.r5_1k))/(top-v[0])-cur.d.rlead;
        if(e[0]<0){e[0]=0;}
    }
    if((v[1]>R_VALID)&&(v[1]<top-R_VALID)){ //avoid overflow etc
        e[1]=(((long long)v[1])*(cur.d.r3_10k+cur.d.r5_1k))/(top-v[1])-cur.d.rlead;
        if(e[1]<0){e[1]=0;}
    }
    if((v[2]>R_VALID)&&(v[2]<top-R_VALID)){ //avoid overflow etc
        e[2]=(((long long)v[2])*(cur.d.r4_100k+cur.d.r5_1k))/(top-v[2])-cur.d.rlead;
        if(e[2]<0){e[2]=0;}
    }
    if((v[3]>R_VALID)&&(v[3]<top-R_VALID)){ //avoid overflow etc
        e[3]=(((long long)v[3])*(cur.d.r5_1k+cur.d.r2_1k))/(top-v[3])-cur.d.rlead;
        if(e[3]<0){e[3]=0;}
    }
    if((v[4]>R_VALID)&&(v[4]<top-R_VALID)){ //avoid overflow etc
        e[4]=(((long long)v[4])*(cur.d.r6_10k+cur.d.r2_1k))/(top-v[4])-cur.d.rlead;
        if(e[4]<0){e[4]=0;}
    }
    if((v[5]>R_VALID)&&(v[5]<top-R_VALID)){ //avoid overflow etc
        e[5]=(((long long)v[5])*(cur.d.r7_100k+cur.d.r2_1k))/(top-v[5])-cur.d.rlead;        
        if(e[5]<0){e[5]=0;}
    }
    if((e[0]>-1)&&(e[3]>-1)){   //check if valid and average
        e[0]=(e[0]+e[3])/2;
    }else{
        e[0]=-1;e[3]=-1;
    }
    if((e[1]>-1)&&(e[4]>-1)){   //check if valid and average
        e[1]=(e[1]+e[4])/2;
    }else{
        e[1]=-1;e[4]=-1;
    }
    if((e[2]>-1)&&(e[5]>-1)){   //check if valid and average
        e[2]=(e[2]+e[5])/2;
    }else{
        e[2]=-1;e[5]=-1;
    }
    if((e[0]<0)&&(e[1]<0)&&(e[2]<0)){return -1;}  //all fail
    if((e[0]<0)&&(e[1]<0)){return e[2];}  //single value OK
    if((e[0]<0)&&(e[2]<0)){return e[1];}  //single value OK
    if((e[1]<0)&&(e[2]<0)){return e[0];}  //single value OK
    if(e[1]<0){return (e[0]+e[2])/2;}     //odd failure mode, but return something
    //e[1] being valid means we can perform a smart estimate
    if(e[1]>cur.d.r4_100k){return e[2];}    //high range
    if(e[1]<cur.d.r2_1k){return e[0];}      //low range
    if(e[1]>cur.d.r3_10k){
        if(e[2]>0){
            return (e[1]+e[2])/2;
        }else{
            return e[1];
        }
    }else{
        if(e[0]>0){
            return (e[0]+e[1])/2;
        }else{
            return e[1];
        }        
    }    

    
}

void setCTMUcurrent(char c){    //set IRNG and IRNGH
    if(c>5){return;}    //not valid
    if(c==5){           //sequencing to avoid invalid states
        CTMUCON1Lbits.IRNG=0;
        CTMUCON1Hbits.IRNGH=1;
    }else{
        CTMUCON1Hbits.IRNGH=0;
        CTMUCON1Lbits.IRNG=c&3;        
    }
    CTMUCON1Lbits.ITRIM=cur.d.ctmuTrim;
}

long getCsample(int irng,long t){      //return c from CTMU/t sample
    long a,b,c,v;
    long long n,d;                     //separate to check for overflow    
    v=getVB();                         //reading depends on supply voltage
    setCTMUcurrent(irng);
    setFloat(AN_1);                    //only source is CTMU via AN_1
    a=getADC(anchan[AN_1]);            //very brief for first
    b=getADCsamp(anchan[AN_1],t);      //delay sample
    setLow(AN_1);                      //idle, small time to discharge
    if(a>=b){c=-1;}                    //catch glitch, /0
    else if(b>CTMU_SAT){c=-1;}             //CTMU saturating
    else{
        n=(long long)ctmuActual[irng]*(t+T_SAMP_OFFSET)*TIMECONST;
        d=(b-a)*v;
        if(n>(d*LONGMAX)){return LONGMAX;}
        c=n/d;
    }    
    return c;
}

void compFloat(void){   //floating for logic probe, except - low
    setInput(AN_1);        
    setFloat(AN_2);
    setFloat(AN_3);
    setFloat(D_2A);
    setFloat(D_2B);
    setFloat(AN_5);
    setFloat(AN_6);
    setFloat(D_5A);
    setFloat(D_5B);
    setLow(AN_4);
}

void compIdle(void){    //idle mode for component measure
    setFloat(AN_2);
    setFloat(AN_3);
    setFloat(D_2A);
    setFloat(D_2B);
    setFloat(AN_5);
    setFloat(AN_6);
    setFloat(D_5A);
    setFloat(D_5B);
    setLow(AN_4);
    setLow(AN_1);    
}

void compScope(void){    //idle mode for meter measure
    setFloat(AN_1);    
    setFloat(AN_2);
    setFloat(AN_3);
    setFloat(AN_4);
    setFloat(AN_5);
    setFloat(AN_6);
    setHigh(D_2A);
    setLow(D_2B);
    setHigh(D_5A);
    setLow(D_5B);
}

void compUART(void){    //idle for UART decode, +weak pullup
    setFloat(AN_2);
    setFloat(D_2A);
    setFloat(D_2B);
    setFloat(AN_5);
    setFloat(AN_6);
    setFloat(D_5A);
    setFloat(D_5B);
    setInput(AN_1);     //for sensing
    setHigh(AN_3);      //weak pullup
    setLow(AN_4);
}

long CTMUactual(void){      //for trimming/calibration
    long n1,n2;
    compIdle();     //idle ADC and pins
    setCTMU();
    setCTMUcurrent(CTMU55UA);
    __delay32(1000);
    n1=getADCsamp(anchan[AN_2],100);
    n1=n1-getADCsamp(anchan[AN_1],100);
    n1=(n1*getVB())/4096;
    n1=(n1*10000)/(cur.d.r2_1k+cur.d.r3_10k);
    setCTMUcurrent(CTMU5UA);
    __delay32(1000);
    n2=getADCsamp(anchan[AN_3],100);
    n2=n2-getADCsamp(anchan[AN_1],100);
    n2=(n2*getVB())/4096;
    n2=(n2*100000)/(cur.d.r2_1k+cur.d.r4_100k);
    setADC();                                    
    return (n1+n2)/2;
}