#include "ints.h"


void _ISR __attribute((no_auto_psv)) _T1Interrupt(void){
    long tp,tm;
    static int scopeCnt=0;
    IFS0bits.T1IF=0; 
    ctr++;
    if(ctr>166){      //counter subsampling
        ctr=0;
        if(udflag==0){udflag=1;}    //avoid overruling 2    
        if(tmout){tmout--;}
        if(flashFlag){flashFlag=0;}else{flashFlag=1;}      //simple toggle        
    }
    if(inSettings){
        if(getPin(SW1)==PRESSED){
            sw1count++;             //unsigned, so assume we can't overflow
        }else{
            sw1count=0;
        }
        if(getPin(SW2)==PRESSED){
            sw2count++;             //unsigned, so assume we can't overflow
        }else{
            sw2count=0;
        }    
    }
    if(sampleFlag){
        scopeCnt++;
        if(scopeCnt>=tDint[tScale]){            //scale time
            scopeCnt=0;
            if(samplePtr<SCOPESAMPLES){
                tp=getADC(anchan[AN_2]);                    //get sample
                tm=(getADC(anchan[AN_5])+cur.d.vScope);                    
                tp=tp-tm;
                scopeData[samplePtr]=(tp*vb*21)/4096; //in mV                       
                samplePtr++;
            }else{
                sampleFlag=0;           //hand back to main for display
            }
        }
    }
}

void _ISR __attribute((no_auto_psv)) _U1RXInterrupt(void){
    int errbits=0;
    if(IFS0bits.U1RXIF && IEC0bits.U1RXIE){
        IFS0bits.U1RXIF=0;
        while((U1STAbits.URXDA==1)&&((rx_head+1)%UART_BUFSIZE)!=rx_tail){ //avoid overflow by dropping
            errbits=(U1STAbits.PERR?PARITY_FLAG:0)|(U1STAbits.FERR?FRAME_FLAG:0);    //error bits
            rxbuf[rx_head]=U1RXREG|errbits;
            rx_head=(rx_head+1)%UART_BUFSIZE;
        }    
    }
    if(U1STAbits.OERR){U1STAbits.OERR=0;}   //clear overflow
}


