#ifndef FLASH_H
#define	FLASH_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include <libpic30.h>        //flash macros

#define FLASHADD(x) __builtin_tblpage(x),__builtin_tbloffset(x)
//usage of FLASHADD: flashSave((unsigned int*)&ram,FLASHADD(&flash));

void flashLoad(unsigned int* f, unsigned int* r);   //load contents of flash f to RAM r, just a normal copy
void flashSave(unsigned int* r, unsigned int tab, unsigned int offset);  //save contents of RAM r to flash f

#endif	/* FLASH_H */
