#include "util.h"

long scopeData[SCOPESAMPLES];

const char modeNames[DUMMY][6]={"AUTO ","RES  ","CAP  ","DIODE","METER","SCOPE","UART ","IV   ","LOGIC","TONE "};
const char trigNames[4][5]={"AUTO","RISE","FALL","BOTH"};
const char tName[TSCALECOUNT][5]={" 1ms"," 2ms"," 5ms","10ms","20ms","50ms","0.1s","0.2s","0.5s"};
const unsigned long tDelay[TSCALECOUNT]={    //these are the above-1 respectively
    0L*TSCALEFACTOR,
    1L*TSCALEFACTOR,
    4L*TSCALEFACTOR,
    9L*TSCALEFACTOR,
    19L*TSCALEFACTOR,
    49L*TSCALEFACTOR,
    99L*TSCALEFACTOR,
    199L*TSCALEFACTOR,
    499L*TSCALEFACTOR
};

const unsigned int tDint[TSCALECOUNT]={1,1,1,1,1,1,2,4,10}; //interrupt counts
const long vValue[VSCALECOUNT]={1000L,2000L,5000L,10000L,20000L,30000L};

const char optionText[][16]={
    "HAND      ",
    "R2 1k\x1E R  ",    
    "R3 10k\x1E R ",    
    "R4 100k\x1E R",    
    "R5 1k\x1E L  ",    
    "R6 10k\x1E L ",    
    "R7 100k\x1E L",  
    "BAT       ",
    "LEAD RES. ",
    "AUTO SET  ",
    "STRAY CAP.",    
    "MTR OFFSET",
    "CTMU      ",
    "BRIGHTNESS",
    "TIMEOUT   ",    
    "SAVE      ",
    "RESTORE   ",
    "EXIT      "
};

const char hex[]="0123456789ABCDEF";
char inSettings=0;
long vb;    //battery in mV
long autoR, autoDF, autoDR; //auto measured values
long c;
long cc;
long tp,tm;
enum modes mode=METER;
enum scopeModes scopeMode=TOP;
enum trigModes trigMode=RISE;
enum options option=OLEDHAND;
int scopeX=27;
int vScale=2;       //start at 5V
long scopeTop=5000L;
long scopeBottom=-5000L;
long scopeTrig=0;
int traceY;
char tmrLocked=0;
char endSamp=0;
char trigOK=0;
int tScale=0;
char saveState=0;
enum Usettings Uset=URATE;
enum Ubitsel Ubits=EIGHT_N;
int Urate=0;     //index into bauds[]
char Ustop=0;   //means 1 stop bit according to STSEL
char Upolarity=0;   //0=normal, 1=reverse
char Udisp=TEXT_DISP;       //TEXT_DISP or HEX_DISP
const long bauds[BAUD_COUNT]={110,1200,2400,4800,9600,14400,28800,38400,57600,115200};
int Udispbuf[UDISP_ROWS][UDISP_COLS_TEXT];
int Udispx=0;
int Udispy=0;
char rowFlag=1;
enum IVmodes IVmode=ISCALE;
int vScaleIndex=0;
int iScaleIndex=0;
const long vScales[VSCALE_COUNT]={4000,2000,1000,400,200};      // /div is half
const long iScales[ISCALE_COUNT]={2000,1000,400,200,100};       // /div is half
unsigned int logicBuffer[OLED_COLS];
int logicBufferOffset=0;
enum toneModes toneMode=TONE_ON;
enum toneFreqs toneFreq=TONE_50;
enum toneAmps toneAmp=AMP_03;
char toneOn=0;
const int toneF[TONE_F_DUMMY]={50,60,100,440,1000};
const char toneAmpNames[TONE_A_DUMMY][16]={
    "OUTPUT OFF",
    "300mV p-p ",
    "600mV p-p ",
    "3V p-p nom",
    "6V p-p nom"
};
unsigned int s1rpt=0;
unsigned int s2rpt=0;
unsigned int samplePtr=0;   //this is changed in interrupt, but only when sampleFlag is clear
volatile char sampleFlag=0;

void loadCalValues(void){
    if(getPin(SW3)==PRESSED){       //if SW3 held down, use ram values from boot
        OLEDclear();
        col=16;
        page=3;
        OLEDchararray("No Flash",arial);
        while(getPin(SW3)==PRESSED){}
        __delay_ms(1000);
        OLEDclear();        
    }else{
        flashLoad((unsigned int*)&sav,(unsigned int*)&cur);
        while(checkCurOK()==0){
            OLEDclear();
            col=4;
            page=1;
            OLEDchararray("Load Error",arial);
            col=16;
            page=4;
            OLEDchararray("Defaults",arial);
            __delay_ms(1000);
            OLEDclear();
            __delay_ms(100);
            flashLoad((unsigned int*)&backup,(unsigned int*)&cur);   //load from backups and retry        
        }
    }    
    OLEDflip(cur.d.hand);   //update
    OLEDbrightness(cur.d.oledBright);    
}

void SW3action(void){   //hold=settings, press=next mode
    col=0;
    page=0;
    OLEDclear();
    tmout=3;                //for counting hold of SW3
    while(getPin(SW3)==PRESSED){}
    __delay_ms(1);      //debounce
    sw1flag=0;      //clear pending presses from other modes
    sw2flag=0;
    sw3flag=0;          //clear        
    if(tmout==0){       //switch to settings on long hold                
        inSettings=1;
        compIdle();     //idle ADC and pins
        setADC();                        
    }else{
        mode=mode+1;
        if(mode>=DUMMY){mode=AUTO;}
    }
    udflag=2;       //big update needed
    tmout=cur.d.dTimeout;
    tmrLocked=0;    //unlock on mode change                
    saveState=0;    //cancel any pending
    U1MODEbits.UARTEN=0;    //setting change, reset
    Uset=URATE;         //reset
}

void SW1settings(void){ //act on SW1 pressed in Settings
    sw1flag=0;
    if(udflag==0){udflag=1;}    //avoid overriding 2
    __delay_ms(10);      //debounce
    switch(option){     //SW1 actions
        case OLEDHAND:
            if(cur.d.hand==TEXT_RH){cur.d.hand=TEXT_LH;}else{cur.d.hand=TEXT_RH;}
            OLEDflip(cur.d.hand);
            udflag=2;
            OLEDclear();
            break;
        case AUTO_SET_ALL:
            col=0;
            page=6;
            OLEDchararray("Setting...",arial);  //in progress
            while((getPin(SW1)==PRESSED)||(getPin(SW2)==PRESSED)||(getPin(SW3)==PRESSED)){}
            __delay_ms(10);      //debounce
            autoSetAll();
            col=0;
            page=6;
            OLEDchararray("Set done. ",arial);  //done
            while((getPin(SW1)!=PRESSED)&&(getPin(SW2)!=PRESSED)&&(getPin(SW3)!=PRESSED)){}            
            break;
        case SAVE:
            if(saveState==0){saveState=1;}else{saveState=0;}
            break;
        case RESTORE:
            flashLoad((unsigned int*)&backup,(unsigned int*)&cur);
            col=0;
            page=6;
            OLEDchararray("Restored.",arial);
            OLEDflip(cur.d.hand);   //update
            OLEDbrightness(cur.d.oledBright);    
            break;
        case EXIT:
            OLEDclear();
            udflag=2;       //big update needed
            tmout=cur.d.dTimeout;
            tmrLocked=0;    //unlock on mode change                
            inSettings=0;   //out of settings
            break;
        default:
            break;   
    }    
}

void SW2settings(void){ //act on SW2 pressed in Settings
    sw2flag=0;
    if(udflag==0){udflag=1;}    //avoid overriding 2
    __delay_ms(10);      //debounce
    switch(option){     //SW2 actions
        case OLEDHAND:
            if(cur.d.hand==TEXT_RH){cur.d.hand=TEXT_LH;}else{cur.d.hand=TEXT_RH;}
            OLEDflip(cur.d.hand);
            udflag=2;
            OLEDclear();
            break;
        case SAVE:
            if(saveState==1){saveState=2;}else{saveState=0;}
            break;
        case EXIT:
            inSettings=0;   //out of settings
            break;
        default:
            break;  
    }
}

void SW1settingsRepeat(void){   //act on SW1 held in Settings
    if(udflag==0){udflag=1;}    //avoid overriding 2
    switch(option){     //SW1 actions
        case R2_1K:
            cur.d.r2_1k=cur.d.r2_1k+1;
            if(cur.d.r2_1k>((backup.d.r2_1k*11)/10)){cur.d.r2_1k=((backup.d.r2_1k*11)/10);}
            break;
        case R3_10K:
            cur.d.r3_10k=cur.d.r3_10k+10;
            if(cur.d.r3_10k>((backup.d.r3_10k*11)/10)){cur.d.r3_10k=((backup.d.r3_10k*11)/10);}
            break;
        case R4_100K:
            cur.d.r4_100k=cur.d.r4_100k+100;
            if(cur.d.r4_100k>((backup.d.r4_100k*11)/10)){cur.d.r4_100k=((backup.d.r4_100k*11)/10);}
            break;
        case R5_1K:
            cur.d.r5_1k=cur.d.r5_1k+1;
            if(cur.d.r5_1k>((backup.d.r5_1k*11)/10)){cur.d.r5_1k=((backup.d.r5_1k*11)/10);}
            break;
        case R6_10K:
            cur.d.r6_10k=cur.d.r6_10k+10;
            if(cur.d.r6_10k>((backup.d.r6_10k*11)/10)){cur.d.r6_10k=((backup.d.r6_10k*11)/10);}
            break;
        case R7_100K:
            cur.d.r7_100k=cur.d.r7_100k+100;
            if(cur.d.r7_100k>((backup.d.r7_100k*11)/10)){cur.d.r7_100k=((backup.d.r7_100k*11)/10);}
            break;
        case R_LEAD:
            cur.d.rlead=cur.d.rlead+1;
            if(cur.d.rlead>RLEAD_UPPER){cur.d.rlead=RLEAD_UPPER;}
            break;
        case C_STRAY:
            cur.d.cstray=cur.d.cstray+1;
            if(cur.d.cstray>CSTRAY_UPPER){cur.d.cstray=CSTRAY_UPPER;}
            break;
        case OFFSET:
            cur.d.vScope=cur.d.vScope+1;
            if(cur.d.vScope>VOFFSET_RANGE){cur.d.vScope=VOFFSET_RANGE;}
            break;
        case V_BATTERY:
            cur.d.vBandgap=cur.d.vBandgap+1;
            if(cur.d.vBandgap>BANDGAP_MAX){cur.d.vBandgap=BANDGAP_MAX;}
            break;
        case CTMU_TRIM:
            cur.d.ctmuTrim=cur.d.ctmuTrim+1;
            if(cur.d.ctmuTrim>CTMU_MAX){cur.d.ctmuTrim=CTMU_MAX;}
            CTMUCON1Lbits.ITRIM=cur.d.ctmuTrim;
            break;
        case O_BRIGHTNESS:
            cur.d.oledBright=cur.d.oledBright+1;
            if(cur.d.oledBright>OLED_B_MAX){cur.d.oledBright=OLED_B_MAX;}
            OLEDbrightness(cur.d.oledBright);
            break;
        case TIMEOUT:
            cur.d.dTimeout=cur.d.dTimeout+3;    //3 steps per second
            if(cur.d.dTimeout>(TIMEOUT_MAX*3+2)){cur.d.dTimeout=(TIMEOUT_MAX*3+2);}
            break;            
        default:
            break;   
    }
}

void SW2settingsRepeat(void){   //act on SW2 held in Settings
    if(udflag==0){udflag=1;}    //avoid overriding 2
    switch(option){     //SW2 actions
        case R2_1K:
            cur.d.r2_1k=cur.d.r2_1k-1;
            if(cur.d.r2_1k<((backup.d.r2_1k*9)/10)){cur.d.r2_1k=((backup.d.r2_1k*9)/10);}
            break;
        case R3_10K:
            cur.d.r3_10k=cur.d.r3_10k-10;
            if(cur.d.r3_10k<((backup.d.r3_10k*9)/10)){cur.d.r3_10k=((backup.d.r3_10k*9)/10);}
            break;
        case R4_100K:
            cur.d.r4_100k=cur.d.r4_100k-100;
            if(cur.d.r4_100k<((backup.d.r4_100k*9)/10)){cur.d.r4_100k=((backup.d.r4_100k*9)/10);}
            break;
        case R5_1K:
            cur.d.r5_1k=cur.d.r5_1k-1;
            if(cur.d.r5_1k<((backup.d.r5_1k*9)/10)){cur.d.r5_1k=((backup.d.r5_1k*9)/10);}
            break;
        case R6_10K:
            cur.d.r6_10k=cur.d.r6_10k-10;
            if(cur.d.r6_10k<((backup.d.r6_10k*9)/10)){cur.d.r6_10k=((backup.d.r6_10k*9)/10);}
            break;
        case R7_100K:
            cur.d.r7_100k=cur.d.r7_100k-100;
            if(cur.d.r7_100k<((backup.d.r7_100k*9)/10)){cur.d.r7_100k=((backup.d.r7_100k*9)/10);}
            break;
        case R_LEAD:
            cur.d.rlead=cur.d.rlead-1;
            if(cur.d.rlead<0){cur.d.rlead=0;}
            break;
        case C_STRAY:
            cur.d.cstray=cur.d.cstray-1;
            if(cur.d.cstray<0){cur.d.cstray=0;}
            break;
        case OFFSET:
            cur.d.vScope=cur.d.vScope-1;
            if(cur.d.vScope<(-VOFFSET_RANGE)){cur.d.vScope=-VOFFSET_RANGE;}
            break;
        case V_BATTERY:
            cur.d.vBandgap=cur.d.vBandgap-1;
            if(cur.d.vBandgap<BANDGAP_MIN){cur.d.vBandgap=BANDGAP_MIN;}
            break;
        case CTMU_TRIM:
            cur.d.ctmuTrim=cur.d.ctmuTrim-1;
            if(cur.d.ctmuTrim<CTMU_MIN){cur.d.ctmuTrim=CTMU_MIN;}
            CTMUCON1Lbits.ITRIM=cur.d.ctmuTrim;
            break;
        case O_BRIGHTNESS:
            cur.d.oledBright=cur.d.oledBright-1;
            if(cur.d.oledBright<OLED_B_MIN){cur.d.oledBright=OLED_B_MIN;}
            OLEDbrightness(cur.d.oledBright);
            break;
        case TIMEOUT:
            cur.d.dTimeout=cur.d.dTimeout-3;    //3 steps per second
            if(cur.d.dTimeout<(TIMEOUT_MIN*3+2)){cur.d.dTimeout=(TIMEOUT_MIN*3+2);}
            break;            
        default:
            break;   
    }    
}

void SW3settings(void){ //act on SW3 pressed in Settings
    sw3flag=0;          //clear        
    tmout=3;        //for counting hold of SW3
    while(getPin(SW3)==PRESSED){}
    __delay_ms(1);      //debounce
    if(tmout==0){       //switch out of settings on long hold
        inSettings=0;
    }else{
        option=option+1;
        if(option>=OPTIONDUMMY){option=OLEDHAND;}
    }
    udflag=2;       //big update needed
    tmout=cur.d.dTimeout;
    tmrLocked=0;    //unlock on mode change                    
}

void drawSettings(void){        //any drawing that needs to be done
    if(udflag>1){   //major update
        OLEDclear();
        col=0;
        page=0;
        OLEDchararray("Settings",arial);
        col=0;
        page=2;                
        OLEDchararray(optionText[option],arial);                
    }
    col=0;
    page=4;     //next text will be here              
    switch(option){
        case OLEDHAND:
            if(cur.d.hand==TEXT_RH){
                OLEDchararray("Right hand",arial);
            }else{
                OLEDchararray("Left hand ",arial);                            
            }
            break;
        case R2_1K:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.r2_1k,arial);
            OLEDchar(C_OHM,arial);
            break;
        case R3_10K:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.r3_10k,arial);
            OLEDchar(C_OHM,arial);
            break;
        case R4_100K:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.r4_100k,arial);
            OLEDchar(C_OHM,arial);
            break;
        case R5_1K:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.r5_1k,arial);
            OLEDchar(C_OHM,arial);
            break;
        case R6_10K:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.r6_10k,arial);
            OLEDchar(C_OHM,arial);
            break;
        case R7_100K:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.r7_100k,arial);
            OLEDchar(C_OHM,arial);
            break;
        case R_LEAD:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.rlead,arial);
            OLEDchar(C_OHM,arial);
            break;
        case AUTO_SET_ALL:
            OLEDchararray("Tips open",arial);                            
            col=0;
            page=6; 
            OLEDchararray("Press S1.",arial);                                        
            break;
        case C_STRAY:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.cstray,arial);
            col=108;
            page=6;                
            OLEDchararray("  ",small);                                        
            col=108;
            page=7;                
            OLEDchararray("pF",small);                                        
            break;
        case OFFSET:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showSint(cur.d.vScope,arial);                            
            col=44;
            page=2;                
            showSint(-getMeter(),arial);        //negative so adjustment is correct
            col=116;
            page=2;                
            OLEDchararray("  ",small);                                        
            col=116;
            page=3;                
            OLEDchararray("mV",small);                                        
            break;
        case V_BATTERY:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.vBandgap,arial);
            col=56;
            page=2;                
            shown4(getVB(),arial);
            OLEDchararray("mV",arial);                            
            break;
        case CTMU_TRIM:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showSint(cur.d.ctmuTrim,arial);
            col=56;
            page=2; 
            showSint(CTMUactual()-CTMU_550_NOM,arial);                        
            break;
        case O_BRIGHTNESS:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.oledBright,arial);
            break;
        case TIMEOUT:
            OLEDchararray("S1+ S2-   ",arial);                            
            col=0;
            page=6; 
            showLong(cur.d.dTimeout/3,arial);
            OLEDchar('s',arial);
            break;            
        case SAVE:
            if(saveState==1){
                OLEDchararray("Press S2 ",arial);                                                        
            }else if(saveState==2){
                OLEDchararray("Saving...",arial);                                                                                    
            }else if(saveState==3){
                OLEDchararray("Save done",arial);                                                                                                                
            }else{
                OLEDchararray("Press S1 ",arial);                                                                                    
            }
            break;
        case RESTORE:
            OLEDchararray("S1 restore",arial);                            
            break;
        case EXIT:
            OLEDchararray("S1/S2 exit",arial);                            
            break;
        default:
            OLEDchararray("??????????",arial);   //error                         
            break;
    }
    udflag=0;
}

void doAuto(void){              //actions for AUTO mode
    if(udflag){
        if(udflag==2){    
            compIdle();
            setADC();                        
        }
        udflag=0;
        //capacitance is self-contained
        cc=getC();
        cc=adjustC(cc);
        //multi step for R and D as we use the same raw data
        vb=getVB();
        getV();     //scan with resistors
        autoR=getR();
        autoDF=getDF();
        autoDR=getDR();
        //R
        col=0;
        page=0;
        OLEDchararray("R:",arial);            
        showOhms(autoR,arial);            
        //D
        col=0;
        page=4;
        OLEDchararray("D:",arial);            
        showD(autoDF,autoDR,arial);            
        //show C
        col=0;
        page=2;
        OLEDchararray("C:",arial);            
        showFarad(cc,arial);  
    }    
    if(sw1flag){sw1flag=0;tmrLocked=1;udflag=1;}
    if(sw2flag){sw2flag=0;tmrLocked=0;udflag=1;}        
}

void doResistor(void){          //actions for RES mode
    if(udflag){
        if(udflag==2){    
            compIdle();
            setADC();                        
        }
        udflag=0;
        //multi step for R and D as we use the same raw data
        vb=getVB();
        getV();     //scan with resistors
        autoR=getR();
        //R
        col=0;
        page=0;
        showOhms(autoR,LARGE_FONT);                    
    }    
    if(sw1flag){sw1flag=0;tmrLocked=1;udflag=1;}
    if(sw2flag){sw2flag=0;tmrLocked=0;udflag=1;}            
}

void doCapacitor(void){         //actions for CAP mode
    if(udflag){
        if(udflag==2){    
            compIdle();
            setADC();                        
        }
        udflag=0;
        //capacitance is self-contained
        cc=getC();
        cc=adjustC(cc);
        vb=getVB();
        //show C
        col=0;
        page=0;
        showFarad(cc,LARGE_FONT);                                
    }    
    if(sw1flag){sw1flag=0;tmrLocked=1;udflag=1;}
    if(sw2flag){sw2flag=0;tmrLocked=0;udflag=1;}                        
}

void doDiode(void){             //actions for DIODE mode
    if(udflag){
        if(udflag==2){    
            compIdle();
            setADC();                        
        }
        udflag=0;
        //multi step for R and D as we use the same raw data
        vb=getVB();
        getV();     //scan with resistors
        autoDF=getDF();
        autoDR=getDR();
        col=0;
        page=0;
        //D
        showD(autoDF,autoDR,LARGE_FONT);            
    }    
    if(sw1flag){sw1flag=0;tmrLocked=1;udflag=1;}
    if(sw2flag){sw2flag=0;tmrLocked=0;udflag=1;}                        
    setHigh(AN_1);      //keep this on to forward bias LEDs etc
}

void doMeter(void){             //actions for SCOPE mode
    if(udflag){
        if(udflag==2){    
            compScope();
            setADC();                        
        }
        udflag=0;
        vb=getVB();
        tp=getADC(anchan[AN_2]);
        tm=(getADC(anchan[AN_5])+cur.d.vScope);                    
        tp=tp-tm;
        tp=(tp*vb*21)/4096;
        col=0;
        page=0;
        showV(tp,LARGE_FONT);        
    }    
    if(sw1flag){sw1flag=0;tmrLocked=1;udflag=1;}
    if(sw2flag){sw2flag=0;tmrLocked=0;udflag=1;}                        
}

void doScope(void){             //call fast or slow
    if(tScale<5){
        sampleFlag=0;           //stop ISR samples
        doScopeFast();          //different handling
    }else{
        doScopeSlow();          //for different sample rates
    }
}

void doScopeSlow(void){             //actions for SCOPE mode slow sample
    //does sampling in timer ISR, tracked by sampleFlag, samplePtr
    int i;
    if(udflag){
        if(udflag==2){    
            compScope();
            setADC();                        
            samplePtr=0;
            sampleFlag=1;       //ready to go again
        }
        udflag=0;
        vb=getVB();
        col=0;
        page=0;
        if((scopeMode==TOP)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            showV2(scopeTop,small);
        }
        col=0;
        page=1;
        if((scopeMode==TRIGMODE)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            OLEDchararray(trigNames[trigMode],small);                    
        }
        col=0;
        page=2;
        if((scopeMode==TRIGGER)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            showV2(scopeTrig,small);                    
        }
        col=0;
        page=4;
        if((scopeMode==TIME)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            OLEDchararray(tName[tScale],small);
        }
        col=0;
        page=5;
        if((scopeMode==BOTTOM)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            showV2(scopeBottom,small);                    
        }
    }
    if((samplePtr<SCOPESAMPLES)&&(sampleFlag==0)){      //start if not running
        samplePtr=0;
        sampleFlag=1;       //ready to go again from start     
    }
    if((samplePtr>=SCOPESAMPLES)&&(sampleFlag==0)){                        //set complete
        scopeX=0;   //default trigger point as auto has no trigger point
        trigOK=0;   //set to confirm
        switch(trigMode){
            case RISE:
                for(i=TSCALEOFFSET;i<(SCOPESAMPLES-1);i++){   //32 to allow for pre trig
                    if((scopeData[i]<scopeTrig)&&(scopeData[i+1]>scopeTrig)){
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                }                            
                break;
            case FALL:
                for(i=TSCALEOFFSET;i<(SCOPESAMPLES-1);i++){   //32 to allow for pre trig
                    if((scopeData[i]>scopeTrig)&&(scopeData[i+1]<scopeTrig)){
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                }                            
                break;
            case BOTH:
                for(i=TSCALEOFFSET;i<(SCOPESAMPLES-1);i++){   //32 to allow for pre trig
                    if((scopeData[i]<scopeTrig)&&(scopeData[i+1]>scopeTrig)){
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                    if((scopeData[i]>scopeTrig)&&(scopeData[i+1]<scopeTrig)){
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                }                            
                break;
            default: break; //AUTO handled here, just does start of sample
        }
        for(i=0;i<101;i++){
            traceY=((scopeTop-scopeData[i+scopeX])*48)/(scopeTop-scopeBottom);
            if(traceY<0){traceY=0;}
            if(traceY>47){traceY=47;}
            col=i+27;
            page=0;                    
            drawTrace(traceY);                            
        }
        col=0;
        page=3;
        if(trigOK){
            OLEDchararray("TRIG",small);
        }else{
            OLEDchararray("WAIT",small);
        }                    
        page=0;
        col=24;
        traceY=((scopeTop-scopeTrig)*48)/(scopeTop-scopeBottom);
        if(traceY<0){traceY=0;}
        if(traceY>47){traceY=47;}
        drawCaret(traceY);                                        
        samplePtr=0;
        sampleFlag=1;       //ready to go again
    }
    if(sw1flag){
        sw1flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2
        tmout=cur.d.dTimeout;
        scopeMode=scopeMode+1;
        if(scopeMode>=SCOPEDUMMY){scopeMode=TOP;}                        
    }
    if(sw2flag){
        sw2flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2;        
        tmout=cur.d.dTimeout;
        switch(scopeMode){
            case TOP:
                vScale=vScale+1;
                if(vScale>=VSCALECOUNT){vScale=0;}
                scopeTop=vValue[vScale];
                if(scopeBottom!=0){
                    scopeBottom=-scopeTop;
                }                                
                if(scopeTrig>scopeTop){scopeTrig=scopeTop;}
                if(scopeTrig<scopeBottom){scopeTrig=scopeBottom;}
                break;
            case BOTTOM:
                if(scopeBottom==0){
                    scopeBottom=-scopeTop;
                }else{
                    scopeBottom=0;
                }
                if(scopeTrig<scopeBottom){scopeTrig=scopeBottom;}
                break;                            
            case TRIGGER:
                scopeTrig=scopeTrig+1000;                           //1V
                if(scopeTrig>scopeTop){scopeTrig=scopeBottom;}                                
                break;
            case TRIGMODE:
                trigMode=trigMode+1;
                if(trigMode>=TRIGDUMMY){trigMode=TRIGAUTO;}
                break;
            case TIME:
                tScale=tScale+1;
                if(tScale>=TSCALECOUNT){tScale=0;}
                break;                            
            default:    break;  //do nothing?
        }
    }
    tmrLocked=(scopeMode==SLEEP);    
}

void doScopeFast(void){             //actions for SCOPE mode fast sample
    int i;
    unsigned int iflags;
    if(udflag){
        if(udflag==2){    
            compScope();
            setADC();                        
        }
        udflag=0;
        vb=getVB();
        col=0;
        page=0;
        if((scopeMode==TOP)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            showV2(scopeTop,small);
        }
        col=0;
        page=1;
        if((scopeMode==TRIGMODE)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            OLEDchararray(trigNames[trigMode],small);                    
        }
        col=0;
        page=2;
        if((scopeMode==TRIGGER)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            showV2(scopeTrig,small);                    
        }
        col=0;
        page=4;
        if((scopeMode==TIME)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            OLEDchararray(tName[tScale],small);
        }
        col=0;
        page=5;
        if((scopeMode==BOTTOM)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            showV2(scopeBottom,small);                    
        }
    }                        
    while((udflag==0)&&(getPin(SW1)!=PRESSED)&&(getPin(SW2)!=PRESSED)&&(getPin(SW3)!=PRESSED)){
        iflags=INTCON2;    //save interrupt state
        INTCON2bits.GIE=0;              //disable interrupts to reduce jitter
        CLKDIVbits.CPDIV=0;        //32MHz        fast sampling
        for(i=0;i<SCOPESAMPLES;i++){        //sample at speed, this is the tight loop
            tp=getADC(anchan[AN_2]);
            tm=(getADC(anchan[AN_5])+cur.d.vScope);                    
            tp=tp-tm;
            scopeData[i]=(tp*vb*21)/4096; //in mV                                                    
            __delay32(tDelay[tScale]);
        }
        CLKDIVbits.CPDIV=2;        //8MHz
        INTCON2=iflags;                 //restore
        scopeX=0;   //default trigger point as auto has no trigger point
        trigOK=0;   //set to confirm
        switch(trigMode){
            case RISE:
                for(i=TSCALEOFFSET;i<(SCOPESAMPLES-1);i++){   //32 to allow for pre trig
                    if((scopeData[i]<scopeTrig)&&(scopeData[i+1]>scopeTrig)){
                        endSamp=1;
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                }                            
                break;
            case FALL:
                for(i=TSCALEOFFSET;i<(SCOPESAMPLES-1);i++){   //32 to allow for pre trig
                    if((scopeData[i]>scopeTrig)&&(scopeData[i+1]<scopeTrig)){
                        endSamp=1;
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                }                            
                break;
            case BOTH:
                for(i=TSCALEOFFSET;i<(SCOPESAMPLES-1);i++){   //32 to allow for pre trig
                    if((scopeData[i]<scopeTrig)&&(scopeData[i+1]>scopeTrig)){
                        endSamp=1;
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                    if((scopeData[i]>scopeTrig)&&(scopeData[i+1]<scopeTrig)){
                        endSamp=1;
                        scopeX=i-TSCALEOFFSET;
                        i=SCOPESAMPLES; //do it this way to let us break out of while and for                                        
                        trigOK=1;
                    }
                }                            
                break;
            default: endSamp=1;break;
        }
        if(endSamp){break;}
    }
    for(i=0;i<101;i++){
        traceY=((scopeTop-scopeData[i+scopeX])*48)/(scopeTop-scopeBottom);
        if(traceY<0){traceY=0;}
        if(traceY>47){traceY=47;}
        col=i+27;
        page=0;                    
        drawTrace(traceY);                            
    }
    col=0;
    page=3;
    if(trigOK){
        OLEDchararray("TRIG",small);
    }else{
        OLEDchararray("WAIT",small);
    }                    
    page=0;
    col=24;
    traceY=((scopeTop-scopeTrig)*48)/(scopeTop-scopeBottom);
    if(traceY<0){traceY=0;}
    if(traceY>47){traceY=47;}
    drawCaret(traceY);                                
    if(sw1flag){
        sw1flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2
        tmout=cur.d.dTimeout;
        scopeMode=scopeMode+1;
        if(scopeMode>=SCOPEDUMMY){scopeMode=TOP;}                        
    }
    if(sw2flag){
        sw2flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2;        
        tmout=cur.d.dTimeout;
        switch(scopeMode){
            case TOP:
                vScale=vScale+1;
                if(vScale>=VSCALECOUNT){vScale=0;}
                scopeTop=vValue[vScale];
                if(scopeBottom!=0){
                    scopeBottom=-scopeTop;
                }                                
                if(scopeTrig>scopeTop){scopeTrig=scopeTop;}
                if(scopeTrig<scopeBottom){scopeTrig=scopeBottom;}
                break;
            case BOTTOM:
                if(scopeBottom==0){
                    scopeBottom=-scopeTop;
                }else{
                    scopeBottom=0;
                }
                if(scopeTrig<scopeBottom){scopeTrig=scopeBottom;}
                break;                            
            case TRIGGER:
                scopeTrig=scopeTrig+1000;                           //1V
                if(scopeTrig>scopeTop){scopeTrig=scopeBottom;}                                
                break;
            case TRIGMODE:
                trigMode=trigMode+1;
                if(trigMode>=TRIGDUMMY){trigMode=TRIGAUTO;}
                break;
            case TIME:
                tScale=tScale+1;
                if(tScale>=TSCALECOUNT){tScale=0;}
                break;                            
            default:    break;  //do nothing?
        }
    }
    tmrLocked=(scopeMode==SLEEP);
}

void doSERDEC(void){             //actions for UART mode            
    int x,y,t;
    if(udflag){
        if(U1MODEbits.UARTEN!=1){   //set and enable
            U1MODEbits.STSEL=Ustop;
            U1MODEbits.PDSEL=Ubits;
            U1MODEbits.URXINV=Upolarity;
            if(bauds[Urate]){   //avoid /0
                U1BRG=(BAUD_NUM/bauds[Urate])-1;
            }
            U1MODEbits.UARTEN=1;    //ready            
        }
        if(udflag==2){    
            compUART();
            //reset display output
            for(y=0;y<UDISP_ROWS;y++){
                for(x=0;x<UDISP_COLS_TEXT;x++){
                    Udispbuf[y][x]=' ';
                }
            }
            Udispx=0;
            Udispy=0;
        }
        udflag=0;
        col=0;
        page=5;
        if((Uset==URATE)&&(flashFlag)){
            OLEDchararray("         ",small);
        }else{
            showLong(bauds[Urate],small);
        }
        OLEDchar(' ',small);
        if((Uset==UBITS)&&(flashFlag)){
            OLEDchararray("  ",small);
        }else{
            switch(Ubits){
                case EIGHT_N: OLEDchararray("8N",small); break;
                case EIGHT_E: OLEDchararray("8E",small); break;
                case EIGHT_O: OLEDchararray("8O",small); break;
                case NINE_N : OLEDchararray("9N",small); break;
                default     : OLEDchararray("??",small); break;
            }
        }
        if((Uset==USTOP)&&(flashFlag)){
            OLEDchararray(" ",small);
        }else{
            OLEDchar('1'+(Ustop&1),small);    //matches STSEL bit
        }
        if((Uset==UPOLARITY)&&(flashFlag)){
            OLEDchararray("   ",small);                
        }else{
            if(Upolarity==1){
                OLEDchararray(" LO",small);
            }else{
                OLEDchararray(" HI",small);                
            }
        }
        if((Uset==UDISP)&&(flashFlag)){
            OLEDchararray("    ",small);                
        }else{
            if(Udisp==TEXT_DISP){
                OLEDchararray(" TXT",small);
            }else{
                OLEDchararray(" HEX",small);                
            }
        }
        tmrLocked=(Uset==USLEEP);
        //data display
        //current row is at bottom
        if(Udisp==TEXT_DISP){           //text mode
            while(uartAvailable()){
                t=uartRead();
                if(t>95){
                    Udispbuf[Udispy][Udispx]=C_ERROR;
                    Udispx=Udispx+1;
                    if(Udispx>=UDISP_COLS_TEXT){
                        nextUdisprow();
                    }
                }else if(t>=32){
                    Udispbuf[Udispy][Udispx]=t&0xFF;
                    Udispx=Udispx+1;
                    if(Udispx>=UDISP_COLS_TEXT){
                        nextUdisprow();
                    }
                }else if(t==10){        //LF
                    nextUdisprow();
                }else if(t==13){        //CR
                    Udispx=0;
                }else if(t==9){         //TAB
                    Udispx=Udispx+5;
                    if(Udispx>=UDISP_COLS_TEXT){
                        nextUdisprow();
                    }                
                }                
            }
        }else{                      //HEX mode
            while(uartAvailable()){
                t=uartRead();
                if(t>95){       //this includes error states
                    Udispbuf[Udispy][Udispx]=C_ERROR;
                }else if(t>=32){
                    Udispbuf[Udispy][Udispx]=t&0xFF;
                }else{                
                    Udispbuf[Udispy][Udispx]=C_ERROR;
                }
                //add hex value
                Udispbuf[Udispy][Udispx*4+5]=hex[(t>>8)&0x1];
                if(t&FRAME_FLAG){Udispbuf[Udispy][Udispx*4+5]='F';}
                if(t&PARITY_FLAG){Udispbuf[Udispy][Udispx*4+5]='P';}
                Udispbuf[Udispy][Udispx*4+6]=hex[(t>>4)&0xF];
                Udispbuf[Udispy][Udispx*4+7]=hex[(t>>0)&0xF];
                Udispx=Udispx+1;
                if(Udispx>=UDISP_COLS_HEX){
                    nextUdisprow();
                }                
            }
        }
        if(getPin(SW1)!=PRESSED){
            if(rowFlag){
                for(y=0;y<UDISP_ROWS;y++){
                    page=y;
                    col=0;
                    for(x=0;x<UDISP_COLS_TEXT;x++){
                        OLEDchar(Udispbuf[(y+1+Udispy)%UDISP_ROWS][x],small);
                    }
                }
                rowFlag=0;
            }else{
                page=4; //just the last row
                col=0;
                for(x=0;x<UDISP_COLS_TEXT;x++){
                    OLEDchar(Udispbuf[Udispy][x],small);
                }            
            }
        }
    }    
    if(sw1flag){    //choose setting to change
        sw1flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2;        
        tmout=cur.d.dTimeout;
        Uset=Uset+1;
        if(Uset>=UDUMMY){Uset=URATE;}  
    }
    if(sw2flag){    //change selected setting
        U1MODEbits.UARTEN=0;    //setting change, update        
        sw2flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2;        
        tmout=cur.d.dTimeout;
        rowFlag=1;
        switch(Uset){
            case URATE: Urate=Urate+1;if(Urate>=BAUD_COUNT){Urate=0;}break;
            case UBITS: Ubits=Ubits+1;if(Ubits>=UBITSDUMMY){Ubits=EIGHT_N;}break;
            case USTOP: Ustop=(Ustop+1)&1;break;
            case UPOLARITY: Upolarity=(Upolarity+1)&1;break;
            case UDISP: if(Udisp==TEXT_DISP){Udisp=HEX_DISP;}else{Udisp=TEXT_DISP;}
            default: break;
        }
    }                            
}

void nextUdisprow(void){    //separate as it's called from a few places
    int i;    
    Udispy=(Udispy+1)%UDISP_ROWS;   //next row
    for(i=0;i<UDISP_COLS_TEXT;i++){ //clear the new row
       Udispbuf[Udispy][i]=' ';
    }
    Udispx=0;                       //cursor at start
    rowFlag=1;                      //needs full redraw
}

void doIVPLOT(void){
    long yScale,xScale; //x is volts, y is current    
    long vv[6],ii[6];       //scaled & signed
    int i,j;
    long top=4095L*ADC_OS;
    if(udflag){
        if(udflag==2){    
            compIdle();
            setADC();                        
        }
        udflag=0;
        vb=getVB();
        getV();     //scan with resistors
        //calculate absolute vales and reorder as nominal left to right
        vv[0]=-(v[3]*vb)/top;    //these are sign reversed
        vv[1]=-(v[4]*vb)/top;
        vv[2]=-(v[5]*vb)/top;
        vv[3]=(v[2]*vb)/top;
        vv[4]=(v[1]*vb)/top;
        vv[5]=(v[0]*vb)/top;
        ii[0]=((v[3]-top)*vb)/(cur.d.r2_1k+cur.d.r5_1k);    //units of 1/top mA
        ii[1]=((v[4]-top)*vb)/(cur.d.r2_1k+cur.d.r6_10k);    //units of 1/top mA
        ii[2]=((v[5]-top)*vb)/(cur.d.r2_1k+cur.d.r7_100k);    //units of 1/top mA
        ii[3]=((top-v[2])*vb)/(cur.d.r4_100k+cur.d.r5_1k);    //units of 1/top mA
        ii[4]=((top-v[1])*vb)/(cur.d.r3_10k+cur.d.r5_1k);    //units of 1/top mA
        ii[5]=((top-v[0])*vb)/(cur.d.r2_1k+cur.d.r5_1k);    //units of 1/top mA
        for(i=0;i<6;i++){ii[i]=(ii[i]*1000)/top;}           //rescale to uA
        //load and check scales
        yScale=iScales[iScaleIndex];    //uA, ie from -nuA to +nuA
        xScale=vScales[vScaleIndex];    //mV ie from -nmV to +nmV
        if((yScale!=0)&&(xScale!=0)){   //avoid /0
            //scale vv and ii and fit to bitmap area
            for(i=0;i<6;i++){
                vv[i]=((vv[i]*50)/xScale)+50;
                ii[i]=24-((ii[i]*24)/yScale);
            }
        }
        //graticule with emphasised central origin
        clearPixels(0);
        for(i=0;i<101;i++){
            for(j=0;j<6;j++){
                pixels[i][j]=grat[i&3][j];
                if((i%25)==0){pixels[i][j]=pixels[i][j]|34;}
                if(i==50){pixels[i][j]=pixels[i][j]|170;}                
            }
            if((i&3)==2){pixels[i][3]=pixels[i][3]|1;}
        }
        //draw plots and then output
        for(i=0;i<5;i++){
            line(vv[i],ii[i],vv[i+1],ii[i+1],1);
        }
        drawPixels(101,6,27,0);        
        //update scales
        col=0;
        page=2;
        if((IVmode==ISCALE)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            shown4(yScale/2,small);
        }
        col=0;
        page=3;
        OLEDchararray(" \x1F" "A",small);
        col=0;
        page=4;
        OLEDchararray("/div",small);
        col=29;
        page=6;
        if((IVmode==VSCALE)&&(flashFlag)){
            OLEDchararray("    ",small);
        }else{
            shown4(xScale/2,small);
        }
        col=26;
        page=7;
        OLEDchararray("mV/div",small);
    }
    if(sw1flag){    //choose setting to change
        while(getPin(SW1)==PRESSED){}   //wait release/freeze
        __delay_ms(1);
        sw1flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2;        
        tmout=cur.d.dTimeout;
        IVmode=IVmode+1;
        if(IVmode>=IVDUMMY){IVmode=ISCALE;}  
    }
    if(sw2flag){    //change selected setting
        while(getPin(SW2)==PRESSED){}   //wait release/freeze
        __delay_ms(1);
        sw2flag=0;
        if(udflag==0){udflag=1;}    //avoid overriding 2;        
        tmout=cur.d.dTimeout;
        switch(IVmode){
            case ISCALE: iScaleIndex=iScaleIndex+1;if(iScaleIndex>=ISCALE_COUNT){iScaleIndex=0;}break;
            case VSCALE: vScaleIndex=vScaleIndex+1;if(vScaleIndex>=VSCALE_COUNT){vScaleIndex=0;}break;
            case IVSLEEP:break; //nothing to be done
            default: IVmode=ISCALE; break;  //back to known mode
        }
    }                            
    tmrLocked=(IVmode==IVSLEEP);
}

int getScopeOffset(void){
    int r;
    compScope();    //set scope/meter mode
    __delay_ms(100); //settle
    r=getADC(anchan[AN_2])-getADC(anchan[AN_5]);    
    compIdle();     //idle ADC and pins
    return r;    
}

void doLogic(void){         //logic level probe
    char pu,pd;
    char s;
    int i,d;
    if(udflag){
        if(udflag==2){    
            compFloat();
            setADC();                        
        }
        udflag=0;
    }    
    if(sw1flag){sw1flag=0;tmrLocked=1;if(udflag==0){udflag=1;}}    //avoid overriding 2
    if(sw2flag){sw2flag=0;tmrLocked=0;if(udflag==0){udflag=1;}}    //avoid overriding 2
    //as fast as possible
    pinMode(AN_1,INPUT_PULLUP);
    __delay_ms(1);
    pu=getPin(AN_1);
    pinMode(AN_1,INPUT_PULLDOWN);
    __delay_ms(1);
    pd=getPin(AN_1);
    pinMode(AN_1,INPUT);
    col=0;
    page=0;
    if(pu){
        if(pd){
            s='1';  //both hi=1
            d=6;    //top bits set
        }else{
            s='Z';  //pullup/down dominates=Z              
            d=384;   //middle bits set
        }
    }else{
        if(pd){
            s='?';  //reversed=error
            d=384;   //middle bits set
        }else{
            s='0';  //both lo=0                
            d=24576;  //bottom bits set
        }
    }
    OLEDchar(s,LARGE_FONT);
    logicBuffer[logicBufferOffset]=d|32769; //add lines
    //expedited drawing
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write command
    I2Cbyte(0xB0|2);      //set page address    
    I2Cbyte(0x80); //write command
    I2Cbyte(0x00 + (25 & 0x0F));  //set column lower address
    I2Cbyte(0x80); //write command
    I2Cbyte(0x10 + ((25>>4)&0x0F));   //set column higher address    
    I2Cbyte(0x40); //write data
    for(i=0;i<OLED_COLS-25;i++){
        I2Cbyte(logicBuffer[(logicBufferOffset+OLED_COLS-i)%OLED_COLS]&0xFF);            
    }
    I2Cstop();                        
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write command
    I2Cbyte(0xB0|3);      //set page address    
    I2Cbyte(0x80); //write command
    I2Cbyte(0x00 + (25 & 0x0F));  //set column lower address
    I2Cbyte(0x80); //write command
    I2Cbyte(0x10 + ((25>>4)&0x0F));   //set column higher address    
    I2Cbyte(0x40); //write data
    for(i=0;i<OLED_COLS-25;i++){
        I2Cbyte(((logicBuffer[(logicBufferOffset+OLED_COLS-i)%OLED_COLS])>>8)&0xFF);            
    }
    I2Cstop();                        
    logicBufferOffset=(logicBufferOffset+1)%OLED_COLS;
}

void doTone(void){          //output tone generator
    if(udflag){
        if(udflag==2){    
            compIdle();
            setADC();                        
        }
        udflag=0;
        col=48;
        page=0;
        if((toneMode==TONE_ON)&&(flashFlag)){
            OLEDchararray("   ",arial);
        }else{
            if(toneOn){
                OLEDchararray("ON ",arial);
            }else{
                OLEDchararray("OFF",arial);                
            }
        }
        col=0;
        page=2;
        if((toneMode==TONE_FREQ)&&(flashFlag)){
            OLEDchararray("        ",arial);
        }else{
            showSint(toneF[toneFreq],arial);
            OLEDchararray("Hz",arial);            
        }
        col=0;
        page=4;
        if((toneMode==TONE_AMP)&&(flashFlag)){
            OLEDchararray("            ",arial);
        }else{
            OLEDchararray(toneAmpNames[toneAmp],arial);
        }
    }    
    if(sw1flag){    //choose setting to change
        while(getPin(SW1)==PRESSED){}   //wait release/freeze
        __delay_ms(1);
        sw1flag=0;
        if(udflag==0){udflag=1;}        
        tmout=cur.d.dTimeout;
        toneMode=toneMode+1;
        if(toneMode>=TONE_DUMMY){toneMode=TONE_ON;}  
    }
    if(sw2flag){    //change selected setting
        while(getPin(SW2)==PRESSED){}   //wait release/freeze
        __delay_ms(1);
        sw2flag=0;
        if(udflag==0){udflag=1;}  
        tmout=cur.d.dTimeout;
        switch(toneMode){
            case TONE_ON: if(toneOn){toneOn=0;}else{toneOn=1;} break;
            case TONE_FREQ:
                toneFreq=toneFreq+1;
                if(toneFreq>=TONE_F_DUMMY){toneFreq=TONE_50;}
                CCP2PRL=FCY/(2*toneF[toneFreq]);     //based on 4MHz OSC
                break;
            case TONE_AMP:
                toneAmp=toneAmp+1;
                if(toneAmp>=TONE_A_DUMMY){toneAmp=AMP_OFF;}
                break;
            default: toneMode=TONE_ON; break;  //back to known mode
        }
    }                            
    tmrLocked=(toneMode==TONE_SLEEP);    
}

void doToneOutput(void){        //interface hardware to control state
    static char oldState=AMP_OFF;
    unsigned int iflags;        //save interrupt state
    char newState=AMP_OFF;
    if((mode==TONE)&&(toneOn)){
        newState=toneAmp;
    }
    if(newState!=oldState){     //change to be done
        iflags=INTCON2;         //save interrupt state
        INTCON2bits.GIE=0;      //disable        
        __builtin_write_OSCCONL(OSCCON&0xbf);   //unlock for PPS write
        switch(newState){
            case AMP_OFF:
                RPOR7bits.RP15R=RPOR_GPIO;         //1k+
                RPOR7bits.RP14R=RPOR_GPIO;         //10k+
                RPOR13bits.RP26R=RPOR_GPIO;        //1k-
                RPOR13bits.RP27R=RPOR_GPIO;        //10k+
                break;            
            case AMP_03:
                RPOR7bits.RP15R=RPOR_GPIO;         //1k+
                RPOR7bits.RP14R=RPOR_CCP2A;        //10k+
                RPOR13bits.RP26R=RPOR_GPIO;        //1k-
                RPOR13bits.RP27R=RPOR_GPIO;        //10k+
                break;
            case AMP_06:
                RPOR7bits.RP15R=RPOR_GPIO;         //1k+
                RPOR7bits.RP14R=RPOR_CCP2A;        //10k+
                RPOR13bits.RP26R=RPOR_GPIO;        //1k-
                RPOR13bits.RP27R=RPOR_CCP2B;       //10k+
                break;
            case AMP_30:
                RPOR7bits.RP15R=RPOR_CCP2A;        //1k+
                RPOR7bits.RP14R=RPOR_GPIO;         //10k+
                RPOR13bits.RP26R=RPOR_GPIO;        //1k-
                RPOR13bits.RP27R=RPOR_GPIO;        //10k+
                break;
            case AMP_60:
                RPOR7bits.RP15R=RPOR_CCP2A;        //1k+
                RPOR7bits.RP14R=RPOR_GPIO;         //10k+
                RPOR13bits.RP26R=RPOR_CCP2B;       //1k-
                RPOR13bits.RP27R=RPOR_GPIO;        //10k+
                break;
            default:    break;
        }
        __builtin_write_OSCCONL(OSCCON|0x40);   //relock            
        oldState=newState;
        INTCON2=iflags;                 //restore
    }
}

void doze(void){                //use doze to save power until an interrupt
    int i;
    if(udflag==0){          //if we have some idle time
        CLKDIVbits.DOZE=7;
        CLKDIVbits.ROI=1;
        CLKDIVbits.DOZEN=1;
        for(i=0;i<100;i++){
            if(CLKDIVbits.DOZEN==0){return;}    //break out on interrupt which resets DOZEN
        }
        CLKDIVbits.DOZEN=0;             //return to normal
    }                
}

void sleepAndWakeup(void){      //go to sleep and wait for SW1/SW2/SW3 then return
    toneOn=0;               //shut down output
    doToneOutput();
    ANCFGbits.VBGEN3=0;         //disable bandgap
    RCONbits.RETEN=1;           //low power retention sleep
    INTCON2bits.GIE=0;          //disable interrupts                
    I2Cdeinit();    //shut down display
    compIdle();     //set probe pins for sleep, low or pulled down                
    PMD1bits.T1MD=1;    //NB these also reset the peripherals
    PMD1bits.U1MD=1;
    PMD1bits.AD1MD=1;
    //set up IOC, pins are RB9/18/SW1 RB8/17/SW2 RA4/12/SW3
    //clear flags
    IOCFB=0;
    IOCFA=0;
    IOCSTAT=0;
    IFS1bits.IOCIF=0;
    //enable P and N in case one happens while sleep starts
    IOCPBbits.IOCPB9=1;
    IOCPBbits.IOCPB8=1;
    IOCPAbits.IOCPA4=1;
    IOCNBbits.IOCNB9=1;
    IOCNBbits.IOCNB8=1;
    IOCNAbits.IOCNA4=1;
    PADCONbits.IOCON=1;
    IEC1bits.IOCIE=1;                
    Nop();
    Sleep();
    Nop();
    //wakeup                
    IEC1bits.IOCIE=0;
    PADCONbits.IOCON=0; //disable
    IOCPB=0;
    IOCPA=0;
    IOCNB=0;
    IOCNA=0;
    IOCFB=0;
    IOCFA=0;
    IOCSTAT=0;
    IFS1bits.IOCIF=0;
    PMD1bits.T1MD=0;    //re-enable peripherals
    PMD1bits.U1MD=0;
    PMD1bits.AD1MD=0;
    IOinit();           //init as though booting
    setADC();
    I2Cinit();
    OLEDinit();
    OLEDflip(cur.d.hand);   //update
    OLEDbrightness(cur.d.oledBright);    
    udflag=2;               //update all screens
    INTCON2bits.GIE=1;          //start pending interrupts
    while((getPin(SW1)==PRESSED)||(getPin(SW2)==PRESSED)||(getPin(SW3)==PRESSED)){}
    __delay_ms(100);    
}

void autoSetAll(void){      //calibrate open circuit stray cap, CTMU trim and meter offset
    long c,d;
    cur.d.vScope=getScopeOffset();  
    //sanity checks
    if(cur.d.vScope>VOFFSET_RANGE){cur.d.vScope=VOFFSET_RANGE;}
    if(cur.d.vScope<(-VOFFSET_RANGE)){cur.d.vScope=-VOFFSET_RANGE;}
    //capacitance: settle, acquire, check and assign
    compIdle();
    setADC();                        
    __delay_ms(100);    
    c=getC();
    if(c<0){c=0;}
    if(c>CSTRAY_UPPER){c=CSTRAY_UPPER;}
    cur.d.cstray=c;
    //CTMU adjust: find trim value that sets current nearest nominal
    cur.d.ctmuTrim=-CTMU_TEST_VALUE;
    c=CTMUactual()-CTMU_550_NOM;
    cur.d.ctmuTrim=CTMU_TEST_VALUE;
    d=CTMUactual()-CTMU_550_NOM;
    if(d<=c){
        c=0;        //not a good reading, sane default
    }else{
        c=CTMU_TEST_VALUE-((d*2*CTMU_TEST_VALUE)/(d-c));
    }
    //validate
    if(c>CTMU_MAX){c=CTMU_MAX;}  
    if(c<CTMU_MIN){c=CTMU_MIN;}
    cur.d.ctmuTrim=c;    
    compIdle();
    setADC();                        
}

long getMeter(void){        //read meter value
    compScope();
    __delay32(1000);    
    vb=getVB();
    tp=getADC(anchan[AN_2]);
    tm=(getADC(anchan[AN_5])+cur.d.vScope);                    
    tp=tp-tm;
    tp=(tp*vb*21)/4096;
    compIdle();
    return tp;
}