#include "flash.h"
#include <xc.h> // include processor files - each processor file is guarded.  

void flashLoad(unsigned int* f, unsigned int* r){   //load contents of flash f to RAM r
    unsigned int i;                             //should work for consts in autopsv
    for(i=0;i<_FLASH_PAGE;i++){
        r[i]=f[i];
    }    
}

//call with flashSave(r,__builtin_tblpage(f),__builtin_tbloffset(f)) or use helper FLASHADD
void flashSave(unsigned int* r, unsigned int tab, unsigned int offset){  //save contents of RAM r to flash f
    unsigned int iflags=INTCON2;    //save interrupt state
    unsigned int i,j;
    unsigned int flash_row=128;     //_FLASH_ROW=192 => 128 words
    INTCON2bits.GIE=0;              //disable
    //block erase, relies on flashimg being _FLASH_PAGE size
    NVMCONbits.NVMOP=3;             //block erase
    NVMCONbits.WREN=1;              //enable
    NVMADRU=tab;
    NVMADR=offset;
    __builtin_write_NVM();                  //unlock and write
    while(NVMCONbits.WR){};                 //wait til done

    NVMCONbits.NVMOP=2;             //row programming
    NVMCONbits.WREN=1;              //enable
    TBLPAG=0xFA;                    //flash buffers
    for(i=0;i<_FLASH_PAGE;i=i+flash_row){
        NVMADRU=tab;    //set address
        NVMADR=offset+i*2;                  //2 words per opcode
        for(j=0;j<flash_row;j++){
            __builtin_tblwtl(j*2,r[i+j]);   //*2 is needed as we skip hi byte
            __builtin_tblwth(j*2,0xFFFF);   //keep hi byte blank
        }
        __builtin_write_NVM();                  //unlock and write
        while(NVMCONbits.WR){};                 //wait til done
    }
    NVMCONbits.NVMOP=4;             //unused mode
    NVMCONbits.WREN=0;              //disable
    INTCON2=iflags;                 //restore
}