#ifndef DEFAULTS_H
#define	DEFAULTS_H

#include <xc.h>
#include "oled.h"

//default data
//                     r1k   r10k   r100k   r1k   r10k   r100k  battery rlead cstray vScope  ctmu bright timeout hand
#define DATA_DEFAULTS {1000L,10000L,100000L,1000L,10000L,100000L,  1200,    0,     0,     0,    0,    64,   30*3,TEXT_RH}

//check that these still work if flash used > 64k
#define IMG_DEFA const union flashpadded __attribute__((address(0x1000)))
#define IMG_DEFB const union flashpadded __attribute__((address(0x1000+_FLASH_PAGE*2)))

//appears to overlap the arrays because they are identical
//#define IMG_DEFA const union flashpadded __attribute__((aligned(_FLASH_PAGE*2),space(auto_psv)))
//#define IMG_DEFB const union flashpadded __attribute__((aligned(_FLASH_PAGE*2),space(auto_psv)))

//limits for range checking, lower is 0 if not specified
#define RLEAD_UPPER (100)
#define CSTRAY_UPPER (1000)
#define OLED_B_MIN (32)
#define OLED_B_MAX (255)
#define TIMEOUT_MIN (3)
#define TIMEOUT_MAX (99)
#define BANDGAP_MAX (1400)
#define BANDGAP_MIN (1000)
#define CTMU_MIN (-32)
#define CTMU_MAX (31)
#define VOFFSET_RANGE (50)
#define CTMU_TEST_VALUE (8)

//struct for cal/setting data
struct flashdata{
    long r2_1k;
    long r3_10k;
    long r4_100k;
    long r5_1k;
    long r6_10k;
    long r7_100k;
    long vBandgap;  
    long rlead;
    long cstray;
    int vScope;
    int ctmuTrim;
    int oledBright;
    int dTimeout;
    char hand;    
};

//union to ensure padding
union flashpadded{
    struct flashdata d;
    unsigned int padding[_FLASH_PAGE];  //pad to this size so that erases do not affect other objects
};

extern union flashpadded cur;
extern IMG_DEFA sav;
extern IMG_DEFB backup;
char checkCurOK(void);  //check if values are valid

#endif	/* DEFAULTS_H */
