#ifndef UTIL_H
#define	UTIL_H
//wrapper for main helpers
#include "io.h"
#include <libpic30.h>        //delay macros
#include "oled.h"
#include "flash.h"
#include "measure.h"
#include "display.h"
//these are the flash/RAM structs and default values
#include "defaults.h"

//fonts in various files
extern const char arial[],grotesk[],small[],grotesklite[];    

#define LARGE_FONT grotesklite

//globals etc
//sampled scope data
#define SCOPESAMPLES 200
extern long scopeData[SCOPESAMPLES];
#define TSCALECOUNT (9)
#define TSCALEFACTOR (640)
#define VSCALECOUNT (6)
#define TSCALEOFFSET (24)

enum modes{AUTO,RES,CAP,DIODE,METER,SCOPE,SERDEC,IVPLOT,LOGIC,TONE,DUMMY};   //dummy to catch end of list
enum scopeModes{TOP,TRIGMODE,TRIGGER,TIME,BOTTOM,SLEEP,SCOPEDUMMY};
enum trigModes{TRIGAUTO,RISE,FALL,BOTH,TRIGDUMMY};
enum Usettings{URATE,UBITS,USTOP,UPOLARITY,UDISP,USLEEP,UDUMMY};  //for serial decoder
enum Ubitsel{EIGHT_N,EIGHT_E,EIGHT_O,NINE_N,UBITSDUMMY};        //correspond to UxMODE.PDSEL
enum IVmodes{ISCALE,VSCALE,IVSLEEP,IVDUMMY};                    //settings for IV screen
enum toneModes{TONE_ON,TONE_FREQ,TONE_AMP,TONE_SLEEP,TONE_DUMMY};          //settings for tone mode
enum toneFreqs{TONE_50,TONE_60,TONE_100,TONE_440,TONE_1000,TONE_F_DUMMY};
enum toneAmps{AMP_OFF,AMP_03,AMP_06,AMP_30,AMP_60,TONE_A_DUMMY};

extern const char modeNames[DUMMY][6];
extern const char trigNames[4][5];
extern const char tName[TSCALECOUNT][5];
extern const unsigned long tDelay[TSCALECOUNT];
extern const unsigned int tDint[TSCALECOUNT];
extern const long vValue[VSCALECOUNT];

enum options{OLEDHAND,R2_1K,R3_10K,R4_100K,R5_1K,R6_10K,R7_100K,V_BATTERY,R_LEAD,AUTO_SET_ALL,C_STRAY,OFFSET,CTMU_TRIM,O_BRIGHTNESS,TIMEOUT,SAVE,RESTORE,EXIT,OPTIONDUMMY};
extern const char optionText[][16];

extern char inSettings;
extern long vb;    //battery in mV
extern long autoR, autoDF, autoDR; //auto measured values
extern long c;
extern long cc;
extern long tp,tm;
extern enum modes mode;
extern enum scopeModes scopeMode;
extern enum trigModes trigMode;
extern enum options option;
extern int scopeX;
extern int vScale;
extern long scopeTop;
extern long scopeBottom;
extern long scopeTrig;
extern int traceY;
extern char tmrLocked;
extern char endSamp;
extern char trigOK;
extern int tScale;
extern char saveState;
extern const char hex[];
extern const int toneF[TONE_F_DUMMY];
extern char toneOn;

#define BAUD_COUNT (10)
#define BAUD_NUM (1000000UL)
extern int Urate;
extern char Ustop,Upolarity,Udisp;
extern enum Ubitsel Ubits;
extern const long bauds[BAUD_COUNT];
#define TEXT_DISP (0)
#define HEX_DISP (1)
#define UDISP_ROWS (5)
#define UDISP_COLS_TEXT (21)
#define UDISP_COLS_HEX (4)
#define VSCALE_COUNT (5)
#define ISCALE_COUNT (5)
#define RPOR_OC1 (13)
#define RPOR_GPIO (0)
#define RPOR_CCP2A (16)
#define RPOR_CCP2B (17)

extern unsigned int s1rpt,s2rpt;
extern unsigned int samplePtr;
extern volatile char sampleFlag;

void loadCalValues(void);       //load from flash and check
void SW3action(void);           //hold=settings, press=next mode
void SW1settings(void);         //act on SW1 pressed in Settings
void SW2settings(void);         //act on SW2 pressed in Settings
void SW1settingsRepeat(void);   //act on SW1 held in Settings
void SW2settingsRepeat(void);   //act on SW2 held in Settings
void SW3settings(void);         //act on SW3 pressed in Settings
void drawSettings(void);        //any drawing that needs to be done
void doAuto(void);              //actions for AUTO mode
void doResistor(void);          //actions for RES mode
void doCapacitor(void);         //actions for CAP mode
void doDiode(void);             //actions for DIODE mode
void doMeter(void);             //actions for SCOPE mode
void doScope(void);             //call fast or slow
void doScopeSlow(void);         //actions for SCOPE mode slow sample
void doScopeFast(void);         //actions for SCOPE mode fast sample
void doSERDEC(void);            //actions for UART mode
void nextUdisprow(void);        //separate as it's called from a few places
void doIVPLOT(void);            //actions for IVPLOT
int getScopeOffset(void);       //measure scope offset
void doLogic(void);             //logic level probe
void doTone(void);              //output tone generator
void doToneOutput(void);        //interface hardware to control state
void doze(void);                //use doze to save power until an interrupt
void sleepAndWakeup(void);      //go to sleep and wait for SW1/SW2/SW3 then return
void autoSetAll(void);          //calibrate open circuit stray cap, CTMU trim and meter offset
long getMeter(void);            //read meter value

#endif	/* UTIL_H */

