
#include "p33Fxxxx.h"
#include "DEE Emulation 16-bit.h"
#include "SPDIF.h"
#include "main.h"
#include "Interface.h"
#include "LCD.h"
#include "Wave_Config.h"


// Device configuration registers
_FGS(GWRP_OFF & GCP_OFF); // we don't want to write protect the flash
_FOSCSEL(FNOSC_PRI); // start up initially without the PLL but using the 24.576MHz crystal directly
_FOSC(FCKSM_CSECMD & OSCIOFNC_OFF & POSCMD_HS); // we need the HS oscillator since xtal freq. is >10MHz
_FWDT(FWDTEN_OFF); // not using the watchdog timer

unsigned short txBufferA[FRAME] __attribute__((space(dma)));
unsigned short txBufferB[FRAME] __attribute__((space(dma)));
volatile signed short DACBuffer[DAC_BUFFER_SIZE];
unsigned char DACBufferHead, DACBufferTail;

void DCIInit(void);
void DMAInit(void);
void DACInit(void);

void (* volatile int_ptr)();
void (* volatile dac_int_ptr)();

int main (void) {
    // set PLL to get Fcy just under 40MHz (24.576MHz / 4 * 26 / 4 = 39.936MHz)
    CLKDIV = 2;
#ifdef DEFAULT_RATE_48
    PLLFBD = 22;
#else
    PLLFBD = 24;
#endif

    __builtin_write_OSCCONH(0x03); // switch to PLL
    __builtin_write_OSCCONL(0x01);

	
#ifdef REVISIONB
  #ifdef DEFAULT_RATE_48
    sample_rate = 48;
  #else
    sample_rate = 96;
  #endif
#endif
    DACInit();

    // initialise EEPROM emulation and load defaults
    DataEEInit();
    load_settings_bank(0);
    hide_cursor();

    setup_sine_tables();
    compute_channel_status(pro_mode, emph_enabled);

    // initialise LCD
    LCD_Init();

	// set up interrupt handlers so that when we enable DAC/DCI it doesn't fall over
    int_ptr = &mode_Null;
    dac_int_ptr = &mode_analog_Null;

    // The following pins are digital inputs:
    //    AN5/C1N+/RP3/CN7/RB3 (44.1kHz clock)
    //    SOSCI/RP4/CN1/PMBE/RB4 (96kHz clock)
    //    PGED2/TMS/RP11/CN15/PMD1/RB11 (LCD busy flag/DB7)
    //    Only AN5 is an analogue pin so let's enable its digital input buffer
    AD1PCFGLbits.PCFG5 = 1;

    // This reduces the effect of using AN0/AN1 as an analogue output on the leakage current of
    // the other ADC pins.
    AD1PCFGLbits.PCFG0 = 1;
    AD1PCFGLbits.PCFG1 = 1;

#ifdef REVISIONB
    RPINR24bits.CSCKR = 4;
#else
    RPINR24bits.CSCKR = 3;
#endif
    TRISBbits.TRISB3 = 1;
    TRISBbits.TRISB4 = 1;

    RPOR1bits.RP2R = 13; // set RB2 = DCI Data Output


    // set up ADC for battery monitoring
//  AD1CON1bits.FORM = 0;  // format as integer
    AD1CON3bits.SAMC = 31; // maximum auto-sampling time
    AD1CON1bits.SSRC = 7;  // automatic conversions
    AD1CON1bits.AD12B = 1; // 12 bit mode

//  AD1CON3bits.ADRC = 0;  // clock derived from system clock
    AD1CON3bits.ADCS = 4;  // 125ns clock @ max. 40MHz

    AD1CHS0bits.CH0SA = 3; // AN3 is the + input for channel 0
//  AD1CHS0bits.CH0NA = 0; // Avss is the - input for channel 0

//  AD1CON2bits.VCFG = 0;  // Avdd/Avss are the voltage reference
    TRISBbits.TRISB1 = 1;  // AN3/RB1 is an input
    AD1CON1bits.ADON = 1;  // turn on ADC

    // set up DCI & DMA
    DMAInit();
    DCIInit();

    // Set up timer three for PWM, in order to generate a 6.144MHz square wave.
    // We'll use that for the digital output when it is idle.
    T3CONbits.TCS = 0;
    T3CONbits.TCKPS = 0;
    TMR3 = 0;
    PR3 = 11;
    T3CONbits.TON = 1;
    OC3CONbits.OCTSEL = 3-2;
    OC3CONbits.OCM = 6;
    OC3RS = 6;

#ifdef DEFAULT_RATE_48
    DAC1CONbits.DACEN = 1;    // DAC enabled at sample rate of 48kHz
#endif
	// this enables the default rate/mode loaded from EEPROM earlier
    reinit_mode();

    // main loop is LCD interface
    LCD_Interface();
    return 0;
}

void DCIInit(void) {
    TSCONbits.TSE0 = 1;    // Enable Transmit Time Slot 0
    RSCON = 0x0;
//  DCICON1bits.COFSM = 0; // Multichannel Frame Sync mode 
    DCICON1bits.DJST = 1;  // Data TX/RX is begun with the frame sync pulse
//  DCICON1bits.CSCKE = 0; // Data changes on rising edge sampled on falling edge of CSCK
//  DCICON1bits.COFSD = 0; // Frame sync driven by DCI
#ifdef DEFAULT_RATE_48
//  DCICON1bits.CSCKD = 0; // Clock is internally generated
#else
    DCICON1bits.CSCKD = 1; // Clock is input to DCI from codec
#endif
//  DCICON2bits.BLEN = 0;  // One data word will be buffered between interrupts
//  DCICON2bits.COFSG = 0; // Data frame has one word
    DCICON2bits.WS = 15;   // Data word size is 16 bits*/
#ifdef DEFAULT_RATE_48
    DCICON3bits.BCG = 2;
#else
//  DCICON3bits.BCG = 0;
#endif

    DCICON1bits.DCIEN = 1; // Enable the module 
    _DCIIE = 0;            // Disabled since DMA is used
}

void DMAInit(void) {
    // DMA 0 - DPSRAM to DCI
//  DMA0CONbits.SIZE = 0;      // Word transfers
    DMA0CONbits.DIR = 1;       // From DPSRAM to DCI
//  DMA0CONbits.AMODE = 0;     // Register Indirect with post-increment mode
    DMA0CONbits.MODE = 2;      // Continuous ping pong mode enabled
    DMA0CONbits.HALF = 1;      // Interrupt when half of the data has been moved
//  DMA0CONbits.NULLW = 0;
//  DMA0REQbits.FORCE = 0;     // Automatic transfer
    DMA0REQbits.IRQSEL = 0x3C; // Codec transfer done

    DMA0STA =__builtin_dmaoffset(txBufferA);
    DMA0STB =__builtin_dmaoffset(txBufferB);

    DMA0PAD = (int)&TXBUF0;
    DMA0CNT = FRAME-1;

    IFS0bits.DMA0IF = 0;
    IEC0bits.DMA0IE = 1;

    DMA0CONbits.CHEN = 1;      // Enable the channel
}

void DACInit(void) {
    ACLKCONbits.ASRCSEL = 1;  // set primary oscillator as source for the reference clock
//  ACLKCONbits.APSTSCLR = 7; // no clock division
    ACLKCONbits.SELACLK = 1;  // enable auxilliary clock

    TRISB |= (1<<12)|(1<<13)|(1<<14)|(1<<15);
//  TRISBbits.TRISB12 = 1;
//  TRISBbits.TRISB13 = 1;
//  TRISBbits.TRISB14 = 1;
//  TRISBbits.TRISB15 = 1;

//  IPC19bits.DAC1LIP = 5;    // increase interrupt priority so it gets priority over DDC

    DAC1STATbits.LOEN = 1;    // enable left channel output
    DAC1STATbits.ROEN = 1;    // enable right channel output
//  DAC1STATbits.LITYPE = 0;  // interrupt if FIFO is not full
//  DAC1STATbits.RITYPE = 0;  // interrupt if FIFO is not full
////DAC1STATbits.LITYPE = 1;  // interrupt if FIFO is empty
////DAC1STATbits.RITYPE = 1;  // interrupt if FIFO is empty
    DAC1CONbits.DACFDIV = 0;  // don't divide clock
    DAC1CONbits.FORM = 1;     // signed integer
//  DAC1DFLT = 0;

    IFS4bits.DAC1LIF = 0;     // clear interrupt flag
    IEC4bits.DAC1LIE = 1;     // enable interrupts
    DAC1CONbits.DACEN = 0;    // don't want DAC enabled yet

    // shouldn't have to do this twice but it's acting like the clock is divided by 256 if I don't?!?!
#ifdef DEFAULT_RATE_48
    ACLKCONbits.APSTSCLR = 6; // clock divided by two
#else
    ACLKCONbits.APSTSCLR = 7; // no clock division
#endif
}

void __attribute__((__interrupt__,no_auto_psv)) _DMA0Interrupt(void) {
    int_ptr();
    IFS0bits.DMA0IF = 0;
}

unsigned char foo;
void __attribute__((__interrupt__,no_auto_psv)) _DAC1LInterrupt(void) {
    IFS4bits.DAC1LIF = 0;

    while( !(DAC1STATbits.LFULL) && DAC1CONbits.DACEN ) {
        unsigned char tail = DACBufferTail;
        DAC1LDAT = DACBuffer[tail];
        DAC1RDAT = DACBuffer[tail+1];
        DACBufferTail = (tail+2)&(DAC_BUFFER_SIZE-1);
        dac_int_ptr();
    }
}
