
#include "p33Fxxxx.h"
#include <string.h>
//#include <stdlib.h>
#include <math.h>
#include "SPDIF.h"
#include "main.h"
#define INTERPOLATION
#include "SPDIF_Common.h"

unsigned char parity_table[256];
unsigned char biphase_table_rev4[16];
unsigned short biphase_table_rev8[256];
volatile unsigned char chan_status[192];
unsigned short polarity_table[2] = { 0x0000, 0xFFFF };
unsigned short* sine_table_deltas_2Hz;

unsigned short subframe;
unsigned short polarity;

volatile unsigned long sine_offset_l, sine_offset_r;
volatile unsigned short sine_freq_l, sine_freq_r;
volatile unsigned short sine_scale_l, sine_scale_r;
volatile unsigned long sample_counter;

volatile unsigned char sample_rate, is_analog;
volatile unsigned char mute_l, mute_r;
unsigned short orig_freq_a, orig_freq_b;

volatile mode_t mode;
volatile wavetype_t wavetype;
volatile sweeptype_t sweeptype;
volatile sweepdir_t sweepdir;

volatile unsigned long pulse_on_samples, pulse_total_samples;
volatile unsigned short pulse_on_time, pulse_off_time;
volatile unsigned short pulse_on_scale, pulse_off_scale;
volatile unsigned char ampl_change_counter_l, ampl_change_counter_r;
volatile unsigned short ampl_change_scale_l, ampl_change_scale_r;

volatile unsigned long sweep_on_samples, sweep_total_samples;
volatile unsigned short sweep_start_freq, sweep_finish_freq;
volatile unsigned short sweep_on_time, sweep_off_time;
volatile unsigned short sweep_scale;
volatile unsigned long sweep_counter;
volatile unsigned short sweep_rate;
volatile unsigned long sweep_linear_rate;


unsigned short next[FRAME];
#include "SPDIF_mode_Null.h"
#include "SPDIF_mode_analog_Null.h"
#include "SPDIF_mode_analog_Sine_Mixed.h"
#include "SPDIF_mode_analog_NonSine_Plain.h"
#include "SPDIF_mode_analog_NonSine_Pulsed.h"
#include "SPDIF_mode_analog_NonSine_Mixed.h"
#include "SPDIF_mode_dual_Null.h"
#include "SPDIF_mode_dual_Sine_Mixed.h"
#include "SPDIF_mode_dual_NonSine_Plain.h"
#include "SPDIF_mode_dual_NonSine_Pulsed.h"
#include "SPDIF_mode_dual_NonSine_Mixed.h"


extern unsigned short __curbrk;

void setup_sine_tables() {
    unsigned short i, s;
    unsigned char j, p;
    unsigned short* dest;
    unsigned long last, cur;
    unsigned long address;
    register int eedata_addr, eedata_val_l, eedata_val_h;
    int savedTBLPAG;        //Context save of TBLPAG value. Current and packed page are on same page.

    savedTBLPAG = TBLPAG;

    // compute deltas
    sine_table_deltas_2Hz = &__curbrk;//(unsigned short*)malloc(6001 * sizeof(unsigned short));
    dest = sine_table_deltas_2Hz;

    address = __builtin_tbladdress(sine_table_2Hz);
    TBLPAG = address>>16;

    eedata_addr = address;
    __asm__ volatile ("tblrdl [%1], %0" : "=r"(eedata_val_l) : "r"(eedata_addr));
    __asm__ volatile ("tblrdh [%1], %0" : "=r"(eedata_val_h) : "r"(eedata_addr));
    last = eedata_val_l | (((unsigned long)eedata_val_h)<<16);

    for( i = 1; i < 6001; ++i ) {
        address = __builtin_tbladdress(sine_table_2Hz) + (i<<1);
        TBLPAG = address>>16;

        eedata_addr = address;
        __asm__ volatile ("tblrdl [%1], %0" : "=r"(eedata_val_l) : "r"(eedata_addr));
        __asm__ volatile ("tblrdh [%1], %0" : "=r"(eedata_val_h) : "r"(eedata_addr));
        cur = eedata_val_l | (((unsigned long)eedata_val_h)<<16);

        dest[0] = (cur - last)>>1;
        last = cur;
        ++dest;
    }
    dest[0] = 0;
    TBLPAG = savedTBLPAG;

    // computer parity and biphase tables
    for( i = 0; i < 256; ++i ) {
        p = 0;
        s = 0;
        for( j = 0; j < 8; ++j ) {
            s <<= 2;
            if( i&(1<<j) ) {
                p ^= 0x80;
                s |= s & 4 ? 1 : 2;
            } else {
                s |= s & 4 ? 0 : 3;
            }
        }
        parity_table[i] = p;
        biphase_table_rev8[i] = s;
        if( i < 16 ) {
            biphase_table_rev4[i] = s>>8;
        }
    }
}
