
#ifndef _SPDIF_H_
#define _SPDIF_H_

// S/PDIF tables
extern unsigned char parity_table[256];
extern unsigned char biphase_table_rev4[16];
extern unsigned short biphase_table_rev8[256];
extern volatile unsigned char chan_status[192];
extern unsigned short polarity_table[2];

// S/PDIF status
extern unsigned short subframe;
extern unsigned short polarity;

// Wave generator configuration

extern volatile unsigned long sine_offset_l, sine_offset_r;
extern volatile unsigned short sine_freq_l, sine_freq_r;
extern volatile unsigned short sine_scale_l, sine_scale_r;
extern volatile unsigned long sample_counter;

extern volatile unsigned char sample_rate, is_analog;
extern volatile unsigned char mute_l, mute_r;

typedef enum { Null, Locked, Independent, Mixed, Pulsed, Sweep } mode_t;
typedef enum { Sine, Square, Triangle, Sawtooth_Up, Sawtooth_Down } wavetype_t;
typedef enum { arithmetic, geometric } sweeptype_t;
typedef enum { sweep_up, sweep_down } sweepdir_t;
extern volatile mode_t mode;
extern volatile wavetype_t wavetype;
extern volatile sweeptype_t sweeptype;
extern volatile sweepdir_t sweepdir;

extern volatile unsigned long pulse_on_samples, pulse_total_samples;
extern volatile unsigned short pulse_on_time, pulse_off_time;
extern volatile unsigned short pulse_on_scale, pulse_off_scale;
extern volatile unsigned char ampl_change_counter_l, ampl_change_counter_r;
extern volatile unsigned short ampl_change_scale_l, ampl_change_scale_r;

extern volatile unsigned long sweep_on_samples, sweep_total_samples;
extern volatile unsigned short sweep_start_freq, sweep_finish_freq;
extern volatile unsigned short sweep_on_time, sweep_off_time;
extern volatile unsigned short sweep_scale;
extern volatile unsigned long sweep_counter;
extern volatile unsigned short sweep_rate;
extern volatile unsigned long sweep_linear_rate;


extern void mode_Null(void);
extern void mode_Sine_Plain(void);
extern void mode_Sine_Mixed(void);
extern void mode_Sine_Pulsed(void);
extern void mode_Sine_Sweep_Geometric(void);
extern void mode_Sine_Sweep_Geometric_rev(void);
extern void mode_NonSine_Plain(void);
extern void mode_NonSine_Mixed(void);
extern void mode_NonSine_Pulsed(void);
extern void mode_NonSine_Sweep_Geometric(void);
extern void mode_NonSine_Sweep_Geometric_rev(void);
extern void mode_analog_DoNothing();
extern void mode_analog_Null();
extern void mode_analog_Sine_Plain();
extern void mode_analog_Sine_NonMixed();
extern void mode_analog_Sine_Mixed();
extern void mode_analog_NonSine_Plain();
extern void mode_analog_NonSine_Pulsed();
extern void mode_analog_NonSine_Mixed();
extern void mode_analog_NonSine_Sweep_Geometric();
extern void mode_analog_NonSine_Sweep_Geometric_rev();
extern void mode_dual_Null(void);
extern void mode_dual_Sine_Plain(void);
extern void mode_dual_Sine_Mixed(void);
extern void mode_dual_Sine_Pulsed(void);
extern void mode_dual_Sine_Sweep_Geometric();
extern void mode_dual_Sine_Sweep_Geometric_rev();
extern void mode_dual_NonSine_Plain(void);
extern void mode_dual_NonSine_Mixed(void);
extern void mode_dual_NonSine_Pulsed(void);
extern void mode_dual_NonSine_Sweep_Geometric();
extern void mode_dual_NonSine_Sweep_Geometric_rev();

void setup_sine_tables();


#define PREAMBLE_X 0xE200
#define PREAMBLE_Y 0xE400
#define PREAMBLE_Z 0xE800

#endif//_SPDIF_H_
