'	Traffic Light Controller
'	PICAXE-08M controls a single set of red/yellow/green lights
'	with 4 modes of operation, namely:
'		manual, auto, random and shutdown
'
'	A single push-button is used to change between modes by
'	varying duration of the push-button press.
'
'------
'
#picaxe 08m
'	Timers in here
'	Timer time = value x 0.1sec
'	Timers not to exceed byte variable limit of 255
symbol manual_time = 1				'go to manual as soon as PB pressed
symbol auto_time = 20				'go to auto after PB pressed for 2 sec
symbol random_time = 40				'go to random after PB pressed for 4sec
symbol shut_time = 60				'shutdown after PB pressed for 6sec
symbol green_time = 100				'green on time in auto mode (10sec)
symbol yellow_time = 120			'cumulative time (ie yellow on for 2sec)
symbol red_time = 220				'cumulative time (ie red on for 10sec)

'	Setup inputs and outputs
'	PB, input, pin3 (leg 4)
'	red, output, pin1 (leg 6)
'	yellow, output, pin2 (leg 5)
'	green, output, pin4 (leg 3)
'	unused, output, pin0, (leg 7)
let dirs = %00010111

start:
	nap 5
	if pin3=1 then reset
	goto start

reset:
	b0=0	'0=manual 1=auto 2=random
	b1=0	'auto and random mode timer
	b2=0	'PB pressed timer
	b3=0	'manual state: 0=initialised, 1=green, 2=yellow, 3=red
	w2=0	'random word for random mode - b4 for light selection, b5 for duration
	b6=0	'scaled b5

main:
	if b0>0 then let b1=b1+1 endif	'inc auto/random timer

	if pin3=1 then let b2=b2+1		'inc PB pressed timer
	else b2=0 					'else clear PB pressed timer
	endif

	pause 100					'debounce and loop timer (~100msec loops)

'------mode changing------

	if b2=shut_time then			'shutdown
		pins = %00000000			'lights out
		sleep 4				'give heaps of time to release PB
		goto start
	endif

	if b2=random_time then let b0=2 endif	'switch to random

	if b2=auto_time then let b0=1 endif	'switch to auto mode

	if b2=manual_time then
		let b0=0				'switch to manual mode
		let b3=b3+1				'and change to next colour
		if b3=4 then let b3=1 endif	'loop back to green
	endif

'------mode effect------

	if b2=manual_time then			'in manual mode - PB just pressed
		if b3=1 then
			b1=green_time		'set auto timer in case of mode change
			goto green
		endif
		if b3=2 then
			b1=yellow_time
			goto yellow
		endif
		if b3=3 then
			b1=red_time
			goto red
		endif
	endif
	if b0=1 then				'in auto mode
		if b1<green_time then
			b3=1				'set manual state in case of mode change
			goto green
		endif
		if b1<yellow_time then
			b3=2
			goto yellow
		endif
		if b1<red_time then
			b3=3
			goto red
		endif
		let b1=0				'if red_time elapsed, reset loop timer
	endif
	if b0=2 and b1>b6 then			'in random mode and period elapsed
		random w2				'generate new random variables (w2=b4&b5)
		let b3 = b4//3+1			'including which colour to light
		let b6 = b5/13+1			'and for how long (up to 2sec)
		let b1 = 0				'reset timer for next period
		if b3=1 then goto green
		if b3=2 then goto yellow
		if b3=3 then goto red
	endif	
	goto main

red:
	pins = %00000010
	goto main
yellow:
	pins = %00000100
	goto main
green:
	pins = %00010000
	goto main