

; Solar lights  

	list P=16F88
	#include p16f88.inc
	ERRORLEVEL -302
	ERRORLEVEL -306

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF


; Bank 0 RAM
DIGITAL			equ	H'20'	; storage 
LDR				equ	H'21'	; LDR reading (2.5V threshold)	
CUT_M			equ	H'22'	; cutout voltage high byte
CUT_L	  		equ	H'23'	; cutout voltage low byte
FLOAT_H			equ	H'24'	; float voltage high byte
FLOAT_L			equ	H'25'	; float voltage low byte
COMP			equ	H'26'	; compensation 
BATT_HI			equ	H'27'	; battery volts high byte
BATT_LO			equ	H'28'	; battery low byte
DELCNT			equ	H'29'	; delay counter
FLASHER			equ	H'2A'	; LED flasher timer 
TEMPERATURE		equ	H'2B'	; temperature reading deg C	
THERMISTOR		equ	H'2C'	; thermistor flag for LED
CUT_COMP_M		equ	H'2D'	; cutout temp compensated voltage high byte
CUT_COMP_L 		equ	H'2E'	; cutout temp compensated voltage low byte
FLOAT_COMP_M	equ	H'2F'	; float temp compensated voltage high byte
FLOAT_COMP_L	equ	H'30'	; float temp compensated voltage low byte
NEGATIVE		equ	H'31'	; subtract negative flag
VALUE_1			equ	H'32'	; delay counter
VALUE_2			equ	H'33'	; delay counter
TIMER			equ	H'34'	; timer for lamp
TIME_ON			equ	H'35'	; time on counter
SENSOR_COUNT	equ	H'36'	; sensor counter for periodic checking
SENSOR_COUNT1	equ	H'37'	; sensor counter for periodic checking	
SECOND			equ	H'38'	; second counter
MINUTE			equ	H'39'	; minute counter
LAST_LDR		equ	H'3A'	; last LDR value
CELL_LO			equ	H'3B'	; solar cell voltage ls byte
CELL_HI			equ	H'3C'	; solar cell voltage ms byte
CELL_I_LO		equ	H'3D'	; solar cell current ls byte
CELL_I_HI		equ	H'3E'	; solar cell current ms byte
CHARGE_STATE	equ	H'3F'	; 0 charge, 1 float
CHARGE_FLAG		equ	H'40'	; flag for charge
CHRG_RATE		equ	H'41'	; charge change rate
CELL_V			equ	H'42'	; solar cell voltage 8-bit
CELL_I			equ	H'43'	; solar cell current 8-bit
PERIOD			equ	H'44'	; power calculation rate
CCPR1_STORE		equ	H'45'	; CCPR1L storage value
FIRST			equ	H'46'	; first run
POWERH			equ	H'47'	; power ms byte
POWERL			equ	H'48'	; power ls byte
VALUE1			equ	H'49'	; temporary value
VALUE2			equ	H'4A'	; temporary value
VALUE3			equ	H'4B'	; temporary value
VALUE4			equ	H'4C'	; temporary value
HOUR0			equ	H'4D'	; hour counter
HOUR1			equ	H'4E'	; 14 seconds counter for hour counter (256 x 14s=1hour)
		
; math routines
TEMP1			equ	H'5C'
TEMPB0			equ	H'5D'
TEMPB1			equ	H'5E'
TEMPB2			equ	H'5F'
TEMP			equ H'60'
REMB3			equ H'61'
REMB2			equ	H'62'
REMB1      		equ H'63'
REMB0			equ	H'64'
AARGB5			equ	H'65'
AARGB4      	equ H'66'
AARGB3			equ	H'67'
AARGB2      	equ H'68'
AARGB1      	equ H'69'
AARGB0      	equ H'6A'	; most significant byte of argument A
BARGB3      	equ H'6B'
BARGB2      	equ H'6C'
BARGB1      	equ H'6D'
BARGB0      	equ H'6E'	; most significant byte of argument B
LOOPCOUNT   	equ H'6F'  	; division counter
			 
; All Banks RAM
; Interrupt store registers 
W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt

; start at memory 0
	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

; position the lookup table at start to avoid a 256 bit boundary

TEMP_CONV ; convert A/D values to deg C based on thermistor R=Ae**(B/T) where (T is in K ie deg C plus 273)
; A =0.01058 and B is 4100
	addwf	PCL,f	; add value to program counter
; 60 deg C max
	retlw	D'60'	; 60deg C for A/D D49 (8-bit)
	retlw	D'59'	; deg C for A/D D50(8-bit)
	retlw	D'58'	; deg C for A/D D51(8-bit)
	retlw	D'58'	; deg C for A/D D52(8-bit)
	retlw	D'57'	; deg C for A/D D53(8-bit)
	retlw	D'57'	; deg C for A/D D54(8-bit)
	retlw	D'56'	; deg C for A/D D55(8-bit)
	retlw	D'56'	; deg C for A/D D56(8-bit)
	retlw	D'55'	; deg C for A/D D57(8-bit)
	retlw	D'54'	; deg C for A/D D58(8-bit)
	retlw	D'54'	; 54 deg C for A/D D59(8-bit)
	
	retlw	D'53'	; deg C for A/D D60(8-bit)
	retlw	D'53'	; deg C for A/D D61(8-bit)
	retlw	D'52'	; deg C for A/D D62(8-bit)
	retlw	D'52'	; deg C for A/D D63(8-bit)
	retlw	D'51'	; deg C for A/D D64(8-bit)
	retlw	D'50'	; deg C for A/D D65(8-bit)
	retlw	D'50'	; deg C for A/D D66(8-bit)
	retlw	D'50'	; deg C for A/D D67(8-bit)
	retlw	D'49'	; deg C for A/D D68(8-bit)
	retlw	D'49'	; deg C for A/D D69(8-bit)

	retlw	D'48'	; 48 deg C for A/D D70(8-bit)
	retlw	D'48'	; deg C for A/D D71(8-bit)
	retlw	D'47'	; deg C for A/D D72(8-bit)
	retlw	D'47'	; deg C for A/D D73(8-bit)
	retlw	D'46'	; deg C for A/D D74(8-bit)
	retlw	D'46'	; deg C for A/D D75(8-bit)
	retlw	D'45'	; deg C for A/D D76(8-bit)
	retlw	D'45'	; deg C for A/D D77(8-bit)
	retlw	D'44'	; deg C for A/D D78(8-bit)
	retlw	D'44'	; deg C for A/D D79(8-bit)

	retlw	D'43'	; deg C for A/D D80(8-bit)
	retlw	D'43'	; deg C for A/D D81(8-bit)
	retlw	D'43'	; deg C for A/D D82(8-bit)
	retlw	D'42'	; deg C for A/D D83(8-bit)
	retlw	D'42'	; deg C for A/D D84(8-bit)
	retlw	D'41'	; deg C for A/D D85(8-bit)
	retlw	D'41'	; deg C for A/D D86(8-bit)
	retlw	D'40'	; deg C for A/D D87(8-bit)
	retlw	D'40'	; deg C for A/D D88(8-bit)
	retlw	D'40'	; 40 deg C for A/D D89(8-bit)

	retlw	D'39'	; deg C for A/D D90(8-bit)
	retlw	D'39'	; deg C for A/D D91(8-bit)
	retlw	D'38'	; deg C for A/D D92(8-bit)
	retlw	D'38'	; deg C for A/D D93(8-bit)
	retlw	D'38'	; deg C for A/D D94(8-bit)
	retlw	D'37'	; deg C for A/D D95(8-bit)
	retlw	D'37'	; deg C for A/D D96(8-bit)
	retlw	D'36'	; deg C for A/D D97(8-bit)
	retlw	D'36'	; deg C for A/D D98(8-bit)
	retlw	D'36'	; deg C for A/D D99(8-bit)

	retlw	D'35'	; deg C for A/D D100(8-bit)
	retlw	D'35'	; deg C for A/D D101(8-bit)
	retlw	D'34'	; deg C for A/D D102(8-bit)
	retlw	D'34'	; deg C for A/D D103(8-bit)
	retlw	D'34'	; deg C for A/D D104(8-bit)
	retlw	D'33'	; deg C for A/D D105(8-bit)
	retlw	D'33'	; deg C for A/D D106(8-bit)
	retlw	D'33'	; deg C for A/D D107(8-bit)
	retlw	D'32'	; deg C for A/D D108(8-bit)
	retlw	D'32'	; 32 deg C for A/D D109(8-bit)

	retlw	D'32'	; deg C for A/D D110(8-bit)
	retlw	D'31'	; deg C for A/D D111(8-bit)
	retlw	D'31'	; deg C for A/D D112(8-bit)
	retlw	D'30'	; deg C for A/D D113(8-bit)
	retlw	D'30'	; deg C for A/D D114(8-bit)
	retlw	D'30'	; deg C for A/D D115(8-bit)
	retlw	D'29'	; deg C for A/D D116(8-bit)
	retlw	D'29'	; deg C for A/D D117(8-bit)
	retlw	D'29'	; deg C for A/D D118(8-bit)
	retlw	D'28'	; deg C for A/D D119(8-bit)

	retlw	D'28'	; deg C for A/D D120(8-bit)
	retlw	D'28'	; deg C for A/D D121(8-bit)
	retlw	D'27'	; deg C for A/D D122(8-bit)
	retlw	D'27'	; deg C for A/D D123(8-bit)
	retlw	D'27'	; deg C for A/D D124(8-bit)
	retlw	D'26'	; deg C for A/D D125(8-bit)
	retlw	D'26'	; deg C for A/D D126(8-bit)
	retlw	D'26'	; deg C for A/D D127(8-bit)
	retlw	D'25'	; deg C for A/D D128(8-bit)
	retlw	D'25'	; deg C for A/D D129(8-bit)

	retlw	D'24'	; deg C for A/D D130(8-bit)
	retlw	D'24'	; deg C for A/D D131(8-bit)
	retlw	D'24'	; deg C for A/D D132(8-bit)
	retlw	D'24'	; deg C for A/D D133(8-bit)
	retlw	D'23'	; deg C for A/D D134(8-bit)
	retlw	D'23'	; deg C for A/D D135(8-bit)
	retlw	D'23'	; deg C for A/D D136(8-bit)
	retlw	D'22'	; deg C for A/D D137(8-bit)
	retlw	D'22'	; deg C for A/D D138(8-bit)
	retlw	D'22'	; deg C for A/D D139(8-bit)

	retlw	D'21'	; deg C for A/D D140(8-bit)
	retlw	D'21'	; deg C for A/D D141(8-bit)
	retlw	D'21'	; deg C for A/D D142(8-bit)
	retlw	D'20'	; deg C for A/D D143(8-bit)
	retlw	D'20'	; deg C for A/D D144(8-bit)
	retlw	D'20'	; deg C for A/D D145(8-bit)
	retlw	D'19'	; deg C for A/D D146(8-bit)
	retlw	D'19'	; deg C for A/D D147(8-bit)
	retlw	D'19'	; deg C for A/D D148(8-bit)
	retlw	D'18'	; deg C for A/D D149(8-bit)

	retlw	D'18'	; deg C for A/D D150(8-bit)
	retlw	D'18'	; deg C for A/D D151(8-bit)
	retlw	D'17'	; deg C for A/D D152(8-bit)
	retlw	D'17'	; deg C for A/D D153(8-bit)
	retlw	D'17'	; deg C for A/D D154(8-bit)
	retlw	D'16'	; deg C for A/D D155(8-bit)
	retlw	D'16'	; deg C for A/D D156(8-bit)
	retlw	D'16'	; deg C for A/D D157(8-bit)
	retlw	D'15'	; deg C for A/D D158(8-bit)
	retlw	D'15'	; deg C for A/D D159(8-bit)

	retlw	D'15'	; deg C for A/D D160(8-bit)
	retlw	D'14'	; deg C for A/D D161(8-bit)
	retlw	D'14'	; deg C for A/D D162(8-bit)
	retlw	D'14'	; deg C for A/D D163(8-bit)
	retlw	D'13'	; deg C for A/D D164(8-bit)
	retlw	D'13'	; deg C for A/D D165(8-bit)
	retlw	D'13'	; deg C for A/D D166(8-bit)
	retlw	D'12'	; deg C for A/D D167(8-bit)
	retlw	D'12'	; deg C for A/D D168(8-bit)
	retlw	D'12'	; deg C for A/D D169(8-bit)

	retlw	D'11'	; deg C for A/D D170(8-bit)
	retlw	D'11'	; deg C for A/D D171(8-bit)
	retlw	D'11'	; deg C for A/D D172(8-bit)
	retlw	D'10'	; deg C for A/D D173(8-bit)
	retlw	D'10'	; deg C for A/D D174(8-bit)
	retlw	D'10'	; deg C for A/D D175(8-bit)
	retlw	D'9'	; deg C for A/D D176(8-bit)
	retlw	D'9'	; deg C for A/D D177(8-bit)
	retlw	D'8'	; deg C for A/D D178(8-bit)
	retlw	D'8'	; 8 deg C for A/D D179(8-bit)

	retlw	D'8'	; deg C for A/D D180(8-bit)
	retlw	D'7'	; deg C for A/D D181(8-bit)
	retlw	D'7'	; deg C for A/D D182(8-bit)
	retlw	D'7'	; deg C for A/D D183(8-bit)
	retlw	D'6'	; deg C for A/D D184(8-bit)
	retlw	D'6'	; deg C for A/D D185(8-bit)
	retlw	D'6'	; deg C for A/D D186(8-bit)
	retlw	D'5'	; deg C for A/D D187(8-bit)
	retlw	D'5'	; deg C for A/D D188(8-bit)
	retlw	D'4'	; 4 deg C for A/D D189(8-bit)

	retlw	D'4'	; deg C for A/D D190(8-bit)
	retlw	D'4'	; deg C for A/D D191(8-bit)
	retlw	D'3'	; deg C for A/D D192(8-bit)
	retlw	D'3'	; deg C for A/D D193(8-bit)
	retlw	D'2'	; deg C for A/D D194(8-bit)
	retlw	D'2'	; deg C for A/D D195(8-bit)
	retlw	D'2'	; deg C for A/D D196(8-bit)
	retlw	D'1'	; deg C for A/D D197(8-bit)
	retlw	D'1'	; deg C for A/D D198(8-bit)
	retlw	D'0'	; deg C for A/D D199(8-bit)
; 0 deg C min
	retlw	D'0'	; 0 deg C for A/D D200(8-bit)

;**********************************************************************************************

SETUP

	clrf	PORTB		; outputs low
	bsf		PORTB,4		; charge LED off
; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11000110'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTB,0
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11111111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'10000111'	; settings (pullups disabled, TMR0/256)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'01111111'	; AN0 to AN6 are analog inputs
	movwf	ANSEL
	movlw	B'10000000'	; * 4MHz operation right justified A/D result, Vdd to Vss A/D
;	movlw	B'11000000'	; ** 8MHz operation right justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01101000'	; * 4MHz operation
;	movlw	B'01111000'	; ** 8MHz operation 8MHz
	movwf	OSCCON		; 
	bcf		STATUS,RP0	; select memory bank 0
; timer 1
	movlw	B'00100001'	; * 4MHz operation timer 1 prescaler /4, fosc/4
;	movlw	B'00110001'	; ** 8MHz operation timer 1 prescaler /8, fosc/4
	movwf	T1CON
	bsf		T1CON,0		; timer 1 on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	H'1F'		; * 4MHz operation 31.24kHz pwm rate 7-bit resolution	
;	movlw	H'3F'		; ** 8MHz operation 31.24kHz pwm rate 8-bit resolution
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm set
	clrf	CCPR1L		; duty 0% Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	; clear 10-bits
	clrf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation
	
; initial conditions
INITIAL

	clrf	THERMISTOR		; thermistor flags
	movlw	D'1'
	movwf	SENSOR_COUNT	; counter ready to zero on next decrement
	movwf	SENSOR_COUNT1
	clrf	CHARGE_STATE	; start at main charge ( 0 main charge, 1 float)
	clrf	CHARGE_FLAG		; flag for charge
	clrf	PERIOD			; period counter for solar cell power calculations
	clrf	CCPR1_STORE		; CCPR1L storage
	clrf	FIRST			; first run
	clrf	POWERH			; power ms byte
	clrf	POWERL			; power ls byte
	clrf	FLASHER			; flash timer
	clrf	CHRG_RATE		; charge rate flag
	movlw	D'9'
	movwf	SECOND			; lamp timer seconds counter
	movlw	D'120'			; 
	movwf	MINUTE			; lamp timer minutes counter
	clrf	TIME_ON			; cleared
	clrf	HOUR0			; hour counter
	clrf	HOUR1			; 14s counter for hour0 counter

; load SLA preset values
; battery voltage reduced to 0.3125 so 14.4V becomes 4.50V and D920 (H398) with A/D conversion (10-bit)
	movlw	H'03'
	movwf	CUT_M		; cutout SLA voltage high byte 14.4V 
	movlw	H'98'
	movwf	CUT_L		; cutout SLA voltage low byte
	movlw	H'03'
	movwf	FLOAT_H		; float SLA voltage high byte 13.5V 
	movlw	H'5F'
	movwf	FLOAT_L		; float SLA voltage low byte
	
; read LDR value.
; set analog input address. Channel 5
	bsf		ADCON0,5
	bcf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD			; convert to digital 
	movf	ADRESH,w		; if bit 0 and/or bit 1 set over 1.25V, bit 0 and bit 1 clear under 1.25V
	movwf	LDR				; current LDR value	
	movwf	LAST_LDR		; last LDR value

ALLOW_INTERRUPTS
; allow interrupts
	bsf		STATUS,RP0		; select memory bank 1
	bsf		PIE1,TMR1IE		; timer 1 overflow interrupt
	bcf		STATUS,RP0		; select memory bank 0
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag
	bsf		INTCON,PEIE		; enable periperal interrupts 	 
	bsf		INTCON,GIE

;*******************************************************

CYCLE ; beginining of normal running loop
; sensors checked periodically 
	decfsz	SENSOR_COUNT,f
	goto	LAMP_ON_OFF
	decfsz	SENSOR_COUNT1,f
	goto	LAMP_ON_OFF		; when both zero check sensors
	movlw	D'4'			; * 4MHz operation
;	movlw	D'8'			; ** 8MHz operation
	movwf	SENSOR_COUNT1	; set period to about 500ms

SENSORS
; Switched A/D sensors to save power. Only sensed on an irregular basis
; set values and read sensor values
	bsf		PORTB,5			; set sensor supply on	

; Channel 1 A/D value(mV/deg C Compensation) 
; compensation calculated as (Comp/50) x 255 

CH_1AD
; set analog input address
	bcf		ADCON0,5
	bcf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD			; convert to digital ls bits in 'DIGITAL'

; reduce from 10-bit to 8-bit
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right

; write compensation value
	movf	DIGITAL,w		; 8-bit byte
	movwf	COMP			; mV/deg C SLA compensation

; Channel 6 A/D value (thermistor (temperature))
CH_6AD
; set analog input address
	bsf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3		; A/D No.6
	call	DEL_AD			; convert to digital ls bits in 'DIGITAL'
	
; change from 10-bit to 8-bit
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right

; check for thermistor out of circuit
	movf	DIGITAL,w
	sublw	D'250'			; >250
	bcf		INTCON,GIE		; stop interrupt
	clrf	THERMISTOR		; clear value
	btfsc	STATUS,C
	goto	CK_ZRO
	bsf		THERMISTOR,0	; set bit 0 when out of circuit
	goto	BY_ZRO

; check for zero degrees or less
CK_ZRO
	movf	DIGITAL,w
	sublw	D'199'			; >199
	movlw	D'199'			; keep at 0 degrees
	btfss	STATUS,C
	movwf	DIGITAL			; keep at 0 degrees C so compensation plateaus below 0 degrees C 

; check for thermistor short circuit
	movlw	D'04'
	subwf	DIGITAL,w		; if less than 4
	btfss	STATUS,C
	bsf		THERMISTOR,1	; set when short circuit

BY_ZRO
TEMP_CONV1	
	bsf		INTCON,GIE		; allow interrupt
; convert to temperature
	movf	DIGITAL,w
	sublw	D'199'			; take from 199 if negative then >200 so set at 200
	movlw	D'200'			; ready to load if >200
	btfss	STATUS,C
	movwf	DIGITAL
	movlw	D'49'			; minimum value
	subwf	DIGITAL,f		; take away 49 from A/D value
	btfss	STATUS,C		; if minus then >60 deg C so set at 60deg
	clrf	DIGITAL			; 0 so 60 deg C in lookup table
	movf	DIGITAL,w
	call	TEMP_CONV		; convert reading to temperature in deg C
	movwf	TEMPERATURE		; store value

; find compensation requirement with temperature difference from 20 deg C
; multiplied by D100 and divided by D8000 to calculate mV/deg C for cutout and float voltages
; this is added (for <20 deg C) or subtracted (for >20deg C) from cutoff and float Voltages. 	

; take away 20 deg C
	clrf	NEGATIVE		; subtract flag
	movlw	D'20'			; 20 deg C
	subwf	TEMPERATURE,w	;
	btfss	STATUS,C		; if negative then less than 20 deg C
	bsf		NEGATIVE,7
; (temperature - 20) x 100
	movwf	AARGB0
; if negative then subtract from 20
	btfss	NEGATIVE,7
	goto	CONTINUE1
	movf	TEMPERATURE,w
	sublw	D'20'			; temperature from 20
	movwf	AARGB0

CONTINUE1
; multiply temperature difference from 20 deg C (in AARGB0) by compensation value
	movf	COMP,w
	movwf	BARGB0
	call	EIGHTEIGHT
; result in AARGB0,AARGB1	
; shift result
	movf	AARGB1,w
	movwf	AARGB2
	movf	AARGB0,w
	movwf	AARGB1
	clrf	AARGB0 
; Multiply by 100
	movlw	D'100'
	movwf	BARGB2
	clrf	BARGB1
	clrf	BARGB0
	call	FXM2424U		; multiply
; shift result for division	
	movf	AARGB2,w		; ms of multiplication
	movwf	AARGB0
	movf	AARGB3,w		; ls byte
	movwf	AARGB1
	movf	AARGB4,w		; ms of multiplication
	movwf	AARGB2
	movf	AARGB5,w		; ls byte
	movwf	AARGB3
; Divide by D8000 = H1F40
	clrf	BARGB0
	clrf	BARGB1
	movlw	H'1F'
	movwf  	BARGB2
	movlw	H'40'
	movwf	BARGB3	
	call	FXD3232U		; divide

; cutoff calculations
	btfsc	NEGATIVE,7		; if set add value
	goto	ADD_COMP1
; take compensation value from cutoff V and place in CUT_COMP_M/LS 
	movf	AARGB3,w		; result
	subwf	CUT_L,w
	movwf	CUT_COMP_L
	movf	CUT_M,w			; ms cutout V
	btfss	STATUS,C
	decf	CUT_M,w			; decrease if carry
	movwf	CUT_COMP_M	  	
	btfss	CUT_COMP_M,7	; if bit 7 set then over so clear 
	goto	CHECK_FLOAT
	clrf	CUT_COMP_M
	clrf	CUT_COMP_L
	goto	CHECK_FLOAT

ADD_COMP1
	movf	CUT_M,w	
	movwf	CUT_COMP_M
	movf	AARGB3,w		; result
	addwf	CUT_L,w
	movwf	CUT_COMP_L
	btfsc	STATUS,C
	incf	CUT_COMP_M,f	; increase if carry

; check if over 1024
	btfss	CUT_COMP_M,2	; if bit set over so set at 1023 	  	
	goto	CHECK_FLOAT
	movlw	B'00000011'		; set at 1023
	movwf	CUT_COMP_M
	movlw	H'FF'
	movwf	CUT_COMP_L

; Float calculations
CHECK_FLOAT
	btfsc	NEGATIVE,7		; if set add value
	goto	ADD_COMP2

 ; take compensation value from float V and place in FLOAT_COMP_M/LS
	movf	AARGB3,w		; result
	subwf	FLOAT_L,w
	movwf	FLOAT_COMP_L
	movf	FLOAT_H,w		; ms float V
	btfss	STATUS,C
	decf	FLOAT_H,w		; decrease if carry
	
	movwf	FLOAT_COMP_M	  	
	btfss	FLOAT_COMP_M,7	; if bit 7 set then over so clear 
	goto	CH_0AD
	clrf	FLOAT_COMP_M
	clrf	FLOAT_COMP_L
	goto	CH_0AD

ADD_COMP2
	movf	FLOAT_H,w		; ms float V to w 
	movwf	FLOAT_COMP_M
	movf	AARGB3,w		; result
	addwf	FLOAT_L,w
	movwf	FLOAT_COMP_L
	btfsc	STATUS,C
	incf	FLOAT_COMP_M,f		; increase if carry

; check if over 1024
	btfss	FLOAT_COMP_M,2	; if bit set over so set at 1023 	  	
	goto	CH_0AD
	movlw	B'00000011'		; set at 1023
	movwf	FLOAT_COMP_M
	movlw	H'FF'
	movwf	FLOAT_COMP_L

; Timer
CH_0AD
; set analog input address
	bcf		ADCON0,5
	bcf		ADCON0,4
	bcf		ADCON0,3		; A/D No.0
	call	DEL_AD			; convert to digital. ls bits in 'DIGITAL'
	
; change from 10-bit to 8-bit
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right
	rrf		ADRESH,f		; move right ls byte
	rrf		DIGITAL,f		; ls byte moved right
	movf	DIGITAL,w
	movwf	TIMER			; lamp timeout

; Battery voltage, Channel 2 A/D 
; voltage at AN2 is 0.3125 of actual measured due to divider
; so 15V is reduced to 4.6875V and results in D960 from A/D converter (10-bit value)
; this divider value sets the other cutoff, float and compensation calculations

CH_2AD
; set analog input address
	bcf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3		; 
	call	DEL_AD
	movf	DIGITAL,w
	movwf	BATT_LO			; battery voltage ls byte
	movf	ADRESH,w		; ms byte
	movwf	BATT_HI			; battery voltage ms byte

; check if below 12.45V or about 75% of capacity 
; A/D is (D796, H31C). Reset to main charge when voltage drops to below 12.45V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'3'			; take from 
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'1C'			; 12.45V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >12.45V
	clrf	CHARGE_STATE	; below 12.45V so set for main charging

; Channel 5. LDR
CH_5AD
; set analog input address
	bsf		ADCON0,5
	bcf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD			; convert to digital 
	movf	ADRESH,w		; if bit 1 set over 2.5V, bit 1 clear under 2.5V
	movwf	LDR

; end of switched sensors

	bsf		CHRG_RATE,0		; charge rate flag set to show new values available

; if S1 is on maintain A/D inputs with RB5 high

	btfsc	PORTB,1			; if S1 on maintain RB5 high
	bcf		PORTB,5			; sensor power off

;****************************************************

LAMP_ON_OFF

;PIR Operation: Lamp on if PIR triggered and the selected Night/Day option LDR level is correct 
;				(or with switch)
; 				Lamp is off with switch, timer or with the alternative LDR level
;Switch Operation: Lamp on if switch closed and selected Night/Day option LDR level is correct
; 				Lamp is off with switch, timer or with the alternative LDR level
;LDR Operation: Lamp on if selected Night/Day option LDR transition is correct (or with switch)
; 				Lamp is off with switch, timer or with the alternative LDR level

; check for low battery
; check if below 11V
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'2'			; take from 11V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'BF'			; 11V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfsc	DIGITAL,7		; if set then >11V
	goto	LAMP_ON_TEST	

; Lamp off
	bcf		PORTB,0			; lamp drive off
	goto	BY_LAMP			

LAMP_ON_TEST
	btfsc	PORTB,5			; if Q6 on bypass
	goto	BY_LAMP			; test mode for input sensing readings 
; Manual on switch	
	btfss	PORTB,1			; when low switch on lamp
	goto	LAMP_ONorOFF	; lamp on or off

; check PIR operation
	btfss	PORTA,6			; check selection for PIR operation
	goto	NO_PIR
; PIR operation set
	btfss	PORTB,2			; has PIR triggered
	goto	CHECK_LDR1
; Check LDR and day/night operation
CHECK_LDR
	btfsc	PORTA,7			; day or night operation
	goto	DAY
; night operation
	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when set LDR is in darkness
	btfsc	STATUS,Z 			
	goto	BY_LAMP
	goto	LAMP_ON			; on
DAY	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when set LDR is in darkness
	btfss	STATUS,Z 	 			
	goto	BY_LAMP 
	goto	LAMP_ON

CHECK_LDR1
	btfsc	PORTA,7			; day or night operation
	goto	DAY1
; night operation
	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when set LDR is in darkness
	btfsc	STATUS,Z 			
	goto	LAMP_OFF
	goto	BY_LAMP			; 
DAY1
	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when set LDR is in darkness
	btfss	STATUS,Z 	 			
	goto	LAMP_OFF		; off 
	goto	BY_LAMP

LAMP_ON
; load timer
	btfsc	PORTB,0			; if lamp on already bypass timer setting
	goto	BY_LAMP
	clrf	SECOND			; seconds and minutes counters cleared
	clrf	MINUTE
	movf	TIMER,w
	movwf	TIME_ON			; time on counter

	bsf		PORTB,0			; lamp on
	goto	BY_LAMP

LAMP_ONorOFF
; manual switch operation
		
	btfss	PORTB,0			; if on, switch off
	goto	ON_SW
	bcf		PORTB,0
	goto	DEBOUNCE
ON_SW

	btfsc	PORTA,7			; day or night operation
	goto	DAY3
; night operation
	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when set LDR is in darkness
	btfsc	STATUS,Z 			
	goto	BY_LAMP
	goto	LAMP_ON3		; on
DAY3
	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when set LDR is in darkness
	btfss	STATUS,Z 	 			
	goto	BY_LAMP 

LAMP_ON3
	clrf	SECOND			; seconds counter cleared
	clrf	MINUTE			; minutes counter cleared
	movf	TIMER,w			; time on value
	movwf	TIME_ON			; time on counter
	
	bsf		PORTB,0
DEBOUNCE
	call	DELAY
; if switch still closed drive Q6
	btfss	PORTB,1
	bsf		PORTB,5			; Q6 on
		
NO_PIR

; no PIR operation
; LDR used to trigger lamp on or off with level change edge

; Check LDR level and day/night operation

	btfsc	PORTA,7			; day or night operation
	goto	DAY2
; night operation
	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when bits set LDR is in darkness
	btfsc	STATUS,Z 			
	goto	LAMP_OFF_NIGHT	; off with level
	goto	LAMP_ON_NIGHT	; on
DAY2
	movlw	B'00000010'		; 2.5V threshold
	andwf	LDR,w			; when bits set LDR is in darkness
	btfss	STATUS,Z 	 			
	goto	LAMP_OFF_DAY	; off with level
	goto	LAMP_ON_DAY

LAMP_ON_NIGHT
; lamp on only if last LDR value was 0
	movlw	B'00000010'		; 2.5V threshold
	andwf	LAST_LDR,w		; when set LDR is in darkness
	btfsc	STATUS,Z 			
	goto	LAMP_ON1
	movf	LDR,w			; new LDR value transferred
	movwf	LAST_LDR
	goto	BY_LAMP
LAMP_ON1
	movf	LDR,w			; new LDR transferred
	movwf	LAST_LDR
	goto 	LAMP_ON

LAMP_OFF_NIGHT
LAMP_OFF_DAY
LAMP_OFF
	movf	LDR,w			; new LDR transferred
	movwf	LAST_LDR
	clrf	TIME_ON			; output off
	bcf		PORTB,0			; lamp off
	goto	BY_LAMP

LAMP_ON_DAY
; lamp on only if last LDR value was not 0
	movlw	B'00000010'		; 2.5V threshold
	andwf	LAST_LDR,w		; when set LDR is in darkness
	btfss	STATUS,Z 			
	goto	LAMP_ON1
	movf	LDR,w			; new LDR value transferred
	movwf	LAST_LDR

BY_LAMP						; end of lamp control

			
;**********************************************************************

; Charge Control

CHARGE_MODE

; if THERMISTOR,1 is set (ie a short circuit)
	btfss	THERMISTOR,1	; sc thermistor
	goto	CHK_ZRO_BIT
	bsf		CHARGE_FLAG,0	; set charge flag so no charge 
	goto	NO_CHARGE
CHK_ZRO_BIT
	btfss	THERMISTOR,0	; thermistor out
	goto	CHK_BATT
	bsf		CHARGE_FLAG,0	; set charge flag so no charge 
	goto	NO_CHARGE

CHK_BATT 
; if battery at 0V (usually when not connected) then no charge
	movf	BATT_HI,w		; if zero
	btfss	STATUS,Z		; ms byte not zero so bypass test
	goto	NOT_ZRO_BATT
	movf	BATT_LO,w
	btfss	STATUS,Z		; H'0000'
	goto	CHK_1_BATT
CHRG_BATT_0_OFF
	bsf		CHARGE_FLAG,0	; stop charging
	goto	NO_CHARGE
CHK_1_BATT
	xorlw	D'01'			; test for (zero above or a 1) H'0001'
	btfsc	STATUS,Z
	goto	CHRG_BATT_0_OFF

NOT_ZRO_BATT
; battery voltage: if low then apply bursts till >10.5V (D671, H29F)

; check if below 10.5V (test at 33F for 13V) 10.5V use 29F
	movf	BATT_HI,w		; high byte of battery voltage
	sublw	H'2'			; take from 10.5V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	sublw	H'9F'			; 10.5V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >10.5V
	goto	BURST			; burst charge till voltage is abone 10.5V

MODE_CHARGE
; charge mode
; measure solar cell voltage
; AN3
; solar cell voltage is divided by a factor of 0.176

; set analog input address
	bcf		ADCON0,5
	bsf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD
	movf	DIGITAL,w
	movwf	CELL_LO			; solar cell voltage ls byte
	movf	ADRESH,w		; ms byte
	movwf	CELL_HI			; solar cell voltage ms byte

; start charge when solar cell has sufficient voltage. ie about 12V 
; check if above 12V D432, H1B0 (solar cell voltage is divided by a factor of 0.176)
	movf	CELL_HI,w		; high byte of solar call voltage
	sublw	H'1'			; take from 
	movwf	DIGITAL			; store
	movf	CELL_LO,w		; low byte
	sublw	H'B0'			; 12V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then >12V
	goto	NO_CHARGE		; charge off till solar cell ready

; charge; check charge status full (main bulk charge) or absorption/ float (trickle)
	clrf	CHARGE_FLAG		; charging flag	
	movf	CHARGE_STATE,w	; 0 charge, 1 float
	btfsc	STATUS,Z
	goto	CHARGE_FULL
	goto	CHARGE_ABSORP_FLOAT

NO_CHARGE
	bsf		CHARGE_FLAG,0	; no charge flag
	clrf	CCPR1L			; charge off
	goto	CYCLE
	
CHARGE_FULL; (CHARGE_STATE = 0) main bulk charge

; if battery voltage is D1023 (H3FF) then over in value
	movf	BATT_HI,w		; ms byte
	xorlw	H'03'			; 3
	btfss	STATUS,Z
	goto	TEST_BATT2		; not equal
	movf	BATT_LO,w
	xorlw	H'FF'
	btfsc	STATUS,Z	
	goto	NO_CHARGE		; battery voltage high so end charge
TEST_BATT2
; compare battery voltage (BATT_HI/LO) with cutout (CUT_COMP_M/L)
	movf	BATT_HI,w		; high byte of battery voltage
	subwf	CUT_COMP_M,w	; take from compensated cutout
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	subwf	CUT_COMP_L,w	; take from compensated cutout
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then battery is over cutout voltage
	goto	FULL_POWER_RUN
	clrf	CCPR1L
	movlw 	H'FF'			; 256 counts for 1 hour
;	movlw	H'4'			; about 1 minute timer test period 
	movwf	HOUR0			; set absorption period @ 1 hour
	goto	CHARGE_ABSORP_FLOAT

; full charge; maintain max power from solar cell
; periodically alter the duty cycle to find power maximum
; store CCPR1L value that provides max power 
FULL_POWER_RUN

	movf	PERIOD,w		; when zero check for maximum power
	btfss	STATUS,Z		; 
	goto	CYCLE
	movf	FIRST,w			; first run
	btfss	STATUS,Z		; when clear 
	goto	CH_4AD
	clrf	POWERH			; power
	clrf	POWERL
	clrf	CCPR1L			; drive cleared
	call	DELAY2			; time for current reading to drop
	clrf	CCPR1_STORE
	movlw	H'FF'
	movwf	FIRST			; sets first run

; measure solar cell current
; AN4
CH_4AD
; solar cell current (1V=~200mA)

; set analog input address
	bsf		ADCON0,5
	bcf		ADCON0,4
	bcf		ADCON0,3		; 
	call	DEL_AD
	movf	DIGITAL,w
	movwf	CELL_I_LO		; solar cell current ls byte
	movf	ADRESH,w		; ms byte
	movwf	CELL_I_HI		; solar cell current ms byte

; AN3
CH_3AD
; solar cell voltage is divided by a factor of 0.176

; set analog input address
	bcf		ADCON0,5
	bsf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD
	movf	DIGITAL,w
	movwf	CELL_LO			; solar cell voltage ls byte
	movf	ADRESH,w		; ms byte
	movwf	CELL_HI			; solar cell voltage ms byte

; multiply CELL_HI, CELL_LO by CELL_I_HI, CELL_I_LO check for maximum

; set at 8-bit
; solar cell voltage
	rrf		CELL_HI,w		; shift ms byte right and store
	movwf	DIGITAL
	rrf		CELL_LO,w		; shift ls byte and store
	movwf	CELL_V
	rrf		DIGITAL,w		; shift stored ms byte
	rrf		CELL_V,f		; shift stored ls byte
; solar cell current
	rrf		CELL_I_HI,w
	movwf	DIGITAL
	rrf		CELL_I_LO,w
	movwf	CELL_I
	rrf		DIGITAL,w
	rrf		CELL_I,f
	
; multiply
	movf	CELL_V,w
	movwf	AARGB0
	movf	CELL_I,w
	movwf	BARGB0
	call	EIGHTEIGHT

; result is in AARGB0,AARGB1
; compare with POWERH,POWERL. 
	movf	AARGB0,w		; high byte of power new
	subwf	POWERH,w		; take from last power value
	movwf	DIGITAL			; store
	movf	AARGB1,w		; low byte
	subwf	POWERL,w		; take from last power value
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then new power > old power
	goto	BY_TRANSFER

TRANSFER ; transfer values
; new power is larger than last, transfer to POWERH,POWERL
; transfer CCPR1L into CCPR1_STORE
	movf	AARGB0,w
	movwf	POWERH
	movf	AARGB1,w
	movwf	POWERL
	movf	CCPR1L,w
	movwf	CCPR1_STORE	
BY_TRANSFER
; increase charge
	movf	CCPR1L,w		; check if maximum 
	sublw	D'63'
	btfss	STATUS,C		; if maximum value end of test cycle
	goto	MAX				; bypass decrease if 0
	incf	CCPR1L,f
	call	DELAY3; 		; allow change
	goto	CYCLE

MAX
; when max power found, set next timer for test period
	movlw	D'76'			; ~20s (0.262ms per bit)
	movwf	PERIOD			; next 20s
	clrf	FIRST			; so runs with first values at start

	movf	CCPR1_STORE,w
	movwf	CCPR1L			; set full charge rate at maximum power
	goto	CYCLE

CHARGE_ABSORP_FLOAT; (CHARGE_STATE = 1)
	movlw	D'01'
	movwf	CHARGE_STATE	; absorption/float mode set when coming from full mode

; if battery voltage is D1023 (H3FF) then over in value
	movf	BATT_HI,w		; ms byte
	xorlw	H'03'			; 3
	btfss	STATUS,Z
	goto	TEST_BATT3		; not equal
	movf	BATT_LO,w
	xorlw	H'FF'
	btfsc	STATUS,Z	
	goto	NO_CHARGE		; battery voltage high so end charge
TEST_BATT3
; alter CHARGE_CONT to adjust the drive to maintain float V	

	btfss	CHRG_RATE,0		; check when set new value available
	goto	CYCLE
	clrf	CHRG_RATE

; set values to 8-bit
; battery
	rrf		BATT_HI,w
	movwf	VALUE1
	rrf		BATT_LO,w		; get value difference
	movwf	VALUE2
	rrf		VALUE1,w
	rrf		VALUE2,f	

; check hour timer. If still timing then absorption. if timer ended (hour0=0) then float
	movf	HOUR0,w
	btfsc	STATUS,Z
	goto	FLOAT_VALUES

ABSORPTION_VALUES
; absorption
	rrf		CUT_COMP_M,w
	movwf	VALUE3
	rrf		CUT_COMP_L,w		; get value difference
	movwf	VALUE4
	rrf		VALUE3,w
	rrf		VALUE4,f

; compare battery with compensated cutoff V
	movf	BATT_HI,w		; high byte of battery voltage
	subwf	CUT_COMP_M,w 	; take from compensated cut V
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	subwf	CUT_COMP_L,w	; take from compensated cut V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then battery voltage is over cut voltage
	goto	INC_CHARGE
	goto	DECREASE_CHARGE

FLOAT_VALUES 
; float
	rrf		FLOAT_COMP_M,w
	movwf	VALUE3
	rrf		FLOAT_COMP_L,w		; get value difference
	movwf	VALUE4
	rrf		VALUE3,w
	rrf		VALUE4,f

; compare battery with float V
	movf	BATT_HI,w		; high byte of battery voltage
	subwf	FLOAT_COMP_M,w 	; take from compensated float
	movwf	DIGITAL			; store
	movf	BATT_LO,w		; low byte
	subwf	FLOAT_COMP_L,w	; take from compensated float V
	btfss	STATUS,C
	decf	DIGITAL,f		; decrease if required
	btfss	DIGITAL,7		; if set then battery voltage is over float voltage
	goto	INC_CHARGE

; decrease charge
DECREASE_CHARGE
	movf	VALUE4,w		; absorption/float 8-bit
	subwf	VALUE2,f		; battery 8-bit
; if >3 switch off charge
	movf	VALUE2,w
	sublw	D'3'
	btfss	STATUS,C
	goto	CLEAR_CHRG		; over 

	movf	VALUE2,w		; subtracted value
	subwf	CCPR1L,w
	btfss	STATUS,C		; if negative set at 0
	clrw	
	movwf	CCPR1L			; reduce charge
	goto	CYCLE
CLEAR_CHRG
	clrf	CCPR1L
	goto	CYCLE

INC_CHARGE
	movf	VALUE2,w		; batt
	subwf	VALUE4,w		; float
	addwf	CCPR1L,w
	movwf	VALUE2			; store
	sublw	D'64'			; if over 64 set at 64
	btfss	STATUS,C		; if carry set at D64
	goto	SET_FULL		; D'64'					
; increase charge
	movf	VALUE2,w		; added value
	movwf	CCPR1L	
	goto	CYCLE
SET_FULL
	movlw	D'64'			; set at maximum 64
	movwf	CCPR1L	
	goto	CYCLE
	
BURST 
	bsf		CHARGE_FLAG,0	; no normal charging flag
; burst pulses of current till voltage >10.5V
	movf	FLASHER,w		; flasher counter (0-255 count)
	andlw	B'00001111'		; 
; only burst is on for 1 in 16 (6.25% on duty cycle) at a 4.2s rate
	btfss	STATUS,Z
	goto	BURST_OFF
; Burst on
	bcf		PORTB,4			; Charge LED on
	movlw	D'64'
	movwf	CCPR1L			; set full charge
	goto	CYCLE	

BURST_OFF
	bsf		PORTB,4			; charge LED off
	clrf	CCPR1L
	goto	CYCLE

;***************************************************

; INTERRUPT
; start interrupt by saving w and status registers 
	
INTERRUPT
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP		; status in status_tmp 
	bcf		STATUS,RP0		; bank select
	bcf 	STATUS,RP1		; select memory bank 0 

	bcf		PIR1,TMR1IF		; clear flag

; flasher rate (increases every 0.262ms)
	incf	FLASHER,f		; flasher

; rate for power calculation during charging 
	movf	PERIOD,w		; period for charging power cycle
	btfss	STATUS,Z
	decf	PERIOD,f		; decrease if not 0

; flash charge LED(PORTB,4)if required
; check thermistor
	btfss	THERMISTOR,0	; when set, thermistor is out of circuit 
 	goto	CK_THERM1
	movf	FLASHER,w
	andlw	B'00001111'		; flash 262ms on each 2 seconds
	btfsc	STATUS,Z		; 
	goto	SET_OUT
	bsf		PORTB,4			; charge LED off
	goto	TIME
SET_OUT
	bcf		PORTB,4			; charge LED on
	goto	TIME

CK_THERM1
	btfss	THERMISTOR,1	; when set, thermistor is shorted
 	goto	CHARGE_CONDITION
	movf	FLASHER,w
	andlw	B'00000111'		; flash 262ms on each 1 second
	btfsc	STATUS,Z
	goto	SET_OUT1
	bsf		PORTB,4			; charge LED off
	goto	TIME
SET_OUT1
	bcf		PORTB,4			; charge LED on
	goto	TIME

CHARGE_CONDITION
	movf	CHARGE_FLAG,w	; if zero then charging
	btfss	STATUS,Z
	goto	OFF_CHRG
; check main or trickle
	btfss	CHARGE_STATE,0	; clear then main charge
	goto	MAIN_LED

; if HOUR0 clear use float flasher. Otherwise absorption flasher
	movf	HOUR0,w
	btfsc	STATUS,Z
	goto	FLOAT_FLASH
;
ABSORPTION_FLASH
	btfss	FLASHER,1		; alternate flash once every 1 second during absorption
	goto	SET_OUT2		; charge LED off
	bsf		PORTB,4			; charge LED off
	goto	TIME
;
FLOAT_FLASH
	btfss	FLASHER,2		; alternate flash once every 2-seconds during float
	goto	SET_OUT2
	bsf		PORTB,4			; charge LED off
	goto	TIME
SET_OUT2
	bcf		PORTB,4			; charge LED on
	goto	TIME	
;
MAIN_LED
	bcf		PORTB,4			; charge LED on
	goto	TIME	
;
OFF_CHRG
	bsf		PORTB,4			; charge LED off

; decrease TIME_ON counter to 0, and when 0 clear RB0 for LAMP off
; timer for lamp
; TIMEOUT
; 0-2.5V sets 2-266s (2s to 4.44 minutes ~2s steps)
; 2.5V-<5V sets 3.84m-480 minutes (3.8 minutes to 8hours ~3.8minute steps)
; 5V sets no timeout
 
TIME
	incf	SECOND,f		; seconds
	movf	SECOND,w
	sublw	D'7'			; 2 seconds
	btfsc	STATUS,C
	goto	CHECK_END
	clrf	SECOND			; cleared when 2-seconds reached

; check TIMER value
	btfss	TIMER,7			; if bit 7 set use minutes
	goto	SEC_COUNT
; minutes
	movf	TIMER,w			; if FF then no timeout
	xorlw	D'255'
	btfsc	STATUS,Z
	goto	CHECK_END
	movf	TIMER,w			; if FE then no timeout
	xorlw	D'254'
	btfsc	STATUS,Z
	goto	CHECK_END

	bcf		TIME_ON,7		; clear bit 7 in minutes mode
	incf	MINUTE,f		; seconds
	movf	MINUTE,w
	sublw	D'109'			; 3.8 minutes
	btfsc	STATUS,C
	goto	CHECK_END
	clrf	MINUTE
SEC_COUNT
	movf	TIME_ON,w
	btfsc	STATUS,Z		; when not zero decrement counter
	goto	CLEAR_LAMP
	decf	TIME_ON,f
	goto	CHECK_END
CLEAR_LAMP
	bcf		PORTB,0			; lamp off
	
CHECK_END
; hour timer
	incf	HOUR1,f			; seconds
	movf	HOUR1,w
	sublw	D'52'			; 14 seconds
	btfsc	STATUS,C
	goto	RECLAIM
	clrf	HOUR1			; cleared when 14-seconds reached

	movf	HOUR0,w			; starts at 255 so 256 x 14s = 1 hour 
	btfss	STATUS,Z		; check if zero
	decf	HOUR0,f			; no decrease if already 0
		
RECLAIM
; end of interrupt reclaim w and status 
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;**************************************************************
; Subroutines

; delays

; DELAY for A/D acquisition
DEL_AD
	movlw	D'50'			; * 4MHz operation
;	movlw	D'100'			; ** 8MHz operation
	movwf	DELCNT
DEL1
	decfsz	DELCNT,f
	goto	DEL1

	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	bsf		STATUS,RP0		; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	DIGITAL
	return

; delay general purpose debounce switch 500ms
DELAY
   movlw	D'2'		; * 4MHz operation
;	movlw	D'4'		; ** 8MHz operation number of delay cycles
DELAY_1	
	movwf	DELCNT

DELAY_M
	movlw	D'255'		; set delay period 
	movwf	VALUE_1		; VALUE_1 = w
LP_1
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_2
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1
	decfsz	DELCNT,f
	goto	DELAY_M
	return	

DELAY2
	movlw	D'4'		; * 4MHz operation set delay period 	
;	movlw	D'8'		; ** 8MHz operation set delay period 
	movwf	VALUE_1		; VALUE_1 = w
LP_3
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_4
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_4
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_3
	return	

DELAY3
	movlw	D'23'		; * 4MHz operation
;	movlw	D'25'		; ** 8MHz operation set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_5
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_5
	return	
	
;*********************************
; 24x24 Bit Unsigned Fixed Point Multiply 24x24 -> 48
; Input: 24 bit unsigned fixed point multiplicand in AARGB0,1,2
; 24 bit unsigned fixed point multiplier in BARGB0,1,2
; Use: CALL FXM2424U
; Output: 48 bit unsigned fixed point product in AARGB0
; Result: AARG <-- AARG x BARG
; Max Timing: 9+501+2 = 512 clks
; Min Timing: 9+150 = 159 clks

FXM2424U
	CLRF 	AARGB3 ; clear partial product
	CLRF 	AARGB4
	CLRF 	AARGB5
	MOVF 	AARGB0,W
	MOVWF 	TEMPB0
	MOVF 	AARGB1,W
	MOVWF 	TEMPB1
	MOVF 	AARGB2,W
	MOVWF 	TEMPB2

	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
LOOPUM2424A
	RRF 	BARGB2,F
	BTFSC 	STATUS,C
	GOTO 	ALUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO	LOOPUM2424A
	MOVWF 	LOOPCOUNT
LOOPUM2424B
	RRF 	BARGB1,F
	BTFSC 	STATUS,C
	GOTO	BLUM2424NAP
	DECFSZ	LOOPCOUNT,F
	GOTO	LOOPUM2424B
	MOVWF	LOOPCOUNT
LOOPUM2424C
	RRF		BARGB0,F
	BTFSC 	STATUS,C
	GOTO 	CLUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPUM2424C
	CLRF 	AARGB0
	CLRF 	AARGB1
	CLRF 	AARGB2
	RETLW 	0x00
CLUM2424NAP
	BCF 	STATUS,C
	GOTO 	CLUM2424NA
BLUM2424NAP
	BCF 	STATUS,C
	GOTO 	BLUM2424NA
ALUM2424NAP
	BCF 	STATUS,C
	GOTO 	ALUM2424NA
ALOOPUM2424
	RRF 	BARGB2,F
	BTFSS 	STATUS,C
	GOTO 	ALUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF	AARGB0,F
ALUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	ALOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
BLOOPUM2424
	RRF 	BARGB1,F
	BTFSS 	STATUS,C
	GOTO 	BLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
BLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	BLOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
CLOOPUM2424
	RRF 	BARGB0,F
	BTFSS 	STATUS,C
	GOTO 	CLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
CLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	RRF 	AARGB5,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	CLOOPUM2424
	return

;********************************
; 32/32 Bit Unsigned Fixed Point Divide 32/32 -> 32.32
; Input: 32 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2,AARGB3
; 32 bit unsigned fixed point divisor in BARGB0, BARGB1, BARGB2, BARGB3
; Use: CALL FXD3232U
; Output: 32 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2,AARGB3
; 32 bit unsigned fixed point remainder in REMB0, REMB1, REMB2, REMB3
; Result: AARG, REM <-- AARG / BARG
; Max Timing: 4+1025+2 = 1031 clks
; Max Timing: 4+981+2 = 987 clks
; PM: 4+359+1 = 364 DM: 13
FXD3232U
	CLRF 	REMB0
	CLRF	REMB1
	CLRF 	REMB2
	CLRF 	REMB3
	call	UDIV3232L
	return

UDIV3232L 
; Max Timing: 24+6*32+31+31+6*32+31+31+6*32+31+31+6*32+31+16 = 1025 clks
; Min Timing: 24+6*31+30+30+6*31+30+30+6*31+30+30+6*31+30+3 = 981 clks
; PM: 359 DM: 13
	CLRF 	TEMP
	RLF 	AARGB0,W
	RLF 	REMB3,F
	MOVF 	BARGB3,W
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	RLF 	AARGB0,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232A 
	RLF 	AARGB0,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB0,0
	GOTO 	UADD22LA
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LA

UADD22LA 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LA 
	RLF		AARGB0,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232A
	RLF 	AARGB1,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB0,0
	GOTO 	UADD22L8
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L8

UADD22L8 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22L8 
	RLF 	AARGB1,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232B 
	RLF 	AARGB1,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB1,0
	GOTO 	UADD22LB
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LB

UADD22LB 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LB 
	RLF 	AARGB1,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232B
	RLF 	AARGB2,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS	AARGB1,0
	GOTO 	UADD22L16
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L16

UADD22L16 	
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF	TEMP,F

UOK22L16
	RLF		AARGB2,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232C 
	RLF 	AARGB2,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB2,0
	GOTO 	UADD22LC
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22LC

UADD22LC
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22LC 
	RLF 	AARGB2,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPU3232C
	RLF 	AARGB3,W
	RLF 	REMB3,F
	RLF 	REMB2,F
	RLF 	REMB1,F
	RLF 	REMB0,F
	RLF 	TEMP,F
	MOVF 	BARGB3,W
	BTFSS 	AARGB2,0
	GOTO 	UADD22L24
	SUBWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB2,W
	SUBWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB1,W
	SUBWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSS 	STATUS,C
	INCFSZ 	BARGB0,W
	SUBWF 	REMB0,F
	CLRW
	BTFSS 	STATUS,C
	MOVLW 	H'1'
	SUBWF 	TEMP,F
	GOTO 	UOK22L24

UADD22L24 
	ADDWF 	REMB3,F
	MOVF 	BARGB2,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB2,W
	ADDWF 	REMB2,F
	MOVF 	BARGB1,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB1,W
	ADDWF 	REMB1,F
	MOVF 	BARGB0,W
	BTFSC 	STATUS,C
	INCFSZ 	BARGB0,W
	ADDWF 	REMB0,F
	CLRW
	BTFSC 	STATUS,C
	MOVLW 	H'1'
	ADDWF 	TEMP,F

UOK22L24 
	RLF 	AARGB3,F
	MOVLW 	H'7'
	MOVWF 	LOOPCOUNT

LOOPU3232D 
    RLF  	AARGB3,W
    RLF    	REMB3,F
    RLF    	REMB2,F
    RLF    	REMB1,F
    RLF    	REMB0,F
    RLF    	TEMP,F
    MOVF   	BARGB3,W
 	BTFSS  	AARGB3,0
   	GOTO   	UADD22LD

    SUBWF  	REMB3,F
  	MOVF   	BARGB2,W
    BTFSS   STATUS,C
    INCFSZ  BARGB2,W
    SUBWF   REMB2,F
    MOVF    BARGB1,W
    BTFSS   STATUS,C
    INCFSZ  BARGB1,W
    SUBWF   REMB1,F
    MOVF    BARGB0,W
    BTFSS   STATUS,C
    INCFSZ  BARGB0,W
    SUBWF   REMB0,F
    CLRW
    BTFSS   STATUS,C
    MOVLW   H'1'
    SUBWF   TEMP,F
    GOTO    UOK22LD

UADD22LD      
	ADDWF   REMB3,F
    MOVF    BARGB2,W
    BTFSC   STATUS,C
    INCFSZ  BARGB2,W
    ADDWF   REMB2,F
    MOVF    BARGB1,W
    BTFSC   STATUS,C
    INCFSZ  BARGB1,W
    ADDWF   REMB1,F
    MOVF    BARGB0,W
    BTFSC   STATUS,C
    INCFSZ  BARGB0,W
    ADDWF   REMB0,F
    CLRW
    BTFSC   STATUS,C
    MOVLW   H'1'
    ADDWF   TEMP,F
        
UOK22LD
	RLF     AARGB3,F

   	DECFSZ  LOOPCOUNT, F
    GOTO    LOOPU3232D

    BTFSC   AARGB3,0
    GOTO    UOK22L
    MOVF    BARGB3,W
	ADDWF   REMB3,F
    MOVF    BARGB2,W
    BTFSC   STATUS,C
    INCFSZ  BARGB2,W
    ADDWF   REMB2,F
    MOVF    BARGB1,W
    BTFSC   STATUS,C
    INCFSZ  BARGB1,W
    ADDWF   REMB1,F
    MOVF    BARGB0,W
    BTFSC   STATUS,C
    INCFSZ  BARGB0,W
    ADDWF   REMB0,F

UOK22L

	RETURN

;******************	
; 8 x 8 multiply

EIGHTEIGHT      CLRF    AARGB1          ; clear partial product
UMUL0808L        
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
                MOVF    AARGB0,W

LOOPUM0808A
                RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    LUM0808NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808A

                CLRF    AARGB0
                RETLW   H'00'

LUM0808NAP
                BCF     STATUS,C
                GOTO    LUM0808NA

LOOPUM0808
                RRF     BARGB0, F
                BTFSC   STATUS,C
                ADDWF   AARGB0, F
LUM0808NA       RRF    	AARGB0, F
                RRF    	AARGB1, F
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM0808

                return  


 end
