; Air quality Meter using CO and CO2 Sensors

	list P=16F88
	#include p16f88.inc
	ERRORLEVEL -302
	ERRORLEVEL -306

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Bank 0 RAM

CO_BAR		equ	H'20'	; CO bargraph value (0-8) range
CO2_BAR		equ	H'21'	; CO2 bargraph value (0-8) range
DELCNT		equ	H'22'	; delay counter
DIGITAL		equ	H'23'	; A/D value (ls byte)
LED_VAL		equ	H'24'	; LED value for multiplexer
CO2_VALUE	equ	H'25'	; C02 value
CO2_LEVEL	equ	H'26'	; CO2 display level
CO2_THRESH	equ	H'27'	; CO2 threshold
CO_VALUE	equ	H'28'	; C0 value
CO_LEVEL	equ	H'29'	; CO LEVEL
STARTUP		equ	H'2A'	; startup flag
DIV_2		equ	H'2B'	; divide by 2
DIV_256		equ	H'2C'	; divide by 256
CYCLE_CNT	equ	H'2D'	; cycle counter
TEMP_DIM	equ	H'2E'	; dimming counter in interrupt
MULTI		equ	H'2F'	; monitor of multiplex state
HEAT_CYCLE	equ	H'30'	; CO sensor cycle (Heat and Measure)
RANGE		equ	H'31'	; temporary display range value	
CHIRP		equ	H'32'	; alarm chirp type
CHIRP1		equ	H'33'	; temporary CHIRP value
CHIRP2		equ	H'34'	; temporary CHIRP value
CHIRP_COUNT3 equ H'35'	; on period counter
CHIRP_COUNT2 equ H'36'	; on/off rate counter
CHIRP_COUNT1 equ H'37'	; period counter
LAST_CO2	equ	H'38'	; previous C02 value
LAST_CO		equ	H'39'	; previous C0 value	
DIM			equ	H'3A'	; dimming value
	
; Math
AARGB0			equ	H'60'	; ms multiplier
AARGB1			equ	H'61'	; ls multiplier
BARGB0			equ	H'62'	; ms multiplier
LOOPCOUNT		equ	H'63'	; counter
AARGB3			equ	H'64'	; div routine
REMB0			equ	H'65'	; remainder
TEMP1			equ	H'66'	; temporary register
	
; All Banks RAM

W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt

 
; start at memory 0

	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

; **********************************************************************************************

; Lookup tables for 8-level bargraph display multiplexing

; Inclusive OR the BAR1 and BAR2 values for Q1 multiplex drive

CYCLE_Q1_BAR1 ; (left bargraph with transistor Q1 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 1 level
	retlw	B'00000000'	; for a 2 level
	retlw	B'00000000'	; for a 3 level
	retlw	B'00000000'	; for a 4 level
	retlw	B'00000000'	; for a 5 level
	retlw	B'00000000'	; for a 6 level
	retlw	B'00000000'	; for a 7 level
	retlw	B'00000000'	; for a 8 level
	retlw	B'00000000'	; for a 9 level
	retlw	B'00000000'	; for a 10 level
	retlw	B'00010000'	; for a 11 level. LED 2
	retlw	B'00010000'	; for a 12 level. LED 2
	retlw	B'00011000'	; for a 13 level. LEDs 1&2
	retlw	B'00001000'	; for a 14 level. LED 1
	retlw	B'00001000'	; for a 14 level. LED 1
	retlw	B'00001000'	; for a 14 level. LED 1
CYCLE_Q1_BAR2 ; (right bargraph with transistor Q1 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 1 level
	retlw	B'00000000'	; for a 2 level
	retlw	B'00000000'	; for a 3 level
	retlw	B'00000000'	; for a 4 level
	retlw	B'00000000'	; for a 5 level
	retlw	B'00000000'	; for a 6 level
	retlw	B'00000000'	; for a 7 level
	retlw	B'00000000'	; for a 8 level
	retlw	B'00000000'	; for a 9 level
	retlw	B'00000000'	; for a 10 level
	retlw	B'10000000'	; for a 11 level. LED 10
	retlw	B'10000000'	; for a 12 level. LED 10
	retlw	B'10000001'	; for a 13 level. LEDs 9&10
	retlw	B'00000001'	; for a 14 level. LED 9
	retlw	B'00000001'	; for a 14 level. LED 9
	retlw	B'00000001'	; for a 14 level. LED 9
; Inclusive OR the BAR1 and BAR2 values for Q2 multiplex drive

CYCLE_Q2_BAR1 ; (left bargraph with transistor Q2 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 1 level
	retlw	B'00000000'	; for a 2 level
	retlw	B'00000000'	; for a 3 level
	retlw	B'00000000'	; for a 4 level
	retlw	B'00000000'	; for a 5 level
	retlw	B'00000000'	; for a 6 level
	retlw	B'00001000'	; for a 7 level. LED 4
	retlw	B'00001000'	; for a 8 level. LED 4
	retlw	B'00011000'	; for a 9 level. LEDs 3&4
	retlw	B'00010000'	; for a 10 level. LED 3
	retlw	B'00010000'	; for a 11 level. LED 3
	retlw	B'00000000'	; for a 12 level
	retlw	B'00000000'	; for a 13 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
CYCLE_Q2_BAR2 ; (right bargraph with transistor Q2 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 1 level
	retlw	B'00000000'	; for a 2 level
	retlw	B'00000000'	; for a 3 level
	retlw	B'00000000'	; for a 4 level
	retlw	B'00000000'	; for a 5 level
	retlw	B'00000000'	; for a 6 level
	retlw	B'00000001'	; for a 7 level. LED 12
	retlw	B'00000001'	; for a 8 level. LED 12
	retlw	B'10000001'	; for a 9 level. LEDs 11&12
	retlw	B'10000000'	; for a 10 level. LED 11
	retlw	B'10000000'	; for a 11 level. LED 11
	retlw	B'00000000'	; for a 12 level
	retlw	B'00000000'	; for a 13 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
; Inclusive OR the BAR1 and BAR2 values for Q3 multiplex drive

CYCLE_Q3_BAR1 ; (left bargraph with transistor Q3 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 1 level
	retlw	B'00000000'	; for a 2 level
	retlw	B'00010000'	; for a 3 level. LED 6
	retlw	B'00010000'	; for a 4 level. LED 6
	retlw	B'00011000'	; for a 5 level. LED 5&6
	retlw	B'00001000'	; for a 6 level. LED 5
	retlw	B'00001000'	; for a 7 level. LED 5
	retlw	B'00000000'	; for a 8 level
	retlw	B'00000000'	; for a 9 level
	retlw	B'00000000'	; for a 10 level
	retlw	B'00000000'	; for a 11 level
	retlw	B'00000000'	; for a 12 level
	retlw	B'00000000'	; for a 13 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
CYCLE_Q3_BAR2 ; (right bargraph with transistor Q3 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000000'	; for a 1 level
	retlw	B'00000000'	; for a 2 level
	retlw	B'10000000'	; for a 3 level. LED 14
	retlw	B'10000000'	; for a 4 level. LED 14
	retlw	B'10000001'	; for a 5 level. LED 13&14
	retlw	B'00000001'	; for a 6 level. LED 13
	retlw	B'00000001'	; for a 7 level. LED 13 
	retlw	B'00000000'	; for a 8 level
	retlw	B'00000000'	; for a 9 level
	retlw	B'00000000'	; for a 10 level
	retlw	B'00000000'	; for a 11 level
	retlw	B'00000000'	; for a 12 level
	retlw	B'00000000'	; for a 13 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
; Inclusive OR the BAR1 and BAR2 values for Q4 multiplex drive

CYCLE_Q4_BAR1 ; (left bargraph with transistor Q4 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00001000'	; for a 0 level. LED 8	
	retlw	B'00011000'	; for a 1 level. LED 7&8
	retlw	B'00010000'	; for a 2 level. LED 7
	retlw	B'00010000'	; for a 3 level. LED 7
	retlw	B'00000000'	; for a 4 level
	retlw	B'00000000'	; for a 5 level
	retlw	B'00000000'	; for a 6 level
	retlw	B'00000000'	; for a 7 level
	retlw	B'00000000'	; for a 8 level
	retlw	B'00000000'	; for a 9 level
	retlw	B'00000000'	; for a 10 level
	retlw	B'00000000'	; for a 11 level
	retlw	B'00000000'	; for a 12 level
	retlw	B'00000000'	; for a 13 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
CYCLE_Q4_BAR2 ; (right bargraph with transistor Q4 on)
	addwf	PCL,f		; add value to program counter
	retlw	B'00000000'	; for a 0 level
	retlw	B'00000001'	; for a 0 level. LED 16
	retlw	B'10000001'	; for a 1 level. LED 15&16
	retlw	B'10000000'	; for a 2 level. LED 15
	retlw	B'10000000'	; for a 3 level. LED 15
	retlw	B'00000000'	; for a 4 level
	retlw	B'00000000'	; for a 5 level
	retlw	B'00000000'	; for a 6 level
	retlw	B'00000000'	; for a 7 level
	retlw	B'00000000'	; for a 8 level
	retlw	B'00000000'	; for a 9 level
	retlw	B'00000000'	; for a 10 level
	retlw	B'00000000'	; for a 11 level
	retlw	B'00000000'	; for a 12 level
	retlw	B'00000000'	; for a 13 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
	retlw	B'00000000'	; for a 14 level
; **********************************************
SETUP

	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'01000000'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00011110'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000001'	; settings (pullups enabled TMR0/4)976Hz
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00111110'	; AN1 to AN5 are analog inputs
	movwf	ANSEL
	movlw	B'00000001'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01101000'	; 4MHz operation
	movwf	OSCCON		; 
	bcf		STATUS,RP0	; select memory bank 0
; timer 1
	movlw	B'00100001'	; timer 1 prescaler /4, fosc/4
	movwf	T1CON
	bsf		T1CON,0		; timer 1 on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	H'F7'		; 	
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm set
	clrf	CCPR1L		; duty 0% output off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	; clear 10-bits
	clrf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation
	
; initial conditions
INITIAL
	clrf	CO_BAR		; CO bargraph value 
	clrf	CO2_BAR		; CO2 bargraph value 
	clrf 	CO2_VALUE	; C02 value
	clrf	CO2_LEVEL	; CO2 display level
	clrf	CO2_THRESH	; CO2 threshold
	clrf	CO_VALUE	; C0 value
	clrf	CO_LEVEL	; CO level
	clrf	HEAT_CYCLE	; CO sensor cycle
	clrf	CHIRP		; alarm Chirp type
	clrf	CHIRP_COUNT3 ; on period counter
	clrf	CHIRP_COUNT2 ; on/off rate counter
	clrf	CHIRP_COUNT1 ; period counter
	clrf	LAST_CO2	; previous C02 value
	clrf	LAST_CO	 	; previous C0 value	
	clrf	STARTUP		; startup flag for sensors 60s 

; allow interrupts
ALL_INTERRUPTS
	bsf		INTCON,TMR0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE		; set global interrupt enable for above

CYCLE ; program runs here

; DIMMING
; AN1 Dimming level via LDR
; set analog input address
	bcf		ADCON0,5
	bcf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD			; convert to digital 
	comf	ADRESH,w		; 8-bit result
	movwf	DIM

; check if startup ended
	btfss	STARTUP,0		; set after 60s
	goto	CO_SENSOR

; CO2 Sensor
; CO2 sensor
; AN5 CO2 sensor
; sensor is 325mV at 0.0314% in air. 
; this is x 11 for a 3.58V reading
; at 1% CO2 sensor is 265mV and 2.92V. Exhaled air is 5% CO2. 5% would be around 0.2V
; range for 1% is 660mV allowing about 33 8-bit levels

; AN5 CO2_VALUE	; C02 value
; set analog input address
	bsf		ADCON0,5
	bcf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD			; convert to digital 
	comf	ADRESH,w		; 8-bit result reversed  
	movwf	CO2_VALUE		; C02 value

; threshold
	movlw	D'102'			; threshold (ie at 3V op amp output)
	movwf	CO2_THRESH		; CO2 Threshold (minimum)

; AN2 CO2 display level (maximum)CO2_LEVEL	; CO2 display level
; set analog input address
	bcf		ADCON0,5
	bsf		ADCON0,4
	bcf		ADCON0,3		; 
	call	DEL_AD			; convert to digital 
	movf	ADRESH,w		; 8-bit result
	movwf	CO2_LEVEL		; CO2 display level

; subtract minimum from maximum for range
	movf	CO2_THRESH,w	; minimum
	subwf	CO2_LEVEL,w		; maximum
	movwf	RANGE
	movlw	D'00'			; lowest value
	btfss	STATUS,C		; if negative ie min > max set at 0
	movwf	RANGE
; subtract minimum from CO2_VALUE
	movf	CO2_THRESH,w	; minimum
	subwf	CO2_VALUE,w		; measured sensor value
	movwf	AARGB0
	clrw					; set w at 0
	btfss	STATUS,C		; if negative (value < min) set at 0
	movwf	AARGB0
; CO2_BAR =(subtracted value x 16)/ range
	movlw	D'16'	
	movwf	BARGB0			; multiply
	call	EIGHTEIGHT		; 8-bit x 8-bit multiply 
; result in AARGB0,AARGB1
		
	movf	RANGE,w
	movwf	BARGB0			; divide by range
	call	DIV16_8			; divide
; CO2_BAR, CO2 bargraph value 
	movf	AARGB0,w		; ms byte
	btfss	STATUS,Z		; if not zero set CO2_BAR at 16
	goto	SET_CO2_14
	movf	AARGB1,w		; ls byte
	sublw	D'16'			; if negative then value >16
	btfsc	STATUS,C
	goto	CO2_SENSOR_HYSTERESIS

SET_CO2_14
	movlw	D'16'			; add 2 to 14 for hysteresis
	movwf	AARGB1

CO2_SENSOR_HYSTERESIS
; subtract last value from current value
	movf	AARGB1,w
	subwf	LAST_CO2,w
	btfsc	STATUS,C
	goto 	NEW_CO2
		
; Hysteresis to current value
	movlw	D'2'
	addwf	LAST_CO2,w		; subtract from value
	subwf	AARGB1,w
	btfss	STATUS,C		; if smaller use last values
	goto	OUT_CO2

; use new
NEW_CO2
	movf	AARGB1,w
	movwf	LAST_CO2
	movwf	CO2_BAR
OUT_CO2
	
CO_SENSOR

; Use HEAT_CYCLE as a cycle indicator for the sensor. 0 = start heat, 1 = end heat 2, measure
; 0.1ppm in outside air, 0.5-5ppm in homes, 5-15ppm near a gas stove, 50ppm long term limit for safe levels
; CO sensor
; CO_BAR, CO bargraph value (0-8) range
; CO_VALUE, AN3	; C0 value outputs a 10:1 range 
; Heat with Q5 on (RB1 high) for 60s 
; place D114 in CYCLE_CNT wait till zero
; Release Q5 (RB1 low) set CYCLE_CNT at 175 for 90s
; wait till CYCLE_CNT is zero. Measure AN3

	movf	HEAT_CYCLE,w	; check the current heat cycle
	btfss	STATUS,Z		; if zero load counter for 60s
	goto	HEAT_NEXT
; start heat cycle
	movlw	D'117'			; (117) 60s timer
	movwf	CYCLE_CNT
	bsf		PORTB,1			; Q5 on
	incf	HEAT_CYCLE,f	; 1	
HEAT_NEXT
	movf	CYCLE_CNT,w		; check timer
	btfss	STATUS,Z
	goto	BYPASS_READ_CO	; wait for zero timer value
	movf	HEAT_CYCLE,w	; check the current heat cycle
	xorlw	D'1'			; heat cycle end
	btfss	STATUS,Z
	goto	READ_CO			; end of 90s
	movlw	D'175'			; (175) 90s timer
	movwf	CYCLE_CNT
	bcf		PORTB,1			; Q5 off
	bsf		STARTUP,0		; set startup flag
	incf	HEAT_CYCLE,f	; 2
	goto	BYPASS_READ_CO
READ_CO
	clrf	HEAT_CYCLE		; next cycle repeats 60s heat, 90s reading
; AN3 CO_VALUE	; C0 value
; set analog input address
	bcf		ADCON0,5
	bsf		ADCON0,4
	bsf		ADCON0,3		; 
	call	DEL_AD			; convert to digital 
	movf	ADRESH,w		; 8-bit result
	movwf	CO_VALUE		; C0 value
BYPASS_READ_CO
; AN4 CO level. 
; set analog input address
	bsf		ADCON0,5
	bcf		ADCON0,4
	bcf		ADCON0,3		; 
	call	DEL_AD			; convert to digital 
	movf	ADRESH,w		; 8-bit result
	movwf	CO_LEVEL		; CO level maximum level

; subtract minimum from maximum for range
	movlw	D'102'			; quiescent level
	subwf	CO_LEVEL,w		; maximum
	movwf	RANGE
	movlw	D'00'			; lowest value
	btfss	STATUS,C		; if negative ie min > max set at 0
	movwf	RANGE
; subtract minimum from CO_VALUE
	movlw	D'102'			; minimum
	subwf	CO_VALUE,w		; measured sensor value
	movwf	AARGB0
	clrw					; set w at 0
	btfss	STATUS,C		; if negative (value < min) set at 0
	movwf	AARGB0
; CO_BAR =(subtracted value x 16)/ range
	movlw	D'16'	
	movwf	BARGB0			; multiply
	call	EIGHTEIGHT		; 8-bit x 8-bit multiply 
; result in AARGB0,AARGB1
	movf	RANGE,w
	movwf	BARGB0			; divide by range
	call	DIV16_8			; divide
; CO_BAR, CO bargraph value (0-14) range
	movf	AARGB0,w		; ms byte
	btfss	STATUS,Z		; if not zero set CO2_BAR at 16
	goto	SET_CO_16
	movf	AARGB1,w		; ls byte
	sublw	D'16'			; if negative then value >16
	btfss	STATUS,C
	goto	SET_CO_16		; set 
	movf	AARGB1,w
	movwf	CO_BAR
	goto	CO_SENSOR_HYSTERESIS

SET_CO_16
	movlw	D'16'
	movwf	AARGB1

CO_SENSOR_HYSTERESIS
; subtract last value from current value
	movf	AARGB1,w
	subwf	LAST_CO,w
	btfsc	STATUS,C
	goto 	NEW_CO
		
; Hysteresis to current value
	movlw	D'2'
	addwf	LAST_CO,w		; subtract from value
	subwf	AARGB1,w
	btfss	STATUS,C		; if smaller use last values
	goto	OUT_CO

; use new
NEW_CO
	movf	AARGB1,w
	movwf	LAST_CO
	movwf	CO_BAR
OUT_CO

	
ALARM

; use in Interrupt with flags to indicate alarm type long or short
; CO2_BAR and CO_BAR values 0-8
; CHIRP = 0 no alarm 
	clrf	CHIRP1
	clrf	CHIRP2		; clear chirp values
; sound alarm if either bargraph is at level 6 with a short chirp at a long interval
	movf	CO_BAR,w
	sublw	D'9'
	btfsc	STATUS,C
	goto	CK_CO_7
	movlw	D'1'	
	movwf	CHIRP1

; sound alarm if either bargraph is at level 7 with longer chirp at a shorter interval
CK_CO_7
	movf	CO_BAR,w
	sublw	D'11'
	btfsc	STATUS,C
	goto	CK_CO_8
	movlw	D'2'
	movwf	CHIRP1

; sound alarm for longer again at faster rate for level 8
CK_CO_8
	movf	CO_BAR,w
	sublw	D'13'
	btfsc	STATUS,C
	goto	CO2_ALARM
	movlw	D'3'
	movwf	CHIRP1

CO2_ALARM
	
; sound alarm if either bargraph is at level 6 with a short chirp at a long interval
	movf	CO2_BAR,w
	sublw	D'9'
	btfsc	STATUS,C
	goto	CK_CO2_7
	movlw	D'1'
	movwf	CHIRP2

; sound alarm if either bargraph is at level 7 with longer chirp at a shorter interval
CK_CO2_7
	movf	CO2_BAR,w
	sublw	D'11'
	btfsc	STATUS,C
	goto	CK_CO2_8
	movlw	D'2'
	movwf	CHIRP2

; sound alarm for longer again at faster rate for level 8
CK_CO2_8
	movf	CO2_BAR,w
	sublw	D'13'
	btfsc	STATUS,C
	goto	CHIRP_RUN
	movlw	D'3'
	movwf	CHIRP2

CHIRP_RUN
	movf	CHIRP1,w
	btfss	STATUS,Z	; if CHIRP1 and CHIRP2 are zero then clear CHIRP
	goto	NOT_CLEAR
	movf	CHIRP2,w
	btfss	STATUS,Z
	goto	NOT_CLEAR
	clrf	CHIRP
	goto	CYCLE

NOT_CLEAR

; find largest value
	movf	CHIRP1,w
	subwf	CHIRP2,w
	movf	CHIRP2,w	; chirp 2 used unless CHIRP1 is >
	btfss	STATUS,C	; subtract chirp1 from 2. If negative then CHIRP1 is > CHIRP2
	movf	CHIRP1,w	; CHIRP1 is larger	
	movwf	CHIRP		; set chirp
	goto	CYCLE


 ; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 
	
INTERRUPT
	
; 976Hz rate	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp
	bcf		STATUS,RP0	; select memory bank 0 

MULTIPLEX ; multiplex displays
; get current Q1-Q4 drive value
	movf	PORTB,w
	andlw	B'10100100'	; Q1, RB7. Q3, RB2. Q4, RB5 
	movwf	MULTI		; monitor multiplex state
	btfsc	PORTA,6  	; Q2  		
	bsf		MULTI,6		; set bit 6 when PORTA,6 is set
; clear LEDs
	bcf		PORTB,7		; Q1
	bcf		PORTA,6		; Q2
	bcf		PORTB,2		; Q3
	bcf		PORTB,5		; Q4

; dimming delay loop based on LDR 'DIM' value
; 
	movlw	D'51'
	subwf	DIM,w		; if < no dimming
	btfss	STATUS,C
	goto	CYCLE_LEDS
	movwf	TEMP_DIM
	btfsc	STATUS,Z
	goto	CYCLE_LEDS
		
DIM_LOOP
	nop
	decfsz	TEMP_DIM,f	; delay extended to give more dimming
	goto	DIM_LOOP	
	
CYCLE_LEDS
; clear LEDs
	bcf		PORTB,3		; LEDs 1,4,5,8
	bcf		PORTB,4		; LEDs 2,3,6,7
	bcf		PORTA,0		; LEDs 9,12,13,16
	bcf		PORTA,7		; LEDs 10,11,14,15

; cycle between Q1, Q2, Q3 and Q4
	movf	MULTI,w		; check if 0
	btfsc	STATUS,Z
	goto	START		; start multiplexing
; check Q4
	btfss	MULTI,5		; is Q4 on
	goto	CHECK_Q3

; reset to Q1
START ; also start of multiplexer cycle
; drive Q1
	bcf		PORTB,7		; Q1 off
	bcf		PORTB,5		; Q4 off
	bcf		PORTB,2		; Q3 off
	bcf		PORTA,6		; Q2 off

	movf	CO2_BAR,w	; CO2 bargraph value
	call	CYCLE_Q1_BAR2; lookup table for LED drive for Q1
	movwf	LED_VAL		; store value
; Diagnostic
	movf	CO_LEVEL,w	; if zero, diagnostic mode
	btfsc	STATUS,Z
	goto	DIAG_Q1
	movf	CO_BAR,w	; CO bargraph value
	call	CYCLE_Q1_BAR1; lookup table for LED drive for Q1
DRIVE_Q1
	iorwf	LED_VAL,f	; include the two lookup values
; drive LEDs

	bsf		PORTB,7		; Q1 on
	goto	LED_DRV
DIAG_Q1
	movf	HEAT_CYCLE,w	; if zero or 1, heat cycle
	sublw	D'1'			; if negative measure cycle
	movlw	D'0'
	btfsc	STATUS,C	
	movlw	B'00011000'		; LEDs 1&2
	goto	DRIVE_Q1

CHECK_Q3
	btfss	MULTI,2		; is Q3 on
	goto	CHECK_Q2
; drive Q4
	bcf		PORTB,7		; Q1 off
	bcf		PORTB,5		; Q4 off
	bcf		PORTB,2		; Q3 off
	bcf		PORTA,6		; Q2 off
	movf	CO2_BAR,w	; CO2 bargraph value
	call	CYCLE_Q4_BAR2; lookup table for LED drive for Q4
	movwf	LED_VAL		; store value
; Diagnostic
	movf	CO_LEVEL,w	; if zero, diagnostic mode
	btfsc	STATUS,Z
	goto	DIAG_Q4
	movf	CO_BAR,w	; CO bargraph value
	call	CYCLE_Q4_BAR1; lookup table for LED drive for Q4
DRIVE_Q4
	iorwf	LED_VAL,f	; include the two lookup values

	bsf		PORTB,5		; Q4 on
	goto	LED_DRV
DIAG_Q4
	movf	HEAT_CYCLE,w	; if zero or 1, heat cycle
	sublw	D'1'			; if negative measure cycle
	movlw	D'0'
	btfsc	STATUS,C
	goto	DRIVE_Q4		; w is 0
; check timer
	movlw	D'30'
	subwf	CYCLE_CNT,w
	movlw	D'0'
	btfsc	STATUS,C		; if over 59, LED7 and 8 on
	movlw	B'00011000'		; LED7 and 8	
	iorwf	LED_VAL,f		; include
	movlw	B'00001000'		;  LED 8
	goto	DRIVE_Q4

CHECK_Q2
	btfss	MULTI,6		; is Q2 on
	goto	CHECK_Q1
; drive Q3
	bcf		PORTB,7		; Q1 off
	bcf		PORTB,5		; Q4 off
	bcf		PORTB,2		; Q3 off
	bcf		PORTA,6		; Q2 off
	movf	CO2_BAR,w	; CO2 bargraph value
	call	CYCLE_Q3_BAR2; lookup table for LED drive for Q3
	movwf	LED_VAL		; store value
; Diagnostic
	movf	CO_LEVEL,w	; if zero, diagnostic mode
	btfsc	STATUS,Z
	goto	DIAG_Q3
	movf	CO_BAR,w	; CO bargraph value
	call	CYCLE_Q3_BAR1; lookup table for LED drive for Q3
DRIVE_Q3
	iorwf	LED_VAL,f	; include the two lookup values
	bsf		PORTB,2		; Q3 on
	goto	LED_DRV

DIAG_Q3
	movf	HEAT_CYCLE,w	; if zero or 1, heat cycle
	sublw	D'1'			; if negative measure cycle
	movlw	D'0'
	btfsc	STATUS,C	
	goto	DRIVE_Q3		; w is 0
; check timer
	movlw	D'88'
	subwf	CYCLE_CNT,w
	movlw	D'0'
	btfsc	STATUS,C		; if over, LED5 and 6 on
	movlw	B'00011000'		; LED5 and 6	
	iorwf	LED_VAL,f		; include
	movlw	D'59'
	subwf	CYCLE_CNT,w
	movlw	D'0'
	btfsc	STATUS,C		; if over, LED6 on
	movlw	B'00010000'		; LED 6
	goto	DRIVE_Q3

CHECK_Q1
	btfss	MULTI,7		; is Q1 on
	goto	START		; error. not Q1, Q2, Q3 or Q4
; drive Q2
	bcf		PORTB,7		; Q1 off
	bcf		PORTB,5		; Q4 off
	bcf		PORTB,2		; Q3 off
	bcf		PORTA,6		; Q2 off
	movf	CO2_BAR,w	; CO2 bargraph value
	call	CYCLE_Q2_BAR2; lookup table for LED drive for Q2
	movwf	LED_VAL		; store value
; Diagnostic
	movf	CO_LEVEL,w	; if zero, diagnostic mode
	btfsc	STATUS,Z
	goto	DIAG_Q2
	movf	CO_BAR,w	; CO bargraph value
	call	CYCLE_Q2_BAR1; lookup table for LED drive for Q2
DRIVE_Q2
	iorwf	LED_VAL,f	; include the two lookup values
	bsf		PORTA,6		; Q2 on
	goto	LED_DRV
DIAG_Q2
	movf	HEAT_CYCLE,w	; if zero or 1, heat cycle
	sublw	D'1'			; if negative measure cycle
	movlw	D'0'
	btfsc	STATUS,C	
	goto	DRIVE_Q2		; w is 0
; check timer
	movlw	D'146'
	subwf	CYCLE_CNT,w
	movlw	D'0'
	btfsc	STATUS,C		; if over, LED4 and 3 on
	movlw	B'00011000'		; LED4 and 3	
	iorwf	LED_VAL,f		; include
	movlw	D'117'
	subwf	CYCLE_CNT,w
	movlw	D'0'
	btfsc	STATUS,C		; if over, LED4 on
	movlw	B'00001000'		; LED 4
	goto	DRIVE_Q2

LED_DRV
; drive LEDs
	btfsc	LED_VAL,3	; if led value set set port
	bsf		PORTB,3		; LEDs 1,4,5,8
	btfsc	LED_VAL,4	; if led value set set port
	bsf		PORTB,4		; LEDs 2,3,6,7
	btfsc	LED_VAL,0	; if led value set set port
	bsf		PORTA,0		; LEDs 9,12,13,16
	btfsc	LED_VAL,7	; if led value set set port
	bsf		PORTA,7		; LEDs 10,11,14,15
; increase counter
TIMERS
	incf	DIV_2,f		; divide by 2 for 2.048ms count
	btfss	DIV_2,0		; when set run other counters
	goto	ALM_DRV
	incfsz	DIV_256,f	; 524ms counter
	goto	ALM_DRV	
	movf	CYCLE_CNT,w	; counts down to zero from 114 for 60s and 172 for 90s
	btfss	STATUS,Z	; when zero do not decrease
	decf	CYCLE_CNT,f	; decrease to zero

ALM_DRV

; alarm driver
	movf	CHIRP,w
	btfsc	STATUS,Z	; if zero no chirp
	goto	CHIRP_OFF
	movf	CHIRP,w
	xorlw	D'1'			; short chirp and at slow rate
	btfss	STATUS,Z
	goto	CK_NEXT1
	incf	CHIRP_COUNT3,f	; chirp on counter	
	incfsz	CHIRP_COUNT1,f	; period counter
	goto	PERIOD_COUNT1
	incf	CHIRP_COUNT2,f	; 16 bit counter
PERIOD_COUNT1
	btfss	CHIRP_COUNT2,5	; 512ms/bit 
	goto	CLR_OUT_ONLY
	btfsc	CHIRP_COUNT3,4	; 1.024ms/bit. When bits are set, chirp
	goto	CHIRP_OFF
	movlw	D'127'			; chirp on
	movwf	CCPR1L
	goto	RECLAIM

CK_NEXT1
	movf	CHIRP,w
	xorlw	D'2'			; short chirp and at slow rate
	btfss	STATUS,Z
	goto	CK_NEXT2
	incf	CHIRP_COUNT3,f	; chirp on counter	
	incfsz	CHIRP_COUNT1,f	; period counter
	goto	PERIOD_COUNT2
	incf	CHIRP_COUNT2,f	; 16 bit counter
PERIOD_COUNT2
	btfss	CHIRP_COUNT2,3	; 512ms/bit
	goto	CLR_OUT_ONLY
	btfsc	CHIRP_COUNT3,5	; 1.024ms/bit. When bits are set, chirp
	goto	CHIRP_OFF
	movlw	D'127'			; chirp on
	movwf	CCPR1L
	goto	RECLAIM

CK_NEXT2
	movf	CHIRP,w
	xorlw	D'3'			; short chirp and at fast rate
	btfss	STATUS,Z
	goto	RECLAIM
	incf	CHIRP_COUNT3,f	; chirp on counter	
	incfsz	CHIRP_COUNT1,f	; period counter
	goto	PERIOD_COUNT3
	incf	CHIRP_COUNT2,f	; 16 bit counter
PERIOD_COUNT3
	btfss	CHIRP_COUNT2,0	; 512ms/bit
	goto	CLR_OUT_ONLY
	btfsc	CHIRP_COUNT3,6	; 1.024ms/bit. When bits are set, chirp
	goto	CHIRP_OFF
	movlw	D'127'			; chirp on at 4kHz
	movwf	CCPR1L
	goto	RECLAIM

CHIRP_OFF
	clrf	CHIRP_COUNT3	; on period counter
	clrf	CHIRP_COUNT2	; on/off rate counter
CLR_OUT_ONLY
	clrf	CCPR1L		; duty 0% output off

; end of interrupt reclaim w and status 
RECLAIM
	bcf		INTCON,TMR0IF	; clear TMR0 interrupt flag
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt


;**************************************************************
; Subroutines

; delays

; DELAY for A/D acquisition
DEL_AD
	movlw	D'50'			; 
	movwf	DELCNT
DEL1
	decfsz	DELCNT,f
	goto	DEL1

	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	return

; 8 x 8 multiply

EIGHTEIGHT      CLRF    AARGB1          ; clear partial product
UMUL0808L        
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
                MOVF    AARGB0,W

LOOPUM0808A
                RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    LUM0808NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808A

                CLRF    AARGB0
                RETLW   H'00'

LUM0808NAP
                BCF     STATUS,C
                GOTO    LUM0808NA

LOOPUM0808
                RRF     BARGB0, F
                BTFSC   STATUS,C
                ADDWF   AARGB0, F
LUM0808NA       RRF    	AARGB0, F
                RRF    	AARGB1, F
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808

                return  

;**********************************************************************************************
        
;       16/8 Bit Unsigned Fixed Point Divide 16/8 -> 16.08

;       Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;               8 bit unsigned fixed point divisor in BARGB0

;      ;       Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;               8 bit unsigned fixed point remainder in REMB0

;       Result: AARG, REM  <--  AARG / BARG

DIV16_8      	CLRF            REMB0
                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608A      RLF             AARGB0,W
                RLF             REMB0, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F

                BTFSC           STATUS,C
                GOTO            UOK68A          
                ADDWF           REMB0, F
                BCF             STATUS,C
UOK68A          RLF             AARGB0, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608A

                CLRF            TEMP1

                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608B      RLF             AARGB1,W
                RLF             REMB0, F
                RLF             TEMP1, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSS           STATUS,C
                INCFSZ          AARGB3,W
                SUBWF           TEMP1, F

                BTFSC           STATUS,C
                GOTO            UOK68B          
                MOVF            BARGB0,W
                ADDWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSC           STATUS,C
                INCFSZ          AARGB3,W
                ADDWF           TEMP1, F

                BCF             STATUS,C
UOK68B          RLF             AARGB1, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608B
                return
           
 end
