
 
; Ultrasonic cleaner

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _HS_OSC	

EEPROM0		equ	H'00'	; non-volatile storage for 
; RAM 

W_TMP			equ	H'20'	; storage of w before interrupt
STATUS_TMP		equ	H'21'	; status storage before interrupt	
STORE1			equ	H'22'	; delay counter	
STORE2			equ	H'23'	; delay counter
STORE3			equ	H'24'	; delay counter
FREQ_SET		equ	H'25'	; frequency set value
STATE			equ	H'26'	; push pull port output selector
CYCLE1			equ	H'27'	; cycle counter ms
CYCLE2			equ	H'28'	; cycle counter ls	
SWEEP_STEP		equ	H'29'	; sweep steps counter
SWEEP_BAND		equ	H'2A'	; sweep bands
DEAD_TIME		equ	H'2B'	; dead time counter	
TIMER			equ	H'2C'	; timer	
TIMER1			equ	H'2D'	; timer multiplier
RANDOM			equ	H'2E'	; random sequence
MODE			equ	H'2F'	; frequency mode

; preprogram EEPROM DATA 
	
	ORG     H'2100'
	DE		H'00'

; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
	nop
	nop
	nop		; 
	org     4			; interrupt vector
	goto	INTERRUPT

; ***********************************************************************

SWEEP1 ; narrow range
	addwf	PCL,f		; add w to program counter
; 40kHz with 12kHz bandwidth								
	retlw	D'212';	 
	retlw	D'214';	
	retlw	D'213';	
	retlw	D'214'; 
 	retlw	D'212'; 
	retlw	D'213'		; 37.87 to 41.66kHz ~344Hz spacings 

;lookup table for frequency sweep including overlapping
; Within each band are 12 frequency steps at 200ns apart.
SWEEP ; wide range
	addwf	PCL,f		; add w to program counter
 
; 6 bands as per this table. Values are for timer 1 counter.

; Within each band are 12 frequency steps at 200ns apart.

; 20kHz with ~2.6kHz bandwidth 									
	retlw	D'148'		; 19.08 to 20.0kHz ~83Hz spacing
	retlw	D'153'		; 19.8 to 20.8kHz
	retlw	D'158'		; 20.66 to 21.7kHz ~94Hz spacings

; 28kHz with 3kHz bandwidth 	
	retlw	D'186'		; 27kHz
; ~175Hz spacings 
	retlw	D'190'		; 30kHz

; 40kHz with 4kHz bandwidth
	retlw	D'213'		; 37.87 to 41.66kHz ~344Hz spacings 

; period for each band
BAND_LENGTH1 ; narrow range
	addwf	PCL,f		; add w to program counter	
	retlw	D'2'
	retlw	D'2'
	retlw	D'1'
	retlw	D'2'
	retlw	D'2'
	retlw	D'1'

; period for each band
BAND_LENGTH ; wide range
	addwf	PCL,f		; add w to program counter	
; 20kHz
	retlw	D'1'
	retlw	D'1'
	retlw	D'1'
; 28kHz
	retlw	D'2'
	retlw	D'3'
; 40kHz
	retlw	D'8'

RANDOMISE
	addwf	PCL,f		; add w to program counter	
; random value 0-6
;1
	retlw	D'1'
	retlw	D'5'
	retlw	D'2'
	retlw	D'0'
	retlw	D'4'
	retlw	D'3'
;2
	retlw	D'4'
	retlw	D'5'
	retlw	D'1'
	retlw	D'2'
	retlw	D'3'	
	retlw	D'0'

;3
	retlw	D'2'
	retlw	D'1'
	retlw	D'5'
	retlw	D'0'
	retlw	D'3'
	retlw	D'4'
;4	
	retlw	D'5'
	retlw	D'1'
	retlw	D'4'
	retlw	D'2'
	retlw	D'0'
	retlw	D'3'
;5	
	retlw	D'0'
	retlw	D'1'
	retlw	D'3'
	retlw	D'2'
	retlw	D'5'
	retlw	D'4'
	
;6	
	retlw	D'3'
	retlw	D'1'
	retlw	D'2'
	retlw	D'4'
	retlw	D'0'
	retlw	D'5'
		

; *******************************************
INTERRUPT
; interrupt occurs when start switch is presseed and released.
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp
	bcf		STATUS,RP0	; select memory bank 0 

; when GPIO,3 goes low, start Ultrasonic cleaner

; measure timer potentiometer
; channel 2 
; routine to wait for A/D conversion
A_D
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	movf	ADRESH,w	; look at pot value
	sublw	D'16'
	movlw	D'16'		; set 16 ready to load
	btfss	STATUS,C	; if negative use ADRESH value. Otherwise set at 16 minimum	
	movf	ADRESH,w
	movwf	TIMER		; load timer
	clrf	TIMER1		; multiplier

; stop interrupt 
	movf	GPIO,w		; read GPIO,3 to ensure interrupt on change (ioc) flag can be cleared
	bcf		INTCON,GPIF	; clear ioc flag
	bcf		INTCON,GPIE	; disable ioc interrupt	
	bcf		INTCON,GIE	; stop interrupt

; end of interrupt reclaim w and status 
RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; **********************************************************

MAIN
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00101100'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'10000000'	; settings (pullups disabled) 
	movwf	OPTION_REG
	movlw	B'00001000'	; interrupt on change for GP3
	movwf	IOC			; interrupt on change register

; analog inputs, A/D
	movlw	B'01100100'	; AN2 analog input 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00001000'	; channel 2 left justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	clrf	T1CON
	bsf		T1CON,0		; timer 1 on

; initial condition
	clrf	GPIO
	bcf		PIR1,TMR1IF	; clear timer 1 overflow

	call	EEPROM_READ	; get current frequency range mode
	movwf	MODE		; frequency mode; wide or narrow

; start up delay ~0.5s
	movlw	D'20'		; delay extension
	movwf 	STORE3
DEL_CONT
	movlw	H'FF'		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT

; if start switch closed, change mode
	btfsc	GPIO,3
	goto	STOP
; switch closed
	incf	MODE,f		; next mode
	movf	MODE,w
	call	EEPROM_WRITE; write to EEPROM
; wait for switch open

WAIT_OPEN
	btfss	GPIO,3
	goto	WAIT_OPEN
; delay ~0.2s
	movlw	D'8'		; delay extension
STOP_END
	movwf 	STORE3
DEL_CONTY
	movlw	H'FF'		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONTY

; Wait for start button
STOP
	clrf	GPIO		; mosfets off
; wait for GPIO,3 to be high
GP3_SET
	btfss	GPIO,3
	goto	GP3_SET 
; debounce
	movlw	D'2'		; delay extension
	movwf 	STORE3
DEL_CONT1
	movlw	H'FF'		; delay routine
	call	DELAYX
	decfsz	STORE3,f	; when 0, exit delay
	goto	DEL_CONT1

INIT
; set initial start button interrupt operation
	movf	GPIO,w		; read GPIO,3 to ensure interrupt on change (ioc) flag can be cleared
	bcf		INTCON,GPIF	; clear ioc flag
	bsf		INTCON,GPIE	; enable ioc interrupt
	bsf		INTCON,GIE	; global enable	
; waits here for low start signal at GP3
	sleep				; wakes on interrupt
	nop

	movlw	D'11'		; steps -1 (12 steps)
	movwf	SWEEP_STEP	; sweep step counter
 
; lookup table values
	clrf	RANDOM
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag clear

DRIVE
; sweep cycle
	incf	RANDOM,f
	movf	RANDOM,w
	sublw	D'35'		; 6-bands, x number of sequences -1
	btfss	STATUS,C
	clrf	RANDOM	
	movf	RANDOM,w	; frequency band randomisation

	call	RANDOMISE
	movwf	SWEEP_BAND
	
IN_SWEEP
	movf	SWEEP_BAND,w
	btfss	MODE,0
	goto	WIDE1
	call	SWEEP1		; narrow range
	goto	TOTAL
WIDE1
	call	SWEEP		; wide range lookup value (sweep is frequency range for each burst)

; Total frequency range
TOTAL
	movwf	FREQ_SET	; frequency set value

; Set cycle counter for number of cycles delivered per tone burst
; set according to band
	movf	SWEEP_BAND,w
	call	BAND_LENGTH
	movwf	CYCLE1
	movlw	H'8F'
	movwf	CYCLE2

; ** Test length extended
;	movwf	CYCLE1

	btfss	MODE,0
	bcf		PIR1,TMR1IF	; clear flag for 10ms off period 

DUTY ; duty period

; check pulse counters
	decf	CYCLE2,f
	movf	CYCLE2,f 	; check ls
	btfsc	STATUS,Z	; if zero decrease ms byte
	decfsz	CYCLE1,f	; if zero end of cycles
	goto	OUT_DRV		; output driver

; check sweep steps 
	movf	SWEEP_STEP,w
	btfsc	STATUS,Z	; when zero end of bursts
	goto	END_BURST	; end of cycle burst

; check for end if timer turned off
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	movf	ADRESH,w	; look at pot value
	sublw	D'8'
	btfsc	STATUS,C	; if negative continue. Otherwise end	
	goto	STOP

; Set cycle counter for number of cycles delivered per tone burst
; set according to band
	movf	SWEEP_BAND,w

	btfss	MODE,0
	goto	WIDE2
	call	BAND_LENGTH1	; narrow range
	goto	VALUE_B
WIDE2
	call	BAND_LENGTH		; wide range
VALUE_B
	movwf	CYCLE1
	movlw	H'8F'
	movwf	CYCLE2

; ** Test length extended
;	movwf	CYCLE1

; count down sweep steps 
	decf	SWEEP_STEP,f; next frequency 
	goto	OUT_DRV		; output driver

; end of cycle burst period
END_BURST
	movlw	D'11'		; 
	movwf	SWEEP_STEP	; reset sweep step value
; cycle till end of frequency half period
WAIT1
	btfss	PIR1,TMR1IF	; timer flag
	goto	WAIT1
; cycle loop

	clrf	GPIO		; driver cleared
; check timer	
	movf	TIMER,w
	btfss	STATUS,Z
	goto	TIME_TEST
; delay ~1s
	movlw	D'40'		; delay extension
	goto   	STOP_END	; stop when timer ended

TIME_TEST
	incf	TIMER1,f
	movf	TIMER1,w	; timer multiplier
	btfss	MODE,0
	goto	TIME_W
	sublw	D'45'		; narrow timer period calibration
	goto	TEST1
TIME_W
	sublw	D'17'		; wide timer period calibration
TEST1
	btfsc	STATUS,C	; if over clear
	goto	DRIVE
	clrf	TIMER1
	decf	TIMER,f
	goto	DRIVE

; output driver
OUT_DRV
	incf	STATE,f		; toggle output selector for GP0 or GP1 using bit 0
	movf	TIMER,w	 	; stop when timer is zero
	btfsc	STATUS,Z
	goto   	STOP

;**** following 14 instructions must not cross page boundary **** 
; Check addresses in listing file.
; divide into steps for a frequency sweep
INCREMENT
	movf	SWEEP_STEP,w; allows 200ns changes to frequency
	addwf	PCL,f
	goto	ONE
	goto	TWO
	goto	THREE
	goto	FOUR
	goto	FIVE
	goto	SIX
	goto	SEVEN
	goto	EIGHT
	goto	NINE
	goto	TEN
	goto	ELEVEN
	goto	TWELVE
; ** end of page boundary restriction
TWELVE
	btfss	PIR1,TMR1IF	; timer flag
	goto	TWELVE
	nop
	nop
	nop
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET12
	nop					; extra frequency adjust
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET12
; end of dead time
	goto	RESET_TIMER_GP1
ELEVEN
	btfss	PIR1,TMR1IF	; timer flag
	goto	ELEVEN
	nop
	nop
	nop
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET11
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET11
; end of dead time
	goto	RESET_TIMER_GP1
TEN
	btfss	PIR1,TMR1IF	; timer flag
	goto	TEN
	nop
	nop
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET10
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET10
	nop					; extra frequency adjust
; end of dead time
	goto	RESET_TIMER_GP1
NINE
	btfss	PIR1,TMR1IF	; timer flag
	goto	NINE
	nop
	nop
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET9
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET9
; end of dead time
	goto	RESET_TIMER_GP1
EIGHT
	btfss	PIR1,TMR1IF	; timer flag
	goto	EIGHT
	nop
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET8
	nop
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET8
; end of dead time
	goto	RESET_TIMER_GP1
SEVEN
	btfss	PIR1,TMR1IF	; timer flag
	goto	SEVEN
	nop
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET7
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET7
; end of dead time
	goto	RESET_TIMER_GP1
SIX
	btfss	PIR1,TMR1IF	; timer flag
	goto	SIX
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET6
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET6
	nop					; extra frequency adjust
	goto	RESET_TIMER_GP1
FIVE
	btfss	PIR1,TMR1IF	; timer flag
	goto	FIVE
	nop
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET5
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET5
; end of dead time
	goto	RESET_TIMER_GP1

FOUR
	btfss	PIR1,TMR1IF	; timer flag
	goto	FOUR
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET4
	nop					; extra frequency adjust
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET4
; end of dead time
	goto	RESET_TIMER_GP1

THREE
	btfss	PIR1,TMR1IF	; timer flag
	goto	THREE
	nop
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET3
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET3
; end of dead time
	goto	RESET_TIMER_GP1

TWO
	btfss	PIR1,TMR1IF	; timer flag
	goto	TWO
	clrf	GPIO		; driver cleared after wait period
	; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET2
	nop					; equalise dead time
; end of dead time

	goto	RESET_TIMER_GP0
SET2
	nop					; extra frequency adjust
; end of dead time
	goto	RESET_TIMER_GP1 ;  

ONE	btfss	PIR1,TMR1IF	; timer flag
	goto	ONE
	clrf	GPIO		; driver cleared after wait period
; add 'nop's for extra dead period
; set output	
	btfsc	STATE,0		; if 0 was set set 1
	goto	SET1
	nop					; equalise dead time
; end of dead time
	goto	RESET_TIMER_GP0
SET1
; end of dead time
	goto	RESET_TIMER_GP1	; 

; reset timer
RESET_TIMER_GP0
	
	comf	TMR1H,f		; ms byte set
	movf	FREQ_SET,w	; ls byte set
	bcf		T1CON,0		; timer 1 off
	movwf	TMR1L	
	bsf		T1CON,0		; timer 1 on
; add extra dead time
	movlw	D'5'
	movwf	DEAD_TIME
DEC_DEAD0
	decfsz	DEAD_TIME,f
	goto	DEC_DEAD0
	bsf		GPIO,GP0	; set 0 output 
	bcf		PIR1,TMR1IF	; clear flag	
	goto	DUTY

; reset timer
RESET_TIMER_GP1
	
	comf	TMR1H,f		; ms byte set
	movf	FREQ_SET,w	; ls byte set
	bcf		T1CON,0		; timer 1 off
	movwf	TMR1L
	bsf		T1CON,0		; timer 1 on
; add extra dead time
	movlw	D'5'
	movwf	DEAD_TIME
DEC_DEAD1
	decfsz	DEAD_TIME,f
	goto	DEC_DEAD1
	bsf		GPIO,GP1	; set 1 output
	bcf		PIR1,TMR1IF	; clear flag	 
	goto	DUTY

 ; ***************************************************************************	

; Subroutines

; read mode
EEPROM_READ
	bsf 	STATUS,RP0 	; Bank 1
	movlw 	EEPROM0		;
	movwf 	EEADR 		; Address to read
	bsf 	EECON1,RD 	; EE Read
	movf 	EEDATA,w 	; Move data to w
	bcf		STATUS,RP0	; Bank 0
	return

; EEPROM write
EEPROM_WRITE
	bsf 	STATUS,RP0 	; Bank 1
	movwf 	EEDATA		; data
	movlw 	EEPROM0		;
	movwf 	EEADR 		; Address
	bsf 	EECON1,WREN ; Enable write
	bcf 	INTCON,GIE 	; Disable Interrupts
	movlw 	H'55'		; Unlock write
	movwf 	EECON2 		;
	movlw 	H'AA' 		;
	movwf 	EECON2 ;
	bsf 	EECON1,WR 	; Start the write
	bcf		STATUS,RP0	; Bank 0
	return

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return



	end
