 // Standard header file for the CCS compiler and PIC18F4550

/* Copyright 2009 Geoff Graham - http://geoffg.net
   This program is free software: you can redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation, either version 2 of the License, or (at your
   option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
   implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.  You should have received a copy of the GNU General Public License along with this program.
   If not, see <http://www.gnu.org/licenses/>. 
   
*/


// standard type definitions
typedef     int1            bit;
typedef     signed int8     sint8;
typedef     signed int16    sint16;
typedef     signed int32    sint24;
typedef     signed int32    sint32;
typedef     unsigned int8   uint8;
typedef     unsigned int16  uint16;
typedef     unsigned int32  uint24;
typedef     unsigned int32  uint32;

#define forever 1
#define OFF     0
#define ON      1

#define uSec(a) delay_us(a)
#define mSec(a) delay_ms(a)

//#define eeprom_read(a) read_eeprom(a)
uint8 eeprom_read(uint8 a) { return read_eeprom(a); }
//#define eeprom_write(a, b) write_eeprom(a, b)
void eeprom_write(uint8 a, uint8 b) { write_eeprom(a, b); }

#define WordLoByte(v) make8(v, 0)
#define WordHiByte(v) make8(v, 1)

#use fast_io(A) 
#use fast_io(B)
#use fast_io(c)
#use fast_io(D)
#use fast_io(E)

#nolist

// Register and bit definitions used in the the PIC18F4550.
// These are intended to make the CCS compiler compatible
// with the definitions used by the Hi-Tech compiler which
// in turn used the naming conventions defined by Microchip
#byte   ADCON2  = 0xFC0
#byte   CCP1CON = 0xFBD
#byte   CVRCON  = 0xFB5
#byte   EECON1  = 0xFA6
#byte   HLVDCON = 0xFD2
#byte   INTCON2 = 0xFF1
#byte   INTCON  = 0xFF2
#byte   IPR2    = 0xFA2
#byte   OSCCON  = 0xFD3
#byte   PIE2    = 0xFA0
#byte   RCON    = 0xFD0
#byte   RCSTA   = 0xFAB
#byte   T0CON   = 0xFD5
#byte   ADCON0  = 0xFC2
#byte   ADCON1  = 0xFC1
#byte   BAUDCON = 0xFB8
#byte   CCP2CON = 0xFBA
#byte   CMCON   = 0xFB4
#byte   ECCP1AS = 0xFB6
#byte   ECCP1DEL    = 0xFB7
#byte   INTCON3 = 0xFF0
#byte   IPR1    = 0xF9F
#byte   LATA    = 0xF89
#byte   LATB    = 0xF8A
#byte   LATC    = 0xF8B
#byte   LATD    = 0xF8C
#byte   LATE    = 0xF8D
#byte   OSCTUNE = 0xF9B
#byte   PIE1    = 0xF9D
#byte   PIR1    = 0xF9E
#byte   PIR2    = 0xFA1
#byte   PORTA   = 0xF80
#byte   PORTB   = 0xF81
#byte   PORTC   = 0xF82
#byte   PORTD   = 0xF83
#byte   PORTE   = 0xF84
#byte   SPPCFG  = 0xF63
#byte   SPPCON  = 0xF65
#byte   SPPEPS  = 0xF64
#byte   SSPCON1 = 0xFC6
#byte   SSPCON2 = 0xFC5
#byte   SSPSTAT = 0xFC7
#byte   STATUS  = 0xFD8
#byte   STKPTR  = 0xFFC
#byte   T1CON   = 0xFCD
#byte   T2CON   = 0xFCA
#byte   T3CON   = 0xFB1
#byte   SPBRGH  = 0xFB0
#byte   SPBRG   = 0xFAF
#byte   TRISA   = 0xF92
#byte   TRISB   = 0xF93
#byte   TRISC   = 0xF94
#byte   TRISD   = 0xF95
#byte   TRISE   = 0xF96
#byte   TXSTA   = 0xFAC
#byte   UCFG    = 0xF6F
#byte   UCON    = 0xF6D
#byte   UEIE    = 0xF6B
#byte   UEIR    = 0xF6A
#byte   UEP0    = 0xF70
#byte   UEP10   = 0xF7A
#byte   UEP11   = 0xF7B
#byte   UEP12   = 0xF7C
#byte   UEP13   = 0xF7D
#byte   UEP14   = 0xF7E
#byte   UEP15   = 0xF7F
#byte   UEP1    = 0xF71
#byte   UEP2    = 0xF72
#byte   UEP3    = 0xF73
#byte   UEP4    = 0xF74
#byte   UEP5    = 0xF75
#byte   UEP6    = 0xF76
#byte   UEP7    = 0xF77
#byte   UEP8    = 0xF78
#byte   UEP9    = 0xF79
#byte   UIE = 0xF69
#byte   UIR = 0xF68
#byte   USTAT   = 0xF6C
#byte   WDTCON  = 0xFD1
#byte	TMR1H   = 0xFCF
#byte	TMR1L	= 0xFCE

#byte       RCREG       = 0xFAE
#byte       TXREG       = 0xFAD
#bit        RBPU        = INTCON2.7

/* Bits used in the STATUS register */
#bit        CARRY       = STATUS.0
#bit        DC          = STATUS.1
#bit        ZERO        = STATUS.2
#bit        PD          = STATUS.3
#bit        TO          = STATUS.4
#bit        RP0         = STATUS.5
#bit        RP1         = STATUS.6
#bit        IRP         = STATUS.7

/* Bits used in the PORTA register */
#bit        RA0         = PORTA.0
#bit        RA1         = PORTA.1
#bit        RA2         = PORTA.2
#bit        RA3         = PORTA.3
#bit        RA4         = PORTA.4
#bit        RA5         = PORTA.5

/* Bits used in the PORTB register */
#bit        RB0         = PORTB.0
#bit        RB1         = PORTB.1
#bit        RB2         = PORTB.2
#bit        RB3         = PORTB.3
#bit        RB4         = PORTB.4
#bit        RB5         = PORTB.5
#bit        RB6         = PORTB.6
#bit        RB7         = PORTB.7

/* Bits used in the PORTC register */
#bit        RC0         = PORTC.0
#bit        RC1         = PORTC.1
#bit        RC2         = PORTC.2
#bit        RC3         = PORTC.3
#bit        RC4         = PORTC.4
#bit        RC5         = PORTC.5
#bit        RC6         = PORTC.6
#bit        RC7         = PORTC.7

/* Bits used in the PORTD register */
#bit        RD0         = PORTD.0
#bit        RD1         = PORTD.1
#bit        RD2         = PORTD.2
#bit        RD3         = PORTD.3
#bit        RD4         = PORTD.4
#bit        RD5         = PORTD.5
#bit        RD6         = PORTD.6
#bit        RD7         = PORTD.7

/* Bits used in the PORTE register */
#bit        RE0         = PORTE.0
#bit        RE1         = PORTE.1
#bit        RE2         = PORTE.2   
#bit        RE3         = PORTE.3   

/* Bits used in the INTCON register */
#bit        RBIF        = INTCON.0
#bit        INTF        = INTCON.1
#bit        T0IF        = INTCON.2
#bit        TMR0IF      = INTCON.2
#bit        RBIE        = INTCON.3
#bit        INTE        = INTCON.4
#bit        T0IE        = INTCON.5
#bit        TMR0IE      = INTCON.5
#bit        PEIE        = INTCON.6
#bit        GIE         = INTCON.7

/* Bits used in the PIR1 register */
#bit        TMR1IF      = PIR1.0
#bit        TMR2IF      = PIR1.1
#bit        CCP1IF      = PIR1.2
#bit        SSPIF       = PIR1.3
#bit        TXIF        = PIR1.4
#bit        RCIF        = PIR1.5
#bit        ADIF        = PIR1.6
#bit        PSPIF       = PIR1.7

/* Bits used in the PIR2 register */
#bit        CCP2IF      = PIR2.0
#bit        BCLIF       = PIR2.3
#bit        EEIF        = PIR2.4

/* Bits used in the T1CON register */
#bit        TMR1ON      = T1CON.0
#bit        TMR1CS      = T1CON.1
#bit        T1SYNC      = T1CON.2
#bit        T1OSCEN     = T1CON.3
#bit        T1CKPS0     = T1CON.4
#bit        T1CKPS1     = T1CON.5

/* Bits used in the T2CON register */
#bit        T2CKPS0     = T2CON.0
#bit        T2CKPS1     = T2CON.1
#bit        TMR2ON      = T2CON.2
#bit        TOUTPS0     = T2CON.3
#bit        TOUTPS1     = T2CON.4
#bit        TOUTPS2     = T2CON.5
#bit        TOUTPS3     = T2CON.6


/* Bits used in the CCP1CON register */
#bit        CCP1M0      = CCP1CON.0
#bit        CCP1M1      = CCP1CON.1
#bit        CCP1M2      = CCP1CON.2
#bit        CCP1M3      = CCP1CON.3
#bit        CCP1Y       = CCP1CON.4
#bit        CCP1X       = CCP1CON.5


/* Bits used in the RCSTA register */
#bit        RX9D        = RCSTA.0
#bit        OERR        = RCSTA.1
#bit        FERR        = RCSTA.2
#bit        ADDEN       = RCSTA.3
#bit        CREN        = RCSTA.4
#bit        SREN        = RCSTA.5
#bit        RX9         = RCSTA.6
#bit        SPEN        = RCSTA.7

/* Bits used in the CCP2CON register */
#bit        CCP2M0      = CCP2CON.0
#bit        CCP2M1      = CCP2CON.1
#bit        CCP2M2      = CCP2CON.2
#bit        CCP2M3      = CCP2CON.3
#bit        CCP2Y       = CCP2CON.4
#bit        CCP2X       = CCP2CON.5

/* Bits used in the ADCON0 register */
#bit        ADON        = ADCON0.0
#bit        ADGO        = ADCON0.2
#bit        GODONE      = ADCON0.2
#bit        CHS0        = ADCON0.3
#bit        CHS1        = ADCON0.4
#bit        CHS2        = ADCON0.5
#bit        ADCS0       = ADCON0.6
#bit        ADCS1       = ADCON0.7

/* Bits used in the TRISA register */
#bit        TRISA0      = TRISA.0
#bit        TRISA1      = TRISA.1
#bit        TRISA2      = TRISA.2
#bit        TRISA3      = TRISA.3
#bit        TRISA4      = TRISA.4
#bit        TRISA5      = TRISA.5

/* Bits used in the TRISB register */
#bit        TRISB0      = TRISB.0
#bit        TRISB1      = TRISB.1
#bit        TRISB2      = TRISB.2
#bit        TRISB3      = TRISB.3
#bit        TRISB4      = TRISB.4
#bit        TRISB5      = TRISB.5
#bit        TRISB6      = TRISB.6
#bit        TRISB7      = TRISB.7

/* Bits used in the TRISC register */
#bit        TRISC0      = TRISC.0
#bit        TRISC1      = TRISC.1
#bit        TRISC2      = TRISC.2
#bit        TRISC3      = TRISC.3
#bit        TRISC4      = TRISC.4
#bit        TRISC5      = TRISC.5
#bit        TRISC6      = TRISC.6
#bit        TRISC7      = TRISC.7

/* Bits used in the TRISD register */
#bit        TRISD0      = TRISD.0
#bit        TRISD1      = TRISD.1
#bit        TRISD2      = TRISD.2
#bit        TRISD3      = TRISD.3
#bit        TRISD4      = TRISD.4
#bit        TRISD5      = TRISD.5
#bit        TRISD6      = TRISD.6
#bit        TRISD7      = TRISD.7

/* Bits used in the TRISE register */
#bit        TRISE0      = TRISE.0
#bit        TRISE1      = TRISE.1
#bit        TRISE2      = TRISE.2

#bit        PSPMODE     = TRISE.4
#bit        IBOV        = TRISE.5
#bit        OBF         = TRISE.6
#bit        IBF         = TRISE.7

/* Bits used in the PIE1 register */
#bit        TMR1IE      = PIE1.0
#bit        TMR2IE      = PIE1.1
#bit        CCP1IE      = PIE1.2
#bit        SSPIE       = PIE1.3
#bit        TXIE        = PIE1.4
#bit        RCIE        = PIE1.5
#bit        ADIE        = PIE1.6
#bit        PSPIE       = PIE1.7

/* Bits used in the PIE2 register */
#bit        CCP2IE      = PIE2.0
#bit        BCLIE       = PIE2.3
#bit        EEIE        = PIE2.4

/* Bits used in the SSPCON2 register */
#bit        SEN         = SSPCON2.0
#bit        RSEN        = SSPCON2.1
#bit        PEN         = SSPCON2.2
#bit        RCEN        = SSPCON2.3
#bit        ACKEN       = SSPCON2.4
#bit        ACKDT       = SSPCON2.5
#bit        ACKSTAT     = SSPCON2.6
#bit        GCEN        = SSPCON2.7

/* Bits used in the SSPSTAT register    */
#bit        BF          = SSPSTAT.0
#bit        UA          = SSPSTAT.1
#bit        RW          = SSPSTAT.2
#bit        START       = SSPSTAT.3
#bit        STOP        = SSPSTAT.4
#bit        DA          = SSPSTAT.5
#bit        CKE         = SSPSTAT.6
#bit        SMP         = SSPSTAT.7

/* Bits used in the TXSTA register */
#bit        TX9D        = TXSTA.0
#bit        TRMT        = TXSTA.1
#bit        BRGH        = TXSTA.2
#bit        SENDB       = TXSTA.3
#bit        SYNC        = TXSTA.4
#bit        TXEN        = TXSTA.5
#bit        TX9         = TXSTA.6
#bit        CSRC        = TXSTA.7

/* Bits used in the ADCON1 register */
#bit        PCFG0       = ADCON1.0
#bit        PCFG1       = ADCON1.1
#bit        PCFG2       = ADCON1.2
#bit        PCFG3       = ADCON1.3
#bit        ADFM        = ADCON1.7

/* Bits used in the EECON1 register */
#bit        RD          = EECON1.0
#bit        WR          = EECON1.1
#bit        WREN        = EECON1.2
#bit        WRERR       = EECON1.3
#bit        EEPGD       = EECON1.7

#list
