; Recycling reminder


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

; Bank 0 RAM

SECONDS			equ	H'20'	; seconds counter
MINUTES			equ	H'21'	; minutes counter
HOURS			equ	H'22'	; hours counter
DAYS1			equ	H'23'	; days counter for LED1
DAYS2			equ	H'24'	; days counter for LED2
DAYS3			equ	H'25'	; days counter for LED3
DAYS4			equ	H'26'	; days counter for LED4
HOURS_18		equ	H'27'	; 18-hour flash period
ONE_SET			equ	H'28'	; BIN1 flags; weekly, fortnightly, none
TWO_SET			equ	H'29'	; BIN2 flags; weekly, fortnightly, none	
THREE_SET		equ	H'2A'	; BIN3 flags; weekly, fortnightly, none	
FOUR_SET		equ	H'2B'	; BIN4 flags; weekly, fortnightly, none	
CURRENT			equ	H'2C'	; current LEDs flashing
STORE1			equ	H'2D'	; delay counter
STORE2			equ	H'2E'	; delay counter
STALL_15m		equ	H'2F'	; stall timer by 15m or multiples of
LINK_STO		equ	H'30'	; store of PORTA
S_4_FLG			equ	H'31'	; switch 4 pressed flag	
S_3_FLG			equ	H'32'	; switch 3 pressed flag	
PROGRAM_DSP		equ	H'33'	; program display counter
DURATION1		equ	H'34'	; duration S1 is closed	in seconds
DURATION2		equ	H'35'	; duration S2 is closed	in seconds
DURATION3		equ	H'36'	; duration S3 is closed	in seconds
DURATION4		equ	H'37'	; duration S4 is closed	in seconds
DURATION5		equ	H'38'	; duration S5 is closed	in seconds
COUNTER			equ	H'39'	; counter for programming next day (or later) (increasing by 13 days each time) or next week

; All Banks RAM

W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt

	org	0
	goto	SETUP
	org	4	
	goto	INTERRUPT

SETUP

	call	DELAY1

	movlw	B'1111111'
	movwf	PORTB		; 
	movwf	PORTA

	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11101111'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'11110001'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled TMR0/256)
	movwf	OPTION_REG
; analog/ digital inputs
	movlw	B'00000000'	; all digital inputs
	movwf	ANSEL
; oscillator
	bsf		OSCCON,0	; T1 oscillator	
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01001111' ; external clock
	movwf	T1CON 		; Asynchronous operation, external oscillator
	
; initial conditions
	movlw	H'80'		; set for 1s
	movwf	TMR1H 		;
	clrf	TMR1L		; timer 1 is the seconds counter
	clrf	SECONDS		; Initialize timer counters
	clrf	MINUTES		; count minutes
	clrf	HOURS		; count hours
	clrf	DAYS1		; day number for LED1
	clrf	DAYS2		; day number for LED2
	clrf	DAYS3		; day number for LED3
	clrf	DAYS4		; day number for LED4
	clrf	HOURS_18	; LED flashing period
	clrf	DURATION1	; reset switch1 closure period
	clrf	DURATION2	; reset switch2 closure period
	clrf	DURATION3	; reset switch3 closure period
	clrf	DURATION4	; reset switch4 closure period
	clrf	DURATION5	; reset switch5 closure period
	clrf	STALL_15m	; 15m stall counter to delay reminder start time
; initially LEDs are off
	clrf	ONE_SET		; BIN1 flags, weekly, fortnightly, none
	clrf	TWO_SET		; BIN2 flags, weekly, fortnightly, none	
	clrf	THREE_SET	; BIN3 flags, weekly, fortnightly, none	
	clrf	FOUR_SET	; BIN4 flags, weekly, fortnightly, none	
	clrf	S_4_FLG		; switch 4 pressed flag cleared
	clrf	S_3_FLG		; switch 3 pressed flag cleared
	clrf	PROGRAM_DSP	; program display counter

	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE ; Enable Timer1 interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf 	PIR1,TMR1IF ; clear timer interrupt flag
	bsf		INTCON,PEIE	; enable peripheral interrupts
	bsf		INTCON,GIE	; enable interrupts

CYCLE

	SLEEP	; stop program saving power
	nop		; wakes here from sleep every second

; check DURATION1 (period that S1 is pressed)
	movf	DURATION1,w
	btfsc	STATUS,Z	; if zero, bypass
	goto	NEXT_DUR2
	movf	DURATION1,w
	sublw	D'5'		; if >5s then increase day1
	btfsc	STATUS,C
	goto	NEXT_DUR2
INC_DAYS_NEXT1
; increase days1
	movlw	D'13'		; increase by 13 (for an effective program for a day later)
	movwf	COUNTER
INC_DAYS1
	bcf		INTCON,GIE	; disable interrupt
	incf	DAYS1,f		; next day
; check for 14
	movf	DAYS1,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS1		; clear if 14
	btfss	STATUS,C
	clrf	DAYS1		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS1
	bsf		INTCON,GIE	; enable interrupts
; drive LED1
	call	DRIVE_LED1

; delay (1s)
	movlw	D'50'
	call	DELAYX
; check S1
	btfss	PORTB,3
	goto	INC_DAYS_NEXT1

NEXT_DUR2
; check DURATION2 (period that S2 is pressed)
	movf	DURATION2,w
	btfsc	STATUS,Z	; if zero, bypass
	goto	NEXT_DUR3
	movf	DURATION2,w
	sublw	D'5'		; if >5s then increase day2
	btfsc	STATUS,C
	goto	NEXT_DUR3
; increase days2
INC_DAYS_NEXT2
	movlw	D'13'		; increase by 13 (for a day later)
	movwf	COUNTER
INC_DAYS2
	bcf		INTCON,GIE	; disable interruptc
	incf	DAYS2,f		; next day
; check for 14
	movf	DAYS2,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS2		; clear if 14
	btfss	STATUS,C
	clrf	DAYS2		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS2
	bsf		INTCON,GIE	; enable interrupts
; drive LED2
	call	DRIVE_LED2

; delay (1s)
	movlw	D'50'
	call	DELAYX
; check S2
	btfss	PORTB,2
	goto	INC_DAYS_NEXT2

NEXT_DUR3
; check DURATION3 (period that S3 is pressed)
	movf	DURATION3,w
	btfsc	STATUS,Z	; if zero, bypass
	goto	NEXT_DUR4
	movf	DURATION3,w
	sublw	D'5'		; if >5s then increase day3
	btfsc	STATUS,C
	goto	NEXT_DUR4
; increase days3
INC_DAYS_NEXT3
	movlw	D'13'		; increase by 13 (for a day later)
	movwf	COUNTER
INC_DAYS3
	bcf		INTCON,GIE	; disable interrupt
	incf	DAYS3,f		; next day
; check for 14
	movf	DAYS3,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS3		; clear if 14
	btfss	STATUS,C
	clrf	DAYS3		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS3
	bsf		INTCON,GIE	; enable interrupts
; drive LED3
	call	DRIVE_LED3

; delay (1s)
	movlw	D'50'
	call	DELAYX
; check S3
	btfss	PORTB,1
	goto	INC_DAYS_NEXT3

NEXT_DUR4
; check DURATION4 (period that S4 is pressed)
	movf	DURATION4,w
	btfsc	STATUS,Z	; if zero, bypass
	goto	NEXT_DUR5
	movf	DURATION4,w
	sublw	D'5'		; if >5s then increase day3
	btfsc	STATUS,C
	goto	NEXT_DUR5
; increase days4
INC_DAYS_NEXT4
	movlw	D'13'		; increase by 13 (for a day later)
	movwf	COUNTER
INC_DAYS4
	bcf		INTCON,GIE	; disable interrupt
	incf	DAYS4,f		; next day
; check for 14
	movf	DAYS4,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS4		; clear if 14
	btfss	STATUS,C
	clrf	DAYS4		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS4
	bsf		INTCON,GIE	; enable interrupts
; drive LED4
	call	DRIVE_LED4

; delay (1s)
	movlw	D'50'
	call	DELAYX
; check S4
	btfss	PORTB,0
	goto	INC_DAYS_NEXT4

NEXT_DUR5
; check DURATION5 (period that S5 is pressed)
	movf	DURATION5,w
	btfsc	STATUS,Z	; if zero, bypass
	goto	CK_S1_5
	movf	DURATION5,w
	sublw	D'5'		; if >5s then program
	btfsc	STATUS,C
	goto	CLEAR		; otherwise clear all LEDs

; *********************************************************
; program LEDs based on LK1-LK4 settings
; LK1
; output high
	bsf		PORTA,4		; set RA4 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,4		; set RA4 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,4		; set RA4 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA4 is high, LK1 is either in position 1 (pulled high) or open
; if RA4 is low, LK1 is in position 2 (pulled low)
	btfss	PORTA,4
	goto	LK1_2		; LK1 is in position 2
; output low
	bcf		PORTA,4		; set RA4 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,4		; set RA4 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,4		; set RA4 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA4 is low, LK1 is either in position 2 (pulled low) or open
; if RA4 is high, LK1 is in position 1 (pulled high)
	btfsc	PORTA,4
	goto	LK1_1		; LK1 is in position 1
; LK1 in position open
; set bits 1 & 2 (both) for weekly. bit 0 set for enable
	movlw	B'00000111'
	movwf	ONE_SET
	goto	LK2
LK1_2
; LK1 in position 2 (fortnightly next) 
; bit 0 (set = enable, clear = disable)
; bit 1 (set = day 7 (next), clear off)
	movlw	B'00000011'
	movwf	ONE_SET
	goto	LK2
LK1_1
; bit 0 (set = enable, clear = disable)
; bit 2 (set = day 0 (14)(now), clear off)
	movlw	B'00000101'
	movwf	ONE_SET

LK2
; output high
	bsf		PORTA,6		; set RA6 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,6		; set RA6 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,6		; set RA6 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA6 is high, LK2 is either in position 1 (pulled high) or open
; if RA6 is low, LK2 is in position 2 (pulled low)
	btfss	PORTA,6
	goto	LK2_2		; LK2 is in position 2
; output low
	bcf		PORTA,6		; set RA6 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,6		; set RA6 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,6		; set RA6 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA6 is low, LK2 is either in position 2 (pulled low) or open
; if RA6 is high, LK2 is in position 1 (pulled high)
	btfsc	PORTA,6
	goto	LK2_1		; LK2 is in position 1
; LK2 in position open
; set bits 1 & 2 (both) for weekly. bit 0 set for enable
	movlw	B'00000111'
	movwf	TWO_SET
	goto	LK3
LK2_2
; LK2 in position 2 (fortnightly next) 
; bit 0 (set = enable, clear = disable)
; bit 1 (set = day 7 (next), clear off)
	movlw	B'00000011'
	movwf	TWO_SET
	goto	LK3
LK2_1
; bit 0 (set = enable, clear = disable)
; bit 2 (set = day 0 (14)(now), clear off)
	movlw	B'00000101'
	movwf	TWO_SET
LK3
; output high
	bsf		PORTA,7		; set RA7 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7		; set RA7 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7		; set RA7 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA7 is high, LK3 is either in position 1 (pulled high) or open
; if RA7 is low, LK3 is in position 2 (pulled low)
	btfss	PORTA,7
	goto	LK3_2		; LK3 is in position 2
; output low
	bcf		PORTA,7		; set RA7 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7		; set RA7 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7		; set RA7 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA7 is low, LK3 is either in position 2 (pulled low) or open
; if RA7 is high, LK3 is in position 1 (pulled high)
	btfsc	PORTA,7
	goto	LK3_1		; LK3 is in position 1
; LK3 in position open
; set bits 1 & 2 (both) for weekly. bit 0 set for enable
	movlw	B'00000111'
	movwf	THREE_SET
	goto	LK4
LK3_2
; LK3 in position 2 (fortnightly next) 
; bit 0 (set = enable, clear = disable)
; bit 1 (set = day 7 (next), clear off)
	movlw	B'00000011'
	movwf	THREE_SET
	goto	LK4
LK3_1
; bit 0 (set = enable, clear = disable)
; bit 2 (set = day 0 (14)(now), clear off)
	movlw	B'00000101'
	movwf	THREE_SET
LK4
; output high
	bsf		PORTA,0		; set RA0 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,0		; set RA0 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,0		; set RA0 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA0 is high, LK4 is either in position 1 (pulled high) or open
; if RA0 is low, LK4 is in position 2 (pulled low)
	btfss	PORTA,0
	goto	LK4_2		; LK4 is in position 2
; output low
	bcf		PORTA,0		; set RA0 high (when set as an output)
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,0		; set RA0 as an output
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,0		; set RA0 as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; if RA0 is low, LK4 is either in position 2 (pulled low) or open
; if RA0 is high, LK4 is in position 1 (pulled high)
	btfsc	PORTA,0
	goto	LK4_1		; LK4 is in position 1
; LK4 in position open
; set bits 1 & 2 (both) for weekly. bit 0 set for enable
	movlw	B'00000111'
	movwf	FOUR_SET
	goto	SHOW
LK4_2
; LK4 in position 2 (fortnightly next) 
; bit 0 (set = enable, clear = disable)
; bit 1 (set = day 7 (next), clear off)
	movlw	B'00000011'
	movwf	FOUR_SET
	goto	SHOW
LK4_1
; bit 0 (set = enable, clear = disable)
; bit 2 (set = day 0 (14)(now), clear off)
	movlw	B'00000101'
	movwf	FOUR_SET
; *********************************************************
SHOW
; drive LEDs and program. disable LED if S1-S4 pressed
; set HOURS_18 counter for LED flashing
	movlw	D'18'
	movwf	HOURS_18
	movlw	H'80'		; set for 1s
	movwf	TMR1H 		;
	clrf	TMR1L
	clrf	STALL_15m	; clear 15m stall counter to delay reminder start time
	clrf	SECONDS		; initialize timer counters
	clrf	MINUTES
	clrf	HOURS
	clrf	DAYS1
	clrf	DAYS2
	clrf	DAYS3
	clrf	DAYS4
	movlw	D'3'
	movwf	PROGRAM_DSP	; program display counter
SET_LOOP
	movlw	H'FF'
	movwf	CURRENT		; all LEDs can be driven
	call	DRIVE_LEDS	; flash LEDs
; delay (1s)
	movlw	D'50'
	call	DELAYX
; check S1-S4
; disable if switch pressed
; bit 0 (set = enable, clear = disable)
	btfss	PORTB,3		; switch S1
	bcf		ONE_SET,0	; disable LED1
	btfss	PORTB,2 	; switch S2
	bcf		TWO_SET,0	; disable LED2
	btfss	PORTB,1		; switch S3
	bcf		THREE_SET,0	; disable LED3
	btfss	PORTB,0		; switch S4
	bcf		FOUR_SET,0	; disable LED4
; wait for S5 to open
	btfsc	PORTB,5
	goto	END_SET
; alternate DAYS between 0/7
	movf	PROGRAM_DSP,w	; program display counter
	btfsc	STATUS,Z
	goto	WEEK_
	decfsz	PROGRAM_DSP,f	; program display counter
	goto	SET_DAY
WEEK_ 
	movf	DAYS1,w
	btfsc	STATUS,Z
	goto	SET_DAY
	clrf	DAYS1
	clrf	DAYS2
	clrf	DAYS3
	clrf	DAYS4
	movlw	D'3'
	movwf	PROGRAM_DSP	; program display counter
	goto 	SET_LOOP	; show LEDs again
SET_DAY
	movlw	D'7'
	movwf	DAYS1
	movwf	DAYS2
	movwf	DAYS3
	movwf	DAYS4
	goto	SET_LOOP
END_SET
	clrf	DAYS1		; return to day 0/14
	clrf	DAYS2
	clrf	DAYS3
	clrf	DAYS4
	clrf	PROGRAM_DSP	; program display counter
	goto	CK_S1_5

; ********************************************************
	
CLEAR ; clear LEDs flashing. 
	clrf	HOURS_18	; LEDs off

; * test to have progression to next week in 1 minute
;	movlw	D'6'
;	movwf	DAYS1
;	movwf	DAYS2
;	movwf	DAYS3
;	movwf	DAYS4
;	movlw	D'23'
;	movwf	HOURS
;	movlw	D'59'
;	movwf	MINUTES
;	clrf	SECONDS
; * end test	

; ********************************************************

CK_S1_5	
; check switch S1
; if high, clear DURATION1 (duration that S1 switch is closed)
	btfsc	PORTB,3 
	clrf	DURATION1
; check switch S2
; if high, clear DURATION2 (duration that S2 switch is closed)
	btfsc	PORTB,2 
	clrf	DURATION2
; check switch S3
; if high, clear DURATION3 (duration that S3 switch is closed)
	btfsc	PORTB,1 
	clrf	DURATION3
; check switch S4
; if high, clear DURATION4 (duration that S4 switch is closed)
	btfsc	PORTB,0 
	clrf	DURATION4	 
; check switch S5
; if high, clear DURATION5 (duration that S5 switch is closed)
	btfsc	PORTB,5 
	clrf	DURATION5
DUR1
; if RB3 is low, and DURATION1=0, increment DURATION1 to allow the count of seconds in CLOCK routine 
	btfsc	PORTB,3
	goto	DUR2
	movf	DURATION1,w
	btfsc	STATUS,Z
	incf	DURATION1,f	; set at 1 if zero. If not 0, 'DURATION1' increases in CLOCK routine
DUR2
; if RB2 is low, and DURATION2=0, increment DURATION2 to allow the count of seconds in CLOCK routine 
	btfsc	PORTB,2
	goto	DUR3
	movf	DURATION2,w
	btfsc	STATUS,Z
	incf	DURATION2,f	; set at 1 if zero. If not 0, 'DURATION2' increases in CLOCK routine
DUR3
; if RB1 is low, and DURATION3=0, increment DURATION3 to allow the count of seconds in CLOCK routine 
	btfsc	PORTB,1
	goto	DUR4
	movf	DURATION3,w
	btfsc	STATUS,Z
	incf	DURATION3,f	; set at 1 if zero. If not 0, 'DURATION3' increases in CLOCK routine
DUR4
; if RB0 is low, and DURATION4=0, increment DURATION4 to allow the count of seconds in CLOCK routine 
	btfsc	PORTB,0
	goto	DUR5
	movf	DURATION4,w
	btfsc	STATUS,Z
	incf	DURATION4,f	; set at 1 if zero. If not 0, 'DURATION4' increases in CLOCK routine
DUR5	
; if RB5 is low, and DURATION5=0, increment DURATION5 to allow the count of seconds in CLOCK routine 
	btfsc	PORTB,5
	goto	RESET_1_4
	movf	DURATION5,w
	btfsc	STATUS,Z
	incf	DURATION5,f	; set at 1 if zero. If not 0, 'DURATION5' increases in CLOCK routine

RESET_1_4
	movf	HOURS_18,w	; if during reminder period allow reset
	btfsc	STATUS,Z
	goto	LED_SHOW
; If S4 open, clear	S_4_FLG,0 (switch 4 pressed flag)
	btfsc 	PORTB,0	
	clrf	S_4_FLG		; switch 4 pressed flag
; if S3 open, clear S_3_FLG,0
	btfsc	PORTB,1	
	clrf	S_3_FLG		; switch 3 pressed flag
; check S1-S4 for reset
	btfss	PORTB,3		; switch S1
	bcf		CURRENT,1	; disable LED1
	btfss	PORTB,2		; switch S2
	bcf		CURRENT,2	; disable LED2
; check if S3 pressed flag is set (during time forward press)
	btfsc	S_3_FLG,0	; set switch 3 pressed flag
	goto	S_4			; bypass till opened
	btfss	PORTB,1		; switch S3
	bcf		CURRENT,3	; disable LED1
; check if S4 pressed flag is set (during time forward press)
S_4	btfsc	S_4_FLG,0	; set switch 4 pressed flag
	goto	LED_SHOW	; bypass till opened
	btfss	PORTB,0		; switch S4
	bcf		CURRENT,4	; disable LED1

LED_SHOW
	call	DRIVE_LEDS
	goto	LINKS

; *****************************************************
DRIVE_LEDS
	
; flash LEDs if DAYS = 0 or 7 and HOURS_18 is not clear
	movf	HOURS_18,w
	btfsc	STATUS,Z
	return				; no flash if timer not set
DRIVE_LEDS_RUN
; set RA1, RA2, RA3 and RB4 high
	movlw	B'00001110'
	movwf	PORTA
	bsf		PORTB,4
LED1
; prevent flash if 'CURRENT' flag for LED is off (Clear)
	btfss	CURRENT,1	; is LED1 reset
	goto	LED2		; bypass LED1
; disable flash if LED not enabled	
	btfss	ONE_SET,0	; if set then enabled
	goto	LED2		; bypass LED1
; check if LED flash is required
; if DAY is 0 and bit2 is set, flash
	movf	DAYS1,w
	btfss	STATUS,Z	; if zero 
	goto	DAY7_1
	btfsc	ONE_SET,2
	goto	FLASH1
DAY7_1
; if DAY is 7 and bit1 is set, flash
	movf	DAYS1,w
	xorlw	D'7'
	btfss	STATUS,Z	; if zero 
	goto	LED2
	btfss	ONE_SET,1
	goto	LED2
FLASH1
	call	DRIVE_LED1

LED2
; prevent flash if 'CURRENT' flag for LED is off (Clear)
	btfss	CURRENT,2	; is LED2 reset
	goto	LED3		; bypass LED2
; disable flash if LED not enabled	
	btfss	TWO_SET,0	; if set then enabled
	goto	LED3		; bypass LED2
; check if LED flash is required
; if DAY0 and bit2 is set, flash
	movf	DAYS2,w
	btfss	STATUS,Z	; if zero 
	goto	DAY7_2
	btfsc	TWO_SET,2
	goto	FLASH2
DAY7_2
; if DAY7 and bit1 is set, flash
	movf	DAYS2,w
	xorlw	D'7'
	btfss	STATUS,Z	; if zero 
	goto	LED3
	btfss	TWO_SET,1
	goto	LED3
FLASH2
	call	DRIVE_LED2
 
LED3
; prevent flash if 'CURRENT' flag for LED is off (Clear)
	btfss	CURRENT,3	; is LED3 reset
	goto	LED4		; bypass LED3
; disable flash if LED not enabled	
	btfss	THREE_SET,0	; if set then enabled
	goto	LED4		; bypass LED3
; check if LED flash is required
; if DAY0 and bit2 is set, flash
	movf	DAYS3,w
	btfss	STATUS,Z	; if zero 
	goto	DAY7_3
	btfsc	THREE_SET,2
	goto	FLASH3
DAY7_3
; if DAY7 and bit1 is set, flash
	movf	DAYS3,w
	xorlw	D'7'
	btfss	STATUS,Z	; if zero 
	goto	LED4
	btfss	THREE_SET,1
	goto	LED4
FLASH3
	call	DRIVE_LED3

LED4
; prevent flash if 'CURRENT' flag for LED is off (Clear)
	btfss	CURRENT,4	; is LED3 reset
	return				; bypass LED4
; disable flash if LED not enabled	
	btfss	FOUR_SET,0	; if set then enabled
	return				; bypass LED4
; check if LED flash is required
; if DAY0 and bit2 is set, flash
	movf	DAYS4,w
	btfss	STATUS,Z	; if zero 
	goto	DAY7_4
	btfsc	FOUR_SET,2
	goto	FLASH4
DAY7_4
; if DAY7 and bit1 is set, flash
	movf	DAYS4,w
	xorlw	D'7'
	btfss	STATUS,Z	; if zero 
	return
	btfss	FOUR_SET,1
	return
FLASH4
	call	DRIVE_LED4
	return
; *****************************************************

LINKS
; keep open circuit links low or high to prevent supply current increasing.
; (read input and maintain level driving low or high)
; REFRESH LK1 to LK4 (RA4, RA6, RA7, RA0)
; set RA4, RA6, RA7 and RA0 as inputs 
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11110001'	; (RA4, RA6, RA7 and RA0 set as inputs)
	movwf	TRISA		; set as an input
	bcf		STATUS,RP0	; select memory bank 0
	nop
; read input levels
	movf	PORTA,w		; read inputs
	movwf	LINK_STO	; store
; set RA4, RA6, RA7 and RA0 set as outputs	
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00100000'	; (RA4, RA6, RA7 and RA0 set as outputs)
	movwf	TRISA		; set as an output, maintain the low or high
	bcf		STATUS,RP0	; select memory bank 0
	movf	LINK_STO,w	; previously read level
	movwf	PORTA		; drive low or high

; ****************************************************

TIME_ADJ
; Crystal with tolerance @20ppm = 1.728s/day or 12.096s/week or 10.4832 minutes/year.
; time adjust. add 15m or stall by 15m per switch press. S4 & S3 for on earlier (add 15m). S1 & S2 for on later (stall by 15m).

	movf	HOURS_18,w
	btfss	STATUS,Z	; if zero then time can be moved
	goto 	CYCLE
	bcf		INTCON,GIE	; stop interrupts
; Switch S4 & S3
	btfsc	PORTB,0
	goto	CK_CLK_S1
	btfsc	PORTB,1
	goto	CK_CLK_S1
; add 15m per press
	clrf	STALL_15m	; stop the stall if set
	movlw	D'16'
	movwf	STORE1
ADD_15
	decfsz	STORE1,f
	goto	INC_15X
	goto	CYCLE2		; finished adding 15m
INC_15X	
	incf	MINUTES,f 	; next minutes
; check for 60 minutes
	movf	MINUTES,w
	sublw	D'60'
	btfss	STATUS,Z 	; 60 minutes
	goto	ADD_15		; continue to add 15 minutes
	clrf	MINUTES		; clear minutes
	incf	HOURS,f		; next hours

; check for 24 hours
	movf	HOURS,w
	sublw	D'24'
	btfss	STATUS,Z 	; 24 hours 
	goto	ADD_15		; continue to add 15 minutes
	clrf	HOURS		; clear hours

; next days
; days1
NEXT_DAYS1
	incf	DAYS1,f		; next day
	movf	DAYS1,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18X1	; set HOURS_18 counter for LED flashing
; check for 14
	movf	DAYS1,w
	sublw	D'14'
	btfss	STATUS,Z 	; 7 days 
	goto	NEXT_DAYS2
	clrf	DAYS1

; set HOURS_18 counter for LED flashing
SET_18X1
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,1	; allow LED1 to be able to be driven

; days2
NEXT_DAYS2
	incf	DAYS2,f		; next day
	movf	DAYS2,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18X2	; set HOURS_18 counter for LED flashing
; check for 14
	movf	DAYS2,w
	sublw	D'14'
	btfss	STATUS,Z 	; 7 days 
	goto	NEXT_DAYS3
	clrf	DAYS2

; set HOURS_18 counter for LED flashing
SET_18X2
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,2	; allow LED2 to be able to be driven

; days3
NEXT_DAYS3
	incf	DAYS3,f		; next day
	movf	DAYS3,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18X3	; set HOURS_18 counter for LED flashing
; check for 14
	movf	DAYS3,w
	sublw	D'14'
	btfss	STATUS,Z 	; 7 days 
	goto	NEXT_DAYS4
	clrf	DAYS3

; set HOURS_18 counter for LED flashing
SET_18X3
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,3	; allow LED3 to be able to be driven

; days4
NEXT_DAYS4
	incf	DAYS4,f		; next day
	movf	DAYS4,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18X4	; set HOURS_18 counter for LED flashing
; check for 14
	movf	DAYS4,w
	sublw	D'14'
	btfss	STATUS,Z 	; 7 days 
	goto	ADD_15
	clrf	DAYS4

; set HOURS_18 counter for LED flashing
SET_18X4
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,4	; allow LED4 to be able to be driven
	goto	ADD_15		; add 15 minutes

CK_CLK_S1
; Switch S1 and S2
	btfsc	PORTB,3
	goto	CK_2_3
	btfsc	PORTB,2
	goto	CYCLE1
; stall timer for 15m per switch press
	movlw	D'15'
	addwf	STALL_15m,f
	movlw	D'255'
	btfsc	STATUS,C	; if over 255 then set at 255 max
	movwf	STALL_15m
; flash LED1
	bsf		INTCON,GIE	; allow interrupts
	call	DRIVE_LED1

CYCLE1
	bsf		INTCON,GIE	; allow interrupts
	goto	CYCLE
CYCLE2
; flash LED4
	bsf		INTCON,GIE	; allow interrupts
	call	DRIVE_LED4
	bsf		S_4_FLG,0	; set switch 4 pressed flag
	bsf		S_3_FLG,0	; set switch 3 pressed flag
	goto	CYCLE1


WEEK
; shift by 1 week if S2 & S3 closed
CK_2_3

	btfsc	PORTB,2
	goto	CYCLE1
	btfsc	PORTB,1
	goto	CYCLE1

; add 7 days
; increase days1
	movlw	D'7'		; increase by 7 days
	movwf	COUNTER
INC_DAYS1X
	incf	DAYS1,f		; next day
; check for 14
	movf	DAYS1,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS1		; clear if 14
	btfss	STATUS,C
	clrf	DAYS1		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS1X

; days2
; increase days2
	movlw	D'7'		; increase by 7 days
	movwf	COUNTER
INC_DAYS2X
	incf	DAYS2,f		; next day
; check for 14
	movf	DAYS2,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS2		; clear if 14
	btfss	STATUS,C
	clrf	DAYS2		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS2X

; days3
; increase days3
	movlw	D'7'		; increase by 7 days
	movwf	COUNTER
INC_DAYS3X
	incf	DAYS3,f		; next day
; check for 14
	movf	DAYS3,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS3		; clear if 14
	btfss	STATUS,C
	clrf	DAYS3		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS3X

; days4
; increase days4
	movlw	D'7'		; increase by 7 days
	movwf	COUNTER
INC_DAYS4X
	incf	DAYS4,f		; next day
; check for 14
	movf	DAYS4,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 14 days 
	clrf	DAYS4		; clear if 14
	btfss	STATUS,C
	clrf	DAYS4		; clear if >14
	decfsz	COUNTER,f	; decrease till 0
	goto	INC_DAYS4X

	bsf		INTCON,GIE	; allow interrupts

; LED2
	call	DRIVE_LED2

; LED3
	call	DRIVE_LED3

; wait until switches are open
	
LOOP_WAIT
	btfsc	PORTB,2
	goto	CYCLE
	btfsc	PORTB,1
	goto	CYCLE
	movlw	D'5'
	movwf	STORE1
	call	DELAY3
	goto	LOOP_WAIT
	
; ****************************************************

DELAY1
	movlw	D'10'
DELAY2
DELAYX
	movwf	STORE1
LOOP2
	movlw	D'100'
	movwf	STORE2
LOOP1
	decfsz	STORE2,f
	goto	LOOP1
	decfsz	STORE1,f
	goto	LOOP2
	return
DELAY3
	movwf	STORE1
LOOP4
	movlw	D'10'
	movwf	STORE2
LOOP3
	decfsz	STORE2,f
	goto	LOOP3
	decfsz	STORE1,f
	goto	LOOP4
	return


DRIVE_LED1
; set RB3 low to charge 100uF capacitor
	bcf		PORTB,3
    bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,3		; set RB3 as an output
	bcf		STATUS,RP0	; select memory bank 0
; delay to charge 
   	movlw	D'10'
	movwf	STORE1
	call 	DELAY3
; RB3 an input again
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,3		; set RB3 as an input
	bcf		STATUS,RP0	; select memory bank 0 
; flash LED1
	bcf		PORTB,4		; flash
 ; delay to flash 
  	movlw	D'10'
	movwf	STORE1
	call 	DELAY3 
	bsf		PORTB,4		; high to prevent reverse polarity on capacitor
	return

DRIVE_LED2
; set RB2 low to charge 100uF capacitor
	bcf		PORTB,2
    bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,2		; set RB2 as an output
	bcf		STATUS,RP0	; select memory bank 0
; delay to charge 
  	movlw	D'10'
	movwf	STORE1
	call 	DELAY3
; RB2 an input again
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,2		; set RB2 as an input
	bcf		STATUS,RP0	; select memory bank 0
; flash LED2
	bcf		PORTA,3		; flash
 ; delay to flash 
  	movlw	D'10'
	movwf	STORE1
	call 	DELAY3 
	bsf		PORTA,3		; high to prevent reverse polarity on capacitor
	return

DRIVE_LED3
; set RB1 low to charge 100uF capacitor
	bcf		PORTB,1
    bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,1		; set RB1 as an output
	bcf		STATUS,RP0	; select memory bank 0
; delay to charge 
  	movlw	D'10'
	movwf	STORE1
	call 	DELAY3
; RB1 an input again
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,1		; set RB1 as an output
	bcf		STATUS,RP0	; select memory bank 0
; flash LED3
	bcf		PORTA,2		; flash
 ; delay to flash 
  	movlw	D'10'
	movwf	STORE1
	call 	DELAY3 
	bsf		PORTA,2		; high to prevent reverse polarity on capacitor
	return

DRIVE_LED4
; set RB0 low to charge 100uF capacitor
	bcf		PORTB,0
    bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISB,0		; set RB0 as an output
	bcf		STATUS,RP0	; select memory bank 0
; delay to charge 
  	movlw	D'10'
	movwf	STORE1
	call 	DELAY3
; RB0 an input again
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISB,0		; set RB0 as an input
	bcf		STATUS,RP0	; select memory bank 0 
; flash LED4
	bcf		PORTA,1		; flash
; delay to flash 
  	movlw	D'10'
	movwf	STORE1
	call 	DELAY3 
	bsf		PORTA,1		; high to prevent reverse polarity on capacitor
	return

; *************************************************
INTERRUPT
; start interrupt by saving w and status registers 
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; select memory bank 0
; update clock and week days 

; *******************************************
; start test **
; rapid test by presetting timer so 1m = 1day
;	movlw	D'23'
;	movwf	HOURS
;	movlw	D'59'
;	movwf	MINUTES	
; end test **
; *******************************************

	btfss	PIR1,TMR1IF
	goto	END_INTERRUPT

	bsf		TMR1H,7 	; set for 1 second
	incf	SECONDS,f	; seconds

; duration
; increment 'duration1' if not 0
	movf	DURATION1,w
	btfss	STATUS,Z	; check for 0
	incf	DURATION1,f
; increment 'duration2' if not 0
	movf	DURATION2,w
	btfss	STATUS,Z	; check for 0
	incf	DURATION2,f
; increment 'duration3' if not 0
	movf	DURATION3,w
	btfss	STATUS,Z	; check for 0
	incf	DURATION3,f
; increment 'duration4' if not 0
	movf	DURATION4,w
	btfss	STATUS,Z	; check for 0
	incf	DURATION4,f
; increment 'duration5' if not 0
	movf	DURATION5,w
	btfss	STATUS,Z	; check for 0
	incf	DURATION5,f

; check for 60s
	movf	SECONDS,w
	sublw	D'60'
	btfss	STATUS,Z 	; 60 seconds
	goto	END_INTERRUPT	; not 60s
	clrf	SECONDS		; clear seconds


; check if 15m stall is required(or multiples of)for time adjust
	movf	STALL_15m,w
	btfsc	STATUS,Z	; if zero then increase minutes
	goto	INC_MIN
	decfsz	STALL_15m,f
	goto	END_INTERRUPT

INC_MIN
	incf	MINUTES,f 	; next minutes

; check for 60 minutes
	movf	MINUTES,w
	sublw	D'60'
	btfss	STATUS,Z 	; 60 minutes
	goto	END_INTERRUPT	; not 60mins
	clrf	MINUTES		; clear minutes

	incf	HOURS,f		; next hours
; decrease HOURS_18 counter
	movf	HOURS_18,w
	btfss	STATUS,Z	; do not decrement if already zero
	decf	HOURS_18,f

; check for 24 hours
	movf	HOURS,w
	sublw	D'24'
	btfss	STATUS,Z 	; 24 hours 
	goto	END_INTERRUPT	; not 24 hours
	clrf	HOURS		; clear hours

; days1
DAYS_1
	incf	DAYS1,f		; next day
	movf	DAYS1,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18_1	; set HOURS_18 counter for LED flashing
; 14th day
	movf	DAYS1,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 7 days 
	goto	CLR_DY1
	btfsc	STATUS,C	; if negative (ie >14) then clear
	goto	DAYS_2
CLR_DY1
	clrf	DAYS1
; set HOURS_18 counter for LED flashing
SET_18_1
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,1		; allow LED1 to be able to be driven	

; days2
DAYS_2
	incf	DAYS2,f		; next day
	movf	DAYS2,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18_2	; set HOURS_18 counter for LED flashing
; 14th day
	movf	DAYS2,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 7 days 
	goto	CLR_DY2
	btfsc	STATUS,C	; if negative (ie >14) then clear
	goto	DAYS_3
CLR_DY2
	clrf	DAYS2
; set HOURS_18 counter for LED flashing
SET_18_2
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,2		; allow LED2 to be able to be driven

; days3
DAYS_3
	incf	DAYS3,f		; next day
	movf	DAYS3,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18_3	; set HOURS_18 counter for LED flashing
; 14th day
	movf	DAYS3,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 7 days 
	goto	CLR_DY3
	btfsc	STATUS,C	; if negative (ie >14) then clear
	goto	DAYS_4
CLR_DY3
	clrf	DAYS3
; set HOURS_18 counter for LED flashing
SET_18_3
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,3		; allow LED3 to be able to be driven

; days4
DAYS_4
	incf	DAYS4,f		; next day
	movf	DAYS4,w
	sublw	D'7'
	btfsc	STATUS,Z 	; 7 days 
	goto	SET_18_4	; set HOURS_18 counter for LED flashing
; 14th day
	movf	DAYS4,w
	sublw	D'14'
	btfsc	STATUS,Z 	; 7 days 
	goto	CLR_DY4
	btfsc	STATUS,C	; if negative (ie >14) then clear
	goto	END_INTERRUPT
CLR_DY4
	clrf	DAYS4
; set HOURS_18 counter for LED flashing
SET_18_4
	movlw	D'18'
	movwf	HOURS_18
	bsf 	CURRENT,4		; allow LED4 to be able to be driven

END_INTERRUPT
	bcf 	PIR1,TMR1IF ; clear timer interrupt flag
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

	end
