	LIST	p=16F628		;tell assembler what chip we are using
	include "P16F628.inc"		;include the defaults for the chip
	__config 0x3D18			;sets the configuration settings 
					;Default is to use the internal oscillator

	;Variable declerations
	cblock 0x20		;Start of main RAM
		DPH		;16-bit Delta phase LSB
		DPH_		;MSB
		PH		;16-bit Phase LSB
		PH_		;MSB
		WTEMP		;Temp variables to hold W and STATUS
		STATTMP		;When the comparator interrupt is called.
	endc

	org	0x0000
	GOTO start		;Jump over interrupt handler


				;START OF INTERRUPT HANDLER
	ORG	0x0004		

	MOVWF	WTEMP		;Save W
	MOVF	STATUS,W	;Save Status
	MOVWF	STATTMP
	BCF	STATUS,Z	;Clear Zero

	;The following 9 lines perform quadrature decoding
	;One quadrature line is connected to a comparator, with output at
	;CMCON, 7. The other line is connected to RA3
	BTFSS	CMCON, 7
	GOTO 	lo		
				
hi	BTFSC	PORTA,3		;If the comparator output is high, this is executed
	GOTO	incdph
	GOTO	decdph
	
lo	BTFSS	PORTA, 3	;On a transition of the comparator input
	GOTO	incdph		;the 2nd quadrature input (on PORTA, 3) defines direction
				;If it's low, DPH is incremented. If high it's decremented.

decdph	DECF	DPH,F		;Decrement low byte
	INCFSZ	DPH,W		;Check for underflow
	INCF	DPH_,F		;If there was underflow this doesn't happen
	DECF	DPH_,F		;Decrement DPH_, if there wasn't underflow this
	GOTO	conti		;cancels with the INCF above.		

incdph	INCF	DPH,F		;Increment dph
	BTFSC	STATUS,Z	;If overflow
	INCF	DPH_,F		;Increment upper byte

conti	MOVF	CMCON,W		;Read CMCON to clear the interrupt
	BCF	PIR1, CMIF	;Clear interrupt
	MOVF	STATTMP,W	;Restore status
	MOVWF	STATUS
	MOVFW	WTEMP		;Restore W
	BCF	INTCON, 1	;Clear interrupt
	RETFIE			;Return from interrupt

				;END OF INTERRUPT HANDLER
	
start	CLRF	PORTB		;Some initialisation
	CLRF	PORTA		;Clear output port registers

	BSF	STATUS, RP0	;select bank 1 for access to TRIS registers
	MOVLW 	0xFB		;0=pin is an output
	MOVWF	TRISA		;Port A all inputs, except RA2, for Vref
	MOVLW	0x00		;Port B all outputs, to output waveform
	MOVWF	TRISB

				;Setup Voltage reference
	MOVLW	0xCC		;Vref = 1.25+12/32*5 = 3.125V
	MOVWF	VRCON

	BCF	STATUS, RP0	;Go back to bank 0

				;Setup comparators

	MOVLW	0x03		;Set CM bits to 011, common vref
	MOVWF	CMCON

				;Enable interrupts
	CLRF	PIR1
	CLRF	INTCON
	BSF	STATUS, RP0	;Bank 1
	CLRF	PIE1
	BSF	PIE1, CMIE	;Enable comparator ints
	BCF	STATUS,	RP0	;Bank 0
	BSF	INTCON, PEIE	;Enable Peripheral ints
	BSF	INTCON, GIE	;Enable Global ints

				;Setup phase shift
	CLRF	PH		;Clear phase accumulator LSB
	CLRF	PH_		;Clear MSB
	MOVLW	0x01		;Set the initial delta-phase value as 1
	MOVWF	DPH
	MOVLW	0x00		;Clear MSB
	MOVWF	DPH_
	
loop				;Main programme loop. This increments the phase accumulator,
				;and converts the MSB of the 16-bit phase accumulator to
				;a sin() value which is then outputted on PORTB

	;16-bit add for PH = PH + DPH

	MOVF	DPH,W	;Move phase value to working
	ADDWF	PH,F	;Increment Phase
	MOVF	DPH_,W
	BTFSC	STATUS,C
	INCF	DPH_,W	;If PH carries, increment PH_
	ADDWF	PH_,F

	MOVF	PH_,W	;Use MSBs of Phase to calculate sin()

	ANDLW	0x7F	;Zero the MSB, this is requried for the table to work
	CALL	table	;Retrieve phase value from sin() Table

	BTFSS	PH_,7	;W now has a value for sin().
	GOTO	add	;if(PH<128) sin = sin + 127, else sin = 127-sin
	SUBLW	0x7F	;W = 127 - sin()
	GOTO	output

add	ADDLW	0x7F	;Add 127 to sin() value
	NOP		;DO NOT REMOVE THIS NOP. It is required such that the
			;same number of instructions are completed for the first
			;half of the sin() wave as in the second half. Removing it
			;increases the first harmonic to ~-30dB from ~-55dB.

output	MOVWF	PORTB	;Output sin() value on PortB
	GOTO loop

	;This table hold sin() values for zero->pi. This is to limit
	;the table length to 127 instructions. This is required as a
	;programme counter jump cannot exceed 255, as only the LSB is
	;available in one register. The MSB is in a different register.

table	ADDWF	PCL, f	;jump to the relevant table location
	RETLW 0x0
	RETLW 0x3
	RETLW 0x6
	RETLW 0x9
	RETLW 0xC
	RETLW 0xF
	RETLW 0x12
	RETLW 0x15
	RETLW 0x18
	RETLW 0x1B
	RETLW 0x1E
	RETLW 0x21
	RETLW 0x24
	RETLW 0x27
	RETLW 0x2A
	RETLW 0x2D
	RETLW 0x30
	RETLW 0x33
	RETLW 0x36
	RETLW 0x39
	RETLW 0x3B
	RETLW 0x3E
	RETLW 0x41
	RETLW 0x43
	RETLW 0x46
	RETLW 0x49
	RETLW 0x4B
	RETLW 0x4E
	RETLW 0x50
	RETLW 0x52
	RETLW 0x55
	RETLW 0x57
	RETLW 0x59
	RETLW 0x5B
	RETLW 0x5E
	RETLW 0x60
	RETLW 0x62
	RETLW 0x64
	RETLW 0x66
	RETLW 0x67
	RETLW 0x69
	RETLW 0x6B
	RETLW 0x6C
	RETLW 0x6E
	RETLW 0x70
	RETLW 0x71
	RETLW 0x72
	RETLW 0x74
	RETLW 0x75
	RETLW 0x76
	RETLW 0x77
	RETLW 0x78
	RETLW 0x79
	RETLW 0x7A
	RETLW 0x7B
	RETLW 0x7B
	RETLW 0x7C
	RETLW 0x7D
	RETLW 0x7D
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7F
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7E
	RETLW 0x7D
	RETLW 0x7D
	RETLW 0x7C
	RETLW 0x7B
	RETLW 0x7B
	RETLW 0x7A
	RETLW 0x79
	RETLW 0x78
	RETLW 0x77
	RETLW 0x76
	RETLW 0x75
	RETLW 0x74
	RETLW 0x72
	RETLW 0x71
	RETLW 0x70
	RETLW 0x6E
	RETLW 0x6C
	RETLW 0x6B
	RETLW 0x69
	RETLW 0x67
	RETLW 0x66
	RETLW 0x64
	RETLW 0x62
	RETLW 0x60
	RETLW 0x5E
	RETLW 0x5B
	RETLW 0x59
	RETLW 0x57
	RETLW 0x55
	RETLW 0x52
	RETLW 0x50
	RETLW 0x4E
	RETLW 0x4B
	RETLW 0x49
	RETLW 0x46
	RETLW 0x43
	RETLW 0x41
	RETLW 0x3E
	RETLW 0x3B
	RETLW 0x39
	RETLW 0x36
	RETLW 0x33
	RETLW 0x30
	RETLW 0x2D
	RETLW 0x2A
	RETLW 0x27
	RETLW 0x24
	RETLW 0x21
	RETLW 0x1E
	RETLW 0x1B
	RETLW 0x18
	RETLW 0x15
	RETLW 0x12
	RETLW 0xF
	RETLW 0xC
	RETLW 0x9
	RETLW 0x6
	RETLW 0x3
	END