#if defined (__AVR_ATmega8__)   // This enables you to recompile for an ATMega8 processor instead of an ATMega88 (if you'd like)
	#define TIMSK0	TIMSK
	#define TIMSK1	TIMSK
	#define TIMSK2	TIMSK
	#define TCCR0B	TCCR0
	#define TCCR2B	TCCR2
	#define	EICRA	MCUCR
	#define EIMSK	GICR
#endif

#define PORT_(port) PORT ## port
#define DDR_(port)  DDR  ## port
#define PIN_(port)  PIN  ## port

#define PORT(port) PORT_(port)
#define DDR(port)  DDR_(port)
#define PIN(port)  PIN_(port)

#define cbi(reg, bit) (reg&=~(1<<bit))
#define sbi(reg, bit) (reg|= (1<<bit))