///////////// Multiplex & PWM settings
#define	DUTY_CYCLE	1 // =10x the % of allotted time each digit spends lit up, so 7 would be 70% on 30% off

#define DISPLAY_HZ	70  // Multiplex frequency. At lower than about 70Hz you will start to notice the flicker
#define DIGIT_ADDRESS_TIME 		3906/DISPLAY_HZ
/*
 This is the amount of time (in timer 'ticks') spent on each segment during the multiplex.
 For a (fixed) 8MHz crystal, there are 8000000 cycles per second.
 We are using a timer with a 256 prescaler, so we get 31250 'ticks' per second
 But there are 8 segments (7+dp), so each segment is allotted 31250/8 'ticks' or 3906

 Finally we account for the display frequency. For example, at 70Hz we have to visit each segment
 70 times per second. The allotted number of 'ticks' then has to be divided by 70.

 This gives us 3906 / 70 = 55.8 'ticks' to be spent on each segment before moving onto the next segment.

 DUTY_CYCLE then allows us to to set the % of this allotted time that the segment is lit for.

*/

///////////// Nice names for different logic states
#define TOP			1
#define BOTTOM 		2

#define	ON			1
#define OFF			0

#define TRUE		1
#define FALSE		0

#define SHOW_DP			1
#define DONT_SHOW_DP	2

///////////// HARDWARE CONFIGURATION: LED segments for the 7segment displays
#define SEG_A_PORT	D
	#define SEG_A_PIN	0
#define SEG_B_PORT	D
	#define SEG_B_PIN	1
#define SEG_C_PORT	D
	#define SEG_C_PIN	4
#define SEG_D_PORT	D
	#define SEG_D_PIN	5
#define SEG_E_PORT	D
	#define SEG_E_PIN	6
#define SEG_F_PORT	D
	#define SEG_F_PIN	7
#define SEG_G_PORT	B
	#define SEG_G_PIN	0
#define SEG_DP_PORT	B
	#define SEG_DP_PIN	1

///////////// HARDWARE CONFIGURATION: Digit enable lines for the 7segment displays
#define D1D1_ENABLE_PORT	C	// D1D1 = display1 digit1
	#define D1D1_ENABLE_PIN		0
#define D1D2_ENABLE_PORT	C
	#define D1D2_ENABLE_PIN		1
#define D1D3_ENABLE_PORT	C
	#define D1D3_ENABLE_PIN		2
#define D1D4_ENABLE_PORT	C
	#define D1D4_ENABLE_PIN		3

#define D2D1_ENABLE_PORT	C
	#define D2D1_ENABLE_PIN		4
#define D2D2_ENABLE_PORT	C
	#define D2D2_ENABLE_PIN		5
#define D2D3_ENABLE_PORT	B
	#define D2D3_ENABLE_PIN		2
#define D2D4_ENABLE_PORT	B
	#define D2D4_ENABLE_PIN		3


///////////// Function prototypes
void DisplayUnsignedInt(unsigned char WhichDisplay, unsigned int Number, unsigned char show_DP);
void DisplayChar(unsigned char Character, unsigned char decimalpoint);
void EnableDigit(unsigned char Display, unsigned char Digit);
void Initialise_7SEG();
void Process_7Seg_Multiplex();
