	; --------------------------------------------------------------------
	; flags bit definitions
	; -----------------------------------------------------------------------
	#define	FLAG_RUN	flags,0
	#define	FLAG_FWD	flags,1
	#define	FLAG_REV	flags,2
	#define	FLAG_GP		flags,3
	#define	FLAG_STOP	flags,4
	#define	FLAG_EASTSW flags,5
	#define	FLAG_WESTSW flags,6
	; -----------------------------------------------------------------------
	; OPTION_REG definitions
	; -----------------------------------------------------------------------
	#define	_RBPU_DIS 	b'10000000'		; disable PORTB pullups
	#define _PRESC_WDT  b'00001000'		; prescale to WDT
	#define _PRESC_4	b'00000001'		; prescale TMR0 1:4
	; -----------------------------------------------------------------------
	; T1CON definitions
	; -----------------------------------------------------------------------
	#define	T1_PRESC_1	b'00000000'		; TMR1 prescale = 1:1
	#define	T1_PRESC_2	b'00010000'		; TMR1 prescale = 1:2
	#define	T1_PRESC_4	b'00100000'		; TMR1 prescale = 1:4
	#define	T1_PRESC_8	b'00110000'		; TMR1 prescale = 1:8
	#define	T1_TIMEOUT	d'100'			; # of ms before activating motor 
	#define T1_PRESET	(0x10000 - (T1_TIMEOUT * d'125' * d'125' / d'128')) ; convert timeout (ms) to TMR1 preset value 
	; -----------------------------------------------------------------------
	; ADCON0 definitions
	; -----------------------------------------------------------------------
	#define	_FOSC_8	b'01000000'			; A/D clock = FOSC/8
	#define _ADC_ON	b'00000001'			; A/D = ON
	#define	_CS0	b'00000000'			; A/D channel select 0
	#define	_CS1	b'00001000'			; A/D channel select 1
	; -----------------------------------------------------------------------
	; ADCON1 definitions
	; -----------------------------------------------------------------------
	#define	LEFT_JUST  b'00000000'		; left justify
	#define	RIGHT_JUST b'10000000'		; right justify
	; -----------------------------------------------------------------------
	; voltage threshold definitions
	; -----------------------------------------------------------------------
	#define	CF			d'51' * d'32' / d'125'	; 16-bit adc conversion factor
	#define	THRESH_DARKHI 	high (d'60' * CF)	; 60 mV dark threshold
	#define	THRESH_DARKLO 	low (d'60' * CF)
	#define	THRESH_CLOUDHI 	high (d'700' * CF)	; 700 mV cloud threshold
	#define	THRESH_CLOUDLO 	low (d'700' * CF)	
	constant THRESH_DARK  = THRESH_DARKHI
	constant THRESH_CLOUD = THRESH_CLOUDHI
	; -----------------------------------------------------------------------
	; timer definitions
	; -----------------------------------------------------------------------
	#define TIMEOUT	d'8000' * d'125' / d'128'	; approx. 8 s timeout
	; -----------------------------------------------------------------------
	; PORTB	definitons
	; -----------------------------------------------------------------------
	#define pgm_link		PORTA,4
	#define	eastsw			PORTB,0
	#define	westsw			PORTB,1
	#define	output			PORTB,6
	#define	reverse			PORTB,7
	; -----------------------------------------------------------------------
	; miscellaneous constants/definitions
	; -----------------------------------------------------------------------
	constant west	=		westhi
	constant east	=		easthi
