
//ATTiny13A, needs to be running on internal 9.6MHz oscillator, make sure fuses are set to match
//By Greg Radion
//Switches MUX when ADC voltage is between 20% and 80% of full scale for 0.5 seconds
//For switching toslink audio sources automatically

// Includes:
#include <avr/io.h>
#include <avr/interrupt.h> 
#include <avr/pgmspace.h>
#include <inttypes.h>

// Function Prototypes
int main(void);

// External Connections
#define CTRL_PORT PORTB
#define CTRL_PIN 2

// Defines:
#define muxB() (CTRL_PORT |= (1<<CTRL_PIN))
#define muxA() (CTRL_PORT &= ~(1<<CTRL_PIN))
#define DDR(x) (*(&x - 1)) 

volatile uint8_t update, ticks;

int main(void) {
    
	// Set up ports as inputs and outputs
	// 1: output, 0: input
	DDR(CTRL_PORT) = 1<<CTRL_PIN;

	// set up timer inturrupt for timing facilities
	TCCR0A = (1<<WGM01) | (0<<WGM00); // OC0A Disconnected, OC0B disconnected, Clear Timer on Compare Match Mode
	TCCR0B = (1<<CS02) | (0<<CS01) | (1<<CS00); // clk/1024
	OCR0A = 187; // 187 ticks at (9.6MHz/1024) = 19.95ms
	TIMSK0 = 1<<OCIE0A; // interrupt on match
    
	ADMUX = (1<<ADLAR);//VCC reference, Left Adjust ADC, select chan 0
	ADCSRA = (1<<ADEN) | (1<<ADSC) | (1<<ADATE) | (1<<ADPS2) | (1<<ADPS1) | (1<<ADPS0);//0xC7;//11000111 enable ADC, start adc,  128 prescale
	ADCSRB = 0X00;//FREE running
	DIDR0 = (1<<ADC0D);

    sei();
    
    update = 0;
    muxB();
    // Main program loop
	while(1) { 
        if (update) {
			
			if ((ADCH >= 51) && (ADCH <= 204)) //only using high word which is 8 bits, 51 = 20%, 204 = 80%
			{
				muxA(); //select channel A
			}
			else
			{
				muxB(); //select channel B
			}

            update = 0;
        }
	}
    
    return 0;
}





// Timer ISR
ISR(TIM0_COMPA_vect) {
	
	ticks++;
	if (ticks > 25) //25 x 19.95ms = approx 0.5s
	{
		update = 1;
		ticks = 0;
		
	}
}
