//monitors DCC signal from opto and enables output if OK
//can also monitor current and shut off if trip occurs

#include "TimerOne.h"
#define SIGPIN 10
#define ENPIN 3
#define ISENSEPIN A0
#define DCCINTERVAL 22
#define TRIPTIMEOUT 1000000
#define TRIPLIMIT 120
#define DCCLOSSLIMIT 700

volatile long trip=TRIPTIMEOUT;

void setup() {
  pinMode(SIGPIN,INPUT);      //to use as detector
  pinMode(ENPIN,OUTPUT);  
  digitalWrite(ENPIN,LOW);    //start disabled
  pinMode(LED_BUILTIN, OUTPUT);
  Serial.begin(115200);
  Timer1.initialize(DCCINTERVAL);     //22us gives us distinct counts for long and short pulses
  Timer1.attachInterrupt(testDCC);
}

void loop() {
  int p;
  p=analogRead(ISENSEPIN);
  if(p>TRIPLIMIT){
    trip=TRIPTIMEOUT;
  }
  if(trip>0){
    digitalWrite(ENPIN,LOW);      //fault
    digitalWrite(LED_BUILTIN, LOW);
    Serial.println("FAULT");
  }else{
    digitalWrite(ENPIN,HIGH);    
    digitalWrite(LED_BUILTIN, HIGH);
    Serial.println("OK");
  }
}

void testDCC(){
  static int n=0;
  static char s0=0;
  char s1;
  s1=digitalRead(SIGPIN);
  if(s1!=s0){
    n=0;                      //transition occurred
  }else{
    n++;
    if(n>(DCCLOSSLIMIT/DCCINTERVAL)){trip=TRIPTIMEOUT;}//loss of DCC trip, may need to be set higher if analog locos are used
  }
  s0=s1;
  trip=trip-DCCINTERVAL;    //count down
  if(trip<0){trip=0;}
}

