/* 28/6/07                                                  */
/* End of build 1 of major rewrite to implement rotary ctrl */
/* basic functionality for:
	- Load and save three parm sets
	- Rotary control basics
	- Memory map for load save
	- menu structure for rotary control
*/
/* 28/10/2013                                               */
/* Added a bunch of stuff for PIC32MX450F256H               */
/* includes significant update to use generic defines       */
/* and reduces processor dependance of code used            */
/* 24/12/2013                                               */
/* Generally all working - bar tweaks                       */
/*                                                          */

// Let compile time pre-processor calculate the PR1 (period)
#define SYS_FREQ             (96000000L)
#define PB_DIV                 1
#define PRESCALE               256
#define TOGGLES_PER_SEC        1
#define T1_TICK               (SYS_FREQ/PB_DIV/PRESCALE/TOGGLES_PER_SEC)

//Apears this version of the compiler omits this definition
// if you get compiler errors, then these have probably turned back up :)
#define IN_FN_PPS2_RPD3 RPD3Rbits.RPD3R
#define IN_PIN_PPS2_SDI1 0
#define IN_FN_PPS2_RPG7 RPG7Rbits.RPG7R
#define IN_PIN_PPS2_SDI2 6

/* RB0 - spare (output)*/
/* RB1 - spare (output)*/
/* RB2 - spare (output)*/
/* RB3  = LCD Reset - Active Low (output) */
#define KS0108_LCD_RST 8
/* RB4  = LCD Enable (output) */
#define KS0108_LCD_E 16
/* RB5  = LCD Chip Select 1 (output) */
#define KS0108_LCD_CS1 32
/* RB6 - Rotary_Encoder_Select_0 (input)*/
#define Rotary_Encoder_Select_0 64
/* RB7 - Rotary_Encoder_Select_1 (input)*/
#define Rotary_Encoder_Select_1 128

/* Old Rotary Encoder = 00XXXXXX*/
#define Old_Rotary_Encoder 0x0000
/* Type A rotary Encoder = 10XXXXXX*/
#define Type_A_Rotary_Encoder 0x0080
/* Type B Rotary Encoder = 01XXXXXX*/
#define Type_B_Rotary_Encoder 0x0040

/* RB8 - LCD0 (output) */
/* RB9 - LCD1 (output) */
/* RB10 - LCD2 (output) */
/* RB11 - LCD3 (output) */
/* RB12 - LCD4 (output) */
/* RB13 - LCD5 (output) */
/* RB14 - LCD6 (output) */
/* RB15 - LCD7 (output) */
#define KS0108_PortBits 0xFF00


//DELETE ME!!!!!!
#define Write_Control_LCD_CSEL DelayUs(1); PORTD = PORTD & (0xFFFF - (Write_Data_Enable_LCD + Write_Control_Enable_LCD + Write_Control_LCD)); DelayUs(1)
#define Write_Control_Enable_LCD_CSEL DelayUs(1); PORTD = PORTD | Write_Control_Enable_LCD; DelayUs(1)
#define Write_Data_LCD_CSEL DelayUs(1); PORTD = PORTD | (Write_Control_Enable_LCD + Write_Data_Enable_LCD); DelayUs(1); PORTD = PORTD & (0xFFFF - Write_Control_LCD);DelayUs(50)
#define Write_Data_Enable_LCD_CSEL DelayUs(1); PORTD = PORTD | Write_Data_Enable_LCD; DelayUs(1); PORTD = PORTD & (0xFFFF - Write_Control_Enable_LCD - Write_Control_LCD); DelayUs(50)
// LCD wants 37uS delay after write
#define LCD_Delay_After_Write 40
// LCD Data Setting Time - use 5uS
#define LCD_Settle_Before_Write 5
// LCD Control 1.5mS Setting Time
#define LCD_Settle_After_Control 2
//DELETE ME!!!!





/* port C is oscillators */

/* RD0 SPARE */
/* RD1 = SPI_CS1*/
#define CSel 0x002
/* RD2 = SPI_SCK1*/
/* RD3 = SPI_SDI1 = "0000" = input*/
#define SDI_Out 16
/* RD4 = SDI_SDO1 = "1000"*/
/* RD5 = LCD_RW (output)*/
#define KS0108_LCD_RW 32
/* RD6 = LCD_RS (output)*/
#define KS0108_LCD_RS 64
/* RD7 = LCD_CS (output)*/
#define KS0108_LCD_CS0 128

/* RD8 = DSP_RESET*/
#define Reset_DSP       0x0100   /* Bit 8 of port D */
/* RD9 = SPI_SS1 - "0111"*/
/* RD10 = RESET_DAC*/
#define Reset_DAC 	0x0400   /* bit 10 of port D */
/* RD11 = UNUSED (output)*/
/*
 * Drive LCD Control for dispaly select using port B Output
 */

/* RE0 = SPARE*/
/* RE1 = MODE_SEL (input)*/
/* RE2 = FN_SEL (input)*/
/* RE3 = PHASEA (input)*/
/* RE4 = PHASEB (input)*/
/* RE5 = SPARE*/
/* RE6 = SPARE*/
/* RE7 = Select_PGA2320*/

#define Port_E_Button_Pressed   (2+4+8+16)

/* RF0 EEPROM Chip Select_Active Low*/
#define EEPROM_Select 1
/* RF1 EEPROM Chip Hold_Active Low*/
#define EEPROM_Hold 2
/* RF1 SPARE (output)*/
/* RF4 UNUSED (output)*/
/* RF5 UNUSED (output)*/

/* RG6 = SPI_SCK2 */
/* RG7 = SPI_SDI2 "0001" */
/* RG8 = SPI_SDO2 = "0110" */
/* RG9 = SPI_SS2 = "0110" */

/*
PORT C definitions  - NEEDS FIXING
*/
#define Port_XXXX_Button_Pressed   3



/* Display Strings */
#define Blank_Char_Init 	0x20
#define Line1_Init      	"  TGM Was Here  "
#define Line2_Init     	 	"LCD V0.3   Sep16"

#define ClearScreen  GLCD_ClearScreen_buff(ScreenBuff);  Buffer_Refresh(ScreenBuff, 0, 0, 128, 64);

/*
Stuff to allow modes to be tracked
Use these to control the state machine
*/
#define Choosing_Fn	0
#define Set_Mode    1
#define Save_Mode	2
#define Load_Mode	3

/*
Stuff to allow functions to be tracked in Set mode
*/
#define Temp_Set        10
#define Sleep_Time_Set  11
#define Sensor_Tempco   12
#define Sensor_Offset   13


/*Stuff to allow functions to be tracked in Save mode */
#define Save_Sel_Fn 	20

/*
Stuff to allow functions to be tracked in Load mode
*/
#define Load_Sel_Fn 	30

/*
 Frequency Speed Function
*/
#define Freq_Speed_Counter_1_fn 	666


/*
Stuff to allow memory bank in use to be tracked
*/
#define Mem_Banks_Do_Not_Erase 3
#define Mem_Banks_Erase 4
#define Max_Mem_Banks_With_Erase 4
#define Max_Mem_Banks 	2
#define Default_Mem_Bank 0
#define Clear_Buffers_SPI_Time 3

/*
more stuff 
Use this bitfield to watch what buttons are happening...
*/
#define  HMI_Port PORTE
#define  Exit (unsigned char) 2     //pretty sure this is bit 1 of port E
#define  Sel (unsigned char) 4      //pretty sure this is bit 2 of port E
#define  Vals_0 (unsigned char) 8   //pretty sure this is bit 3 of port E
#define  Vals_1 (unsigned char) 16  //pretty sure this is bit 4 of port E
#define Key_Press_Delay_Us 150
#define Slow_Counter_Init 700
#define Fast_Counter_Init 40

#define Phase_0 (unsigned char) 0
#define Phase_1 Vals_0
#define Phase_2 Vals_0 + Vals_1
#define Phase_3 Vals_1

#define Rot_Up Vals_1
#define Rot_Down Vals_0 + Vals_1

#define Up_Keys (Keypress_Read == Vals_1)
#define Down_Keys (Keypress_Read == (Vals_0 + Vals_1))
#define Sel_Key (Keypress_Read == Sel)
#define Exit_Key (Keypress_Read == Exit)

/*Define Value for Mute Volume */
#define  Mute 255

/* Auto Repeat Counts - how long to wait before starting to Auto Repeat*/
#define Auto_Repeat_Count 6


typedef struct{
		int Temperature;     /* Temperature is in Degrees C*/
		int Snooze_Time;     /* Time is in seconds*/
		int Sensor_Tempco_Val;     /* Tempco of iron's temp sensor*/
		int Sensor_Offset_Val;     /* Offset of iron's temp sensor*/
}  data_val_struct ;

#define Default_Mem_Bank 0

/* How big is each set of data in ROM?*/
#define ParmSet_Array_Size          32
#define Channel_Set_Array_Size      16

/* crossover and para data locations */
#define Temp_Offset            0
#define Snooze_Time_Offset     4
#define Tempco_Offset          8
#define Offset_Offset          12

#define Number_Clicks_Freq_Speed_Up 5
#define Max_Freq_Speed 10000
#define Auto_Revert_Init_Val 400000

#define EEPROM_WR_Delay 10  /* Approx EEPROM write delay in mS */ 

/* Can't believe I have to define this!!! */
#define Pi (double) 3.141592653590
#define sqrt2 (double) 1.414213562373

#define CselEEPROM DelayUs(1); PORTF = PORTF | (EEPROM_Select); DelayUs(1)
#define CselClearEEPROM DelayUs(1); PORTF = PORTF & (0xFFFF - EEPROM_Select); DelayUs(1)
#define HoldClearEEPROM DelayUs(1); PORTF = PORTF | (EEPROM_Hold); DelayUs(1)
#define HoldEEPROM DelayUs(1); PORTF = PORTF & (0xFFFF - EEPROM_Hold); DelayUs(1)


#define Fast_Change_Frequencies 500
#define Fast_Change_Delays 100

/* Old Rotary Encoder = 00XXXXXX*/
#define Encoder_Type_Is_Old (!(PORTB & 0x00C0))
/* Type A rotary Encoder = 10XXXXXX*/
#define Encoder_Type_Is_TypeA (PORTB & Type_A_Rotary_Encoder)
/* Type B Rotary Encoder = 01XXXXXX*/
#define Encoder_Type_Is_TypeB (PORTB & Type_B_Rotary_Encoder)

#define SpeedOfSound 341210   /* millimetres per second */

#define	Min_Temp_Step       1    /* Seems like a sensible number*/
#define	Max_Temp_Step       10    /* Seems like a sensible number*/
#define	Temp_Min            0    /* Seems like a sensible number*/
#define	Temp_Max            450  /* Seems like a sensible number*/
#define	Snooze_Time_Min     10   /* Seems like a sensible number*/
#define	Snooze_Time_Max     3600 /* An hour Seems like a sensible number*/
#define	Tempco_Min          -666 /* Need to work this out*/
#define	Tempco_Max          666 /* Need to work this out*/
#define	Temp_Offset_Min     -666 /* Need to work this out*/
#define	Temp_Offset_Max     666 /* Need to work this out*/

#define	Temp_Default        100
#define	Snooze_Default      60
#define	Tempco_Default      10
#define	Tempco_Offset_Default     10


// Graphics Macros
#define Refresh_LCD GLCD_WriteBuf(ScreenBuff, 0, 0, KS0108_SCREEN_WIDTH, KS0108_SCREEN_HEIGHT);


void	Display_Char(char, char);

void 	Print_Data(int, unsigned char*, unsigned int);

void Load_From_Memory(char );