#define PIPORT Serial1
#define MAXLEN 8
#define ITEMS 3
char* strings[] = { "login:", "sword:", "ypi:~$"};

void setup() {
  while((!Serial)&&(millis()<3000)){}
  PIPORT.begin(115200);
  Serial.begin(115200);
  Serial.println("Starting..");
  Serial.println("Waiting for login");
  PIPORT.write(3);   //control-C should give us a prompt if already booted
}

void loop() {
  int a;
  int d=-1;
  static int s=0;
  a=findMulti(PIPORT,strings,3);
  if(a==0){PIPORT.println("pi");}
  if(a==1){PIPORT.println("raspberry");}
  if((a==2)&&(s==0)){
    s=1;
    Serial.print("Boot took ");
    Serial.print(millis()/1000);
    Serial.println(" seconds.");
  }
  if(a==2){
    Serial.println("Ready: type speech");    
    PIPORT.print("espeak-ng \"");
    while(d!=13){
      if(Serial.available()){
        d=Serial.read();
        if((d!='"')&&(d>31)){PIPORT.write(d);}
      }
    }
    PIPORT.print("\"\r");   //en command and quote
    Serial.println("Sending command.");
  }
}

int findMulti(Stream &port, char** s, int n){
  int result =-1;
  int a,i,k;
  char buf[MAXLEN]="";
  int lens[ITEMS];
  for(i=0;i<n;i++){
    lens[i]=strlen(s[i]);
  }
  while(result<0){
    if(port.available()){
      a=port.read();
      while(strlen(buf)>MAXLEN-2){  //move everything up
        for(i=1;i<MAXLEN;i++){
          buf[i-1]=buf[i];
        }
      }
      k=strlen(buf);
      buf[k]=a;
      k++;
      buf[k]=0;
      for(i=0;i<n;i++){
        if(strmatch(s[i],&buf[k-lens[i]])){result=i;}
      }
    }
  }
  return result;
}

char strmatch(char* a, char* b){
  int i,k;
  k=strlen(a);
  if(k!=strlen(b)){return 0;}   //different length, no match
  for(i=0;i<k;i++){
    if(a[i]!=b[i]){return 0;}           //mismatch    
  }
  return 1;                             //match
}

