#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "CFunctions.h"
#define PWM_ON_CYCLES    0
#define PWM_OFF_CYCLES   1
#define PWM_STATE        2
#define PWM_PORTA_PINS   3
#define PWM_PORTB_PINS   4
#define FUSE_RESISTANCE  5 // in 10ths of a mOhm
#define FUSE_MAX_SQ      6
#define FUSE_HEAT_SPEED  7
#define FUSE_COOL_SPEED  8
#define Q1_TEMP          9 // in uDegC above 25deg
#define Q3_TEMP         10 // in uDecC above 25deg
#define BOX_AMB_TEMP    11 // in uDecC above 25deg
#define F1_TEMP         12 // in uDecC above 25deg
#define F2_TEMP         13 // in uDecC above 25deg
#define FUSE_LINKED     14
#define F1_TRIP_REASON  15
#define F2_TRIP_REASON  16
#define IPLUS_SCALE     17
#define IPLUS_OFFSET    18
#define IMINUS_SCALE    19
#define IMINUS_OFFSET   20
#define F1_HIGH_CUR     21
#define F2_HIGH_CUR     22
#define F1_LAST         23
#define F2_LAST         24

#define ADC_NUM         25
#define ADC_ACCUM_SAMPLES 26
#define ADC_BASE        27
#define ADC_ACCUM       33

#define TRIP_OVER_CURRENT 1
#define TRIP_OVER_TEMP    2
#define TRIP_LINKED       3
#define TRIP_UNDER_VOLT   4

inline unsigned long lim0(int a) {
    return a > 0 ? a : 0;
}

inline int Min(int a, int b) {
    return a < b ? a : b;
}

void UpdateTemperatures() {
    unsigned long IPLUS_mA = LATAbits.LATA2 ? 0 : lim0(Min(CFuncRam[ADC_BASE+0], CFuncRam[F1_LAST]) * CFuncRam[IPLUS_SCALE]/*34124*/ + CFuncRam[IPLUS_OFFSET]) / 1024;
    unsigned long IMINUS_mA = !LATAbits.LATA3 ? 0 : lim0(Min(CFuncRam[ADC_BASE+1], CFuncRam[F2_LAST]) * CFuncRam[IMINUS_SCALE]/*34124*/ + CFuncRam[IMINUS_OFFSET]) / 1024;
    CFuncRam[F1_LAST] = CFuncRam[ADC_BASE+0];
    CFuncRam[F2_LAST] = CFuncRam[ADC_BASE+1];
    unsigned long VH_mV = (unsigned long)CFuncRam[ADC_BASE+2] * 33032 / 1024;
    unsigned long VPLUSH_mV = (unsigned long)CFuncRam[ADC_BASE+3] * 46245 / 1024;
    unsigned long VL_mV = 29700 - (unsigned long)CFuncRam[ADC_BASE+4] * 33032 / 1024;
    unsigned long VMINUSL_mV = 42900 - (unsigned long)CFuncRam[ADC_BASE+5] * 46245 / 1024;
    unsigned long IPLUS_SQ = IPLUS_mA * IPLUS_mA;
    unsigned long IMINUS_SQ = IMINUS_mA * IMINUS_mA;
    unsigned long Q1_rDSon_10thmohm = (8300 - (VPLUSH_mV - VH_mV - 7500) / 3) * (1000 + CFuncRam[Q1_TEMP] / 140000) / 100000;
    unsigned long Q1_dissipation_uW = IPLUS_SQ / 200 * Q1_rDSon_10thmohm / 50;
    unsigned long Q3_rDSon_10thmohm = (8300 - (VMINUSL_mV - VL_mV - 7500) / 3) * (1000 + CFuncRam[Q3_TEMP] / 140000) / 100000;
    unsigned long Q3_dissipation_uW = IMINUS_SQ / 200 * Q3_rDSon_10thmohm / 50;
    unsigned long F1_dissipation_uW = IPLUS_SQ >= CFuncRam[FUSE_MAX_SQ] ? 0xFFFFFFFF : IPLUS_SQ / 200 * CFuncRam[FUSE_RESISTANCE] / 5;
    unsigned long F2_dissipation_uW = IMINUS_SQ >= CFuncRam[FUSE_MAX_SQ] ? 0xFFFFFFFF : IMINUS_SQ / 200 * CFuncRam[FUSE_RESISTANCE] / 5;
    CFuncRam[Q1_TEMP] -= (CFuncRam[Q1_TEMP] - CFuncRam[BOX_AMB_TEMP]) / 1200;
    CFuncRam[Q1_TEMP] += Q1_dissipation_uW / 150;
    CFuncRam[Q3_TEMP] -= (CFuncRam[Q3_TEMP] - CFuncRam[BOX_AMB_TEMP]) / 1200;
    CFuncRam[Q3_TEMP] += Q3_dissipation_uW / 150;
    CFuncRam[BOX_AMB_TEMP] -= CFuncRam[BOX_AMB_TEMP] / 42000;
    if( CFuncRam[Q1_TEMP] > CFuncRam[BOX_AMB_TEMP] )
      CFuncRam[BOX_AMB_TEMP] += (CFuncRam[Q1_TEMP] - CFuncRam[BOX_AMB_TEMP]) / 65536;
    if( CFuncRam[Q3_TEMP] > CFuncRam[BOX_AMB_TEMP] )
      CFuncRam[BOX_AMB_TEMP] += (CFuncRam[Q3_TEMP] - CFuncRam[BOX_AMB_TEMP]) / 65536;
    if( CFuncRam[FUSE_COOL_SPEED] == 3800 ) {
        CFuncRam[F1_TEMP] -= CFuncRam[F1_TEMP] / 3800; // 3800 for slow blow, 380 for med, 40 for fast
        CFuncRam[F1_TEMP] += F1_dissipation_uW / 1430; // 1430 for slow blow, 143 for med, 15 for fast
        CFuncRam[F2_TEMP] -= CFuncRam[F2_TEMP] / 3800;
        CFuncRam[F2_TEMP] += F2_dissipation_uW / 1430;
    } else if( CFuncRam[FUSE_COOL_SPEED] == 380 ) {
        CFuncRam[F1_TEMP] -= CFuncRam[F1_TEMP] / 380; // 3800 for slow blow, 380 for med, 40 for fast
        CFuncRam[F1_TEMP] += F1_dissipation_uW / 143; // 1430 for slow blow, 143 for med, 15 for fast
        CFuncRam[F2_TEMP] -= CFuncRam[F2_TEMP] / 380;
        CFuncRam[F2_TEMP] += F2_dissipation_uW / 143;
    } else {
        CFuncRam[F1_TEMP] -= CFuncRam[F1_TEMP] / 40; // 3800 for slow blow, 380 for med, 40 for fast
        CFuncRam[F1_TEMP] += F1_dissipation_uW / 15; // 1430 for slow blow, 143 for med, 15 for fast
        CFuncRam[F2_TEMP] -= CFuncRam[F2_TEMP] / 40;
        CFuncRam[F2_TEMP] += F2_dissipation_uW / 15;
    }

    if( !LATAbits.LATA2 ) {
        if( IPLUS_mA < 34000 )
            CFuncRam[F1_HIGH_CUR] = 0;
        else
            ++CFuncRam[F1_HIGH_CUR];
        if( CFuncRam[Q1_TEMP] > 135000000 ) {
          LATASET = 1<<2;
          CFuncRam[F1_TRIP_REASON] = TRIP_OVER_TEMP;
          if( CFuncRam[FUSE_LINKED] && LATAbits.LATA3 ) {
            LATACLR = 1<<3;
            CFuncRam[F2_TRIP_REASON] = TRIP_LINKED;
          }
        } else if( CFuncRam[F1_TEMP] > 75000000 || CFuncRam[F1_HIGH_CUR] >= 3 ) {
          LATASET = 1<<2;
          CFuncRam[F1_TRIP_REASON] = TRIP_OVER_CURRENT;
          if( CFuncRam[FUSE_LINKED] && LATAbits.LATA3 ) {
            LATACLR = 1<<3;
            CFuncRam[F2_TRIP_REASON] = TRIP_LINKED;
          }
        } else if( VPLUSH_mV - VH_mV < 6500 ) {
          LATASET = 1<<2;
          CFuncRam[F1_TRIP_REASON] = TRIP_UNDER_VOLT;
          if( CFuncRam[FUSE_LINKED] && LATAbits.LATA3 ) {
            LATACLR = 1<<3;
            CFuncRam[F2_TRIP_REASON] = TRIP_LINKED;
          }
        }
    }
    if( LATAbits.LATA3 ) {
        if( IMINUS_mA < 34000 )
            CFuncRam[F2_HIGH_CUR] = 0;
        else
            ++CFuncRam[F2_HIGH_CUR];
        if( CFuncRam[Q3_TEMP] > 135000000 ) {
          LATACLR = 1<<3;
          CFuncRam[F2_TRIP_REASON] = TRIP_OVER_TEMP;
          if( CFuncRam[FUSE_LINKED] && !LATAbits.LATA2 ) {
            LATASET = 1<<2;
            CFuncRam[F1_TRIP_REASON] = TRIP_LINKED;
          }
        } else if( CFuncRam[F2_TEMP] > 75000000 || CFuncRam[F2_HIGH_CUR] >= 3 ) {
          LATACLR = 1<<3;
          CFuncRam[F2_TRIP_REASON] = TRIP_OVER_CURRENT;
          if( CFuncRam[FUSE_LINKED] && !LATAbits.LATA2 ) {
            LATASET = 1<<2;
            CFuncRam[F1_TRIP_REASON] = TRIP_LINKED;
          }
        } else if( VMINUSL_mV - VL_mV < 1500 ) {
          LATACLR = 1<<3;
          CFuncRam[F2_TRIP_REASON] = TRIP_UNDER_VOLT;
          if( CFuncRam[FUSE_LINKED] && !LATAbits.LATA2 ) {
            LATASET = 1<<2;
            CFuncRam[F1_TRIP_REASON] = TRIP_LINKED;
          }
        }
    }
}

void T1Int(void) {
    if( CFuncRam[PWM_STATE] == 0 && CFuncRam[PWM_ON_CYCLES] > 0 ) {
        LATA |=  CFuncRam[PWM_PORTA_PINS];
        LATB |=  CFuncRam[PWM_PORTB_PINS];
        PR1 = CFuncRam[PWM_ON_CYCLES];
        CFuncRam[PWM_STATE] = 1;
        TMR1 = 0;
    } else {
        LATA &= ~CFuncRam[PWM_PORTA_PINS];
        LATB &= ~CFuncRam[PWM_PORTB_PINS];
        PR1 = CFuncRam[PWM_OFF_CYCLES];
        CFuncRam[PWM_STATE] = 0;

        if( AD1CON1bits.DONE ) {
            if( CFuncRam[ADC_NUM]&1 ) {
                CFuncRam[ADC_BASE + (CFuncRam[ADC_NUM]>>1)] = ADC1BUF0;
            }
            if( ++CFuncRam[ADC_NUM] == 12 ) {
                CFuncRam[ADC_NUM] = 0;
                CFuncRam[ADC_BASE + 0] -= (CFuncRam[ADC_BASE + 2] - 372) >> 5;
//                CFuncRam[ADC_BASE + 0] -= (CFuncRam[ADC_BASE + 2] - 372) >> 6;
                if( CFuncRam[ADC_BASE + 0] < 0 )
                    CFuncRam[ADC_BASE + 0] = 0;
                else if( CFuncRam[ADC_BASE + 0] > 1023 )
                    CFuncRam[ADC_BASE + 0] = 1023;
                CFuncRam[ADC_BASE + 1] -= (651 - CFuncRam[ADC_BASE + 4]) >> 5;
//                CFuncRam[ADC_BASE + 1] -= (651 - CFuncRam[ADC_BASE + 4]) >> 6;
                if( CFuncRam[ADC_BASE + 1] < 0 )
                    CFuncRam[ADC_BASE + 1] = 0;
                else if( CFuncRam[ADC_BASE + 1] > 1023 )
                    CFuncRam[ADC_BASE + 1] = 1023;
                CFuncRam[ADC_ACCUM + 0] += CFuncRam[ADC_BASE + 0];
                CFuncRam[ADC_ACCUM + 1] += CFuncRam[ADC_BASE + 1];
                CFuncRam[ADC_ACCUM + 2] += CFuncRam[ADC_BASE + 2];
                CFuncRam[ADC_ACCUM + 3] += CFuncRam[ADC_BASE + 3];
                CFuncRam[ADC_ACCUM + 4] += CFuncRam[ADC_BASE + 4];
                CFuncRam[ADC_ACCUM + 5] += CFuncRam[ADC_BASE + 5];
                ++CFuncRam[ADC_ACCUM_SAMPLES];
                UpdateTemperatures();
                TMR1 = 0;
            }

            switch(CFuncRam[ADC_NUM]>>1) {
                case 0:
                    AD1CHS = 4UL<<16;
                    break;
                case 1:
                    AD1CHS = 5UL<<16;
                    break;
                case 2:
                    AD1CHS = 0UL<<16;
                    break;
                case 3:
                    AD1CHS = 12UL<<16;
                    break;
                case 4:
                    AD1CHS = 9UL<<16;
                    break;
                case 5:
                    AD1CHS = 11UL<<16;
                    break;
            }

            AD1CON1bits.DONE = 0;
            AD1CON1bits.SAMP = 1;
        }
    }
}

__attribute__((noinline)) void getFPC(void *a, void *b, volatile unsigned int *c) {
    *c = (unsigned int) (__builtin_return_address (0) - (b -a)) ;
}

long long int main(long long int* frequency, long long int* duty_cycle, long long int* porta_pins, long long int* portb_pins, long long int* adc_mask, long long int* adc_results, long long int* fuse_parameters){
    if( *frequency ) {
        volatile unsigned int libAddr;
        int div_ratio, temp, new_t1con, new_on_cycles, new_off_cycles;

        mT1IntEnable(0);
        new_t1con = 0;

        CFuncRam[PWM_PORTA_PINS] = *porta_pins;
        CFuncRam[PWM_PORTB_PINS] = *portb_pins;
        CFuncRam[FUSE_RESISTANCE] = (unsigned long)fuse_parameters[0];
        CFuncRam[FUSE_MAX_SQ] = 0xFFFFFFFFUL / ((unsigned long)CFuncRam[FUSE_RESISTANCE] / 200 + 1);
        CFuncRam[FUSE_HEAT_SPEED] = fuse_parameters[1];
        CFuncRam[FUSE_COOL_SPEED] = fuse_parameters[2];
        CFuncRam[FUSE_LINKED] = fuse_parameters[3];
        CFuncRam[IPLUS_SCALE] = fuse_parameters[11];
        CFuncRam[IPLUS_OFFSET] = fuse_parameters[12];
        CFuncRam[IMINUS_SCALE] = fuse_parameters[13];
        CFuncRam[IMINUS_OFFSET] = fuse_parameters[14];
        fuse_parameters[4] = CFuncRam[Q1_TEMP];
        fuse_parameters[5] = CFuncRam[Q3_TEMP];
        fuse_parameters[6] = CFuncRam[F1_TEMP];
        fuse_parameters[7] = CFuncRam[F2_TEMP];
        fuse_parameters[8] = CFuncRam[BOX_AMB_TEMP];
        if( !fuse_parameters[9] ) {
            fuse_parameters[9] = CFuncRam[F1_TRIP_REASON];
            CFuncRam[F1_TRIP_REASON] = 0;
        }
        if( !fuse_parameters[10] ) {
            fuse_parameters[10] = CFuncRam[F2_TRIP_REASON];
            CFuncRam[F2_TRIP_REASON] = 0;
        }

        getFPC(NULL,&&getFPCLab,&libAddr) ; // warning can be ignored, stupid editor
        getFPCLab: { }

        div_ratio = FloatToInt(FDiv(IntToFloat(CurrentCpuSpeed), IntToFloat(*frequency)));
        temp = div_ratio;

        new_t1con = 0x8000;
        if( div_ratio > 65535 ) {
          if( div_ratio > 65535*8 ) {
            if( div_ratio > 65535*64 ) {
                new_t1con |= 3<<4;
                div_ratio /= 256;
            } else {
                new_t1con |= 2<<4;
                div_ratio /= 64;
            }
          } else {
              new_t1con |= 1<<4;
              div_ratio /= 8;
          }
        }
        new_on_cycles = FloatToInt(FDiv(IntToFloat(div_ratio * *duty_cycle), IntToFloat(100)));
        new_off_cycles = div_ratio - new_on_cycles;

        if( new_t1con != T1CON || new_on_cycles != CFuncRam[PWM_ON_CYCLES] || new_off_cycles != CFuncRam[PWM_OFF_CYCLES] ) {
            CFuncT1=(unsigned int)&T1Int + libAddr;
            if( *duty_cycle > 0 ) {
              LATA |=  CFuncRam[PWM_PORTA_PINS];
              LATB |=  CFuncRam[PWM_PORTB_PINS];
            } else {
              LATA &= ~CFuncRam[PWM_PORTA_PINS];
              LATB &= ~CFuncRam[PWM_PORTB_PINS];
            }
            CFuncRam[PWM_STATE] = (*duty_cycle > 0 ? 1 : 0);
            CFuncRam[PWM_ON_CYCLES] = new_on_cycles;
            CFuncRam[PWM_OFF_CYCLES] = new_off_cycles;
            if( *duty_cycle > 0 )
              PR1 = CFuncRam[PWM_ON_CYCLES];
            else
              PR1 = CFuncRam[PWM_OFF_CYCLES];
            T1CON = new_t1con;
            mT1SetIntPriority(1);
            mT1ClearIntFlag();
            mT1IntEnable(1);
        }

        IEC0bits.T1IE = 0;
        adc_results[0] = CFuncRam[ADC_ACCUM + 0];
        adc_results[1] = CFuncRam[ADC_ACCUM + 1];
        adc_results[2] = CFuncRam[ADC_ACCUM + 2];
        adc_results[3] = CFuncRam[ADC_ACCUM + 3];
        adc_results[4] = CFuncRam[ADC_ACCUM + 4];
        adc_results[5] = CFuncRam[ADC_ACCUM + 5];
        CFuncRam[ADC_ACCUM + 0] = 0;
        CFuncRam[ADC_ACCUM + 1] = 0;
        CFuncRam[ADC_ACCUM + 2] = 0;
        CFuncRam[ADC_ACCUM + 3] = 0;
        CFuncRam[ADC_ACCUM + 4] = 0;
        CFuncRam[ADC_ACCUM + 5] = 0;
        temp = CFuncRam[ADC_ACCUM_SAMPLES];
        CFuncRam[ADC_ACCUM_SAMPLES] = 0;

        if( !(AD1CON1 & 0x8000) ) {
  //        IFS0bits.AD1IF = 0;   // Clear the A/D interrupt flag bit
          AD1CON1 = 0x04E0;
          AD1CON2 = 0x0000;
          AD1CON3 = 0x8F02;
          AD1CHS = 4UL<<16;
          AD1CSSL = 0;//*adc_mask;
          AD1CON1bits.ON = 1;
          AD1CON1bits.SAMP = 1;
        }

        IEC0bits.T1IE = 1;
        return temp;
    } else {
        mT1IntEnable(0);
        T1CON = 0;
        PR1 = 0;
    }
    return 0;
 }
