from sense_hat import SenseHat
import time
import os
import re

sensor_names = {"011581aefaff": "indoor"}

def list_onewire_sensors():
    path = '/sys/bus/w1/devices'
    return [f for f in os.listdir(path) if not os.path.isfile(os.path.join(path, f)) and f.startswith('28-')]

def read_onewire_sensor(name):
    path = '/sys/bus/w1/devices'
    file = open(os.path.join(path,name,'w1_slave'), 'r')
    line1 = file.readline()
    line2 = file.readline()
    file.close()
    if line1.endswith(' YES\n'):
      info = re.search('(\\d+)\n?$', line2)
      if info and int(info.group(1)) > 0:
        return int(info.group(1)) / 1000.0
    return '?';

def get_cpu_temp():
    t = os.popen('/opt/vc/bin/vcgencmd measure_temp')
    cpu_temp = t.read()
    t.close()
    cpu_temp = cpu_temp.replace('temp=','')
    cpu_temp = cpu_temp.replace('\'C\n','')
    return float(cpu_temp)

def getmsg(entities, compensate = 0.3):
    tm = time.strftime("%d/%m/%Y %H:%M:%S", time.localtime())
    msg = "[%s]" % tm

    deg = "&deg;" if entities else "\u00B0"

    try:
        sense = SenseHat()
        t = 0
        ct = 0
        p = 0
        h = 0
        n = 5
        nr = 0
        retries = 5
        for x in range(0, n):
            a = sense.get_temperature()
            b = get_cpu_temp()
            c = sense.get_pressure()
            d = sense.get_humidity()
            if a > 0 and b > 0 and c > 0:
              t += a
              ct += b
              p += c
              h += d
              nr += 1
              if( x < n-1 ):
                time.sleep(0.5)
            elif retries > 0:
              retries -= 1
              n += 1
              if( x < n-1 ):
                time.sleep(0.2)

        if nr > 0:
          t = round((t-(ct-t)*compensate)/nr,1)
          ct = round(ct/nr,1)
          p = round(p/nr,1)
          h = round(h/nr,1)

          msg += " Temperature = %s" % (tm,t) + deg + "C, Pressure = %shPA, Relative humidity = %s%%, CPU=%s" % (p,h,ct) + deg + "C"
          if nr < n:
            msg += " (%s/%s samples)" % (nr,n)
        else:
          msg += " Error, unable to query sensors"
    except:
        msg += "" # no SenseHat

    onewire_sensors = list_onewire_sensors()
    for sensor in onewire_sensors:
      temp = read_onewire_sensor(sensor);
      msg += ' '+( sensor_names[sensor[3:]] if sensor[3:] in sensor_names else sensor[3:])+': '+('?' if temp == '?' else ('%.3f' % temp)+deg+'C')

    return msg

def index(max_msgs = 10,interval=5,compensate=0.3):
    msg = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n"
    msg += "<title>Silicon Chip Temperature/Pressure/Humidity</title></head><body>\n"
    msg += "<iframe id=\"myframe\" style=\"width: 0px; height: 0px; border: 0px\" src=\"index.py/readtemp?max_msgs="+str(max_msgs)+"&interval="+str(interval)+"&compensate="+str(compensate)+"\"></iframe>\n"
    msg += "<script>var ready_to_reload = 1; function reload_frame() { if( ready_to_reload ) { ready_to_reload = 0; document.getElementById('myframe').src += ''; } window.setTimeout(reload_frame,"+str(interval)+"*1000); } window.setTimeout(reload_frame,"+str(interval)+"*1000);</script>\n";
    msg += "</body></html>";

    return msg

def readtemp(max_msgs = 10,interval=5,compensate=0.3):
    msg = "<html><body><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">"
    msg += "<script>parent.document.body.appendChild(parent.document.createElement('BR'));"
    msg += "parent.document.body.appendChild(parent.document.createTextNode('"+getmsg(False, float(compensate))+"'));"
    msg += "if( parent.document.getElementsByTagName('br').length > "+str(max_msgs)+" ) {"
    msg +=   "var br = parent.document.getElementsByTagName('br').item(0);";
    msg +=   "br.parentNode.removeChild(br.nextSibling);";
    msg +=   "br.parentNode.removeChild(br);";
    msg += "}"
    msg += "parent.ready_to_reload = 1;"
    msg += "</script></body></html>"
    return msg
