' Steam loco sound generator with analogue speed input driver.
' G.Hunter,  Feb 05.

' Simple on/off hissing sound (a bit harsh) with no amp modulation.

' Analogue input voltage is on pin1 - arrange resistor divider to give
' 3.3V at max speed. This gives 0-160 analogue values in 16 steps.

' At starting, need something like sound 2,(255,25) then Pause 200 = 2 Hz
' At max speed, need  sound 2,(255,8) then Pause 20 = 10 Hz

' PICAXE-08

' pin1 (adc1) is speed volts input	'stored in variable b1
' pin2 (out2) is amplifier output.

symbol speed = b1				'input voltage 1-160 count
symbol ontime = b2			'length of hiss sound in 12ms periods
symbol offtime = b3			'quiet time between hiss in ms
	
nextread: 
	readadc 1,speed			'get the speed voltage
	if speed < 11 then stopped
  
' Now do the chuffing!!
times2:
	offtime = 254 - speed		'quiet time between chuffs		
	ontime = 175 - speed		'duration of chuff
	ontime = ontime/25 + 5			

chuff:
	sound 2,(255,ontime)		'or try 253 instead of 255
	pause offtime
	goto nextread


stopped: 	
	sound 2,(250,50)			'stopped = quiet hissing sound
	goto nextread			'  or try 240, 245 or 249



