
#include "Sine.h"

static inline unsigned char getval(unsigned char val) {
    unsigned char ret = val ^ polarity;
    polarity = polarity_table[(ret&1)];
    return ret;
}
static inline unsigned short getval16(unsigned short val) {
    unsigned short ret = val ^ polarity;
    polarity = polarity_table[(ret&1)];
    return ret;
}
static inline unsigned short getval16nc(unsigned short val) {
    return val ^ polarity;
}

static inline void scale_sine(unsigned char* sine_value, unsigned short scale_value) {
    unsigned short top16 = sine_value[1] | (((unsigned short)sine_value[2])<<8);
    unsigned long temp1 = (unsigned long)top16 * (unsigned long)scale_value;;
    unsigned long temp2 = (unsigned long)sine_value[0] * (unsigned long)scale_value;
    ((unsigned long*)sine_value)[0] = (temp1 + (temp2>>8))>>5;
}

static inline void get_sine(unsigned short offset, unsigned char frac, unsigned char* tohere, unsigned short scale) {
    unsigned char inv;
    unsigned long address;
    int savedTBLPAG;        //Context save of TBLPAG value. Current and packed page are on same page.

    if( offset >= 12000 ) {
        offset -= 12000;
        inv = 1;
    } else {
        inv = 0;
    }
    if( offset > 6000 ) {
        offset = 12000-offset;
    }


    address = __builtin_tbladdress(sine_table_2Hz) + (offset<<1);
    savedTBLPAG = TBLPAG;
    TBLPAG = address>>16;

    register int eedata_addr, eedata_val_l, eedata_val_h;
    eedata_addr = address;
    __asm__ volatile ("tblrdl [%1], %0" : "=r"(eedata_val_l) : "r"(eedata_addr));
    __asm__ volatile ("tblrdh [%1], %0" : "=r"(eedata_val_h) : "r"(eedata_addr));
    TBLPAG = savedTBLPAG;
    ((unsigned short*)tohere)[0] = eedata_val_l;
    ((unsigned short*)tohere)[1] = eedata_val_h;

#ifdef INTERPOLATION
    if( frac&1 ) {
        ((unsigned long*)tohere)[0] += sine_table_deltas_2Hz[offset]>>1;
    }
    if( frac&2 ) {
        ((unsigned long*)tohere)[0] += sine_table_deltas_2Hz[offset];
    }
#endif

    scale_sine(tohere, scale);
    if( inv ) {
        ((signed long*)tohere)[0] = -((signed long*)tohere)[0];
    }
}

static inline void get_nonsine(unsigned short offset, unsigned char frac, unsigned char* tohere, unsigned short scale) {
    unsigned char inv;

    if( offset >= 12000 ) {
        offset -= 12000;
        inv = 1;
    } else {
        inv = 0;
    }

    if( wavetype == Square ) {
        ((unsigned long*)tohere)[0] = 0x00FFFFFF;
    } else {
        if( wavetype == Triangle ) {
            if( offset >= 6000 ) {
                offset = 12000 - offset;
            }
            offset <<= 1;
        } else {
            if( wavetype == Sawtooth_Up ) {
                if( inv ) {
                    offset = 12000 - offset;
                }
            } else {
                if( !inv ) {
                    offset = 12000-offset;
                }
            }
        }
        ((unsigned long*)tohere)[0] = (unsigned long)offset * 1398L;
    }

    scale_sine(tohere, scale);
    if( inv ) {
        ((signed long*)tohere)[0] = -((signed long*)tohere)[0];
    }
}

static inline void compute_next_subframe_Sine(unsigned char* tohere, unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned char sine[4];
    unsigned short preamble;

    get_sine(offset, frac, sine, scale);

    sine[0] >>= 4;
    sine[3] &= 0x0F;

    if( subframe&1 ) {
        preamble = PREAMBLE_Y;
    } else if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ sine[3] | (chan_status[subframe>>1]^parity_table[sine[0]^sine[1]^sine[2]^sine[3]]) ]);

    if( ++subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_Sine_mixed(unsigned char* tohere, unsigned short l_offset, unsigned char l_frac, unsigned short l_scale, unsigned short r_offset, unsigned char r_frac, unsigned short r_scale) {
    unsigned char l_sine[4], r_sine[4];
#ifdef OLD_MIXED
    unsigned char temp;
#endif
    unsigned short preamble;

    get_sine(l_offset, l_frac, l_sine, l_scale);
    get_sine(r_offset, r_frac, r_sine, r_scale);
    ((signed long*)l_sine)[0] += ((signed long*)r_sine)[0];

    l_sine[0] >>= 4;
    l_sine[3] &= 0x0F;

    if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

#ifdef OLD_MIXED
    temp = biphase_table_rev4[l_sine[0]];
    ((unsigned short*)tohere)[0] = getval16(preamble|temp);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16nc(PREAMBLE_Y|temp);
    ((unsigned short*)tohere)[5] = ((unsigned short*)tohere)[1];
    ((unsigned short*)tohere)[6] = ((unsigned short*)tohere)[2];
    ((unsigned short*)tohere)[7] = ((unsigned short*)tohere)[3];
#else
    ((signed long*)r_sine)[0] = mute_r ? 0 : ((signed long*)l_sine)[0];
    if( mute_l ) {
        ((signed long*)l_sine)[0] = 0;
    }
    
    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[l_sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16(PREAMBLE_Y|biphase_table_rev4[r_sine[0]]);
    ((unsigned short*)tohere)[5] = getval16(biphase_table_rev8[r_sine[1]]);
    ((unsigned short*)tohere)[6] = getval16(biphase_table_rev8[r_sine[2]]);
    ((unsigned short*)tohere)[7] = getval16(biphase_table_rev8[ r_sine[3] | (chan_status[subframe>>1]^parity_table[r_sine[0]^r_sine[1]^r_sine[2]^r_sine[3]]) ]);
#endif

    subframe += 2;
    if( subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_NonSine(unsigned char* tohere, unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned char sine[4];
    unsigned short preamble;

    get_nonsine(offset, frac, sine, scale);

    sine[0] >>= 4;
    sine[3] &= 0x0F;

    if( subframe&1 ) {
        preamble = PREAMBLE_Y;
    } else if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ sine[3] | (chan_status[subframe>>1]^parity_table[sine[0]^sine[1]^sine[2]^sine[3]]) ]);

    if( ++subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_NonSine_mixed(unsigned char* tohere, unsigned short l_offset, unsigned char l_frac, unsigned short l_scale, unsigned short r_offset, unsigned char r_frac, unsigned short r_scale) {
    unsigned char l_sine[4], r_sine[4];
#ifdef OLD_MIXED
    unsigned char temp;
#endif
    unsigned short preamble;

    get_nonsine(l_offset, l_frac, l_sine, l_scale);
    get_nonsine(r_offset, r_frac, r_sine, r_scale);
    ((signed long*)l_sine)[0] += ((signed long*)r_sine)[0];

    l_sine[0] >>= 4;
    l_sine[3] &= 0x0F;

    if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

#ifdef OLD_MIXED
    temp = biphase_table_rev4[l_sine[0]];
    ((unsigned short*)tohere)[0] = getval16(preamble|temp);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16nc(PREAMBLE_Y|temp);
    ((unsigned short*)tohere)[5] = ((unsigned short*)tohere)[1];
    ((unsigned short*)tohere)[6] = ((unsigned short*)tohere)[2];
    ((unsigned short*)tohere)[7] = ((unsigned short*)tohere)[3];
#else
    ((signed long*)r_sine)[0] = mute_r ? 0 : ((signed long*)l_sine)[0];
    if( mute_l ) {
        ((signed long*)l_sine)[0] = 0;
    }
    
    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[l_sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16(PREAMBLE_Y|biphase_table_rev4[r_sine[0]]);
    ((unsigned short*)tohere)[5] = getval16(biphase_table_rev8[r_sine[1]]);
    ((unsigned short*)tohere)[6] = getval16(biphase_table_rev8[r_sine[2]]);
    ((unsigned short*)tohere)[7] = getval16(biphase_table_rev8[ r_sine[3] | (chan_status[subframe>>1]^parity_table[r_sine[0]^r_sine[1]^r_sine[2]^r_sine[3]]) ]);
#endif

    subframe += 2;
    if( subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_Null(unsigned char* tohere, unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned short preamble;

    if( subframe&1 ) {
        preamble = PREAMBLE_Y;
    } else if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

    ((unsigned short*)tohere)[0] = getval16(preamble|0xcc/*biphase_table_rev4[0]*/);
    ((unsigned short*)tohere)[1] = getval16nc(0xcccc/*biphase_table_rev8[0]*/);
    ((unsigned short*)tohere)[2] = getval16nc(0xcccc/*biphase_table_rev8[0]*/);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ chan_status[subframe>>1] ]);

    if( ++subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_value_Sine(unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned char sine[4];

    get_sine(offset, frac, sine, scale);

    DACBuffer[DACBufferHead] = ((unsigned long*)sine)[0]>>12;
    DACBufferHead = (DACBufferHead+1)&(DAC_BUFFER_SIZE-1);
}

static inline void compute_next_value_Sine_mixed(unsigned short l_offset, unsigned char l_frac, unsigned short l_scale, unsigned short r_offset, unsigned char r_frac, unsigned short r_scale) {
    unsigned char l_sine[4], r_sine[4];
#ifndef OLD_MIXED
    register unsigned short val;
#endif

    get_sine(l_offset, l_frac, l_sine, l_scale);
    get_sine(r_offset, r_frac, r_sine, r_scale);
    ((signed long*)l_sine)[0] += ((signed long*)r_sine)[0];

#ifdef OLD_MIXED
    DACBuffer[DACBufferHead  ] = DACBuffer[DACBufferHead+1] = ((unsigned long*)l_sine)[0]>>12;
#else
    val = ((unsigned long*)l_sine)[0]>>12;
    DACBuffer[DACBufferHead  ] = mute_l ? 0 : val;
    DACBuffer[DACBufferHead+1] = mute_r ? 0 : val;
#endif
    DACBufferHead = (DACBufferHead+2)&(DAC_BUFFER_SIZE-1);
}

static inline void compute_next_value_NonSine(unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned char sine[4];

    get_nonsine(offset, frac, sine, scale);

    DACBuffer[DACBufferHead] = ((unsigned long*)sine)[0]>>12;
    DACBufferHead = (DACBufferHead+1)&(DAC_BUFFER_SIZE-1);
}

static inline void compute_next_value_NonSine_mixed(unsigned short l_offset, unsigned char l_frac, unsigned short l_scale, unsigned short r_offset, unsigned char r_frac, unsigned short r_scale) {
    unsigned char l_sine[4], r_sine[4];
#ifndef OLD_MIXED
    register unsigned short val;
#endif

    get_nonsine(l_offset, l_frac, l_sine, l_scale);
    get_nonsine(r_offset, r_frac, r_sine, r_scale);
    ((signed long*)l_sine)[0] += ((signed long*)r_sine)[0];

#ifdef OLD_MIXED
    DACBuffer[DACBufferHead  ] = DACBuffer[DACBufferHead+1] = ((unsigned long*)l_sine)[0]>>12;
#else
    val = ((unsigned long*)l_sine)[0]>>12;
    DACBuffer[DACBufferHead  ] = mute_l ? 0 : val;
    DACBuffer[DACBufferHead+1] = mute_r ? 0 : val;
#endif
    DACBufferHead = (DACBufferHead+2)&(DAC_BUFFER_SIZE-1);
}

static inline void compute_next_subframe_and_value_Sine(unsigned char* tohere, unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned char sine[4];
    unsigned short preamble;

    get_sine(offset, frac, sine, scale);

    sine[0] >>= 4;
    sine[3] &= 0x0F;

    DACBuffer[DACBufferHead] = (((unsigned short*)sine)[1]<<4) | (sine[1]>>4);
    DACBufferHead = (DACBufferHead+1)&(DAC_BUFFER_SIZE-1);

    if( subframe&1 ) {
        preamble = PREAMBLE_Y;
    } else if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ sine[3] | (chan_status[subframe>>1]^parity_table[sine[0]^sine[1]^sine[2]^sine[3]]) ]);

    if( ++subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_and_value_Sine_mixed(unsigned char* tohere, unsigned short l_offset, unsigned char l_frac, unsigned short l_scale, unsigned short r_offset, unsigned char r_frac, unsigned short r_scale) {
    unsigned char l_sine[4], r_sine[4];
#ifdef OLD_MIXED
    unsigned char temp;
#endif
    unsigned short preamble;
#ifndef OLD_MIXED
    register unsigned short val;
#endif

    get_sine(l_offset, l_frac, l_sine, l_scale);
    get_sine(r_offset, r_frac, r_sine, r_scale);
    ((signed long*)l_sine)[0] += ((signed long*)r_sine)[0];

    l_sine[0] >>= 4;
    l_sine[3] &= 0x0F;

#ifdef OLD_MIXED
    DACBuffer[DACBufferHead  ] = DACBuffer[DACBufferHead+1] = (((unsigned short*)l_sine)[1]<<4) | (l_sine[1]>>4)
#else
    val = (((unsigned short*)l_sine)[1]<<4) | (l_sine[1]>>4);
    DACBuffer[DACBufferHead  ] = mute_l ? 0 : val;
    DACBuffer[DACBufferHead+1] = mute_r ? 0 : val;
#endif
    DACBufferHead = (DACBufferHead+2)&(DAC_BUFFER_SIZE-1);

    if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

#ifdef OLD_MIXED
    temp = biphase_table_rev4[l_sine[0]];
    ((unsigned short*)tohere)[0] = getval16(preamble|temp);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16nc(PREAMBLE_Y|temp);
    ((unsigned short*)tohere)[5] = ((unsigned short*)tohere)[1];
    ((unsigned short*)tohere)[6] = ((unsigned short*)tohere)[2];
    ((unsigned short*)tohere)[7] = ((unsigned short*)tohere)[3];
#else
    ((signed long*)r_sine)[0] = mute_r ? 0 : ((signed long*)l_sine)[0];
    if( mute_l ) {
        ((signed long*)l_sine)[0] = 0;
    }
    
    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[l_sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16(PREAMBLE_Y|biphase_table_rev4[r_sine[0]]);
    ((unsigned short*)tohere)[5] = getval16(biphase_table_rev8[r_sine[1]]);
    ((unsigned short*)tohere)[6] = getval16(biphase_table_rev8[r_sine[2]]);
    ((unsigned short*)tohere)[7] = getval16(biphase_table_rev8[ r_sine[3] | (chan_status[subframe>>1]^parity_table[r_sine[0]^r_sine[1]^r_sine[2]^r_sine[3]]) ]);
#endif

    subframe += 2;
    if( subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_and_value_NonSine(unsigned char* tohere, unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned char sine[4];
    unsigned short preamble;

    get_nonsine(offset, frac, sine, scale);

    sine[0] >>= 4;
    sine[3] &= 0x0F;

    DACBuffer[DACBufferHead] = (((unsigned short*)sine)[1]<<4) | (sine[1]>>4);
    DACBufferHead = (DACBufferHead+1)&(DAC_BUFFER_SIZE-1);

    if( subframe&1 ) {
        preamble = PREAMBLE_Y;
    } else if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ sine[3] | (chan_status[subframe>>1]^parity_table[sine[0]^sine[1]^sine[2]^sine[3]]) ]);

    if( ++subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_and_value_NonSine_mixed(unsigned char* tohere, unsigned short l_offset, unsigned char l_frac, unsigned short l_scale, unsigned short r_offset, unsigned char r_frac, unsigned short r_scale) {
    unsigned char l_sine[4], r_sine[4];
#ifdef OLD_MIXED
    unsigned char temp;
#endif
    unsigned short preamble;
#ifndef OLD_MIXED
    register unsigned short val;
#endif

    get_nonsine(l_offset, l_frac, l_sine, l_scale);
    get_nonsine(r_offset, r_frac, r_sine, r_scale);
    ((signed long*)l_sine)[0] += ((signed long*)r_sine)[0];

    l_sine[0] >>= 4;
    l_sine[3] &= 0x0F;

#ifdef OLD_MIXED
    DACBuffer[DACBufferHead  ] = DACBuffer[DACBufferHead+1] = (((unsigned short*)l_sine)[1]<<4) | (l_sine[1]>>4)
#else
    val = (((unsigned short*)l_sine)[1]<<4) | (l_sine[1]>>4);
    DACBuffer[DACBufferHead  ] = mute_l ? 0 : val;
    DACBuffer[DACBufferHead+1] = mute_r ? 0 : val;
#endif
    DACBufferHead = (DACBufferHead+2)&(DAC_BUFFER_SIZE-1);

    if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

#ifdef OLD_MIXED
    temp = biphase_table_rev4[l_sine[0]];
    ((unsigned short*)tohere)[0] = getval16(preamble|temp);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16nc(PREAMBLE_Y|temp);
    ((unsigned short*)tohere)[5] = ((unsigned short*)tohere)[1];
    ((unsigned short*)tohere)[6] = ((unsigned short*)tohere)[2];
    ((unsigned short*)tohere)[7] = ((unsigned short*)tohere)[3];
#else
    ((signed long*)r_sine)[0] = mute_r ? 0 : ((signed long*)l_sine)[0];
    if( mute_l ) {
        ((signed long*)l_sine)[0] = 0;
    }
    
    ((unsigned short*)tohere)[0] = getval16(preamble|biphase_table_rev4[l_sine[0]]);
    ((unsigned short*)tohere)[1] = getval16(biphase_table_rev8[l_sine[1]]);
    ((unsigned short*)tohere)[2] = getval16(biphase_table_rev8[l_sine[2]]);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ l_sine[3] | (chan_status[subframe>>1]^parity_table[l_sine[0]^l_sine[1]^l_sine[2]^l_sine[3]]) ]);

    ((unsigned short*)tohere)[4] = getval16(PREAMBLE_Y|biphase_table_rev4[r_sine[0]]);
    ((unsigned short*)tohere)[5] = getval16(biphase_table_rev8[r_sine[1]]);
    ((unsigned short*)tohere)[6] = getval16(biphase_table_rev8[r_sine[2]]);
    ((unsigned short*)tohere)[7] = getval16(biphase_table_rev8[ r_sine[3] | (chan_status[subframe>>1]^parity_table[r_sine[0]^r_sine[1]^r_sine[2]^r_sine[3]]) ]);
#endif

    subframe += 2;
    if( subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void compute_next_subframe_and_value_Null(unsigned char* tohere, unsigned short offset, unsigned char frac, unsigned short scale) {
    unsigned short preamble;

    DACBuffer[DACBufferHead] = 0;
    DACBufferHead = (DACBufferHead+1)&(DAC_BUFFER_SIZE-1);

    if( subframe&1 ) {
        preamble = PREAMBLE_Y;
    } else if( subframe == 0 ) {
        preamble = PREAMBLE_Z;
    } else {
        preamble = PREAMBLE_X;
    }

    ((unsigned short*)tohere)[0] = getval16(preamble|0xcc/*biphase_table_rev4[0]*/);
    ((unsigned short*)tohere)[1] = getval16nc(0xcccc/*biphase_table_rev8[0]*/);
    ((unsigned short*)tohere)[2] = getval16nc(0xcccc/*biphase_table_rev8[0]*/);
    ((unsigned short*)tohere)[3] = getval16(biphase_table_rev8[ chan_status[subframe>>1] ]);

    if( ++subframe == 192*2 ) {
        subframe = 0;
    }
}

static inline void update_pos_Plain() {
    register unsigned long offset, orig_offset;
    register unsigned short freq;
    register unsigned char temp;

    orig_offset = sine_offset_l;
    freq = sine_freq_l;
    offset = orig_offset + freq;
    if( offset >= 96000 ) {
        offset -= 96000;
    }
    temp = ampl_change_counter_l;
    if( temp ) {
        if( offset < freq || (offset >= 48000 && orig_offset < 48000) || --temp == 0 ) {
            sine_scale_l = ampl_change_scale_l;
            temp = 0;
        }
        ampl_change_counter_l = temp;
    }
    sine_offset_l = offset;

    orig_offset = sine_offset_r;
    freq = sine_freq_r;
    offset = orig_offset + freq;
    if( offset >= 96000 ) {
        offset -= 96000;
    }
    temp = ampl_change_counter_r;
    if( temp ) {
        if( offset < freq || (offset >= 48000 && orig_offset < 48000) || --temp == 0 ) {
            sine_scale_r = ampl_change_scale_r;
            temp = 0;
        }
        ampl_change_counter_r = temp;
    }
    sine_offset_r = offset;
}

static inline void update_pos_Pulsed() {
    register unsigned long counter, offset, orig_offset;
    register unsigned short freq;
    register unsigned char temp;

    orig_offset = sine_offset_l;
    freq = sine_freq_l;
    offset = orig_offset + freq;
    if( offset >= 96000 ) {
        offset -= 96000;
    }

    counter = sample_counter+1;
    if( counter >= pulse_total_samples ) {
        counter = 0;
        ampl_change_counter_l = 201;
        ampl_change_scale_l = mute_l ? 0 : pulse_on_scale;
        ampl_change_scale_r = mute_r ? 0 : pulse_on_scale;
    } else if( counter == pulse_on_samples ) {
        ampl_change_counter_l = 201;
        ampl_change_scale_l = mute_l ? 0 : pulse_off_scale;
        ampl_change_scale_r = mute_r ? 0 : pulse_off_scale;
    }
    sample_counter = counter;

    temp = ampl_change_counter_l;
    if( temp ) {
        if( offset < freq || (offset >= 48000 && orig_offset < 48000) || --temp == 0 ) {
            sine_scale_l = ampl_change_scale_l;
            sine_scale_r = ampl_change_scale_r;
            temp = 0;
        }
        ampl_change_counter_l = temp;
    }

    sine_offset_l = sine_offset_r = offset;
}

static inline void update_pos_Sweep() {
    register unsigned long counter, offset, orig_offset;
    register unsigned short freq;
    register unsigned char temp;

    orig_offset = sine_offset_l;
    freq = sine_freq_l;
    offset = orig_offset + freq;
    if( offset >= 96000 ) {
        offset -= 96000;
    }

    counter = sample_counter+1;
    if( counter >= sweep_on_samples ) {
        if( counter >= sweep_total_samples ) {
            counter = 0;
            sweep_counter = 0;
            offset = 0;
            sine_scale_l = sine_scale_r = sweep_scale;
            sine_freq_l = sweep_start_freq;
        } else if( counter == sweep_on_samples ) {
            ampl_change_counter_l = 201;
            ampl_change_scale_l = ampl_change_scale_r = 0;
        }
    } else {
        switch( sweepdir ) {
//      case sweep_up:
        default:
            {
                register unsigned long sweep_counter_ = sweep_counter;
                register unsigned short finish_freq = sweep_finish_freq;
                sweep_counter_ += (unsigned long)freq * (unsigned long)sweep_rate + (unsigned long)sweep_linear_rate;
                freq += sweep_counter_ >> 24;
                if( freq > finish_freq ) {
                    freq = finish_freq;
                }
                sine_freq_l = freq;
                sweep_counter = sweep_counter_ & ((1L<<24)-1);
                break;
            }
        case sweep_down:
            {
                register unsigned long sweep_counter_ = sweep_counter;
                register unsigned short finish_freq = sweep_finish_freq;
                sweep_counter_ += (unsigned long)freq * (unsigned long)sweep_rate + (unsigned long)sweep_linear_rate;
                freq -= sweep_counter_ >> 24;
                if( freq < finish_freq ) {
                    freq = finish_freq;
                }
                sine_freq_l = freq;
                sweep_counter = sweep_counter_ & ((1L<<24)-1);
                break;
            }
        }
    }

    temp = ampl_change_counter_l;
    if( temp ) {
        if( offset < freq || (offset >= 48000 && orig_offset < 48000) || --temp == 0 ) {
            sine_scale_l = ampl_change_scale_l;
            sine_scale_r = ampl_change_scale_r;
            temp = 0;
        }
        ampl_change_counter_l = temp;
    }

    sample_counter = counter;
    sine_offset_l = sine_offset_r = offset;
}

static inline void update_pos_Sweep_Geometric() {
    register unsigned long counter, offset, orig_offset;
    register unsigned short freq;
    register unsigned char temp;

    orig_offset = sine_offset_l;
    freq = sine_freq_l;
    offset = orig_offset + freq;
    if( offset >= 96000 ) {
        offset -= 96000;
    }

    counter = sample_counter+1;     
    if( counter >= sweep_on_samples ) {
        if( counter >= sweep_total_samples ) {
            counter = 0;
            sweep_counter = 0;
            offset = 0;
            sine_scale_l = sine_scale_r = sweep_scale;
            sine_freq_l = sweep_start_freq;
        } else if( counter == sweep_on_samples ) {
            ampl_change_counter_l = 201;
            ampl_change_scale_l = ampl_change_scale_r = 0;
        }
    } else {
        register unsigned long sweep_counter_;
        register unsigned short finish_freq;
        sweep_counter_ = sweep_counter + ((unsigned long)freq * (unsigned long)sweep_rate) + (unsigned long)sweep_linear_rate;
        freq += sweep_counter_ >> 24;
        finish_freq = sweep_finish_freq;
        if( freq > finish_freq ) {
            freq = finish_freq;
        }
        sine_freq_l = freq;
        sweep_counter = sweep_counter_ & ((1L<<24)-1);
    }

    temp = ampl_change_counter_l;
    if( temp ) {
        if( offset < freq || (offset >= 48000 && orig_offset < 48000) || --temp == 0 ) {
            sine_scale_l = ampl_change_scale_l;
            sine_scale_r = ampl_change_scale_r;
            temp = 0;
        }
        ampl_change_counter_l = temp;
    }

    sample_counter = counter;
    sine_offset_l = sine_offset_r = offset;
}

static inline void update_pos_Sweep_Geometric_rev() {
    register unsigned long counter, offset, orig_offset;
    register unsigned short freq;
    register unsigned char temp;

    orig_offset = sine_offset_l;
    freq = sine_freq_l;
    offset = orig_offset + freq;
    if( offset >= 96000 ) {
        offset -= 96000;
    }

    counter = sample_counter+1;     
    if( counter >= sweep_on_samples ) {
        if( counter >= sweep_total_samples ) {
            counter = 0;
            sweep_counter = 0;
            offset = 0;
            sine_scale_l = sine_scale_r = sweep_scale;
            sine_freq_l = sweep_start_freq;
        } else if( counter == sweep_on_samples ) {
            ampl_change_counter_l = 201;
            ampl_change_scale_l = ampl_change_scale_r = 0;
        }
    } else {
        register unsigned long sweep_counter_;
        register unsigned short finish_freq;
        sweep_counter_ = sweep_counter + ((unsigned long)freq * (unsigned long)sweep_rate) + (unsigned long)sweep_linear_rate;
        freq -= sweep_counter_ >> 24;
        finish_freq = sweep_finish_freq;
        if( freq < finish_freq ) {
            freq = finish_freq;
        }
        sine_freq_l = freq;
        sweep_counter = sweep_counter_ & ((1L<<24)-1);
    }

    temp = ampl_change_counter_l;
    if( temp ) {
        if( offset < freq || (offset >= 48000 && orig_offset < 48000) || --temp == 0 ) {
            sine_scale_l = ampl_change_scale_l;
            sine_scale_r = ampl_change_scale_r;
            temp = 0;
        }
        ampl_change_counter_l = temp;
    }

    sample_counter = counter;
    sine_offset_l = sine_offset_r = offset;
}
