
typedef enum { Mode_Locked, Mode_Independent, Mode_Mixed, Mode_Pulse, Mode_Sweep } Mode;
extern Mode intmode;
extern unsigned short freq, freq_l, freq_r, freq_start, freq_finish;
extern unsigned char  db, db_l, db_r, db_on, db_off;
extern unsigned short phase_diff;
extern unsigned short pulse_on, pulse_off;
extern unsigned short sweep_on, sweep_off;
extern unsigned char l_mute, r_mute;
extern unsigned char edit_pos;
extern unsigned char in_settings;
extern unsigned char pro_mode, emph_enabled;

typedef enum { Settings_Rate, Settings_Status, Settings_Sweep, Settings_Bits, Settings_Battery, Settings_LCD, Settings_Bank } SettingsMode;
extern SettingsMode settings_mode;
extern unsigned char samplerate_index;
extern unsigned char wavetype_index;
extern unsigned char lcd_brightness;
extern unsigned char lcd_contrast;
extern unsigned char settings_bank;
extern unsigned char sweep_index;
extern unsigned char settings_load, settings_save;
extern unsigned char settings_loaded, settings_saved;

extern void load_settings_bank(unsigned char bank);
extern void save_settings_bank(unsigned char bank);

#ifdef REVISIONB
#define KEY_UP       1
#define KEY_DOWN     6
#define KEY_LEFT     3
#define KEY_RIGHT    0
#define KEY_MIDDLE   2
#define KEY_LMUTE    7
#define KEY_RMUTE    4
#define KEY_CHANSWAP 8
#else
#define KEY_UP 0
#define KEY_DOWN 1
#define KEY_LEFT 2
#define KEY_RIGHT 3
#define KEY_MIDDLE 4
#define KEY_LMUTE 5
#define KEY_RMUTE 6
#define KEY_CHANSWAP 7
#endif

extern void update_lcd();
extern void reinit_mode();
extern void handle_key(int key);
extern void hide_cursor();
extern void once_per_second();
extern void four_times_per_second();
